/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.impl.Types;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.UUID;

public abstract class ValueLocatorBase {
    public static final int SER_UNKNOWN = 0;
    public static final int SER_MAP = 1;
    public static final int SER_LIST = 2;
    public static final int SER_COLLECTION = 3;
    public static final int SER_OBJECT_ARRAY = 4;
    public static final int SER_SHORT_ARRAY = 5;
    public static final int SER_INT_ARRAY = 6;
    public static final int SER_LONG_ARRAY = 7;
    public static final int SER_FLOAT_ARRAY = 8;
    public static final int SER_DOUBLE_ARRAY = 9;
    public static final int SER_BOOLEAN_ARRAY = 10;
    public static final int SER_TREE_NODE = 11;
    public static final int SER_STRING = 12;
    public static final int SER_CHARACTER_SEQUENCE = 13;
    public static final int SER_CHAR_ARRAY = 14;
    public static final int SER_BYTE_ARRAY = 15;
    public static final int SER_NUMBER_BYTE = 16;
    public static final int SER_NUMBER_SHORT = 17;
    public static final int SER_NUMBER_INTEGER = 18;
    public static final int SER_NUMBER_INTEGER_WRAPPER = 19;
    public static final int SER_NUMBER_LONG = 20;
    public static final int SER_NUMBER_LONG_WRAPPER = 21;
    public static final int SER_NUMBER_FLOAT = 22;
    public static final int SER_NUMBER_FLOAT_WRAPPER = 23;
    public static final int SER_NUMBER_DOUBLE = 24;
    public static final int SER_NUMBER_DOUBLE_WRAPPER = 25;
    public static final int SER_NUMBER_BIG_INTEGER = 26;
    public static final int SER_NUMBER_BIG_DECIMAL = 27;
    public static final int SER_BOOLEAN = 28;
    public static final int SER_BOOLEAN_WRAPPER = 29;
    public static final int SER_CHAR = 30;
    public static final int SER_ENUM = 31;
    public static final int SER_DATE = 32;
    public static final int SER_CALENDAR = 33;
    public static final int SER_CLASS = 34;
    public static final int SER_FILE = 35;
    public static final int SER_UUID = 36;
    public static final int SER_URL = 37;
    public static final int SER_URI = 38;
    public static final int SER_PATH = 39;
    public static final int SER_ITERABLE = 40;
    protected static final int CACHE_FLAGS = JSON.CACHE_FLAGS;

    protected int _findSimpleType(Class<?> clazz, boolean bl) {
        if (clazz == String.class) {
            return 12;
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2.isPrimitive()) {
                if (clazz == byte[].class) {
                    return 15;
                }
                if (clazz == char[].class) {
                    return 14;
                }
                if (clazz == int[].class) {
                    return 6;
                }
                if (clazz == long[].class) {
                    return 7;
                }
                if (clazz == boolean[].class) {
                    return 10;
                }
                if (clazz == short[].class) {
                    return 5;
                }
                if (clazz == float[].class) {
                    return 8;
                }
                if (clazz == double[].class) {
                    return 9;
                }
                return 0;
            }
            return 4;
        }
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return 28;
            }
            if (clazz == Integer.TYPE) {
                return 18;
            }
            if (clazz == Long.TYPE) {
                return 20;
            }
            if (clazz == Byte.TYPE) {
                return 16;
            }
            if (clazz == Short.TYPE) {
                return 17;
            }
            if (clazz == Double.TYPE) {
                return 24;
            }
            if (clazz == Float.TYPE) {
                return 22;
            }
            if (clazz == Character.TYPE) {
                return 30;
            }
            throw new IllegalArgumentException("Unrecognized primitive type: " + clazz.getName());
        }
        if (clazz == Boolean.class) {
            return 29;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            if (clazz == Integer.class) {
                return 19;
            }
            if (clazz == Long.class) {
                return 21;
            }
            if (clazz == Double.class) {
                return 25;
            }
            if (clazz == Float.class) {
                return 23;
            }
            if (clazz == BigDecimal.class) {
                return 27;
            }
            if (clazz == BigInteger.class) {
                return 26;
            }
            if (clazz == Byte.class) {
                return 16;
            }
            if (clazz == Short.class) {
                return 17;
            }
            return 0;
        }
        if (clazz == Character.class) {
            return 30;
        }
        if (Types.isEnum(clazz)) {
            return 31;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return 1;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            if (List.class.isAssignableFrom(clazz) && RandomAccess.class.isAssignableFrom(clazz)) {
                return 2;
            }
            return 3;
        }
        if (TreeNode.class.isAssignableFrom(clazz)) {
            return 11;
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return 33;
        }
        if (clazz == Class.class) {
            return 34;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return 32;
        }
        if (File.class.isAssignableFrom(clazz)) {
            return 35;
        }
        if (URL.class.isAssignableFrom(clazz)) {
            return 37;
        }
        if (URI.class.isAssignableFrom(clazz)) {
            return 38;
        }
        if (UUID.class.isAssignableFrom(clazz)) {
            return 36;
        }
        if (Path.class.isAssignableFrom(clazz)) {
            return 39;
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return 13;
        }
        if (bl && Iterable.class.isAssignableFrom(clazz) && !Path.class.isAssignableFrom(clazz)) {
            return 40;
        }
        return 0;
    }
}

