/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.stree;

import com.fasterxml.jackson.jr.private_.JsonGenerator;
import com.fasterxml.jackson.jr.private_.JsonToken;
import com.fasterxml.jackson.jr.stree.JacksonJrsTreeCodec;
import com.fasterxml.jackson.jr.stree.JrsValue;
import java.io.IOException;

public class JrsBoolean
extends JrsValue.Scalar {
    public static JrsBoolean TRUE = new JrsBoolean(true, JsonToken.VALUE_TRUE);
    public static JrsBoolean FALSE = new JrsBoolean(false, JsonToken.VALUE_FALSE);
    private final boolean _value;
    private final JsonToken _token;

    private JrsBoolean(boolean bl, JsonToken jsonToken) {
        this._value = bl;
        this._token = jsonToken;
    }

    @Override
    public JsonToken asToken() {
        return this._token;
    }

    @Override
    public String asText() {
        return this._value ? "true" : "false";
    }

    public boolean booleanValue() {
        return this._value;
    }

    @Override
    protected void write(JsonGenerator jsonGenerator, JacksonJrsTreeCodec jacksonJrsTreeCodec) throws IOException {
        jsonGenerator.writeBoolean(this._value);
    }
}

