/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.impl.AnyReader;
import com.fasterxml.jackson.jr.ob.impl.ArrayReader;
import com.fasterxml.jackson.jr.ob.impl.BeanPropertyReader;
import com.fasterxml.jackson.jr.ob.impl.BeanPropertyWriter;
import com.fasterxml.jackson.jr.ob.impl.BeanReader;
import com.fasterxml.jackson.jr.ob.impl.ClassKey;
import com.fasterxml.jackson.jr.ob.impl.CollectionReader;
import com.fasterxml.jackson.jr.ob.impl.EnumReader;
import com.fasterxml.jackson.jr.ob.impl.MapReader;
import com.fasterxml.jackson.jr.ob.impl.POJODefinition;
import com.fasterxml.jackson.jr.ob.impl.SimpleValueReader;
import com.fasterxml.jackson.jr.ob.impl.ValueReader;
import com.fasterxml.jackson.jr.private_.TreeNode;
import com.fasterxml.jackson.jr.type.ResolvedType;
import com.fasterxml.jackson.jr.type.TypeBindings;
import com.fasterxml.jackson.jr.type.TypeResolver;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class TypeDetector {
    protected final BeanPropertyWriter[] NO_PROPS_FOR_WRITE = new BeanPropertyWriter[0];
    protected static final int MAX_CACHED_READERS = 500;
    public static final int SER_UNKNOWN = 0;
    public static final int SER_MAP = 1;
    public static final int SER_LIST = 2;
    public static final int SER_COLLECTION = 3;
    public static final int SER_OBJECT_ARRAY = 4;
    public static final int SER_INT_ARRAY = 5;
    public static final int SER_LONG_ARRAY = 6;
    public static final int SER_BOOLEAN_ARRAY = 7;
    public static final int SER_TREE_NODE = 8;
    public static final int SER_STRING = 9;
    public static final int SER_CHARACTER_SEQUENCE = 10;
    public static final int SER_CHAR_ARRAY = 11;
    public static final int SER_BYTE_ARRAY = 12;
    public static final int SER_NUMBER_BYTE = 13;
    public static final int SER_NUMBER_SHORT = 14;
    public static final int SER_NUMBER_INTEGER = 15;
    public static final int SER_NUMBER_LONG = 16;
    public static final int SER_NUMBER_FLOAT = 17;
    public static final int SER_NUMBER_DOUBLE = 18;
    public static final int SER_NUMBER_BIG_INTEGER = 19;
    public static final int SER_NUMBER_BIG_DECIMAL = 20;
    public static final int SER_BOOLEAN = 21;
    public static final int SER_CHAR = 22;
    public static final int SER_ENUM = 23;
    public static final int SER_DATE = 24;
    public static final int SER_CALENDAR = 25;
    public static final int SER_CLASS = 26;
    public static final int SER_FILE = 27;
    public static final int SER_UUID = 28;
    public static final int SER_URL = 29;
    public static final int SER_URI = 30;
    public static final int SER_ITERABLE = 31;
    protected static final int CACHE_FLAGS = JSON.Feature.cacheBreakers();
    protected final ConcurrentHashMap<ClassKey, Integer> _knownSerTypes;
    protected final CopyOnWriteArrayList<BeanPropertyWriter[]> _knownWriters;
    protected final TypeResolver _typeResolver;
    protected final ConcurrentHashMap<ClassKey, ValueReader> _knownReaders;
    protected Map<ClassKey, ValueReader> _incompleteReaders;
    protected final Object _readerLock;
    protected ClassKey _key;
    protected Class<?> _prevClass;
    protected int _prevType;
    protected int _features;

    protected TypeDetector(int n) {
        this._features = n;
        this._knownSerTypes = new ConcurrentHashMap(50, 0.75f, 4);
        this._knownWriters = new CopyOnWriteArrayList();
        this._knownReaders = new ConcurrentHashMap(50, 0.75f, 4);
        this._typeResolver = new TypeResolver();
        this._readerLock = new Object();
    }

    protected TypeDetector(TypeDetector typeDetector, int n) {
        this._features = n;
        this._knownSerTypes = typeDetector._knownSerTypes;
        this._knownWriters = typeDetector._knownWriters;
        this._knownReaders = typeDetector._knownReaders;
        this._typeResolver = typeDetector._typeResolver;
        this._readerLock = typeDetector._readerLock;
    }

    public static final TypeDetector blueprint(int n) {
        return new TypeDetector(n & CACHE_FLAGS);
    }

    public TypeDetector perOperationInstance(int n) {
        return new TypeDetector(this, n & CACHE_FLAGS);
    }

    protected POJODefinition resolvePOJODefinition(Class<?> clazz) {
        try {
            return POJODefinition.find(clazz);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(String.format("Failed to introspect ClassDefinition for type '%s': %s", clazz.getName(), exception.getMessage()), exception);
        }
    }

    protected int _findSimple(Class<?> clazz, boolean bl) {
        if (clazz == String.class) {
            return 9;
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2.isPrimitive()) {
                if (clazz == byte[].class) {
                    return 12;
                }
                if (clazz == char[].class) {
                    return 11;
                }
                if (clazz == int[].class) {
                    return 5;
                }
                if (clazz == long[].class) {
                    return 6;
                }
                if (clazz == boolean[].class) {
                    return 7;
                }
                return 0;
            }
            return 4;
        }
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return 21;
            }
            if (clazz == Integer.TYPE) {
                return 15;
            }
            if (clazz == Long.TYPE) {
                return 16;
            }
            if (clazz == Byte.TYPE) {
                return 13;
            }
            if (clazz == Short.TYPE) {
                return 14;
            }
            if (clazz == Double.TYPE) {
                return 18;
            }
            if (clazz == Float.TYPE) {
                return 17;
            }
            if (clazz == Character.TYPE) {
                return 22;
            }
            throw new IllegalArgumentException("Unrecognized primitive type: " + clazz.getName());
        }
        if (clazz == Boolean.class) {
            return 21;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            if (clazz == Integer.class) {
                return 15;
            }
            if (clazz == Long.class) {
                return 16;
            }
            if (clazz == Byte.class) {
                return 13;
            }
            if (clazz == Short.class) {
                return 14;
            }
            if (clazz == Double.class) {
                return 18;
            }
            if (clazz == Float.class) {
                return 17;
            }
            if (clazz == BigDecimal.class) {
                return 20;
            }
            if (clazz == BigInteger.class) {
                return 19;
            }
            return 0;
        }
        if (clazz == Character.class) {
            return 22;
        }
        if (clazz.isEnum()) {
            return 23;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return 1;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            if (List.class.isAssignableFrom(clazz) && RandomAccess.class.isAssignableFrom(clazz)) {
                return 2;
            }
            return 3;
        }
        if (TreeNode.class.isAssignableFrom(clazz)) {
            return 8;
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return 25;
        }
        if (clazz == Class.class) {
            return 26;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return 24;
        }
        if (File.class.isAssignableFrom(clazz)) {
            return 27;
        }
        if (URL.class.isAssignableFrom(clazz)) {
            return 29;
        }
        if (URI.class.isAssignableFrom(clazz)) {
            return 30;
        }
        if (UUID.class.isAssignableFrom(clazz)) {
            return 28;
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return 10;
        }
        if (bl && Iterable.class.isAssignableFrom(clazz)) {
            return 31;
        }
        return 0;
    }

    public BeanPropertyWriter[] getPropertyWriters(int n) {
        if (n < 0) {
            n = -(n + 1);
        }
        return this._knownWriters.get(n);
    }

    public final int findSerializationType(Class<?> clazz) {
        int n;
        if (clazz == this._prevClass) {
            return this._prevType;
        }
        if (clazz == String.class) {
            return 9;
        }
        ClassKey classKey = this._key == null ? new ClassKey(clazz, this._features) : this._key.with(clazz, this._features);
        Integer n2 = this._knownSerTypes.get(classKey);
        if (n2 == null) {
            n = this._findPOJOSerializationType(clazz);
            this._knownSerTypes.put(new ClassKey(clazz, this._features), n);
        } else {
            n = n2;
        }
        this._prevType = n;
        this._prevClass = clazz;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int _findPOJOSerializationType(Class<?> clazz) {
        int n = this._findSimple(clazz, true);
        if (n == 0 && JSON.Feature.HANDLE_JAVA_BEANS.isEnabled(this._features)) {
            POJODefinition pOJODefinition = this.resolvePOJODefinition(clazz);
            BeanPropertyWriter[] beanPropertyWriterArray = this.resolveBeanForSer(clazz, pOJODefinition);
            CopyOnWriteArrayList<BeanPropertyWriter[]> copyOnWriteArrayList = this._knownWriters;
            synchronized (copyOnWriteArrayList) {
                ClassKey classKey = new ClassKey(clazz, this._features);
                Integer n2 = this._knownSerTypes.get(classKey);
                if (n2 != null) {
                    return n2;
                }
                this._knownWriters.add(beanPropertyWriterArray);
                int n3 = -this._knownWriters.size();
                this._knownSerTypes.put(classKey, n3);
                return n3;
            }
        }
        return n;
    }

    protected BeanPropertyWriter[] resolveBeanForSer(Class<?> clazz, POJODefinition pOJODefinition) {
        BeanPropertyWriter[] beanPropertyWriterArray;
        int n;
        POJODefinition.Prop[] propArray = pOJODefinition.properties();
        int n2 = propArray.length;
        ArrayList<BeanPropertyWriter> arrayList = new ArrayList<BeanPropertyWriter>(n2);
        boolean bl = JSON.Feature.WRITE_READONLY_BEAN_PROPERTIES.isEnabled(this._features);
        boolean bl2 = JSON.Feature.FORCE_REFLECTION_ACCESS.isEnabled(this._features);
        boolean bl3 = JSON.Feature.USE_FIELDS.isEnabled(this._features);
        for (n = 0; n < n2; ++n) {
            Class<?> clazz2;
            Field field;
            beanPropertyWriterArray = propArray[n];
            Method method = beanPropertyWriterArray.getter;
            if (method == null && JSON.Feature.USE_IS_GETTERS.isEnabled(this._features)) {
                method = beanPropertyWriterArray.isGetter;
            }
            Field field2 = field = bl3 ? beanPropertyWriterArray.field : null;
            if (method == null && field == null || !bl && !beanPropertyWriterArray.hasSetter()) continue;
            if (method != null) {
                clazz2 = method.getReturnType();
                if (bl2) {
                    method.setAccessible(true);
                }
            } else {
                clazz2 = field.getType();
                if (bl2) {
                    field.setAccessible(true);
                }
            }
            int n3 = this._findSimple(clazz2, true);
            arrayList.add(new BeanPropertyWriter(n3, beanPropertyWriterArray.name, beanPropertyWriterArray.field, method));
        }
        n = arrayList.size();
        beanPropertyWriterArray = n == 0 ? this.NO_PROPS_FOR_WRITE : arrayList.toArray(new BeanPropertyWriter[n]);
        return beanPropertyWriterArray;
    }

    public ValueReader enumReader(Class<?> clazz) {
        Object[] objectArray = clazz.getEnumConstants();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Object obj : objectArray) {
            hashMap.put(obj.toString(), obj);
        }
        return new EnumReader(objectArray, hashMap);
    }

    protected ValueReader collectionReader(Class<?> clazz, Type type) {
        ResolvedType resolvedType = this._typeResolver.resolve(this.bindings(clazz), type);
        List<ResolvedType> list = resolvedType.typeParametersFor(Collection.class);
        return this.collectionReader(resolvedType.erasedType(), list.get(0));
    }

    protected ValueReader collectionReader(Class<?> clazz, ResolvedType resolvedType) {
        Class<?> clazz2 = resolvedType.erasedType();
        if (Collection.class.isAssignableFrom(clazz2)) {
            List<ResolvedType> list = resolvedType.typeParametersFor(Collection.class);
            return this.collectionReader(clazz2, list.get(0));
        }
        if (Map.class.isAssignableFrom(clazz2)) {
            List<ResolvedType> list = resolvedType.typeParametersFor(Map.class);
            return this.mapReader(clazz2, list.get(1));
        }
        return new CollectionReader(clazz, this.createReader(null, clazz2, clazz2));
    }

    protected ValueReader mapReader(Class<?> clazz, Type type) {
        ResolvedType resolvedType = this._typeResolver.resolve(this.bindings(clazz), type);
        List<ResolvedType> list = resolvedType.typeParametersFor(Map.class);
        return this.mapReader(resolvedType.erasedType(), list.get(1));
    }

    protected ValueReader mapReader(Class<?> clazz, ResolvedType resolvedType) {
        Class<?> clazz2 = resolvedType.erasedType();
        if (Collection.class.isAssignableFrom(clazz2)) {
            List<ResolvedType> list = resolvedType.typeParametersFor(Collection.class);
            return this.collectionReader(clazz2, list.get(0));
        }
        if (Map.class.isAssignableFrom(clazz2)) {
            List<ResolvedType> list = resolvedType.typeParametersFor(Map.class);
            return this.mapReader(clazz2, list.get(1));
        }
        return new MapReader(clazz, this.createReader(null, clazz2, clazz2));
    }

    public ValueReader findReader(Class<?> clazz) {
        ClassKey classKey = this._key == null ? new ClassKey(clazz, this._features) : this._key.with(clazz, this._features);
        ValueReader valueReader = this._knownReaders.get(classKey);
        if (valueReader != null) {
            return valueReader;
        }
        valueReader = this.createReader(null, clazz, clazz);
        if (this._knownReaders.size() >= 500) {
            this._knownReaders.clear();
        }
        this._knownReaders.putIfAbsent(new ClassKey(clazz, this._features), valueReader);
        return valueReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueReader createReader(Class<?> clazz, Class<?> clazz2, Type type) {
        if (clazz2 == Object.class) {
            return AnyReader.std;
        }
        if (clazz2.isArray()) {
            Class<?> clazz3 = clazz2.getComponentType();
            if (!clazz3.isPrimitive()) {
                return new ArrayReader(clazz3, this.createReader(clazz, clazz3, clazz3));
            }
            int n = this._findSimple(clazz2, false);
            if (n > 0) {
                return new SimpleValueReader(n, clazz2);
            }
            throw new IllegalArgumentException("Deserialization of " + clazz2.getName() + " not (yet) supported");
        }
        if (clazz2.isEnum()) {
            return this.enumReader(clazz2);
        }
        if (Collection.class.isAssignableFrom(clazz2)) {
            return this.collectionReader(clazz, type);
        }
        if (Map.class.isAssignableFrom(clazz2)) {
            return this.mapReader(clazz, type);
        }
        int n = this._findSimple(clazz2, false);
        if (n > 0) {
            return new SimpleValueReader(n, clazz2);
        }
        ClassKey classKey = new ClassKey(clazz2, this._features);
        Object object = this._readerLock;
        synchronized (object) {
            ValueReader valueReader;
            if (this._incompleteReaders == null) {
                this._incompleteReaders = new HashMap<ClassKey, ValueReader>();
            } else {
                valueReader = this._incompleteReaders.get(classKey);
                if (valueReader != null) {
                    return valueReader;
                }
            }
            valueReader = this._resolveBeanForDeser(clazz2);
            try {
                this._incompleteReaders.put(classKey, valueReader);
                for (Map.Entry<String, BeanPropertyReader> entry : ((BeanReader)valueReader).propertiesByName().entrySet()) {
                    BeanPropertyReader beanPropertyReader = entry.getValue();
                    entry.setValue(beanPropertyReader.withReader(this.createReader(clazz, beanPropertyReader.rawSetterType(), beanPropertyReader.genericSetterType())));
                }
            }
            finally {
                this._incompleteReaders.remove(classKey);
            }
            return valueReader;
        }
    }

    protected BeanReader _resolveBeanForDeser(Class<?> clazz) {
        POJODefinition pOJODefinition = this.resolvePOJODefinition(clazz);
        Constructor<?> constructor = pOJODefinition.defaultCtor;
        Constructor<?> constructor2 = pOJODefinition.stringCtor;
        Constructor<?> constructor3 = pOJODefinition.longCtor;
        boolean bl = JSON.Feature.FORCE_REFLECTION_ACCESS.isEnabled(this._features);
        if (bl) {
            if (constructor != null) {
                constructor.setAccessible(true);
            }
            if (constructor2 != null) {
                constructor2.setAccessible(true);
            }
            if (constructor3 != null) {
                constructor3.setAccessible(true);
            }
        }
        POJODefinition.Prop[] propArray = pOJODefinition.properties();
        HashMap<String, BeanPropertyReader> hashMap = new HashMap();
        int n = propArray.length;
        if (n == 0) {
            hashMap = Collections.emptyMap();
        } else {
            boolean bl2 = JSON.Feature.USE_FIELDS.isEnabled(this._features);
            hashMap = new HashMap();
            for (int i = 0; i < n; ++i) {
                Field field;
                POJODefinition.Prop prop = propArray[i];
                Method method = prop.setter;
                Field field2 = field = bl2 ? prop.field : null;
                if (method != null) {
                    if (bl) {
                        method.setAccessible(true);
                    } else if (!Modifier.isPublic(method.getModifiers())) {
                        method = null;
                    }
                }
                if (method == null) {
                    if (field == null) continue;
                    if (bl) {
                        field.setAccessible(true);
                    } else if (!Modifier.isPublic(field.getModifiers())) continue;
                }
                hashMap.put(prop.name, new BeanPropertyReader(prop.name, field, method));
            }
        }
        return new BeanReader(clazz, hashMap, constructor, constructor2, constructor3);
    }

    private TypeBindings bindings(Class<?> clazz) {
        if (clazz == null) {
            return TypeBindings.emptyBindings();
        }
        return TypeBindings.create(clazz, (ResolvedType[])null);
    }
}

