/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.private_.io.SerializedString;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class BeanPropertyWriter {
    public final SerializedString name;
    public final int typeId;
    protected final Method _getter;
    protected final Field _field;

    public BeanPropertyWriter(int n, String string, Field field, Method method) {
        this.typeId = n;
        this.name = new SerializedString(string);
        this._field = field;
        if (method == null && field == null) {
            throw new IllegalArgumentException("Missing getter and field");
        }
        this._getter = method;
    }

    public Object getValueFor(Object object) throws IOException {
        try {
            if (this._getter == null) {
                return this._field.get(object);
            }
            return this._getter.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            throw new JSONObjectException(String.format("Failed to access property '%s'; exception (%s): %s", this.name, exception.getClass().getName(), exception.getMessage()), exception);
        }
    }

    protected String _bean() {
        if (this._getter == null) {
            return this._field.getDeclaringClass().getName();
        }
        return this._getter.getDeclaringClass().getName();
    }
}

