/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.ob.impl.ValueReader;
import com.fasterxml.jackson.jr.private_.io.SerializedString;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public final class BeanProperty {
    protected final SerializedString _name;
    protected int _typeId;
    protected final ValueReader _valueReader;
    protected final Method _getMethod;
    protected final Method _setMethod;

    public BeanProperty(String string) {
        this._name = new SerializedString(string);
        this._typeId = 0;
        this._getMethod = null;
        this._setMethod = null;
        this._valueReader = null;
    }

    protected BeanProperty(BeanProperty beanProperty, ValueReader valueReader) {
        this._name = beanProperty._name;
        this._typeId = beanProperty._typeId;
        this._getMethod = beanProperty._getMethod;
        this._setMethod = beanProperty._setMethod;
        this._valueReader = valueReader;
    }

    protected BeanProperty(BeanProperty beanProperty, int n, Method method, Method method2) {
        this._name = beanProperty._name;
        this._valueReader = beanProperty._valueReader;
        this._typeId = n;
        this._getMethod = method;
        this._setMethod = method2;
    }

    public BeanProperty withGetter(Method method) {
        return new BeanProperty(this, this._typeId, method, this._setMethod);
    }

    public BeanProperty withSetter(Method method) {
        if (this._setMethod != null && (method.isBridge() || method.isSynthetic())) {
            return this;
        }
        return new BeanProperty(this, this._typeId, this._getMethod, method);
    }

    public BeanProperty withReader(ValueReader valueReader) {
        return new BeanProperty(this, valueReader);
    }

    public BeanProperty withTypeId(int n) {
        return n == this._typeId ? this : new BeanProperty(this, n, this._getMethod, this._setMethod);
    }

    public void forceAccess() {
        if (this._getMethod != null) {
            this._getMethod.setAccessible(true);
        }
        if (this._setMethod != null) {
            this._setMethod.setAccessible(true);
        }
    }

    public boolean hasGetter() {
        return this._getMethod != null;
    }

    public boolean hasSetter() {
        return this._setMethod != null;
    }

    public Type genericSetterType() {
        return this._setMethod.getGenericParameterTypes()[0];
    }

    public Class<?> rawSetterType() {
        return this._setMethod.getParameterTypes()[0];
    }

    public Class<?> rawGetterType() {
        return this._getMethod.getReturnType();
    }

    public ValueReader getReader() {
        return this._valueReader;
    }

    public int getTypeId() {
        return this._typeId;
    }

    public SerializedString getName() {
        return this._name;
    }

    public SerializedString getNameIfHasSetter() {
        return this._setMethod == null ? null : this._name;
    }

    public Object getValueFor(Object object) throws IOException {
        if (this._getMethod == null) {
            throw new IllegalStateException("No getter for property '" + this._name + "' (type " + this._bean() + ")");
        }
        try {
            return this._getMethod.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            throw new JSONObjectException("Failed to access property '" + this._name + "'; exception " + exception.getClass().getName() + "): " + exception.getMessage(), exception);
        }
    }

    public Object setValueFor(Object object, Object object2) throws IOException {
        if (this._setMethod == null) {
            throw new IllegalStateException("No setter for property '" + this._name + "' (type " + this._bean() + ")");
        }
        try {
            return this._setMethod.invoke(object, object2);
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            while (throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            throw new JSONObjectException("Failed to set property '" + this._name + "'; exception " + exception.getClass().getName() + "): " + exception.getMessage(), exception);
        }
    }

    protected String _bean() {
        Class<?> clazz;
        if (this._getMethod != null) {
            clazz = this._getMethod.getDeclaringClass();
        } else if (this._setMethod != null) {
            clazz = this._setMethod.getDeclaringClass();
        } else {
            return "UNKNOWN";
        }
        return clazz.getName();
    }

    public String toString() {
        return this._name.toString();
    }
}

