/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.ob.impl.CollectionBuilder;
import com.fasterxml.jackson.jr.ob.impl.JSONReader;
import com.fasterxml.jackson.jr.ob.impl.MapBuilder;
import com.fasterxml.jackson.jr.ob.impl.ValueReader;
import com.fasterxml.jackson.jr.private.JsonParser;
import com.fasterxml.jackson.jr.private.JsonToken;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class AnyReader
extends ValueReader {
    public static final AnyReader std = new AnyReader();

    @Override
    public Object readNext(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        jsonParser.nextToken();
        return this.read(jSONReader, jsonParser);
    }

    @Override
    public Object read(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        int n = jsonToken == null ? 0 : jsonToken.id();
        switch (n) {
            case 11: {
                return null;
            }
            case 1: {
                return this.readFromObject(jSONReader, jsonParser, jSONReader._mapBuilder);
            }
            case 3: {
                if (jSONReader._arraysAsLists) {
                    return this.readCollectionFromArray(jSONReader, jsonParser, jSONReader._collectionBuilder);
                }
                return this.readArrayFromArray(jSONReader, jsonParser, jSONReader._collectionBuilder);
            }
            case 6: {
                return this.fromString(jsonParser.getText());
            }
            case 7: {
                JsonParser.NumberType numberType = jsonParser.getNumberType();
                if (numberType == JsonParser.NumberType.INT) {
                    return jsonParser.getIntValue();
                }
                if (numberType == JsonParser.NumberType.LONG) {
                    return jsonParser.getLongValue();
                }
                return jsonParser.getBigIntegerValue();
            }
            case 8: {
                if (!JSON.Feature.USE_BIG_DECIMAL_FOR_FLOATS.isEnabled(jSONReader._features)) {
                    JsonParser.NumberType numberType = jsonParser.getNumberType();
                    if (numberType == JsonParser.NumberType.FLOAT) {
                        return Float.valueOf(jsonParser.getFloatValue());
                    }
                    if (numberType == JsonParser.NumberType.DOUBLE) {
                        return jsonParser.getDoubleValue();
                    }
                }
                return jsonParser.getDecimalValue();
            }
            case 9: {
                return this.fromBoolean(true);
            }
            case 10: {
                return this.fromBoolean(false);
            }
            case 12: {
                return this.fromEmbedded(jsonParser.getEmbeddedObject());
            }
        }
        throw JSONObjectException.from(jsonParser, "Unexpected value token: " + this._tokenDesc(jsonParser));
    }

    public Map<Object, Object> readFromObject(JSONReader jSONReader, JsonParser jsonParser, MapBuilder mapBuilder) throws IOException {
        if (jsonParser.nextValue() == JsonToken.END_OBJECT) {
            return mapBuilder.emptyMap();
        }
        Object object = this.fromKey(jsonParser.getCurrentName());
        Object object2 = this.read(jSONReader, jsonParser);
        if (jsonParser.nextValue() == JsonToken.END_OBJECT) {
            return mapBuilder.singletonMap(object, object2);
        }
        mapBuilder = mapBuilder.start().put(object, object2);
        do {
            mapBuilder = mapBuilder.put(this.fromKey(jsonParser.getCurrentName()), this.read(jSONReader, jsonParser));
        } while (jsonParser.nextValue() != JsonToken.END_OBJECT);
        return mapBuilder.build();
    }

    public Object[] readArrayFromArray(JSONReader jSONReader, JsonParser jsonParser, CollectionBuilder collectionBuilder) throws IOException {
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.emptyArray();
        }
        Object object = this.read(jSONReader, jsonParser);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.singletonArray(object);
        }
        collectionBuilder = collectionBuilder.start().add(object);
        do {
            collectionBuilder = collectionBuilder.add(this.read(jSONReader, jsonParser));
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        return collectionBuilder.buildArray();
    }

    public Collection<Object> readCollectionFromArray(JSONReader jSONReader, JsonParser jsonParser, CollectionBuilder collectionBuilder) throws IOException {
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.emptyCollection();
        }
        Object object = this.read(jSONReader, jsonParser);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.singletonCollection(object);
        }
        collectionBuilder = collectionBuilder.start().add(object);
        do {
            collectionBuilder = collectionBuilder.add(this.read(jSONReader, jsonParser));
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        return collectionBuilder.buildCollection();
    }

    protected Object fromNull() throws IOException {
        return null;
    }

    protected Object fromBoolean(boolean bl) throws IOException {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object fromKey(String string) throws IOException {
        return string;
    }

    protected Object fromString(String string) throws IOException {
        return string;
    }

    protected Object fromEmbedded(Object object) throws IOException {
        return object;
    }
}

