/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.private_.io.SerializedString;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class BeanPropertyWriter {
    public final SerializedString name;
    public final int typeId;
    private final Field _field;
    private final Method _getter;

    public BeanPropertyWriter(int n, String string, Field field, Method method) {
        this.typeId = n;
        this.name = new SerializedString(string);
        if (method == null && field == null) {
            throw new IllegalArgumentException("Missing getter and field");
        }
        this._field = field;
        this._getter = method;
    }

    public BeanPropertyWriter withName(String string) {
        if (this.name.toString().equals(string)) {
            return this;
        }
        return new BeanPropertyWriter(this.typeId, string, this._field, this._getter);
    }

    public Object getValueFor(Object object) throws IOException {
        try {
            if (this._getter == null) {
                return this._field.get(object);
            }
            return this._getter.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            String string = this._getter != null ? String.format("method %s.%s()", this._bean(), this._getter.getName()) : String.format("field %s.%s", this._bean(), this._field.getName());
            throw new JSONObjectException(String.format("Failed to access property '%s' (using %s); exception (%s): %s", this.name, exception.getClass().getName(), string, exception.getMessage()), exception);
        }
    }

    protected String _bean() {
        if (this._getter == null) {
            return this._field.getDeclaringClass().getName();
        }
        return this._getter.getDeclaringClass().getName();
    }
}

