/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.api.ReaderWriterProvider;
import com.fasterxml.jackson.jr.ob.api.ValueReader;
import com.fasterxml.jackson.jr.ob.impl.AnyReader;
import com.fasterxml.jackson.jr.ob.impl.ArrayReader;
import com.fasterxml.jackson.jr.ob.impl.BeanPropertyReader;
import com.fasterxml.jackson.jr.ob.impl.BeanReader;
import com.fasterxml.jackson.jr.ob.impl.ClassKey;
import com.fasterxml.jackson.jr.ob.impl.CollectionReader;
import com.fasterxml.jackson.jr.ob.impl.EnumReader;
import com.fasterxml.jackson.jr.ob.impl.JSONReader;
import com.fasterxml.jackson.jr.ob.impl.MapReader;
import com.fasterxml.jackson.jr.ob.impl.POJODefinition;
import com.fasterxml.jackson.jr.ob.impl.SimpleValueReader;
import com.fasterxml.jackson.jr.ob.impl.ValueLocatorBase;
import com.fasterxml.jackson.jr.type.ResolvedType;
import com.fasterxml.jackson.jr.type.TypeBindings;
import com.fasterxml.jackson.jr.type.TypeResolver;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ValueReaderLocator
extends ValueLocatorBase {
    protected static final int MAX_CACHED_READERS = 500;
    protected final TypeResolver _typeResolver;
    protected final ReaderWriterProvider _readerProvider;
    protected final ConcurrentHashMap<ClassKey, ValueReader> _knownReaders;
    protected Map<ClassKey, ValueReader> _incompleteReaders;
    protected final Object _readerLock;
    protected final int _features;
    protected final JSONReader _readContext;
    private ClassKey _key;

    protected ValueReaderLocator(int n, ReaderWriterProvider readerWriterProvider) {
        this._features = n;
        this._readerProvider = readerWriterProvider;
        this._knownReaders = new ConcurrentHashMap(10, 0.75f, 2);
        this._typeResolver = new TypeResolver();
        this._readerLock = new Object();
        this._readContext = null;
    }

    protected ValueReaderLocator(ValueReaderLocator valueReaderLocator, int n, JSONReader jSONReader) {
        this._features = n;
        this._readContext = jSONReader;
        this._readerProvider = valueReaderLocator._readerProvider;
        this._knownReaders = valueReaderLocator._knownReaders;
        this._typeResolver = valueReaderLocator._typeResolver;
        this._readerLock = valueReaderLocator._readerLock;
    }

    protected ValueReaderLocator(ValueReaderLocator valueReaderLocator, ReaderWriterProvider readerWriterProvider) {
        this._knownReaders = new ConcurrentHashMap(10, 0.75f, 2);
        this._features = valueReaderLocator._features;
        this._readContext = valueReaderLocator._readContext;
        this._readerProvider = readerWriterProvider;
        this._typeResolver = valueReaderLocator._typeResolver;
        this._readerLock = valueReaderLocator._readerLock;
    }

    public static final ValueReaderLocator blueprint(int n, ReaderWriterProvider readerWriterProvider) {
        return new ValueReaderLocator(n & CACHE_FLAGS, readerWriterProvider);
    }

    public ValueReaderLocator with(ReaderWriterProvider readerWriterProvider) {
        if (readerWriterProvider == this._readerProvider) {
            return this;
        }
        return new ValueReaderLocator(this, readerWriterProvider);
    }

    public ValueReaderLocator perOperationInstance(JSONReader jSONReader, int n) {
        return new ValueReaderLocator(this, n & CACHE_FLAGS, jSONReader);
    }

    public ValueReader findReader(Class<?> clazz) {
        ClassKey classKey = this._key == null ? new ClassKey(clazz, this._features) : this._key.with(clazz, this._features);
        ValueReader valueReader = this._knownReaders.get(classKey);
        if (valueReader != null) {
            return valueReader;
        }
        valueReader = this.createReader(null, clazz, clazz);
        if (this._knownReaders.size() >= 500) {
            this._knownReaders.clear();
        }
        this._knownReaders.putIfAbsent(new ClassKey(clazz, this._features), valueReader);
        return valueReader;
    }

    protected ValueReader createReader(Class<?> clazz, Class<?> clazz2, Type type) {
        ValueReader valueReader;
        if (clazz2 == Object.class) {
            return AnyReader.std;
        }
        if (clazz2.isArray()) {
            return this.arrayReader(clazz, clazz2);
        }
        if (clazz2.isEnum()) {
            ValueReader valueReader2;
            if (this._readerProvider != null && (valueReader2 = this._readerProvider.findValueReader(this._readContext, clazz2)) != null) {
                return valueReader2;
            }
            return this.enumReader(clazz2);
        }
        if (Collection.class.isAssignableFrom(clazz2)) {
            return this.collectionReader(clazz, type);
        }
        if (Map.class.isAssignableFrom(clazz2)) {
            return this.mapReader(clazz, type);
        }
        if (this._readerProvider != null && (valueReader = this._readerProvider.findValueReader(this._readContext, clazz2)) != null) {
            return valueReader;
        }
        int n = this._findSimpleType(clazz2, false);
        if (n > 0) {
            return new SimpleValueReader(clazz2, n);
        }
        return this.beanReader(clazz2);
    }

    protected ValueReader arrayReader(Class<?> clazz, Class<?> clazz2) {
        Class<?> clazz3 = clazz2.getComponentType();
        if (!clazz3.isPrimitive()) {
            return new ArrayReader(clazz2, clazz3, this.createReader(clazz, clazz3, clazz3));
        }
        int n = this._findSimpleType(clazz2, false);
        if (n > 0) {
            return new SimpleValueReader(clazz2, n);
        }
        throw new IllegalArgumentException("Deserialization of " + clazz2.getName() + " not (yet) supported");
    }

    protected ValueReader enumReader(Class<?> clazz) {
        Object[] objectArray = clazz.getEnumConstants();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Object obj : objectArray) {
            hashMap.put(obj.toString(), obj);
        }
        return new EnumReader(clazz, objectArray, hashMap);
    }

    protected ValueReader collectionReader(Class<?> clazz, Type type) {
        ResolvedType resolvedType = this._typeResolver.resolve(this._bindings(clazz), type);
        List<ResolvedType> list = resolvedType.typeParametersFor(Collection.class);
        return this.collectionReader(resolvedType.erasedType(), list.get(0));
    }

    protected ValueReader collectionReader(Class<?> clazz, ResolvedType resolvedType) {
        ValueReader valueReader;
        Object object;
        Class<?> clazz2 = resolvedType.erasedType();
        if (Collection.class.isAssignableFrom(clazz2)) {
            object = resolvedType.typeParametersFor(Collection.class);
            valueReader = this.collectionReader(clazz2, object.get(0));
        } else if (Map.class.isAssignableFrom(clazz2)) {
            object = resolvedType.typeParametersFor(Map.class);
            valueReader = this.mapReader(clazz2, object.get(1));
        } else {
            valueReader = this.findReader(clazz2);
        }
        if (this._readerProvider != null && (object = this._readerProvider.findCollectionReader(this._readContext, clazz, resolvedType, valueReader)) != null) {
            return object;
        }
        return new CollectionReader(clazz, valueReader);
    }

    protected ValueReader mapReader(Class<?> clazz, Type type) {
        ResolvedType resolvedType = this._typeResolver.resolve(this._bindings(clazz), type);
        List<ResolvedType> list = resolvedType.typeParametersFor(Map.class);
        return this.mapReader(resolvedType.erasedType(), list.get(1));
    }

    protected ValueReader mapReader(Class<?> clazz, ResolvedType resolvedType) {
        ValueReader valueReader;
        Object object;
        Class<?> clazz2 = resolvedType.erasedType();
        if (Collection.class.isAssignableFrom(clazz2)) {
            object = resolvedType.typeParametersFor(Collection.class);
            valueReader = this.collectionReader(clazz2, object.get(0));
        } else if (Map.class.isAssignableFrom(clazz2)) {
            object = resolvedType.typeParametersFor(Map.class);
            valueReader = this.mapReader(clazz2, object.get(1));
        } else {
            valueReader = this.findReader(clazz2);
        }
        if (this._readerProvider != null && (object = this._readerProvider.findMapReader(this._readContext, clazz, resolvedType, valueReader)) != null) {
            return object;
        }
        return new MapReader(clazz, valueReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueReader beanReader(Class<?> clazz) {
        ClassKey classKey = new ClassKey(clazz, this._features);
        Object object = this._readerLock;
        synchronized (object) {
            ValueReader valueReader;
            if (this._incompleteReaders == null) {
                this._incompleteReaders = new HashMap<ClassKey, ValueReader>();
            } else {
                valueReader = this._incompleteReaders.get(classKey);
                if (valueReader != null) {
                    return valueReader;
                }
            }
            valueReader = this._resolveBeanForDeser(clazz);
            try {
                this._incompleteReaders.put(classKey, valueReader);
                for (Map.Entry<String, BeanPropertyReader> entry : ((BeanReader)valueReader).propertiesByName().entrySet()) {
                    BeanPropertyReader beanPropertyReader = entry.getValue();
                    entry.setValue(beanPropertyReader.withReader(this.createReader(clazz, beanPropertyReader.rawSetterType(), beanPropertyReader.genericSetterType())));
                }
            }
            finally {
                this._incompleteReaders.remove(classKey);
            }
            return valueReader;
        }
    }

    protected BeanReader _resolveBeanForDeser(Class<?> clazz) {
        Map<String, BeanPropertyReader> map;
        POJODefinition.Prop[] propArray;
        int n;
        POJODefinition pOJODefinition = this._resolveBeanDef(clazz);
        Constructor<?> constructor = pOJODefinition.defaultCtor;
        Constructor<?> constructor2 = pOJODefinition.stringCtor;
        Constructor<?> constructor3 = pOJODefinition.longCtor;
        boolean bl = JSON.Feature.FORCE_REFLECTION_ACCESS.isEnabled(this._features);
        if (bl) {
            if (constructor != null) {
                constructor.setAccessible(true);
            }
            if (constructor2 != null) {
                constructor2.setAccessible(true);
            }
            if (constructor3 != null) {
                constructor3.setAccessible(true);
            }
        }
        if ((n = (propArray = pOJODefinition.properties()).length) == 0) {
            map = Collections.emptyMap();
        } else {
            map = new HashMap();
            boolean bl2 = JSON.Feature.USE_FIELDS.isEnabled(this._features);
            for (int i = 0; i < n; ++i) {
                Field field;
                POJODefinition.Prop prop = propArray[i];
                Method method = prop.setter;
                Field field2 = field = bl2 ? prop.field : null;
                if (method != null) {
                    if (bl) {
                        method.setAccessible(true);
                    } else if (!Modifier.isPublic(method.getModifiers())) {
                        method = null;
                    }
                }
                if (method == null) {
                    if (field == null) continue;
                    if (bl) {
                        field.setAccessible(true);
                    } else if (!Modifier.isPublic(field.getModifiers())) continue;
                }
                map.put(prop.name, new BeanPropertyReader(prop.name, field, method));
            }
        }
        return new BeanReader(clazz, map, constructor, constructor2, constructor3);
    }

    private TypeBindings _bindings(Class<?> clazz) {
        if (clazz == null) {
            return TypeBindings.emptyBindings();
        }
        return TypeBindings.create(clazz, (ResolvedType[])null);
    }
}

