/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jaxrs.xml.cfg;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlAnnotationIntrospector;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.jaxb.XmlJaxbAnnotationIntrospector;
import com.fasterxml.jackson.jaxrs.xml.Annotations;
import java.util.ArrayList;

public class MapperConfigurator {
    protected XmlMapper _mapper;
    protected XmlMapper _defaultMapper;
    protected Annotations[] _defaultAnnotationsToUse;
    protected Class<? extends AnnotationIntrospector> _jaxbIntrospectorClass;

    public MapperConfigurator(XmlMapper mapper, Annotations[] defAnnotations) {
        this._mapper = mapper;
        this._defaultAnnotationsToUse = defAnnotations;
    }

    public synchronized XmlMapper getConfiguredMapper() {
        return this._mapper;
    }

    public synchronized XmlMapper getDefaultMapper() {
        if (this._defaultMapper == null) {
            JacksonXmlModule module = this.getConfiguredModule();
            this._defaultMapper = module == null ? new XmlMapper() : new XmlMapper(module);
            this._setAnnotations(this._defaultMapper, this._defaultAnnotationsToUse);
        }
        return this._defaultMapper;
    }

    protected JacksonXmlModule getConfiguredModule() {
        return new JacksonXmlModule();
    }

    public synchronized void setMapper(XmlMapper m) {
        this._mapper = m;
    }

    public synchronized void setAnnotationsToUse(Annotations[] annotationsToUse) {
        this._setAnnotations(this.mapper(), annotationsToUse);
    }

    public synchronized void configure(DeserializationFeature f, boolean state) {
        this.mapper().configure(f, state);
    }

    public synchronized void configure(SerializationFeature f, boolean state) {
        this.mapper().configure(f, state);
    }

    public synchronized void configure(JsonParser.Feature f, boolean state) {
        this.mapper().configure(f, state);
    }

    public synchronized void configure(JsonGenerator.Feature f, boolean state) {
        this.mapper().configure(f, state);
    }

    protected XmlMapper mapper() {
        if (this._mapper == null) {
            this._mapper = new XmlMapper();
            this._setAnnotations(this._mapper, this._defaultAnnotationsToUse);
        }
        return this._mapper;
    }

    protected void _setAnnotations(XmlMapper mapper, Annotations[] annotationsToUse) {
        AnnotationIntrospector intr = annotationsToUse == null || annotationsToUse.length == 0 ? AnnotationIntrospector.nopInstance() : this._resolveIntrospectors(annotationsToUse);
        mapper.setAnnotationIntrospector(intr);
    }

    protected AnnotationIntrospector _resolveIntrospectors(Annotations[] annotationsToUse) {
        ArrayList<AnnotationIntrospector> intr = new ArrayList<AnnotationIntrospector>();
        for (Annotations a : annotationsToUse) {
            if (a == null) continue;
            intr.add(this._resolveIntrospector(a));
        }
        int count = intr.size();
        if (count == 0) {
            return AnnotationIntrospector.nopInstance();
        }
        AnnotationIntrospector curr = (AnnotationIntrospector)intr.get(0);
        int len = intr.size();
        for (int i = 1; i < len; ++i) {
            curr = AnnotationIntrospector.pair((AnnotationIntrospector)curr, (AnnotationIntrospector)((AnnotationIntrospector)intr.get(i)));
        }
        return curr;
    }

    protected AnnotationIntrospector _resolveIntrospector(Annotations ann) {
        switch (ann) {
            case JACKSON: {
                return new JacksonXmlAnnotationIntrospector();
            }
            case JAXB: {
                try {
                    if (this._jaxbIntrospectorClass == null) {
                        this._jaxbIntrospectorClass = XmlJaxbAnnotationIntrospector.class;
                    }
                    return this._jaxbIntrospectorClass.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to instantiate XmlJaxbAnnotationIntrospector: " + e.getMessage(), e);
                }
            }
        }
        throw new IllegalStateException();
    }
}

