/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jaxrs.cfg;

import com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import java.lang.annotation.Annotation;

public abstract class EndpointConfigBase<THIS extends EndpointConfigBase<THIS>> {
    protected Class<?> _activeView;
    protected String _rootName;
    protected DeserializationFeature[] _deserEnable;
    protected DeserializationFeature[] _deserDisable;
    protected ObjectReader _reader;
    protected SerializationFeature[] _serEnable;
    protected SerializationFeature[] _serDisable;
    protected ObjectWriter _writer;

    protected EndpointConfigBase() {
    }

    protected THIS add(Annotation[] annotations, boolean forWriting) {
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                this.addAnnotation(annotation.annotationType(), annotation, forWriting);
            }
        }
        return (THIS)this;
    }

    protected void addAnnotation(Class<? extends Annotation> type, Annotation annotation, boolean forWriting) {
        JacksonAnnotationsInside inside;
        if (type == JsonView.class) {
            Class[] views = ((JsonView)annotation).value();
            this._activeView = views.length > 0 ? views[0] : null;
        } else if (type == JacksonFeatures.class) {
            JacksonFeatures feats = (JacksonFeatures)annotation;
            if (forWriting) {
                this._serEnable = EndpointConfigBase.nullIfEmpty(feats.serializationEnable());
                this._serDisable = EndpointConfigBase.nullIfEmpty(feats.serializationDisable());
            } else {
                this._deserEnable = EndpointConfigBase.nullIfEmpty(feats.deserializationEnable());
                this._deserDisable = EndpointConfigBase.nullIfEmpty(feats.deserializationDisable());
            }
        } else if (type == JsonRootName.class) {
            this._rootName = ((JsonRootName)annotation).value();
        } else if (type != JacksonAnnotationsInside.class && (inside = type.getAnnotation(JacksonAnnotationsInside.class)) != null) {
            this.add(type.getAnnotations(), forWriting);
        }
    }

    protected THIS initReader(ObjectMapper mapper) {
        this._reader = this._activeView != null ? mapper.readerWithView(this._activeView) : mapper.reader();
        if (this._rootName != null) {
            this._reader = this._reader.withRootName(this._rootName);
        }
        if (this._deserEnable != null) {
            this._reader = this._reader.withFeatures(this._deserEnable);
        }
        if (this._deserDisable != null) {
            this._reader = this._reader.withoutFeatures(this._deserDisable);
        }
        this._reader.getFactory().disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        return (THIS)this;
    }

    protected THIS initWriter(ObjectMapper mapper) {
        this._writer = this._activeView != null ? mapper.writerWithView(this._activeView) : mapper.writer();
        if (this._rootName != null) {
            this._writer = this._writer.withRootName(this._rootName);
        }
        if (this._serEnable != null) {
            this._writer = this._writer.withFeatures(this._serEnable);
        }
        if (this._serDisable != null) {
            this._writer = this._writer.withoutFeatures(this._serDisable);
        }
        this._writer.getFactory().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        return (THIS)this;
    }

    public final ObjectReader getReader() {
        if (this._reader == null) {
            throw new IllegalStateException();
        }
        return this._reader;
    }

    public final ObjectWriter getWriter() {
        if (this._writer == null) {
            throw new IllegalStateException();
        }
        return this._writer;
    }

    public abstract Object modifyBeforeWrite(Object var1);

    protected static <T> T[] nullIfEmpty(T[] arg) {
        if (arg == null || arg.length == 0) {
            return null;
        }
        return arg;
    }
}

