/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.async;

import com.fasterxml.aalto.AsyncInputFeeder;
import com.fasterxml.aalto.async.AsyncXmlDeclHelper;
import com.fasterxml.aalto.impl.ErrorConsts;
import com.fasterxml.aalto.in.ByteBasedPNameTable;
import com.fasterxml.aalto.in.ByteBasedScanner;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.util.CharsetNames;
import com.fasterxml.aalto.util.DataUtil;
import com.fasterxml.aalto.util.XmlCharTypes;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;

public abstract class AsyncByteScanner
extends ByteBasedScanner
implements AsyncInputFeeder {
    protected static final int EVENT_INCOMPLETE = 257;
    protected static final int STATE_DEFAULT = 0;
    protected static final int STATE_PROLOG_INITIAL = 1;
    protected static final int STATE_PROLOG_SEEN_LT = 2;
    protected static final int STATE_PROLOG_DECL = 3;
    protected static final int STATE_TREE_SEEN_LT = 1;
    protected static final int STATE_TREE_SEEN_AMP = 2;
    protected static final int STATE_TREE_SEEN_EXCL = 3;
    protected static final int STATE_TREE_SEEN_SLASH = 4;
    protected static final int STATE_TREE_NUMERIC_ENTITY_START = 5;
    protected static final int STATE_TREE_NAMED_ENTITY_START = 6;
    protected static final int STATE_XMLDECL_AFTER_XML = 1;
    protected static final int STATE_XMLDECL_BEFORE_VERSION = 2;
    protected static final int STATE_XMLDECL_VERSION = 3;
    protected static final int STATE_XMLDECL_AFTER_VERSION = 4;
    protected static final int STATE_XMLDECL_VERSION_EQ = 5;
    protected static final int STATE_XMLDECL_VERSION_VALUE = 6;
    protected static final int STATE_XMLDECL_AFTER_VERSION_VALUE = 7;
    protected static final int STATE_XMLDECL_BEFORE_ENCODING = 8;
    protected static final int STATE_XMLDECL_ENCODING = 9;
    protected static final int STATE_XMLDECL_AFTER_ENCODING = 10;
    protected static final int STATE_XMLDECL_ENCODING_EQ = 11;
    protected static final int STATE_XMLDECL_ENCODING_VALUE = 12;
    protected static final int STATE_XMLDECL_AFTER_ENCODING_VALUE = 13;
    protected static final int STATE_XMLDECL_BEFORE_STANDALONE = 14;
    protected static final int STATE_XMLDECL_STANDALONE = 15;
    protected static final int STATE_XMLDECL_AFTER_STANDALONE = 16;
    protected static final int STATE_XMLDECL_STANDALONE_EQ = 17;
    protected static final int STATE_XMLDECL_STANDALONE_VALUE = 18;
    protected static final int STATE_XMLDECL_AFTER_STANDALONE_VALUE = 19;
    protected static final int STATE_XMLDECL_ENDQ = 20;
    protected static final int STATE_DTD_DOCTYPE = 1;
    protected static final int STATE_DTD_AFTER_DOCTYPE = 2;
    protected static final int STATE_DTD_BEFORE_ROOT_NAME = 3;
    protected static final int STATE_DTD_ROOT_NAME = 4;
    protected static final int STATE_DTD_AFTER_ROOT_NAME = 5;
    protected static final int STATE_DTD_BEFORE_IDS = 6;
    protected static final int STATE_DTD_PUBLIC_OR_SYSTEM = 7;
    protected static final int STATE_DTD_AFTER_PUBLIC = 8;
    protected static final int STATE_DTD_AFTER_SYSTEM = 9;
    protected static final int STATE_DTD_BEFORE_PUBLIC_ID = 10;
    protected static final int STATE_DTD_PUBLIC_ID = 11;
    protected static final int STATE_DTD_AFTER_PUBLIC_ID = 12;
    protected static final int STATE_DTD_BEFORE_SYSTEM_ID = 13;
    protected static final int STATE_DTD_SYSTEM_ID = 14;
    protected static final int STATE_DTD_AFTER_SYSTEM_ID = 15;
    protected static final int STATE_DTD_INT_SUBSET = 16;
    protected static final int STATE_DTD_EXPECT_CLOSING_GT = 50;
    protected static final int STATE_TEXT_AMP = 4;
    protected static final int STATE_TEXT_AMP_NAME = 6;
    protected static final int STATE_COMMENT_CONTENT = 1;
    protected static final int STATE_COMMENT_HYPHEN = 2;
    protected static final int STATE_COMMENT_HYPHEN2 = 3;
    protected static final int STATE_CDATA_CONTENT = 1;
    protected static final int STATE_CDATA_C = 2;
    protected static final int STATE_CDATA_CD = 3;
    protected static final int STATE_CDATA_CDA = 4;
    protected static final int STATE_CDATA_CDAT = 5;
    protected static final int STATE_CDATA_CDATA = 6;
    protected static final int STATE_PI_AFTER_TARGET = 1;
    protected static final int STATE_PI_AFTER_TARGET_WS = 2;
    protected static final int STATE_PI_AFTER_TARGET_QMARK = 3;
    protected static final int STATE_PI_IN_TARGET = 4;
    protected static final int STATE_PI_IN_DATA = 5;
    protected static final int STATE_SE_ELEM_NAME = 1;
    protected static final int STATE_SE_SPACE_OR_END = 2;
    protected static final int STATE_SE_SPACE_OR_ATTRNAME = 3;
    protected static final int STATE_SE_ATTR_NAME = 4;
    protected static final int STATE_SE_SPACE_OR_EQ = 5;
    protected static final int STATE_SE_SPACE_OR_ATTRVALUE = 6;
    protected static final int STATE_SE_ATTR_VALUE_NORMAL = 7;
    protected static final int STATE_SE_ATTR_VALUE_NSDECL = 8;
    protected static final int STATE_SE_SEEN_SLASH = 9;
    protected static final int STATE_EE_NEED_GT = 1;
    protected static final int PENDING_STATE_CR = -1;
    protected static final int PENDING_STATE_XMLDECL_LT = -5;
    protected static final int PENDING_STATE_XMLDECL_LTQ = -6;
    protected static final int PENDING_STATE_XMLDECL_TARGET = -7;
    protected static final int PENDING_STATE_PI_QMARK = -15;
    protected static final int PENDING_STATE_COMMENT_HYPHEN1 = -20;
    protected static final int PENDING_STATE_COMMENT_HYPHEN2 = -21;
    protected static final int PENDING_STATE_CDATA_BRACKET1 = -30;
    protected static final int PENDING_STATE_CDATA_BRACKET2 = -31;
    protected static final int PENDING_STATE_ENT_SEEN_HASH = -70;
    protected static final int PENDING_STATE_ENT_SEEN_HASH_X = -71;
    protected static final int PENDING_STATE_ENT_IN_DEC_DIGIT = -72;
    protected static final int PENDING_STATE_ENT_IN_HEX_DIGIT = -73;
    protected static final int PENDING_STATE_ATTR_VALUE_AMP = -60;
    protected static final int PENDING_STATE_ATTR_VALUE_AMP_HASH = -61;
    protected static final int PENDING_STATE_ATTR_VALUE_AMP_HASH_X = -62;
    protected static final int PENDING_STATE_ATTR_VALUE_ENTITY_NAME = -63;
    protected static final int PENDING_STATE_ATTR_VALUE_DEC_DIGIT = -64;
    protected static final int PENDING_STATE_ATTR_VALUE_HEX_DIGIT = -65;
    protected static final int PENDING_STATE_TEXT_AMP = -80;
    protected static final int PENDING_STATE_TEXT_AMP_HASH = -81;
    protected static final int PENDING_STATE_TEXT_DEC_ENTITY = -82;
    protected static final int PENDING_STATE_TEXT_HEX_ENTITY = -83;
    protected static final int PENDING_STATE_TEXT_IN_ENTITY = -84;
    protected static final int PENDING_STATE_TEXT_BRACKET1 = -85;
    protected static final int PENDING_STATE_TEXT_BRACKET2 = -86;
    protected XmlCharTypes _charTypes;
    protected ByteBasedPNameTable _symbols;
    protected int[] _quadBuffer = new int[32];
    protected int _nextEvent = 257;
    protected int _state;
    protected int _surroundingEvent = 257;
    protected int _pendingInput = 0;
    protected boolean _endOfInput = false;
    protected int _quadCount;
    protected int _currQuad;
    protected int _currQuadBytes = 0;
    protected int _entityValue = 0;
    protected boolean _elemAllNsBound;
    protected boolean _elemAttrCount;
    protected byte _elemAttrQuote;
    protected PName _elemAttrName;
    protected int _elemAttrPtr;
    protected int _elemNsPtr;
    protected boolean _inDtdDeclaration;

    protected AsyncByteScanner(ReaderConfig cfg) {
        super(cfg);
    }

    protected void _activateEncoding() {
        if (this._symbols == null) {
            this._charTypes = this._config.getCharTypes();
            this._symbols = this._config.getBBSymbols();
        }
    }

    @Override
    public void endOfInput() {
        this._endOfInput = true;
    }

    @Override
    protected void _releaseBuffers() {
        super._releaseBuffers();
        if (this._symbols.maybeDirty()) {
            this._config.updateBBSymbols(this._symbols);
        }
    }

    @Override
    protected void _closeSource() throws IOException {
        this._endOfInput = true;
    }

    protected void verifyAndSetXmlVersion() throws XMLStreamException {
        if (this._textBuilder.equalsString("1.0")) {
            this._config.setXmlVersion("1.0");
        } else if (this._textBuilder.equalsString("1.1")) {
            this._config.setXmlVersion("1.1");
        } else {
            this.reportInputProblem("Unrecognized XML version '" + this._textBuilder.contentsAsString() + "' (expected '1.0' or '1.1')");
        }
    }

    protected void verifyAndSetXmlEncoding() throws XMLStreamException {
        String enc = CharsetNames.normalize(this._textBuilder.contentsAsString());
        if ("UTF-8" != enc && "US-ASCII" != enc && "ISO-8859-1" != enc) {
            this.reportInputProblem("Unsupported encoding '" + enc + "': only UTF-8 and US-ASCII support by async parser");
        }
        this._config.setXmlEncoding(enc);
        if (enc != null) {
            this._config.setActualEncoding(enc);
        }
        this._charTypes = this._config.getCharTypes();
    }

    protected void verifyAndSetXmlStandalone() throws XMLStreamException {
        if (this._textBuilder.equalsString("yes")) {
            this._config.setXmlStandalone(Boolean.TRUE);
        } else if (this._textBuilder.equalsString("no")) {
            this._config.setXmlStandalone(Boolean.FALSE);
        } else {
            this.reportInputProblem("Invalid standalone value '" + this._textBuilder.contentsAsString() + "': can only use 'yes' and 'no'");
        }
    }

    protected void verifyAndSetPublicId() throws XMLStreamException {
        this._publicId = this._textBuilder.contentsAsString();
    }

    protected void verifyAndSetSystemId() throws XMLStreamException {
        this._systemId = this._textBuilder.contentsAsString();
    }

    protected abstract byte _currentByte() throws XMLStreamException;

    protected abstract byte _nextByte() throws XMLStreamException;

    protected abstract byte _prevByte() throws XMLStreamException;

    protected abstract int handlePI() throws XMLStreamException;

    protected abstract boolean handleDTDInternalSubset(boolean var1) throws XMLStreamException;

    protected abstract int handleComment() throws XMLStreamException;

    protected abstract int handleStartElementStart(byte var1) throws XMLStreamException;

    protected abstract int handleStartElement() throws XMLStreamException;

    protected abstract PName parsePName() throws XMLStreamException;

    protected abstract PName parseNewName(byte var1) throws XMLStreamException;

    protected abstract boolean asyncSkipSpace() throws XMLStreamException;

    protected abstract boolean handlePartialCR() throws XMLStreamException;

    @Override
    protected final void finishToken() throws XMLStreamException {
        this._tokenIncomplete = false;
        switch (this._currToken) {
            case 3: {
                this.finishPI();
                break;
            }
            case 4: {
                this.finishCharacters();
                break;
            }
            case 5: {
                this.finishComment();
                break;
            }
            case 6: {
                this.finishSpace();
                break;
            }
            case 11: {
                this.finishDTD(true);
                break;
            }
            case 12: {
                this.finishCData();
                break;
            }
            default: {
                ErrorConsts.throwInternalError();
            }
        }
    }

    protected abstract int startCharacters(byte var1) throws XMLStreamException;

    protected abstract boolean handleAttrValue() throws XMLStreamException;

    protected abstract boolean handleNsDecl() throws XMLStreamException;

    @Override
    protected void finishCData() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void finishComment() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void finishDTD(boolean copyContents) throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void finishPI() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void finishSpace() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected abstract boolean skipCharacters() throws XMLStreamException;

    @Override
    protected void skipCData() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void skipComment() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void skipPI() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void skipSpace() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected boolean loadMore() throws XMLStreamException {
        this.throwInternal();
        return false;
    }

    @Override
    protected abstract void finishCharacters() throws XMLStreamException;

    protected final PName findPName(int lastQuad, int lastByteCount) throws XMLStreamException {
        --this._inputPtr;
        int qlen = this._quadCount;
        if (lastByteCount == 0) {
            lastQuad = this._quadBuffer[--qlen];
            lastByteCount = 4;
        }
        if (qlen <= 1) {
            if (qlen == 0) {
                int hash = ByteBasedPNameTable.calcHash(lastQuad);
                PName name = this._symbols.findSymbol(hash, lastQuad, 0);
                if (name == null) {
                    this._quadBuffer[0] = lastQuad;
                    name = this.addPName(this._symbols, hash, this._quadBuffer, 1, lastByteCount);
                }
                return name;
            }
            int firstQuad = this._quadBuffer[0];
            int hash = ByteBasedPNameTable.calcHash(firstQuad, lastQuad);
            PName name = this._symbols.findSymbol(hash, firstQuad, lastQuad);
            if (name == null) {
                this._quadBuffer[1] = lastQuad;
                name = this.addPName(this._symbols, hash, this._quadBuffer, 2, lastByteCount);
            }
            return name;
        }
        if (qlen >= this._quadBuffer.length) {
            this._quadBuffer = DataUtil.growArrayBy(this._quadBuffer, this._quadBuffer.length);
        }
        this._quadBuffer[qlen++] = lastQuad;
        int hash = ByteBasedPNameTable.calcHash(this._quadBuffer, qlen);
        PName name = this._symbols.findSymbol(hash, this._quadBuffer, qlen);
        if (name == null) {
            name = this.addPName(this._symbols, hash, this._quadBuffer, qlen, lastByteCount);
        }
        return name;
    }

    protected final PName addPName(ByteBasedPNameTable symbols, int hash, int[] quads, int qlen, int lastQuadBytes) throws XMLStreamException {
        return this.addUTFPName(symbols, this._charTypes, hash, quads, qlen, lastQuadBytes);
    }

    protected void verifyAndAppendEntityCharacter(int charFromEntity) throws XMLStreamException {
        this.verifyXmlChar(charFromEntity);
        if (charFromEntity >> 16 != 0) {
            this._textBuilder.append((char)(0xD800 | (charFromEntity -= 65536) >> 10));
            charFromEntity = 0xDC00 | charFromEntity & 0x3FF;
        }
        this._textBuilder.append((char)charFromEntity);
    }

    protected boolean validPublicIdChar(int c) {
        return c == 10 || c == 13 || c == 32 || c >= 48 && c <= 57 || c >= 64 && c <= 90 || c >= 97 && c <= 122 || c == 33 || c >= 35 && c <= 37 || c >= 39 && c <= 47 || c >= 58 && c <= 59 || c == 61 || c == 63 || c == 95;
    }

    @Override
    protected int decodeCharForError(byte b) throws XMLStreamException {
        return b;
    }

    protected void checkPITargetName(PName targetName) throws XMLStreamException {
        String ln = targetName.getLocalName();
        if (ln.length() == 3 && ln.equalsIgnoreCase("xml") && !targetName.hasPrefix()) {
            this.reportInputProblem(ErrorConsts.ERR_WF_PI_XML_TARGET);
        }
    }

    protected int throwInternal() {
        throw new IllegalStateException("Internal error: should never execute this code path");
    }

    protected void reportInvalidOther(int mask, int ptr) throws XMLStreamException {
        this._inputPtr = ptr;
        this.reportInvalidOther(mask);
    }

    @Override
    public final int nextFromProlog(boolean isProlog) throws XMLStreamException {
        if (this._currToken != 257) {
            this.setStartLocation();
            if (this._currToken == 7) {
                this._currToken = 257;
                if (this._tokenName != null) {
                    this._nextEvent = 3;
                    this._state = 1;
                    this.checkPITargetName(this._tokenName);
                    return this.handlePI();
                }
            } else {
                this._nextEvent = 257;
                this._currToken = 257;
                this._state = 0;
            }
        }
        if (this._nextEvent == 257) {
            byte b;
            if (this._state == 1) {
                if (this._inputPtr >= this._inputEnd) {
                    return this._currToken;
                }
                if (this._pendingInput != 0) {
                    Boolean b2 = this.startXmlDeclaration();
                    if (b2 == null) {
                        return 257;
                    }
                    if (b2 == Boolean.FALSE) {
                        return this._startDocumentNoXmlDecl();
                    }
                    return this.handleXmlDeclaration();
                }
                if (this._currentByte() == 60) {
                    ++this._inputPtr;
                    this._pendingInput = -5;
                    Boolean b3 = this.startXmlDeclaration();
                    if (b3 == null) {
                        return 257;
                    }
                    if (b3 == Boolean.FALSE) {
                        return this._startDocumentNoXmlDecl();
                    }
                    return this.handleXmlDeclaration();
                }
                this._state = 0;
                return this._startDocumentNoXmlDecl();
            }
            if (this._pendingInput != 0 && !this.handlePartialCR()) {
                return this._currToken;
            }
            while (this._state == 0) {
                if (this._inputPtr >= this._inputEnd) {
                    if (this._endOfInput) {
                        this.setStartLocation();
                        return -1;
                    }
                    return this._currToken;
                }
                b = this._nextByte();
                if (b == 60) {
                    this._state = 2;
                    break;
                }
                if (b == 32 || b == 13 || b == 10 || b == 9) {
                    if (this.asyncSkipSpace()) continue;
                    if (this._endOfInput) {
                        this.setStartLocation();
                        return -1;
                    }
                    return this._currToken;
                }
                this.reportPrologUnexpChar(isProlog, this.decodeCharForError(b), null);
            }
            if (this._state == 2) {
                if (this._inputPtr >= this._inputEnd) {
                    return this._currToken;
                }
                b = this._nextByte();
                if (b == 33) {
                    this._state = 3;
                    return this.handlePrologDeclStart(isProlog);
                }
                if (b == 63) {
                    this._nextEvent = 3;
                    this._state = 0;
                    return this.handlePI();
                }
                if (b == 47 || !isProlog) {
                    this.reportPrologUnexpElement(isProlog, b);
                }
                return this.handleStartElementStart(b);
            }
            if (this._state == 3) {
                return this.handlePrologDeclStart(isProlog);
            }
            return this.throwInternal();
        }
        switch (this._nextEvent) {
            case 1: {
                return this.handleStartElement();
            }
            case 7: {
                return this.handleXmlDeclaration();
            }
            case 3: {
                return this.handlePI();
            }
            case 5: {
                return this.handleComment();
            }
            case 11: {
                return this.handleDTD();
            }
        }
        return this.throwInternal();
    }

    protected int _startDocumentNoXmlDecl() throws XMLStreamException {
        this._activateEncoding();
        this._currToken = 7;
        return 7;
    }

    private final int handlePrologDeclStart(boolean isProlog) throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            return 257;
        }
        byte b = this._nextByte();
        if (b == 45) {
            this._nextEvent = 5;
            this._state = 0;
            return this.handleComment();
        }
        if (b == 68) {
            this._nextEvent = 11;
            this._state = 0;
            return this.handleDTD();
        }
        this.reportPrologUnexpChar(isProlog, this.decodeCharForError(b), " (expected '-' for COMMENT)");
        return 257;
    }

    private final Boolean startXmlDeclaration() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            return null;
        }
        if (this._pendingInput == -5) {
            if (this._currentByte() != 63) {
                this._pendingInput = 0;
                this._state = 2;
                return Boolean.FALSE;
            }
            ++this._inputPtr;
            this._pendingInput = -6;
            if (this._inputPtr >= this._inputEnd) {
                return null;
            }
        }
        if (this._pendingInput == -6) {
            byte b = this._nextByte();
            this._tokenName = this._parseNewXmlDeclName(b);
            if (this._tokenName == null) {
                this._pendingInput = -7;
                return null;
            }
            if (!"xml".equals(this._tokenName.getPrefixedName())) {
                this._pendingInput = 0;
                this._state = 1;
                this._nextEvent = 3;
                this.checkPITargetName(this._tokenName);
                return Boolean.FALSE;
            }
        } else if (this._pendingInput == -7) {
            this._tokenName = this._parseXmlDeclName();
            if (this._tokenName == null) {
                return null;
            }
            if (!"xml".equals(this._tokenName.getPrefixedName())) {
                this._pendingInput = 0;
                this._state = 1;
                this._nextEvent = 3;
                this.checkPITargetName(this._tokenName);
                return Boolean.FALSE;
            }
        } else {
            this.throwInternal();
        }
        this._pendingInput = 0;
        this._nextEvent = 7;
        this._state = 1;
        return Boolean.TRUE;
    }

    private int handleXmlDeclaration() throws XMLStreamException {
        if (this._pendingInput == -1 && !this.handlePartialCR()) {
            return 257;
        }
        block22: while (this._inputPtr < this._inputEnd) {
            switch (this._state) {
                case 1: {
                    byte b = this._nextByte();
                    if (b == 32 || b == 13 || b == 10 || b == 9) {
                        this._state = 2;
                    } else {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(b), " (expected space after 'xml' in xml declaration)");
                    }
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 2: {
                    if (!this.asyncSkipSpace()) continue block22;
                    this._tokenName = this._parseNewXmlDeclName(this._nextByte());
                    if (this._tokenName == null) {
                        this._state = 3;
                        continue block22;
                    }
                    if (!this._tokenName.hasPrefixedName("version")) {
                        this.reportInputProblem("Unexpected keyword '" + this._tokenName.getPrefixedName() + "' in XML declaration: expected 'version'");
                    }
                    this._state = 4;
                    continue block22;
                }
                case 3: {
                    this._tokenName = this._parseXmlDeclName();
                    if (this._tokenName == null) continue block22;
                    if (!this._tokenName.hasPrefixedName("version")) {
                        this.reportInputProblem("Unexpected keyword '" + this._tokenName.getPrefixedName() + "' in XML declaration: expected 'version'");
                    }
                    this._state = 4;
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 4: {
                    if (!this.asyncSkipSpace()) continue block22;
                    byte b = this._nextByte();
                    if (b != 61) {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(b), " (expected '=' after 'version' in xml declaration)");
                    }
                    this._state = 5;
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 5: {
                    if (!this.asyncSkipSpace()) continue block22;
                    this._elemAttrQuote = this._nextByte();
                    if (this._elemAttrQuote != 34 && this._elemAttrQuote != 39) {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(this._elemAttrQuote), " (expected '\"' or ''' in xml declaration for version value)");
                    }
                    char[] buf = this._textBuilder.resetWithEmpty();
                    if (this._inputPtr >= this._inputEnd || !this.parseXmlDeclAttr(buf, 0)) {
                        this._state = 6;
                        continue block22;
                    }
                    this.verifyAndSetXmlVersion();
                    this._state = 7;
                    continue block22;
                }
                case 6: {
                    if (!this.parseXmlDeclAttr(this._textBuilder.getBufferWithoutReset(), this._textBuilder.getCurrentLength())) {
                        this._state = 6;
                        continue block22;
                    }
                    this.verifyAndSetXmlVersion();
                    this._state = 7;
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 7: {
                    byte b = this._nextByte();
                    if (b == 63) {
                        this._state = 20;
                        continue block22;
                    }
                    if (b == 32 || b == 13 || b == 10 || b == 9) {
                        this._state = 8;
                    } else {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(b), " (expected space after version value in xml declaration)");
                    }
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 8: {
                    if (!this.asyncSkipSpace()) continue block22;
                    byte b = this._nextByte();
                    if (b == 63) {
                        this._state = 20;
                        continue block22;
                    }
                    this._tokenName = this._parseNewXmlDeclName(b);
                    if (this._tokenName == null) {
                        this._state = 9;
                        continue block22;
                    }
                    if (this._tokenName.hasPrefixedName("encoding")) {
                        this._state = 10;
                        continue block22;
                    }
                    if (this._tokenName.hasPrefixedName("standalone")) {
                        this._state = 16;
                        continue block22;
                    }
                    this.reportInputProblem("Unexpected keyword '" + this._tokenName.getPrefixedName() + "' in XML declaration: expected 'encoding'");
                    continue block22;
                }
                case 9: {
                    this._tokenName = this._parseXmlDeclName();
                    if (this._tokenName == null) continue block22;
                    if (this._tokenName.hasPrefixedName("encoding")) {
                        this._state = 10;
                    } else {
                        if (this._tokenName.hasPrefixedName("standalone")) {
                            this._state = 16;
                            continue block22;
                        }
                        this.reportInputProblem("Unexpected keyword '" + this._tokenName.getPrefixedName() + "' in XML declaration: expected 'encoding'");
                    }
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 10: {
                    if (!this.asyncSkipSpace()) continue block22;
                    byte b = this._nextByte();
                    if (b != 61) {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(b), " (expected '=' after 'encoding' in xml declaration)");
                    }
                    this._state = 11;
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 11: {
                    if (!this.asyncSkipSpace()) continue block22;
                    this._elemAttrQuote = this._nextByte();
                    if (this._elemAttrQuote != 34 && this._elemAttrQuote != 39) {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(this._elemAttrQuote), " (expected '\"' or ''' in xml declaration for encoding value)");
                    }
                    this._state = 12;
                    char[] buf = this._textBuilder.resetWithEmpty();
                    if (this._inputPtr >= this._inputEnd || !this.parseXmlDeclAttr(buf, 0)) {
                        this._state = 12;
                        continue block22;
                    }
                    this.verifyAndSetXmlEncoding();
                    this._state = 13;
                    continue block22;
                }
                case 12: {
                    if (!this.parseXmlDeclAttr(this._textBuilder.getBufferWithoutReset(), this._textBuilder.getCurrentLength())) {
                        this._state = 12;
                        continue block22;
                    }
                    this.verifyAndSetXmlEncoding();
                    this._state = 13;
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 13: {
                    byte b = this._nextByte();
                    if (b == 63) {
                        this._state = 20;
                        continue block22;
                    }
                    if (b == 32 || b == 13 || b == 10 || b == 9) {
                        this._state = 14;
                    } else {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(b), " (expected space after encoding value in xml declaration)");
                    }
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 14: {
                    if (!this.asyncSkipSpace()) continue block22;
                    byte b = this._nextByte();
                    if (b == 63) {
                        this._state = 20;
                        continue block22;
                    }
                    this._tokenName = this._parseNewXmlDeclName(b);
                    if (this._tokenName == null) {
                        this._state = 15;
                        continue block22;
                    }
                    if (!this._tokenName.hasPrefixedName("standalone")) {
                        this.reportInputProblem("Unexpected keyword '" + this._tokenName.getPrefixedName() + "' in XML declaration: expected 'standalone'");
                    }
                    this._state = 16;
                    continue block22;
                }
                case 15: {
                    this._tokenName = this._parseXmlDeclName();
                    if (this._tokenName == null) continue block22;
                    if (!this._tokenName.hasPrefixedName("standalone")) {
                        this.reportInputProblem("Unexpected keyword 'encoding' in XML declaration: expected 'standalone'");
                    }
                    this._state = 16;
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 16: {
                    if (!this.asyncSkipSpace()) continue block22;
                    byte b = this._nextByte();
                    if (b != 61) {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(b), " (expected '=' after 'standalone' in xml declaration)");
                    }
                    this._state = 17;
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 17: {
                    if (!this.asyncSkipSpace()) continue block22;
                    this._elemAttrQuote = this._nextByte();
                    if (this._elemAttrQuote != 34 && this._elemAttrQuote != 39) {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(this._elemAttrQuote), " (expected '\"' or ''' in xml declaration for standalone value)");
                    }
                    char[] buf = this._textBuilder.resetWithEmpty();
                    if (this._inputPtr >= this._inputEnd || !this.parseXmlDeclAttr(buf, 0)) {
                        this._state = 18;
                        continue block22;
                    }
                    this.verifyAndSetXmlStandalone();
                    this._state = 19;
                    continue block22;
                }
                case 18: {
                    if (!this.parseXmlDeclAttr(this._textBuilder.getBufferWithoutReset(), this._textBuilder.getCurrentLength())) {
                        this._state = 18;
                        continue block22;
                    }
                    this.verifyAndSetXmlStandalone();
                    this._state = 19;
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 19: {
                    if (!this.asyncSkipSpace()) continue block22;
                    if (this._nextByte() != 63) {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(this._prevByte()), " (expected '?>' to end xml declaration)");
                    }
                    this._state = 20;
                    if (this._inputPtr >= this._inputEnd) continue block22;
                }
                case 20: {
                    this._tokenName = null;
                    this._state = 0;
                    this._nextEvent = 257;
                    if (this._nextByte() != 62) {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(this._prevByte()), " (expected '>' to end xml declaration)");
                    }
                    this._activateEncoding();
                    return 7;
                }
            }
            this.throwInternal();
        }
        return 257;
    }

    private int handleDTD() throws XMLStreamException {
        if (this._pendingInput == -1 && !this.handlePartialCR()) {
            return 257;
        }
        if (this._state == 16) {
            if (this.handleDTDInternalSubset(false)) {
                this._state = 50;
            } else {
                return 257;
            }
        }
        block19: while (this._inputPtr < this._inputEnd) {
            switch (this._state) {
                case 0: {
                    this._tokenName = this.parseNewName((byte)68);
                    if (this._tokenName == null) {
                        this._state = 1;
                        return 257;
                    }
                    if (!"DOCTYPE".equals(this._tokenName.getPrefixedName())) {
                        this.reportPrologProblem(true, "expected 'DOCTYPE'");
                    }
                    this._state = 2;
                    continue block19;
                }
                case 1: {
                    this._tokenName = this.parsePName();
                    if (this._tokenName == null) {
                        this._state = 1;
                        return 257;
                    }
                    if (!"DOCTYPE".equals(this._tokenName.getPrefixedName())) {
                        this.reportPrologProblem(true, "expected 'DOCTYPE'");
                    }
                    if (this._inputPtr >= this._inputEnd) continue block19;
                }
                case 2: {
                    byte b = this._nextByte();
                    if (b == 32 || b == 13 || b == 10 || b == 9) {
                        this._state = 3;
                    } else {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(b), " (expected space after 'DOCTYPE')");
                    }
                }
                case 3: {
                    if (!this.asyncSkipSpace()) continue block19;
                    this._tokenName = this.parseNewName(this._nextByte());
                    if (this._tokenName == null) {
                        this._state = 4;
                        continue block19;
                    }
                    this._state = 4;
                    continue block19;
                }
                case 4: {
                    this._tokenName = this.parsePName();
                    if (this._tokenName == null) continue block19;
                    this._state = 5;
                    if (this._inputPtr >= this._inputEnd) continue block19;
                }
                case 5: {
                    byte b = this._nextByte();
                    if (b == 62) {
                        this._state = 0;
                        this._nextEvent = 257;
                        return 11;
                    }
                    if (b == 32 || b == 13 || b == 10 || b == 9) {
                        this._state = 6;
                    } else {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(b), " (expected space after root name in DOCTYPE declaration)");
                    }
                }
                case 6: {
                    if (!this.asyncSkipSpace()) continue block19;
                    byte b = this._nextByte();
                    if (b == 62) {
                        this._state = 0;
                        this._nextEvent = 257;
                        return 11;
                    }
                    PName name = this.parseNewName(b);
                    if (name == null) {
                        this._state = 7;
                        continue block19;
                    }
                    String str = name.getPrefixedName();
                    if ("PUBLIC".equals(str)) {
                        this._state = 8;
                        continue block19;
                    }
                    if ("SYSTEM".equals(str)) {
                        this._state = 9;
                        continue block19;
                    }
                    this.reportPrologProblem(true, "unexpected token '" + str + "': expected either PUBLIC or SYSTEM");
                    continue block19;
                }
                case 7: {
                    PName name = this.parsePName();
                    if (name == null) {
                        this._state = 7;
                        continue block19;
                    }
                    String str = name.getPrefixedName();
                    if ("PUBLIC".equals(str)) {
                        this._state = 8;
                        continue block19;
                    }
                    if ("SYSTEM".equals(str)) {
                        this._state = 9;
                        continue block19;
                    }
                    this.reportPrologProblem(true, "unexpected token '" + str + "': expected either PUBLIC or SYSTEM");
                    continue block19;
                }
                case 8: {
                    byte b = this._nextByte();
                    if (b == 32 || b == 13 || b == 10 || b == 9) {
                        this._state = 10;
                        continue block19;
                    }
                    this.reportPrologUnexpChar(true, this.decodeCharForError(b), " (expected space after PUBLIC keyword)");
                    continue block19;
                }
                case 9: {
                    byte b = this._nextByte();
                    if (b == 32 || b == 13 || b == 10 || b == 9) {
                        this._state = 13;
                        continue block19;
                    }
                    this.reportPrologUnexpChar(true, this.decodeCharForError(b), " (expected space after SYSTEM keyword)");
                    continue block19;
                }
                case 10: {
                    if (!this.asyncSkipSpace()) continue block19;
                    this._elemAttrQuote = this._nextByte();
                    if (this._elemAttrQuote != 34 && this._elemAttrQuote != 39) {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(this._elemAttrQuote), " (expected '\"' or ''' for PUBLIC ID)");
                    }
                    char[] buf = this._textBuilder.resetWithEmpty();
                    if (this._inputPtr >= this._inputEnd || !this.parseDtdId(buf, 0, false)) {
                        this._state = 11;
                        continue block19;
                    }
                    this.verifyAndSetPublicId();
                    this._state = 12;
                    continue block19;
                }
                case 11: {
                    if (!this.parseDtdId(this._textBuilder.getBufferWithoutReset(), this._textBuilder.getCurrentLength(), false)) continue block19;
                    this.verifyAndSetPublicId();
                    this._state = 12;
                    if (this._inputPtr >= this._inputEnd) continue block19;
                }
                case 12: {
                    byte b = this._nextByte();
                    if (b == 32 || b == 13 || b == 10 || b == 9) {
                        this._state = 13;
                    } else {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(b), " (expected space after PUBLIC ID)");
                    }
                }
                case 13: {
                    if (!this.asyncSkipSpace()) continue block19;
                    this._elemAttrQuote = this._nextByte();
                    if (this._elemAttrQuote != 34 && this._elemAttrQuote != 39) {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(this._elemAttrQuote), " (expected '\"' or ''' for SYSTEM ID)");
                    }
                    char[] buf = this._textBuilder.resetWithEmpty();
                    if (this._inputPtr >= this._inputEnd || !this.parseDtdId(buf, 0, true)) {
                        this._state = 14;
                        continue block19;
                    }
                    this.verifyAndSetSystemId();
                    this._state = 15;
                    continue block19;
                }
                case 14: {
                    if (!this.parseDtdId(this._textBuilder.getBufferWithoutReset(), this._textBuilder.getCurrentLength(), true)) continue block19;
                    this.verifyAndSetSystemId();
                    this._state = 15;
                    if (this._inputPtr >= this._inputEnd) continue block19;
                }
                case 15: {
                    if (!this.asyncSkipSpace()) continue block19;
                    byte b = this._nextByte();
                    if (b == 62) {
                        this._state = 0;
                        this._nextEvent = 257;
                        return 11;
                    }
                    if (b != 91) {
                        this.reportPrologUnexpChar(true, this.decodeCharForError(this._elemAttrQuote), " (expected either '[' for internal subset, or '>' to end DOCTYPE)");
                    }
                    this._state = 16;
                    if (this.handleDTDInternalSubset(true)) {
                        this._state = 50;
                    } else {
                        return 257;
                    }
                }
                case 50: {
                    if (!this.asyncSkipSpace()) continue block19;
                    byte b = this._nextByte();
                    if (b != 62) {
                        this.reportPrologUnexpChar(true, b, "expected '>' to end DTD");
                    }
                    this._state = 0;
                    this._nextEvent = 257;
                    return 11;
                }
            }
            this.throwInternal();
        }
        return this._currToken;
    }

    private final boolean parseDtdId(char[] outputBuffer, int outputPtr, boolean system) throws XMLStreamException {
        byte quote = this._elemAttrQuote;
        while (this._inputPtr < this._inputEnd) {
            int ch = this._nextByte() & 0xFF;
            if (ch == quote) {
                this._textBuilder.setCurrentLength(outputPtr);
                return true;
            }
            if (!system && !this.validPublicIdChar(ch)) {
                this.reportPrologUnexpChar(true, this.decodeCharForError((byte)ch), " (not valid in " + (system ? "SYSTEM" : "PUBLIC") + " ID)");
            }
            if (outputPtr >= outputBuffer.length) {
                outputBuffer = this._textBuilder.finishCurrentSegment();
                outputPtr = 0;
            }
            outputBuffer[outputPtr++] = (char)ch;
        }
        this._textBuilder.setCurrentLength(outputPtr);
        return false;
    }

    private final PName _parseNewXmlDeclName(byte b) throws XMLStreamException {
        int q = b & 0xFF;
        if (q < 65) {
            this.throwUnexpectedChar(q, "; expected a name start character");
        }
        this._quadCount = 0;
        this._currQuad = q;
        this._currQuadBytes = 1;
        return this._parseXmlDeclName();
    }

    private final PName _parseXmlDeclName() throws XMLStreamException {
        int q = this._currQuad;
        while (true) {
            switch (this._currQuadBytes) {
                case 0: {
                    if (this._inputPtr >= this._inputEnd) {
                        return null;
                    }
                    q = this._nextByte() & 0xFF;
                    if (q < 65 && (q < 45 || q > 58 || q == 47)) {
                        return this._findXmlDeclName(q, 0);
                    }
                }
                case 1: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._currQuad = q;
                        this._currQuadBytes = 1;
                        return null;
                    }
                    int i = this._nextByte() & 0xFF;
                    if (i < 65 && (i < 45 || i > 58 || i == 47)) {
                        return this._findXmlDeclName(q, 1);
                    }
                    q = q << 8 | i;
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._currQuad = q;
                        this._currQuadBytes = 2;
                        return null;
                    }
                    int i = this._nextByte() & 0xFF;
                    if (i < 65 && (i < 45 || i > 58 || i == 47)) {
                        return this._findXmlDeclName(q, 2);
                    }
                    q = q << 8 | i;
                }
                case 3: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._currQuad = q;
                        this._currQuadBytes = 3;
                        return null;
                    }
                    int i = this._nextByte() & 0xFF;
                    if (i < 65 && (i < 45 || i > 58 || i == 47)) {
                        return this._findXmlDeclName(q, 3);
                    }
                    q = q << 8 | i;
                }
            }
            if (this._quadCount == 0) {
                this._quadBuffer[0] = q;
                this._quadCount = 1;
            } else {
                if (this._quadCount >= this._quadBuffer.length) {
                    this._quadBuffer = DataUtil.growArrayBy(this._quadBuffer, this._quadBuffer.length);
                }
                this._quadBuffer[this._quadCount++] = q;
            }
            this._currQuadBytes = 0;
        }
    }

    protected final PName _findXmlDeclName(int lastQuad, int lastByteCount) throws XMLStreamException {
        PName pname;
        int qlen = this._quadCount;
        if (lastByteCount == 0) {
            lastQuad = this._quadBuffer[--qlen];
        }
        switch (qlen) {
            case 0: {
                pname = AsyncXmlDeclHelper.find(lastQuad);
                break;
            }
            case 1: {
                pname = AsyncXmlDeclHelper.find(this._quadBuffer[0], lastQuad);
                break;
            }
            case 2: {
                pname = AsyncXmlDeclHelper.find(this._quadBuffer[0], this._quadBuffer[1], lastQuad);
                break;
            }
            default: {
                pname = null;
            }
        }
        if (pname != null) {
            --this._inputPtr;
            return pname;
        }
        this._activateEncoding();
        return this.findPName(lastQuad, lastByteCount);
    }

    protected boolean parseXmlDeclAttr(char[] outputBuffer, int outputPtr) throws XMLStreamException {
        byte quote = this._elemAttrQuote;
        while (this._inputPtr < this._inputEnd) {
            int ch = this._nextByte() & 0xFF;
            if (ch == quote) {
                this._textBuilder.setCurrentLength(outputPtr);
                return true;
            }
            if (ch <= 32 || ch > 122) {
                this.reportPrologUnexpChar(true, this.decodeCharForError((byte)ch), " (not valid in XML pseudo-attribute values)");
            }
            if (outputPtr >= outputBuffer.length) {
                outputBuffer = this._textBuilder.finishCurrentSegment();
                outputPtr = 0;
            }
            outputBuffer[outputPtr++] = (char)ch;
        }
        this._textBuilder.setCurrentLength(outputPtr);
        return false;
    }
}

