/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.widget.FrameLayout;

public class DashboardCell
extends FrameLayout {
    private OnInterceptedLongPressListener listener;
    long beginTime;

    public DashboardCell(Context context) {
        super(context);
    }

    public DashboardCell(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public DashboardCell(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.beginTime = ev.getEventTime();
                break;
            }
            case 1: 
            case 3: {
                long eventLength = ev.getEventTime() - this.beginTime;
                if (eventLength <= (long)ViewConfiguration.getLongPressTimeout()) break;
                if (this.listener != null) {
                    this.listener.onInterceptedLongPress(this);
                }
                this.cancelLongPress();
                return true;
            }
        }
        return false;
    }

    public void setOnInterceptedLongPressListener(OnInterceptedLongPressListener listener) {
        this.listener = listener;
    }

    public static interface OnInterceptedLongPressListener {
        public void onInterceptedLongPress(DashboardCell var1);
    }
}

