/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.util;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.AlertDialog;
import android.app.AppOpsManager;
import android.app.Service;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.LauncherActivityInfo;
import android.content.pm.LauncherApps;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ShortcutInfo;
import android.content.pm.ShortcutManager;
import android.content.pm.Signature;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.hardware.display.DisplayManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Process;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import android.widget.ImageView;
import androidx.annotation.DimenRes;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.activity.ContextMenuActivity;
import com.farmerbb.taskbar.activity.DummyActivity;
import com.farmerbb.taskbar.activity.InvisibleActivityFreeform;
import com.farmerbb.taskbar.activity.MainActivity;
import com.farmerbb.taskbar.activity.TouchAbsorberActivity;
import com.farmerbb.taskbar.helper.FreeformHackHelper;
import com.farmerbb.taskbar.helper.GlobalHelper;
import com.farmerbb.taskbar.helper.LauncherHelper;
import com.farmerbb.taskbar.helper.MenuHelper;
import com.farmerbb.taskbar.helper.ToastHelper;
import com.farmerbb.taskbar.service.DashboardService;
import com.farmerbb.taskbar.service.NotificationService;
import com.farmerbb.taskbar.service.PowerMenuService;
import com.farmerbb.taskbar.service.StartMenuService;
import com.farmerbb.taskbar.service.TaskbarService;
import com.farmerbb.taskbar.util.AppEntry;
import com.farmerbb.taskbar.util.ApplicationType;
import com.farmerbb.taskbar.util.Callbacks;
import com.farmerbb.taskbar.util.DependencyUtils;
import com.farmerbb.taskbar.util.DisplayInfo;
import com.farmerbb.taskbar.util.IconCache;
import com.farmerbb.taskbar.util.Lazy;
import com.farmerbb.taskbar.util.PinnedBlockedApps;
import com.farmerbb.taskbar.util.SavedWindowSizes;
import com.farmerbb.taskbar.util.ShortcutUtils;
import com.farmerbb.taskbar.util.TaskbarPosition;
import com.farmerbb.taskbar.util.ToastInterface;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class U {
    private static final int MAXIMIZED = 0;
    private static final int LEFT = -1;
    private static final int RIGHT = 1;
    public static final int HIDDEN = 0;
    public static final int TOP_APPS = 1;
    private static final int FULLSCREEN_WORKSPACE_STACK_ID = 1;
    private static final int FREEFORM_WORKSPACE_STACK_ID = 2;
    private static final int WINDOWING_MODE_FULLSCREEN = 1;
    private static final int WINDOWING_MODE_FREEFORM = 5;
    public static final int EXPORT = 123;
    public static final int IMPORT = 456;
    public static final int IMAGE_REQUEST_CODE = 1001;

    private U() {
    }

    public static SharedPreferences getSharedPreferences(Context context) {
        return context.getSharedPreferences("com.farmerbb.taskbar_preferences", 0);
    }

    public static void showPermissionDialog(Context context) {
        Callbacks callbacks = new Callbacks();
        callbacks.onError = () -> U.showErrorDialog(context, "SYSTEM_ALERT_WINDOW", callbacks);
        U.showPermissionDialog(context, callbacks);
    }

    public static AlertDialog showPermissionDialog(Context context, Callbacks callbacks) {
        AlertDialog.Builder builder = U.hasAndroidTVSettings(context) ? U.buildPermissionDialogAndroidTV(context, callbacks) : U.buildPermissionDialogStandard(context, callbacks);
        AlertDialog dialog = builder.create();
        dialog.show();
        dialog.setCancelable(false);
        return dialog;
    }

    @TargetApi(value=23)
    private static AlertDialog.Builder buildPermissionDialogStandard(Context context, Callbacks callbacks) {
        String message = context.getString(R.string.tb_permission_dialog_message) + context.getString(R.string.tb_permission_dialog_instructions_phone);
        return new AlertDialog.Builder(context).setTitle(R.string.tb_permission_dialog_title).setMessage((CharSequence)message).setPositiveButton(R.string.tb_action_grant_permission, (dialog, which) -> {
            try {
                Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + context.getPackageName())));
                intent.addFlags(0x10000000);
                context.startActivity(intent);
                callbacks.onFinish.run();
            }
            catch (ActivityNotFoundException e) {
                callbacks.onError.run();
            }
        });
    }

    private static AlertDialog.Builder buildPermissionDialogAndroidTV(Context context, Callbacks callbacks) {
        String message = context.getString(R.string.tb_permission_dialog_message) + context.getString(R.string.tb_permission_dialog_instructions_tv);
        return new AlertDialog.Builder(context).setTitle(R.string.tb_permission_dialog_title).setMessage((CharSequence)message).setPositiveButton(R.string.tb_action_open_settings, (dialog, which) -> {
            try {
                Intent intent = new Intent("android.settings.MANAGE_APPLICATIONS_SETTINGS");
                intent.addFlags(0x10000000);
                context.startActivity(intent);
                callbacks.onFinish.run();
            }
            catch (ActivityNotFoundException e) {
                callbacks.onError.run();
            }
        });
    }

    public static AlertDialog showErrorDialog(Context context, String appopCmd) {
        return U.showErrorDialog(context, appopCmd, new Callbacks());
    }

    private static AlertDialog showErrorDialog(Context context, String appopCmd, Callbacks callbacks) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle(R.string.tb_error_dialog_title).setMessage((CharSequence)context.getString(R.string.tb_error_dialog_message, new Object[]{context.getPackageName(), appopCmd})).setPositiveButton(R.string.tb_action_ok, (dialog, which) -> callbacks.onFinish.run());
        AlertDialog dialog2 = builder.create();
        dialog2.show();
        dialog2.setCancelable(false);
        return dialog2;
    }

    @TargetApi(value=28)
    public static void lockDevice(Context context) {
        U.sendAccessibilityAction(context, 8);
    }

    public static void sendAccessibilityAction(Context context, int action) {
        U.sendAccessibilityAction(context, action, null);
    }

    public static void sendAccessibilityAction(Context context, int action, Runnable onComplete) {
        U.setComponentEnabled(context, PowerMenuService.class, true);
        boolean isAccessibilityServiceEnabled = U.isAccessibilityServiceEnabled(context);
        if (!isAccessibilityServiceEnabled && U.hasWriteSecureSettingsPermission(context)) {
            String powerMenuService;
            String services = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"enabled_accessibility_services");
            String finalServices = services == null ? "" : services;
            if (!finalServices.contains(powerMenuService = new ComponentName(context, PowerMenuService.class).flattenToString())) {
                try {
                    Settings.Secure.putString((ContentResolver)context.getContentResolver(), (String)"enabled_accessibility_services", (String)(finalServices.isEmpty() ? powerMenuService : finalServices + ":" + powerMenuService));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            new Handler().postDelayed(() -> {
                Intent intent = new Intent("com.farmerbb.taskbar.ACCESSIBILITY_ACTION");
                intent.putExtra("action", action);
                U.sendBroadcast(context, intent);
                try {
                    Settings.Secure.putString((ContentResolver)context.getContentResolver(), (String)"enabled_accessibility_services", (String)finalServices);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (onComplete != null) {
                    onComplete.run();
                }
            }, 100L);
        } else if (isAccessibilityServiceEnabled) {
            Intent intent = new Intent("com.farmerbb.taskbar.ACCESSIBILITY_ACTION");
            intent.putExtra("action", action);
            U.sendBroadcast(context, intent);
            if (onComplete != null) {
                onComplete.run();
            }
        } else {
            U.launchApp(context, () -> {
                Intent intent = new Intent(context, DummyActivity.class);
                intent.putExtra("accessibility", true);
                intent.setFlags(0x10010000);
                try {
                    context.startActivity(intent, U.getActivityOptionsBundle(context, ApplicationType.APP_PORTRAIT, null));
                }
                catch (IllegalArgumentException | SecurityException runtimeException) {
                    // empty catch block
                }
            });
        }
    }

    public static boolean isAccessibilityServiceEnabled(Context context) {
        String accessibilityServices = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"enabled_accessibility_services");
        ComponentName component = new ComponentName(context, PowerMenuService.class);
        return accessibilityServices != null && (accessibilityServices.contains(component.flattenToString()) || accessibilityServices.contains(component.flattenToShortString()));
    }

    public static boolean hasWriteSecureSettingsPermission(Context context) {
        return Build.VERSION.SDK_INT >= 23 && context.checkSelfPermission("android.permission.WRITE_SECURE_SETTINGS") == 0;
    }

    public static void showToast(Context context, int message) {
        U.showToast(context, context.getString(message), 0);
    }

    public static void showToastLong(Context context, int message) {
        U.showToast(context, context.getString(message), 1);
    }

    public static void showToast(Context context, String message, int length) {
        U.cancelToast();
        ToastInterface toast = DependencyUtils.createToast(U.getDisplayContext(context), message, length);
        toast.show();
        ToastHelper.getInstance().setLastToast(toast);
    }

    public static void cancelToast() {
        ToastInterface toast = ToastHelper.getInstance().getLastToast();
        if (toast != null) {
            toast.cancel();
        }
    }

    public static void startShortcut(Context context, AppEntry entry, ShortcutInfo shortcut, View view) {
        U.launchApp(context, entry, null, false, false, false, shortcut, view, null);
    }

    public static void launchApp(Context context, AppEntry entry, String windowSize, boolean launchedFromTaskbar, boolean openInNewWindow, View view) {
        U.launchApp(context, entry, windowSize, launchedFromTaskbar, false, openInNewWindow, null, view, null);
    }

    public static void launchApp(Context context, AppEntry entry, String windowSize, Runnable onError) {
        U.launchApp(context, entry, windowSize, false, true, true, null, null, onError);
    }

    private static void launchApp(Context context, AppEntry entry, String windowSize, boolean launchedFromTaskbar, boolean isPersistentShortcut, boolean openInNewWindow, ShortcutInfo shortcut, View view, Runnable onError) {
        U.launchApp(context, launchedFromTaskbar, isPersistentShortcut, () -> U.continueLaunchingApp(context, entry, windowSize, openInNewWindow, shortcut, view, onError));
    }

    public static void launchApp(Context context, Runnable runnable) {
        U.launchApp(context, true, false, runnable);
    }

    private static void launchApp(Context context, boolean launchedFromTaskbar, boolean isPersistentShortcut, Runnable runnable) {
        boolean isAndroidR;
        SharedPreferences pref = U.getSharedPreferences(context);
        FreeformHackHelper helper = FreeformHackHelper.getInstance();
        boolean specialLaunch = U.hasBrokenSetLaunchBoundsApi() && helper.isInFreeformWorkspace() && MenuHelper.getInstance().isContextMenuOpen();
        boolean noAnimation = pref.getBoolean("disable_animations", false);
        boolean bl = isAndroidR = (double)U.getCurrentApiVersion() > 29.0;
        if (U.hasFreeformSupport(context) && (U.isFreeformModeEnabled(context) || isPersistentShortcut) && (!helper.isInFreeformWorkspace() || specialLaunch)) {
            new Handler().postDelayed(() -> {
                U.startFreeformHack(context, true);
                new Handler().postDelayed(runnable, helper.isFreeformHackActive() ? 0L : (isAndroidR ? 300L : 100L));
            }, launchedFromTaskbar ? 0L : 100L);
        } else {
            new Handler().postDelayed(runnable, !launchedFromTaskbar && noAnimation ? 100L : (isAndroidR ? 100L : 0L));
        }
    }

    public static void startFreeformHack(Context context) {
        U.startFreeformHack(context, false);
    }

    @TargetApi(value=24)
    public static void startFreeformHack(Context context, boolean checkMultiWindow) {
        Intent freeformHackIntent = new Intent(context, InvisibleActivityFreeform.class);
        freeformHackIntent.addFlags(0x10011000);
        if (checkMultiWindow) {
            freeformHackIntent.putExtra("check_multiwindow", true);
        }
        if (U.canDrawOverlays(context)) {
            U.startActivityLowerRight(context, freeformHackIntent);
        }
    }

    public static void stopFreeformHack(Context context) {
        U.sendBroadcast(context, "com.farmerbb.taskbar.FINISH_FREEFORM_ACTIVITY");
        if (U.isOverridingFreeformHack(context, false)) {
            FreeformHackHelper helper = FreeformHackHelper.getInstance();
            helper.setFreeformHackActive(false);
            helper.setInFreeformWorkspace(false);
        }
    }

    @TargetApi(value=24)
    private static void continueLaunchingApp(Context context, AppEntry entry, String windowSize, boolean openInNewWindow, ShortcutInfo shortcut, View view, Runnable onError) {
        boolean realOpenInNewWindow;
        SharedPreferences pref = U.getSharedPreferences(context);
        Intent intent = new Intent();
        intent.setComponent(ComponentName.unflattenFromString((String)entry.getComponentName()));
        intent.setAction("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.LAUNCHER");
        intent.addFlags(0x10000000);
        intent.addFlags(0x20000000);
        if (FreeformHackHelper.getInstance().isInFreeformWorkspace() && Build.VERSION.SDK_INT <= 25) {
            intent.addFlags(16384);
        }
        if (pref.getBoolean("disable_animations", false)) {
            intent.addFlags(65536);
        }
        boolean bl = realOpenInNewWindow = openInNewWindow || pref.getBoolean("force_new_window", false);
        if (realOpenInNewWindow) {
            U.applyOpenInNewWindow(context, intent);
        }
        ApplicationType type = U.getApplicationType(context, entry);
        if (windowSize == null) {
            windowSize = SavedWindowSizes.getInstance(context).getWindowSize(context, entry.getPackageName());
        }
        Bundle bundle = U.getActivityOptionsBundle(context, type, windowSize, view);
        U.prepareToStartActivity(context, realOpenInNewWindow, () -> {
            if (shortcut == null) {
                UserManager userManager = (UserManager)context.getSystemService("user");
                if (entry.getUserId(context) == userManager.getSerialNumberForUser(Process.myUserHandle())) {
                    try {
                        context.startActivity(intent, bundle);
                    }
                    catch (ActivityNotFoundException e) {
                        U.launchAndroidForWork(context, intent.getComponent(), bundle, entry.getUserId(context), onError);
                    }
                    catch (IllegalArgumentException | SecurityException runtimeException) {}
                } else {
                    U.launchAndroidForWork(context, intent.getComponent(), bundle, entry.getUserId(context), onError);
                }
            } else {
                U.launchShortcut(context, shortcut, bundle, onError);
            }
        });
        if (U.shouldCollapse(context, true)) {
            U.sendBroadcast(context, "com.farmerbb.taskbar.HIDE_TASKBAR");
        } else {
            U.sendBroadcast(context, "com.farmerbb.taskbar.HIDE_START_MENU");
        }
    }

    private static Bundle launchMode1(Context context, ApplicationType type, View view, int factor) {
        DisplayInfo display = U.getDisplayInfo(context);
        int width1 = display.width / factor;
        int width2 = display.width - width1;
        int height1 = display.height / factor;
        int height2 = display.height - height1;
        return U.getActivityOptionsBundle(context, type, view, width1, height1, width2, height2);
    }

    private static Bundle launchMode2(Context context, int launchType, ApplicationType type, View view) {
        int iconSize;
        DisplayInfo display = U.getDisplayInfo(context);
        int statusBarHeight = U.getStatusBarHeight(context);
        String position = TaskbarPosition.getTaskbarPosition(context);
        int orientation = U.getDisplayOrientation(context);
        boolean isPortrait = orientation == 1;
        boolean isLandscape = orientation == 2;
        int left = 0;
        int top = statusBarHeight;
        int right = display.width;
        int bottom = display.height;
        int n = iconSize = U.isOverridingFreeformHack(context) && !LauncherHelper.getInstance().isOnHomeScreen(context) ? 0 : context.getResources().getDimensionPixelSize(R.dimen.tb_icon_size);
        if (TaskbarPosition.isVerticalLeft(position)) {
            left += iconSize;
        } else if (TaskbarPosition.isVerticalRight(position)) {
            right -= iconSize;
        } else if (TaskbarPosition.isBottom(position)) {
            bottom -= iconSize;
        } else {
            top += iconSize;
        }
        int halfLandscape = right / 2 + iconSize / 2 * (TaskbarPosition.isVerticalLeft(position) ? 1 : 0);
        boolean isTopLeft = "top_left".equals(position);
        boolean isTopRight = "top_right".equals(position);
        int halfPortrait = bottom / 2 + iconSize / 2 * (isTopLeft || isTopRight ? 1 : 0);
        if (launchType == 1 && isLandscape) {
            left = halfLandscape;
        } else if (launchType == 1 && isPortrait) {
            top = halfPortrait;
        } else if (launchType == -1 && isLandscape) {
            right = halfLandscape;
        } else if (launchType == -1 && isPortrait) {
            bottom = halfPortrait;
        }
        return U.getActivityOptionsBundle(context, type, view, left, top, right, bottom);
    }

    private static Bundle launchMode3(Context context, ApplicationType type, View view) {
        DisplayInfo display = U.getDisplayInfo(context);
        boolean isLandscape = type == ApplicationType.APP_LANDSCAPE;
        int widthDimen = isLandscape ? R.dimen.tb_phone_size_height : R.dimen.tb_phone_size_width;
        int heightDimen = isLandscape ? R.dimen.tb_phone_size_width : R.dimen.tb_phone_size_height;
        int width1 = display.width / 2;
        int width2 = context.getResources().getDimensionPixelSize(widthDimen) / 2;
        int height1 = display.height / 2;
        int height2 = context.getResources().getDimensionPixelSize(heightDimen) / 2;
        return U.getActivityOptionsBundle(context, type, view, width1 - width2, height1 - height2, width1 + width2, height1 + height2);
    }

    private static void launchAndroidForWork(Context context, ComponentName componentName, Bundle bundle, long userId, Runnable onError) {
        block2: {
            UserManager userManager = (UserManager)context.getSystemService("user");
            LauncherApps launcherApps = (LauncherApps)context.getSystemService("launcherapps");
            try {
                launcherApps.startMainActivity(componentName, userManager.getUserForSerialNumber(userId), null, bundle);
            }
            catch (ActivityNotFoundException | IllegalStateException | NullPointerException | SecurityException e) {
                if (onError == null) break block2;
                U.launchApp(context, onError);
            }
        }
    }

    @TargetApi(value=25)
    private static void launchShortcut(Context context, ShortcutInfo shortcut, Bundle bundle, Runnable onError) {
        block3: {
            LauncherApps launcherApps = (LauncherApps)context.getSystemService("launcherapps");
            if (launcherApps.hasShortcutHostPermission()) {
                try {
                    launcherApps.startShortcut(shortcut, null, bundle);
                }
                catch (ActivityNotFoundException | IllegalStateException | NullPointerException | SecurityException e) {
                    if (onError == null) break block3;
                    U.launchApp(context, onError);
                }
            }
        }
    }

    private static void prepareToStartActivity(Context context, boolean openInNewWindow, Runnable runnable) {
        U.sendBroadcast(context, "com.farmerbb.taskbar.HIDE_CONTEXT_MENU");
        if (!FreeformHackHelper.getInstance().isTouchAbsorberActive() && U.shouldLaunchTouchAbsorber(context)) {
            U.startTouchAbsorberActivity(context);
            new Handler().postDelayed(runnable, 100L);
        } else if (openInNewWindow) {
            Intent intent = new Intent(context, DummyActivity.class);
            intent.putExtra("finish_on_pause", true);
            intent.setFlags(0x10010000);
            U.startActivityLowerRight(context, intent);
            new Handler().postDelayed(runnable, 100L);
        } else {
            runnable.run();
        }
    }

    public static void startActivityMaximized(Context context, Intent intent) {
        Bundle bundle = U.launchMode2(context, 0, ApplicationType.CONTEXT_MENU, null);
        U.prepareToStartActivity(context, false, () -> context.startActivity(intent, bundle));
    }

    public static void startActivityLowerRight(Context context, Intent intent) {
        DisplayInfo display = U.getDisplayInfo(context);
        try {
            context.startActivity(intent, U.getActivityOptionsBundle(context, ApplicationType.FREEFORM_HACK, null, display.width, display.height, display.width + 1, display.height + 1));
        }
        catch (IllegalArgumentException | SecurityException runtimeException) {
            // empty catch block
        }
    }

    public static void startTouchAbsorberActivity(Context context) {
        String position = TaskbarPosition.getTaskbarPosition(context);
        DisplayInfo display = U.getDisplayInfo(context);
        int left = 0;
        int top = 0;
        int right = display.width;
        int bottom = display.height;
        int iconSize = context.getResources().getDimensionPixelSize(R.dimen.tb_icon_size);
        if (TaskbarPosition.isVerticalLeft(position)) {
            right = iconSize;
        } else if (TaskbarPosition.isVerticalRight(position)) {
            left = right - iconSize;
        } else if (TaskbarPosition.isBottom(position)) {
            top = bottom - iconSize;
        } else {
            bottom = iconSize;
        }
        Intent intent = new Intent(context, TouchAbsorberActivity.class);
        intent.addFlags(0x10000000);
        intent.addFlags(65536);
        try {
            context.startActivity(intent, U.getActivityOptionsBundle(context, ApplicationType.FREEFORM_HACK, null, left, top, right, bottom));
        }
        catch (IllegalArgumentException | SecurityException runtimeException) {
            // empty catch block
        }
    }

    public static void startContextMenuActivity(Context context, Bundle args) {
        Intent intent = U.getThemedIntent(context, ContextMenuActivity.class);
        intent.putExtra("args", args);
        intent.setFlags(0x10000000);
        if (U.hasFreeformSupport(context) && FreeformHackHelper.getInstance().isInFreeformWorkspace()) {
            DisplayInfo display = U.getDisplayInfo(context);
            if (U.hasBrokenSetLaunchBoundsApi()) {
                intent.putExtra("context_menu_fix", true);
            }
            context.startActivity(intent, U.getActivityOptionsBundle(context, ApplicationType.CONTEXT_MENU, null, 0, 0, display.width, display.height));
        } else {
            context.startActivity(intent);
        }
    }

    public static void checkForUpdates(Context context) {
        String url = U.isPlayStoreRelease(context) ? (context.getPackageName().equals("com.farmerbb.taskbar") && !U.isPlayStoreInstalled(context) ? "https://github.com/farmerbb/Taskbar/releases" : "https://play.google.com/store/apps/details?id=" + context.getPackageName()) : "https://f-droid.org/repository/browse/?fdid=" + context.getPackageName();
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)url));
        intent.setFlags(0x10000000);
        try {
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            // empty catch block
        }
    }

    public static boolean launcherIsDefault(Context context) {
        Intent homeIntent = new Intent("android.intent.action.MAIN");
        homeIntent.addCategory("android.intent.category.HOME");
        ResolveInfo defaultLauncher = context.getPackageManager().resolveActivity(homeIntent, 65536);
        return defaultLauncher.activityInfo.packageName.equals(context.getPackageName());
    }

    private static int getMaxNumOfColumns(Context context) {
        int numOfColumns;
        SharedPreferences pref = U.getSharedPreferences(context);
        DisplayInfo display = U.getDisplayInfo(context);
        float density = display.currentDensity / 160;
        float baseTaskbarSize = U.getBaseTaskbarSizeFloat(context) / density;
        float maxScreenSize = TaskbarPosition.isVertical(context) ? (float)(display.height - U.getStatusBarHeight(context)) / density : (float)display.width / density;
        float iconSize = context.getResources().getDimension(R.dimen.tb_icon_size) / density;
        int userMaxNumOfColumns = Integer.valueOf(pref.getString("max_num_of_recents", "10"));
        for (numOfColumns = 0; baseTaskbarSize + iconSize < maxScreenSize && numOfColumns < userMaxNumOfColumns; ++numOfColumns) {
            baseTaskbarSize += iconSize;
        }
        return numOfColumns;
    }

    public static int getMaxNumOfEntries(Context context) {
        SharedPreferences pref = U.getSharedPreferences(context);
        return pref.getBoolean("disable_scrolling_list", false) ? U.getMaxNumOfColumns(context) : Integer.valueOf(pref.getString("max_num_of_recents", "10"));
    }

    public static int getStatusBarHeight(Context context) {
        return LauncherHelper.getInstance().isOnSecondaryHomeScreen(context) ? 0 : U.getSystemDimen(context, "status_bar_height");
    }

    private static int getNavbarHeight(Context context) {
        SharedPreferences pref = U.getSharedPreferences(context);
        boolean isNavbarHidden = LauncherHelper.getInstance().isOnSecondaryHomeScreen(context) && pref.getBoolean("auto_hide_navbar_desktop_mode", false);
        return isNavbarHidden ? 0 : U.getSystemDimen(context, "navigation_bar_height");
    }

    private static int getSystemDimen(Context context, String id2) {
        context = U.getDisplayContext(context);
        int value = 0;
        int resourceId = context.getResources().getIdentifier(id2, "dimen", "android");
        if (resourceId > 0) {
            value = context.getResources().getDimensionPixelSize(resourceId);
        }
        return value;
    }

    public static void refreshPinnedIcons(Context context) {
        IconCache.getInstance(context).clearCache();
        PinnedBlockedApps pba = PinnedBlockedApps.getInstance(context);
        ArrayList<AppEntry> pinnedAppsList = new ArrayList<AppEntry>(pba.getPinnedApps());
        ArrayList<AppEntry> blockedAppsList = new ArrayList<AppEntry>(pba.getBlockedApps());
        PackageManager pm = context.getPackageManager();
        pba.clear(context);
        for (AppEntry entry : pinnedAppsList) {
            UserManager userManager = (UserManager)context.getSystemService("user");
            LauncherApps launcherApps = (LauncherApps)context.getSystemService("launcherapps");
            List userHandles = userManager.getUserProfiles();
            LauncherActivityInfo appInfo = null;
            for (UserHandle handle : userHandles) {
                List list = launcherApps.getActivityList(entry.getPackageName(), handle);
                if (list.isEmpty()) continue;
                if (!entry.getPackageName().equals("com.google.android.googlequicksearchbox")) {
                    appInfo = (LauncherActivityInfo)list.get(0);
                    break;
                }
                boolean added = false;
                for (LauncherActivityInfo info : list) {
                    if (!info.getName().equals("com.google.android.googlequicksearchbox.SearchActivity")) continue;
                    appInfo = info;
                    added = true;
                }
                if (added) break;
                appInfo = (LauncherActivityInfo)list.get(0);
                break;
            }
            if (appInfo == null) continue;
            AppEntry newEntry = new AppEntry(entry.getPackageName(), entry.getComponentName(), entry.getLabel(), (Drawable)IconCache.getInstance(context).getIcon(context, pm, appInfo), true);
            newEntry.setUserId(entry.getUserId(context));
            pba.addPinnedApp(context, newEntry);
        }
        for (AppEntry entry : blockedAppsList) {
            pba.addBlockedApp(context, entry);
        }
    }

    public static boolean canEnableFreeform() {
        return Build.VERSION.SDK_INT >= 24;
    }

    @TargetApi(value=24)
    public static boolean hasFreeformSupport(Context context) {
        return U.canEnableFreeform() && (context.getPackageManager().hasSystemFeature("android.software.freeform_window_management") || Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"enable_freeform_support", (int)0) != 0 || Build.VERSION.SDK_INT <= 25 && Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"force_resizable_activities", (int)0) != 0);
    }

    public static boolean canBootToFreeform(Context context) {
        return U.canBootToFreeform(context, true);
    }

    private static boolean canBootToFreeform(Context context, boolean checkPref) {
        return U.hasFreeformSupport(context) && !U.isOverridingFreeformHack(context, checkPref);
    }

    public static boolean isSamsungDevice() {
        return Build.MANUFACTURER.equalsIgnoreCase("Samsung");
    }

    private static boolean isNvidiaDevice() {
        return Build.MANUFACTURER.equalsIgnoreCase("NVIDIA");
    }

    public static boolean isServiceRunning(Context context, Class<? extends Service> cls) {
        if (LauncherHelper.getInstance().isOnSecondaryHomeScreen(context) && (cls.equals(TaskbarService.class) || cls.equals(StartMenuService.class) || cls.equals(DashboardService.class))) {
            return true;
        }
        return U.isServiceRunning(context, cls.getName());
    }

    private static boolean isServiceRunning(Context context, String className) {
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!className.equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    public static int getBackgroundTint(Context context) {
        SharedPreferences pref = U.getSharedPreferences(context);
        if (pref.contains("show_background")) {
            SharedPreferences.Editor editor = pref.edit();
            if (!pref.getBoolean("show_background", true)) {
                editor.putInt("background_tint", 0).apply();
            }
            editor.remove("show_background");
            editor.apply();
        }
        return pref.getInt("background_tint", context.getResources().getInteger(R.integer.tb_translucent_gray));
    }

    public static int getAccentColor(Context context) {
        SharedPreferences pref = U.getSharedPreferences(context);
        return pref.getInt("accent_color", context.getResources().getInteger(R.integer.tb_translucent_white));
    }

    public static boolean canDrawOverlays(Context context) {
        return Build.VERSION.SDK_INT < 23 || Settings.canDrawOverlays((Context)context);
    }

    public static boolean isGame(Context context, String packageName) {
        SharedPreferences pref = U.getSharedPreferences(context);
        if (pref.getBoolean("launch_games_fullscreen", true)) {
            PackageManager pm = context.getPackageManager();
            try {
                ApplicationInfo info = pm.getApplicationInfo(packageName, 128);
                return (info.flags & 0x2000000) != 0 || info.metaData != null && info.metaData.getBoolean("isGame", false);
            }
            catch (PackageManager.NameNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    private static ActivityOptions getActivityOptions(View view) {
        return U.getActivityOptions(null, null, view);
    }

    public static ActivityOptions getActivityOptions(Context context, ApplicationType applicationType, View view) {
        int launchDisplayId;
        ActivityOptions options;
        if (view != null) {
            options = Build.VERSION.SDK_INT >= 23 ? ActivityOptions.makeClipRevealAnimation((View)view, (int)0, (int)0, (int)view.getWidth(), (int)view.getHeight()) : ActivityOptions.makeScaleUpAnimation((View)view, (int)0, (int)0, (int)view.getWidth(), (int)view.getHeight());
        } else if (Build.VERSION.SDK_INT >= 23) {
            options = ActivityOptions.makeBasic();
        } else {
            try {
                Constructor constructor = ActivityOptions.class.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                options = (ActivityOptions)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (applicationType == null) {
            return options;
        }
        int stackId = -1;
        switch (applicationType) {
            case APP_PORTRAIT: 
            case APP_LANDSCAPE: {
                if (FreeformHackHelper.getInstance().isFreeformHackActive()) {
                    stackId = U.getFreeformWindowModeId();
                    break;
                }
                stackId = U.getFullscreenWindowModeId();
                break;
            }
            case APP_FULLSCREEN: {
                stackId = U.getFullscreenWindowModeId();
                break;
            }
            case FREEFORM_HACK: {
                stackId = U.getFreeformWindowModeId();
                break;
            }
            case CONTEXT_MENU: {
                if (!U.hasBrokenSetLaunchBoundsApi() && (U.isChromeOs(context) || !(U.getCurrentApiVersion() >= 28.0f))) break;
                stackId = U.getFullscreenWindowModeId();
            }
        }
        U.allowReflection();
        try {
            Method method = ActivityOptions.class.getMethod(U.getWindowingModeMethodName(), Integer.TYPE);
            method.invoke((Object)options, stackId);
        }
        catch (Exception method) {
            // empty catch block
        }
        if (Build.VERSION.SDK_INT >= 26 && (launchDisplayId = LauncherHelper.getInstance().getSecondaryDisplayId()) != -1) {
            options.setLaunchDisplayId(launchDisplayId);
        }
        return options;
    }

    private static int getFullscreenWindowModeId() {
        if (U.getCurrentApiVersion() >= 28.0f) {
            return 1;
        }
        return 1;
    }

    private static int getFreeformWindowModeId() {
        if (U.getCurrentApiVersion() >= 28.0f) {
            return 5;
        }
        return 2;
    }

    private static String getWindowingModeMethodName() {
        if (U.getCurrentApiVersion() >= 28.0f) {
            return "setLaunchWindowingMode";
        }
        return "setLaunchStackId";
    }

    public static Bundle getActivityOptionsBundle(Context context, ApplicationType type, View view) {
        SharedPreferences pref = U.getSharedPreferences(context);
        return U.getActivityOptionsBundle(context, type, pref.getString("window_size", "standard"), view);
    }

    private static Bundle getActivityOptionsBundle(Context context, ApplicationType type, String windowSize, View view) {
        if (!U.canEnableFreeform() || !U.isFreeformModeEnabled(context)) {
            return U.getActivityOptions(view).toBundle();
        }
        switch (windowSize) {
            case "standard": {
                if (!(U.getCurrentApiVersion() > 29.0f)) break;
                return U.launchMode1(context, type, view, 4);
            }
            case "large": {
                return U.launchMode1(context, type, view, 8);
            }
            case "fullscreen": {
                return U.launchMode2(context, 0, type, view);
            }
            case "half_left": {
                return U.launchMode2(context, -1, type, view);
            }
            case "half_right": {
                return U.launchMode2(context, 1, type, view);
            }
            case "phone_size": {
                return U.launchMode3(context, type, view);
            }
        }
        return U.getActivityOptions(context, type, view).toBundle();
    }

    private static Bundle getActivityOptionsBundle(Context context, ApplicationType applicationType, View view, int left, int top, int right, int bottom) {
        ActivityOptions options = U.getActivityOptions(context, applicationType, view);
        if (options == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 24) {
            return options.toBundle();
        }
        return options.setLaunchBounds(new Rect(left, top, right, bottom)).toBundle();
    }

    @SuppressLint(value={"SwitchIntDef"})
    private static ApplicationType getApplicationType(Context context, AppEntry entry) {
        if (U.isGame(context, entry.getPackageName())) {
            return ApplicationType.APP_FULLSCREEN;
        }
        try {
            ActivityInfo info = context.getPackageManager().getActivityInfo(ComponentName.unflattenFromString((String)entry.getComponentName()), 0);
            switch (info.screenOrientation) {
                case 0: 
                case 6: 
                case 8: 
                case 11: {
                    return ApplicationType.APP_LANDSCAPE;
                }
                case 1: 
                case 7: 
                case 9: 
                case 12: {
                    return ApplicationType.APP_PORTRAIT;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return context.getPackageName().equals("com.farmerbb.taskbar.androidx86") ? ApplicationType.APP_LANDSCAPE : ApplicationType.APP_PORTRAIT;
    }

    public static boolean isSystemApp(Context context) {
        try {
            ApplicationInfo info = context.getPackageManager().getApplicationInfo(context.getPackageName(), 0);
            int mask = 129;
            return (info.flags & mask) != 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static boolean isChromeOs(Context context) {
        return context.getPackageManager().hasSystemFeature("org.chromium.arc");
    }

    @TargetApi(value=26)
    public static boolean isAndroidTV(Context context) {
        return context.getPackageManager().hasSystemFeature("android.software.leanback_only");
    }

    public static boolean isBlissOs(Context context) {
        String buildUser;
        boolean validBlissOsBuildProp = false;
        String blissVersion = U.getSystemProperty("ro.bliss.version");
        if (blissVersion != null && !blissVersion.isEmpty()) {
            validBlissOsBuildProp = true;
        }
        if ((buildUser = U.getSystemProperty("ro.build.user")) != null && buildUser.equals("electrikjesus")) {
            validBlissOsBuildProp = true;
        }
        return validBlissOsBuildProp && context.getPackageName().equals("com.farmerbb.taskbar") && U.isSystemApp(context);
    }

    public static boolean isLauncherPermanentlyEnabled(Context context) {
        if (context.getPackageName().equals("com.farmerbb.taskbar.androidx86")) {
            return true;
        }
        return U.hasSupportLibrary(context, 0);
    }

    public static boolean hasSupportLibrary(Context context, int minVersion) {
        PackageManager pm = context.getPackageManager();
        try {
            PackageInfo pInfo = pm.getPackageInfo("com.farmerbb.taskbar.support", 0);
            return pInfo.versionCode >= minVersion && pm.checkSignatures("com.farmerbb.taskbar.support", context.getPackageName()) == 0 && context.getPackageName().equals("com.farmerbb.taskbar") && U.isSystemApp(context);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static int getBaseTaskbarSize(Context context) {
        return Math.round(U.getBaseTaskbarSizeFloat(context));
    }

    private static float getBaseTaskbarSizeFloat(Context context) {
        SharedPreferences pref = U.getSharedPreferences(context);
        float baseTaskbarSize = context.getResources().getDimension(R.dimen.tb_base_taskbar_size);
        boolean navbarButtonsEnabled = false;
        if (U.getBooleanPrefWithDefault(context, "dashboard")) {
            baseTaskbarSize += context.getResources().getDimension(R.dimen.tb_dashboard_button_size);
        }
        if (pref.getBoolean("button_back", false)) {
            navbarButtonsEnabled = true;
            baseTaskbarSize += context.getResources().getDimension(R.dimen.tb_icon_size);
        }
        if (pref.getBoolean("button_home", false)) {
            navbarButtonsEnabled = true;
            baseTaskbarSize += context.getResources().getDimension(R.dimen.tb_icon_size);
        }
        if (pref.getBoolean("button_recents", false)) {
            navbarButtonsEnabled = true;
            baseTaskbarSize += context.getResources().getDimension(R.dimen.tb_icon_size);
        }
        if (navbarButtonsEnabled) {
            baseTaskbarSize += context.getResources().getDimension(R.dimen.tb_navbar_buttons_margin);
        }
        if (U.isSystemTrayEnabled(context)) {
            baseTaskbarSize += context.getResources().getDimension(R.dimen.tb_systray_size);
        }
        return baseTaskbarSize;
    }

    private static void startTaskbarService(Context context, boolean fullRestart) {
        context.startService(new Intent(context, TaskbarService.class));
        context.startService(new Intent(context, StartMenuService.class));
        context.startService(new Intent(context, DashboardService.class));
        if (fullRestart) {
            context.startService(new Intent(context, NotificationService.class));
        }
    }

    private static void stopTaskbarService(Context context, boolean fullRestart) {
        context.stopService(new Intent(context, TaskbarService.class));
        context.stopService(new Intent(context, StartMenuService.class));
        context.stopService(new Intent(context, DashboardService.class));
        if (fullRestart) {
            context.stopService(new Intent(context, NotificationService.class));
        }
    }

    public static void restartTaskbar(Context context) {
        SharedPreferences pref = U.getSharedPreferences(context);
        if (pref.getBoolean("taskbar_active", false) && !pref.getBoolean("is_hidden", false)) {
            pref.edit().putBoolean("is_restarting", true).putBoolean("skip_auto_hide_navbar", true).apply();
            U.stopTaskbarService(context, true);
            U.startTaskbarService(context, true);
        } else if (U.isServiceRunning(context, StartMenuService.class)) {
            pref.edit().putBoolean("skip_auto_hide_navbar", true).apply();
            U.stopTaskbarService(context, false);
            U.startTaskbarService(context, false);
        }
        U.sendBroadcast(context, "com.farmerbb.taskbar.RESTART");
    }

    public static void restartNotificationService(Context context) {
        if (U.isServiceRunning(context, NotificationService.class)) {
            SharedPreferences pref = U.getSharedPreferences(context);
            pref.edit().putBoolean("is_restarting", true).apply();
            Intent intent = new Intent(context, NotificationService.class);
            context.stopService(intent);
            context.startService(intent);
        }
    }

    public static void showHideNavigationBar(Context context, boolean show) {
        U.showHideNavigationBar(context, U.getTaskbarDisplayID(context), show, 0);
    }

    public static void showHideNavigationBar(Context context, int displayID, boolean show, int delay) {
        if (!(U.isDesktopModeActive(context) || U.isBlissOs(context) || U.hasSupportLibrary(context, 7))) {
            return;
        }
        Lazy<Integer> value = () -> show ? 0 : U.getSystemDimen(context, "navigation_bar_height") * -1;
        if (U.hasWriteSecureSettingsPermission(context)) {
            Runnable runnable = () -> {
                try {
                    U.setOverscan(displayID, (Integer)value.get());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            };
            if (delay == 0) {
                runnable.run();
            } else {
                new Handler().postDelayed(runnable, (long)delay);
            }
            return;
        }
        if (U.hasSupportLibrary(context, 7)) {
            Intent intent = new Intent("com.farmerbb.taskbar.support.CHANGE_OVERSCAN");
            intent.setPackage("com.farmerbb.taskbar.support");
            intent.putExtra("display_id", displayID);
            intent.putExtra("value", (Serializable)value.get());
            context.sendBroadcast(intent);
            return;
        }
        if (!U.isBlissOs(context)) {
            return;
        }
        try {
            if (U.getCurrentApiVersion() >= 28.0f) {
                Settings.Secure.putInt((ContentResolver)context.getContentResolver(), (String)"navigation_bar_visible", (int)(show ? 1 : 0));
            } else {
                Settings.System.putInt((ContentResolver)context.getContentResolver(), (String)"navigation_bar_show", (int)(show ? 1 : 0));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void initPrefs(Context context) {
        SharedPreferences pref = U.getSharedPreferences(context);
        if (U.canEnableFreeform()) {
            if (!pref.getBoolean("freeform_hack_override", false)) {
                pref.edit().putBoolean("freeform_hack", U.hasFreeformSupport(context) && !U.isSamsungDevice()).putBoolean("save_window_sizes", false).putBoolean("freeform_hack_override", true).apply();
            } else if (!U.hasFreeformSupport(context)) {
                pref.edit().putBoolean("freeform_hack", false).apply();
                U.stopFreeformHack(context);
            }
        } else {
            boolean freeformWasEnabled = U.isFreeformModeEnabled(context) || pref.getBoolean("show_freeform_disabled_message", false);
            pref.edit().putBoolean("freeform_hack", false).putBoolean("show_freeform_disabled_message", freeformWasEnabled).apply();
            SavedWindowSizes.getInstance(context).clear(context);
            U.stopFreeformHack(context);
        }
        if (U.isBlissOs(context) && Build.VERSION.SDK_INT >= 23 && !pref.getBoolean("bliss_os_prefs", false)) {
            SharedPreferences.Editor editor = pref.edit();
            if (U.hasFreeformSupport(context)) {
                editor.putBoolean("freeform_hack", true);
            }
            editor.putString("recents_amount", "running_apps_only");
            editor.putString("refresh_frequency", "0");
            editor.putString("max_num_of_recents", "2147483647");
            editor.putString("sort_order", "true");
            editor.putString("start_button_image", "app_logo");
            editor.putBoolean("button_back", true);
            editor.putBoolean("button_home", true);
            editor.putBoolean("button_recents", true);
            editor.putBoolean("auto_hide_navbar", true);
            editor.putBoolean("shortcut_icon", false);
            editor.putBoolean("bliss_os_prefs", true);
            editor.apply();
        }
        if (context.getPackageName().equals("com.farmerbb.taskbar.androidx86") && U.isSystemApp(context) && !pref.getBoolean("android_x86_prefs", false)) {
            pref.edit().putString("recents_amount", "running_apps_only").putString("refresh_frequency", "0").putString("max_num_of_recents", "2147483647").putString("sort_order", "true").putBoolean("shortcut_icon", false).putBoolean("android_x86_prefs", true).apply();
        }
    }

    public static DisplayInfo getDisplayInfo(Context context) {
        return U.getDisplayInfo(context, false);
    }

    public static DisplayInfo getDisplayInfo(Context context, boolean fromTaskbar) {
        boolean sameHeight;
        context = U.getDisplayContext(context);
        int displayID = U.getTaskbarDisplayID(context);
        DisplayManager dm = (DisplayManager)context.getSystemService("display");
        Display currentDisplay = null;
        for (Display display : dm.getDisplays()) {
            if (display.getDisplayId() != displayID) continue;
            currentDisplay = display;
            break;
        }
        if (currentDisplay == null) {
            return new DisplayInfo(0, 0, 0, 0);
        }
        DisplayMetrics metrics = new DisplayMetrics();
        currentDisplay.getMetrics(metrics);
        DisplayMetrics realMetrics = new DisplayMetrics();
        currentDisplay.getRealMetrics(realMetrics);
        DisplayInfo info = new DisplayInfo(metrics.widthPixels, metrics.heightPixels, metrics.densityDpi, 0);
        if (U.isChromeOs(context)) {
            SharedPreferences pref = U.getSharedPreferences(context);
            if (!pref.getBoolean("chrome_os_context_menu_fix", true)) {
                info.width = realMetrics.widthPixels;
                info.height = realMetrics.heightPixels;
            }
            return info;
        }
        if (fromTaskbar && U.getDisplayOrientation(context) == 2) {
            return info;
        }
        boolean sameWidth = metrics.widthPixels == realMetrics.widthPixels;
        boolean bl = sameHeight = metrics.heightPixels == realMetrics.heightPixels;
        if (sameWidth && !sameHeight) {
            info.width = realMetrics.widthPixels;
            info.height = realMetrics.heightPixels - U.getNavbarHeight(context);
        }
        if (!sameWidth && sameHeight) {
            info.width = realMetrics.widthPixels - U.getNavbarHeight(context);
            info.height = realMetrics.heightPixels;
        }
        return info;
    }

    private static int getTaskbarDisplayID(Context context) {
        LauncherHelper helper = LauncherHelper.getInstance();
        if (helper.isOnSecondaryHomeScreen(context)) {
            return helper.getSecondaryDisplayId();
        }
        return 0;
    }

    public static void pinAppShortcut(Context context) {
        if (Build.VERSION.SDK_INT >= 26) {
            ShortcutManager mShortcutManager = (ShortcutManager)context.getSystemService(ShortcutManager.class);
            if (mShortcutManager.isRequestPinShortcutSupported()) {
                ShortcutInfo pinShortcutInfo = new ShortcutInfo.Builder(context, "freeform_mode").build();
                mShortcutManager.requestPinShortcut(pinShortcutInfo, null);
            } else {
                U.showToastLong(context, R.string.tb_pin_shortcut_not_supported);
            }
        } else {
            Intent intent = ShortcutUtils.getShortcutIntent(context);
            intent.setAction("com.android.launcher.action.INSTALL_SHORTCUT");
            intent.putExtra("duplicate", false);
            Intent homeIntent = new Intent("android.intent.action.MAIN");
            homeIntent.addCategory("android.intent.category.HOME");
            ResolveInfo defaultLauncher = context.getPackageManager().resolveActivity(homeIntent, 65536);
            intent.setPackage(defaultLauncher.activityInfo.packageName);
            context.sendBroadcast(intent);
            U.showToast(context, R.string.tb_shortcut_created);
        }
    }

    public static boolean shouldCollapse(Context context, boolean pendingAppLaunch) {
        SharedPreferences pref = U.getSharedPreferences(context);
        if (pref.getBoolean("hide_taskbar", true)) {
            if (!U.isFreeformModeEnabled(context) || U.isOverridingFreeformHack(context, false)) {
                return !LauncherHelper.getInstance().isOnHomeScreen(context);
            }
            FreeformHackHelper helper = FreeformHackHelper.getInstance();
            if (pendingAppLaunch) {
                return !helper.isFreeformHackActive();
            }
            return !helper.isInFreeformWorkspace();
        }
        return false;
    }

    public static boolean isOverridingFreeformHack(Context context) {
        return U.isOverridingFreeformHack(context, true);
    }

    public static boolean isOverridingFreeformHack(Context context, boolean checkPref) {
        SharedPreferences pref = U.getSharedPreferences(context);
        return (!checkPref || U.isFreeformModeEnabled(context)) && (U.isChromeOs(context) && (pref.getBoolean("chrome_os_context_menu_fix", true) || pref.getBoolean("launcher", false) && U.launcherIsDefault(context)) || !U.isChromeOs(context) && U.getCurrentApiVersion() >= 28.0f);
    }

    public static boolean isPlayStoreInstalled(Context context) {
        try {
            context.getPackageManager().getPackageInfo("com.android.vending", 0);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    @VisibleForTesting
    public static float getCurrentApiVersion() {
        if (Build.VERSION.SDK_INT >= 23) {
            return Float.valueOf(Build.VERSION.SDK_INT + "." + Build.VERSION.PREVIEW_SDK_INT).floatValue();
        }
        return Build.VERSION.SDK_INT;
    }

    public static boolean hasBrokenSetLaunchBoundsApi() {
        return U.getCurrentApiVersion() >= 26.0f && U.getCurrentApiVersion() < 28.0f && !U.isSamsungDevice() && !U.isNvidiaDevice();
    }

    public static String getSecondScreenPackageName(Context context) {
        return U.getInstalledPackage(context, "com.farmerbb.secondscreen.free", "com.farmerbb.secondscreen");
    }

    private static String getInstalledPackage(Context context, String ... packageNames) {
        return U.getInstalledPackage(context, Arrays.asList(packageNames));
    }

    private static String getInstalledPackage(Context context, List<String> packageNames) {
        if (packageNames == null || packageNames.isEmpty()) {
            return null;
        }
        ArrayList<String> packages = packageNames instanceof ArrayList ? packageNames : new ArrayList<String>(packageNames);
        String packageName = (String)packages.get(0);
        try {
            context.getPackageManager().getPackageInfo(packageName, 0);
            return packageName;
        }
        catch (PackageManager.NameNotFoundException e) {
            packages.remove(0);
            return U.getInstalledPackage(context, packages);
        }
    }

    public static void showRecentAppsDialog(Context context) {
        Callbacks callbacks = new Callbacks();
        callbacks.onError = () -> U.showErrorDialog(context, "GET_USAGE_STATS", callbacks);
        U.showRecentAppsDialog(context, callbacks);
    }

    public static AlertDialog showRecentAppsDialog(Context context, Callbacks callbacks) {
        if (Build.VERSION.SDK_INT >= 23 && !U.isSystemApp(context)) {
            AppOpsManager appOpsManager;
            int mode;
            ApplicationInfo applicationInfo = null;
            try {
                applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            if (applicationInfo != null && (mode = (appOpsManager = (AppOpsManager)context.getSystemService("appops")).checkOpNoThrow("android:get_usage_stats", applicationInfo.uid, applicationInfo.packageName)) != 0) {
                AlertDialog.Builder builder = U.hasAndroidTVSettings(context) ? U.buildRecentAppsDialogAndroidTV(context, callbacks) : U.buildRecentAppsDialogStandard(context, callbacks);
                AlertDialog dialog = builder.create();
                dialog.show();
                dialog.setCancelable(false);
                return dialog;
            }
        }
        callbacks.onFinish.run();
        return null;
    }

    private static AlertDialog.Builder buildRecentAppsDialogStandard(Context context, Callbacks callbacks) {
        String message = context.getString(R.string.tb_enable_recent_apps) + context.getString(R.string.tb_enable_recent_apps_instructions_phone);
        return new AlertDialog.Builder(context).setTitle(R.string.tb_pref_header_recent_apps).setMessage((CharSequence)message).setPositiveButton(R.string.tb_action_ok, (dialog, which) -> {
            try {
                Intent intent = new Intent("android.settings.USAGE_ACCESS_SETTINGS");
                LauncherHelper helper = LauncherHelper.getInstance();
                if (helper.isOnHomeScreen(context)) {
                    U.applyOpenInNewWindow(context, intent);
                }
                context.startActivity(intent);
                U.showToastLong(context, R.string.tb_usage_stats_message);
                callbacks.onFinish.run();
            }
            catch (ActivityNotFoundException e) {
                callbacks.onError.run();
            }
        }).setNegativeButton(R.string.tb_action_cancel, (dialog, which) -> callbacks.onFinish.run());
    }

    private static AlertDialog.Builder buildRecentAppsDialogAndroidTV(Context context, Callbacks callbacks) {
        String message = context.getString(R.string.tb_enable_recent_apps) + context.getString(R.string.tb_enable_recent_apps_instructions_tv);
        return new AlertDialog.Builder(context).setTitle(R.string.tb_pref_header_recent_apps).setMessage((CharSequence)message).setPositiveButton(R.string.tb_action_open_settings, (dialog, which) -> {
            try {
                context.startActivity(new Intent("android.settings.MANAGE_APPLICATIONS_SETTINGS"));
                callbacks.onFinish.run();
            }
            catch (ActivityNotFoundException e) {
                callbacks.onError.run();
            }
        }).setNegativeButton(R.string.tb_action_cancel, (dialog, which) -> callbacks.onFinish.run());
    }

    public static Context wrapContext(Context context) {
        int theme = U.isDarkTheme(context) ? R.style.Taskbar_Dark : R.style.Taskbar;
        return new ContextThemeWrapper(context, theme);
    }

    public static boolean isPlayStoreRelease(Context context) {
        return U.isPlayStoreRelease(context, context.getPackageName());
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    public static boolean isPlayStoreRelease(Context context, String packageName) {
        Signature playStoreSignature = new Signature(context.getString(R.string.tb_signature));
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo info = pm.getPackageInfo(packageName, 64);
            for (Signature signature : info.signatures) {
                if (!signature.equals((Object)playStoreSignature)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isExternalAccessDisabled(Context context) {
        if (U.isLibrary(context)) {
            return true;
        }
        SharedPreferences pref = U.getSharedPreferences(context);
        return !pref.getBoolean("tasker_enabled", true);
    }

    public static boolean enableFreeformModeShortcut(Context context) {
        return U.canEnableFreeform() && !U.isOverridingFreeformHack(context, false) && !U.isChromeOs(context);
    }

    public static void startForegroundService(Context context, Intent intent) {
        if (Build.VERSION.SDK_INT >= 26) {
            if (Settings.canDrawOverlays((Context)context)) {
                context.startForegroundService(intent);
            }
        } else {
            context.startService(intent);
        }
    }

    public static int getOverlayType() {
        return Build.VERSION.SDK_INT >= 26 ? 2038 : 2002;
    }

    public static boolean isDelegatingHomeActivity(Context context) {
        Intent homeIntent = new Intent("android.intent.action.MAIN");
        homeIntent.addCategory("android.intent.category.HOME");
        List listOfLaunchers = context.getPackageManager().queryIntentActivities(homeIntent, 0);
        for (ResolveInfo launcher : listOfLaunchers) {
            if (!launcher.activityInfo.packageName.equals("com.farmerbb.taskbar.support")) continue;
            return true;
        }
        return false;
    }

    @SuppressLint(value={"PrivateApi"})
    private static String getSystemProperty(String key) {
        U.allowReflection();
        try {
            Class<?> cls = Class.forName("android.os.SystemProperties");
            return cls.getMethod("get", String.class).invoke(null, key).toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void showImageChooser(Activity activity) {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("image/*");
        intent.addCategory("android.intent.category.OPENABLE");
        String message = activity.getResources().getString(R.string.tb_filepicker_select_an_image_file);
        try {
            activity.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)message), 1001);
        }
        catch (ActivityNotFoundException ex) {
            U.showToast((Context)activity, activity.getResources().getString(R.string.tb_filepicker_install_file_manager), 50);
        }
    }

    public static boolean importImage(Context context, Uri uri, String filename) {
        try {
            File prevFile;
            BufferedInputStream is;
            byte[] data;
            File imagesDir = new File(context.getFilesDir(), "tb_images");
            imagesDir.mkdirs();
            File importedFile = new File(imagesDir, filename + "_new");
            if (importedFile.exists()) {
                importedFile.delete();
            }
            if ((data = new byte[(is = new BufferedInputStream(context.getContentResolver().openInputStream(uri))).available()]).length > 0) {
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(importedFile));
                is.read(data);
                os.write(data);
                is.close();
                os.close();
            }
            if ((prevFile = new File(imagesDir, filename)).exists()) {
                prevFile.delete();
            }
            importedFile.renameTo(prevFile);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String[] getImageFilenames() {
        return new String[]{"custom_image", "desktop_wallpaper"};
    }

    public static void applyCustomImage(Context context, String filename, ImageView view, Drawable errorDrawable) {
        File file = new File(context.getFilesDir() + "/tb_images", filename);
        if (file.exists()) {
            Handler handler = new Handler();
            new Thread(() -> {
                Bitmap bitmap = BitmapFactory.decodeFile((String)file.getPath());
                handler.post(() -> {
                    if (bitmap != null) {
                        BitmapDrawable bitmapDrawable = new BitmapDrawable(context.getResources(), bitmap);
                        bitmapDrawable.setFilterBitmap(bitmap.getWidth() * bitmap.getHeight() > 2000);
                        view.setImageDrawable((Drawable)bitmapDrawable);
                    } else {
                        U.showToastLong(context, R.string.tb_error_reading_custom_start_image);
                        view.setImageDrawable(errorDrawable);
                    }
                });
            }).start();
        } else {
            view.setImageDrawable(errorDrawable);
        }
    }

    public static String getDefaultStartButtonImage(Context context) {
        SharedPreferences pref = U.getSharedPreferences(context);
        return pref.getBoolean("app_drawer_icon", false) ? "app_logo" : "default";
    }

    private static boolean shouldLaunchTouchAbsorber(Context context) {
        return U.isOverridingFreeformHack(context) && !U.isChromeOs(context) && U.getCurrentApiVersion() < 29.0f;
    }

    public static boolean isDesktopIconsEnabled(Context context) {
        return Build.VERSION.SDK_INT >= 22 && !U.canBootToFreeform(context, false) && !U.shouldLaunchTouchAbsorber(context);
    }

    public static boolean isSystemTrayEnabled(Context context) {
        SharedPreferences pref = U.getSharedPreferences(context);
        return Build.VERSION.SDK_INT >= 23 && U.getBooleanPrefWithDefault(context, "sys_tray") && pref.getBoolean("full_length", true) && !TaskbarPosition.isVertical(context);
    }

    public static boolean isLibrary(Context context) {
        return !context.getPackageName().equals("com.farmerbb.taskbar");
    }

    public static boolean applyDisplayCutoutModeTo(WindowManager.LayoutParams params) {
        if (Build.VERSION.SDK_INT >= 28) {
            params.layoutInDisplayCutoutMode = 1;
            return true;
        }
        return false;
    }

    public static boolean hasAndroidTVSettings(Context context) {
        return U.getInstalledPackage(context, "com.android.tv.settings") != null && Build.VERSION.SDK_INT >= 28;
    }

    public static void restartApp(Activity activity, boolean shouldFade) {
        Intent restartIntent = new Intent((Context)activity, MainActivity.class);
        restartIntent.setFlags(0x10008000);
        activity.startActivity(restartIntent);
        activity.overridePendingTransition(shouldFade ? 0x10A0000 : 0, shouldFade ? 0x10A0001 : 0);
        System.exit(0);
    }

    public static boolean isDesktopModeSupported(Context context) {
        if (U.isLauncherPermanentlyEnabled(context) || U.isChromeOs(context)) {
            return false;
        }
        return Build.VERSION.SDK_INT > 28 && context.getPackageManager().hasSystemFeature("android.software.activities_on_secondary_displays");
    }

    public static boolean isDesktopModePrefEnabled(Context context) {
        boolean desktopModePrefEnabled;
        if (!U.isDesktopModeSupported(context) || !U.hasFreeformSupport(context)) {
            return false;
        }
        try {
            desktopModePrefEnabled = Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"force_desktop_mode_on_external_displays") == 1;
        }
        catch (Settings.SettingNotFoundException e) {
            desktopModePrefEnabled = false;
        }
        return desktopModePrefEnabled;
    }

    public static boolean isDesktopModeActive(Context context) {
        return U.isDesktopModePrefEnabled(context) && U.getExternalDisplayID(context) != 0;
    }

    private static Display getExternalDisplay(Context context) {
        DisplayManager dm = (DisplayManager)context.getSystemService("display");
        Display[] displays = dm.getDisplays();
        return displays[displays.length - 1];
    }

    public static int getExternalDisplayID(Context context) {
        return U.getExternalDisplay(context).getDisplayId();
    }

    public static DisplayInfo getExternalDisplayInfo(Context context) {
        int defaultDensity;
        Display display = U.getExternalDisplay(context);
        if (display == null) {
            return new DisplayInfo(0, 0, 0, 0);
        }
        DisplayMetrics metrics = new DisplayMetrics();
        display.getRealMetrics(metrics);
        try {
            defaultDensity = U.getDefaultDensity(display.getDisplayId());
        }
        catch (Exception e) {
            defaultDensity = 0;
        }
        return new DisplayInfo(metrics.widthPixels, metrics.heightPixels, metrics.densityDpi, defaultDensity);
    }

    @SuppressLint(value={"PrivateApi"})
    private static Object getWindowManagerService() throws Exception {
        U.allowReflection();
        return Class.forName("android.view.WindowManagerGlobal").getMethod("getWindowManagerService", new Class[0]).invoke(null, new Object[0]);
    }

    @SuppressLint(value={"PrivateApi"})
    public static void setDensity(int displayID, String value) throws Exception {
        int USER_CURRENT_OR_SELF = -3;
        U.allowReflection();
        if (value.equals("reset")) {
            Class.forName("android.view.IWindowManager").getMethod("clearForcedDisplayDensityForUser", Integer.TYPE, Integer.TYPE).invoke(U.getWindowManagerService(), displayID, -3);
        } else {
            int density = Integer.parseInt(value);
            Class.forName("android.view.IWindowManager").getMethod("setForcedDisplayDensityForUser", Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke(U.getWindowManagerService(), displayID, density, -3);
        }
    }

    @SuppressLint(value={"PrivateApi"})
    private static void setOverscan(int displayID, int value) throws Exception {
        U.allowReflection();
        Class.forName("android.view.IWindowManager").getMethod("setOverscan", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke(U.getWindowManagerService(), displayID, 0, 0, 0, value);
    }

    @SuppressLint(value={"PrivateApi"})
    private static Integer getDefaultDensity(int displayID) throws Exception {
        U.allowReflection();
        return (Integer)Class.forName("android.view.IWindowManager").getMethod("getInitialDisplayDensity", Integer.TYPE).invoke(U.getWindowManagerService(), displayID);
    }

    public static void registerReceiver(Context context, BroadcastReceiver receiver, String ... actions) {
        U.unregisterReceiver(context, receiver);
        IntentFilter intentFilter = new IntentFilter();
        for (String action : actions) {
            intentFilter.addAction(action);
        }
        LocalBroadcastManager.getInstance((Context)context).registerReceiver(receiver, intentFilter);
    }

    public static void unregisterReceiver(Context context, BroadcastReceiver receiver) {
        LocalBroadcastManager.getInstance((Context)context).unregisterReceiver(receiver);
    }

    public static void sendBroadcast(Context context, String action) {
        U.sendBroadcast(context, new Intent(action));
    }

    public static void sendBroadcast(Context context, Intent intent) {
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
    }

    public static void setComponentEnabled(Context context, Class<?> clazz, boolean enabled) {
        ComponentName component = new ComponentName(context, clazz);
        context.getPackageManager().setComponentEnabledSetting(component, enabled ? 1 : 2, 1);
    }

    public static BitmapDrawable convertToBitmapDrawable(Context context, Drawable drawable2) {
        if (drawable2 instanceof BitmapDrawable) {
            return (BitmapDrawable)drawable2;
        }
        int width = Math.max(drawable2.getIntrinsicWidth(), 1);
        int height = Math.max(drawable2.getIntrinsicHeight(), 1);
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return new BitmapDrawable(context.getResources(), bitmap);
    }

    public static BitmapDrawable convertToMonochrome(Context context, Drawable drawable2, float threshold) {
        Bitmap bitmap = U.convertToBitmapDrawable(context, drawable2).getBitmap();
        Bitmap monoBitmap = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        float[] hsv = new float[3];
        for (int col = 0; col < bitmap.getWidth(); ++col) {
            for (int row = 0; row < bitmap.getHeight(); ++row) {
                Color.colorToHSV((int)bitmap.getPixel(col, row), (float[])hsv);
                if (hsv[2] > threshold) {
                    monoBitmap.setPixel(col, row, -1);
                    continue;
                }
                monoBitmap.setPixel(col, row, 0);
            }
        }
        return new BitmapDrawable(context.getResources(), monoBitmap);
    }

    public static BitmapDrawable resizeDrawable(Context context, Drawable drawable2, @DimenRes int iconSizeRes) {
        int width = Math.max(1, drawable2.getIntrinsicWidth());
        int height = Math.max(1, drawable2.getIntrinsicHeight());
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        int iconSize = context.getApplicationContext().getResources().getDimensionPixelSize(iconSizeRes);
        Bitmap resizedBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)iconSize, (int)iconSize, (boolean)true);
        return new BitmapDrawable(context.getResources(), resizedBitmap);
    }

    private static String getCurrentTheme(Context context) {
        String defaultTheme = context.getString(R.string.tb_pref_theme_default);
        SharedPreferences pref = U.getSharedPreferences(context);
        String themePref = pref.getString("theme", defaultTheme);
        if (themePref.equals("system")) {
            Configuration configuration = context.getResources().getConfiguration();
            int currentNightMode = configuration.uiMode & 0x30;
            switch (currentNightMode) {
                case 16: {
                    return "light";
                }
                case 32: {
                    return "dark";
                }
            }
        } else {
            return themePref;
        }
        return defaultTheme;
    }

    public static boolean isFavoriteAppTilesEnabled(Context context) {
        return Build.VERSION.SDK_INT >= 24 && !U.isChromeOs(context) && !U.isLibrary(context);
    }

    public static Intent getThemedIntent(Context context, Class<?> clazz) {
        Class<?> newClass;
        if (!U.isDarkTheme(context)) {
            newClass = clazz;
        } else {
            try {
                newClass = Class.forName(clazz.getPackage().getName() + ".dark." + clazz.getSimpleName() + "Dark");
            }
            catch (ClassNotFoundException | NullPointerException e) {
                newClass = clazz;
            }
        }
        return new Intent(context, newClass);
    }

    public static boolean isDarkTheme(Context context) {
        return U.getCurrentTheme(context).equals("dark");
    }

    public static boolean getBooleanPrefWithDefault(Context context, String key) {
        context = U.getDisplayContext(context);
        int resId = U.getDefaultPrefResID(key, R.bool.class);
        SharedPreferences pref = U.getSharedPreferences(context);
        boolean def = pref.getBoolean(key + "_default", context.getResources().getBoolean(resId));
        return pref.getBoolean(key, def);
    }

    public static int getIntPrefWithDefault(Context context, String key) {
        context = U.getDisplayContext(context);
        int resId = U.getDefaultPrefResID(key, R.integer.class);
        SharedPreferences pref = U.getSharedPreferences(context);
        int def = pref.getInt(key + "_default", context.getResources().getInteger(resId));
        return pref.getInt(key, def);
    }

    private static int getDefaultPrefResID(String key, Class<?> rClass) {
        int resId;
        try {
            Field field = rClass.getField("tb_def_" + key);
            resId = field.getInt(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return 0;
        }
        return resId;
    }

    public static boolean isFreeformModeEnabled(Context context) {
        if (U.isLibrary(context)) {
            return true;
        }
        SharedPreferences pref = U.getSharedPreferences(context);
        return pref.getBoolean("desktop_mode", false) || pref.getBoolean("freeform_hack", false);
    }

    public static Context getDisplayContext(Context context) {
        if (U.isDesktopModeActive(context)) {
            return context.createDisplayContext(U.getExternalDisplay(context));
        }
        return context.getApplicationContext();
    }

    public static int getDisplayOrientation(Context context) {
        return U.getDisplayContext((Context)context).getResources().getConfiguration().orientation;
    }

    @TargetApi(value=24)
    public static void applyOpenInNewWindow(Context context, Intent intent) {
        if (!U.isFreeformModeEnabled(context)) {
            return;
        }
        intent.addFlags(0x8000000);
        ActivityInfo activityInfo = intent.resolveActivityInfo(context.getPackageManager(), 0);
        if (activityInfo != null) {
            switch (activityInfo.launchMode) {
                case 2: 
                case 3: {
                    intent.addFlags(4096);
                }
            }
        }
    }

    public static boolean isConsumerBuild(Context context) {
        return !context.getPackageName().equals("com.farmerbb.taskbar.androidx86") && !U.isLibrary(context);
    }

    public static void allowReflection() {
        GlobalHelper helper = GlobalHelper.getInstance();
        if (helper.isReflectionAllowed()) {
            return;
        }
        try {
            Method forName = Class.class.getDeclaredMethod("forName", String.class);
            Method getDeclaredMethod = Class.class.getDeclaredMethod("getDeclaredMethod", String.class, Class[].class);
            Class vmRuntimeClass = (Class)forName.invoke(null, "dalvik.system.VMRuntime");
            Method getRuntime = (Method)getDeclaredMethod.invoke((Object)vmRuntimeClass, "getRuntime", null);
            Method setHiddenApiExemptions = (Method)getDeclaredMethod.invoke((Object)vmRuntimeClass, "setHiddenApiExemptions", new Class[]{String[].class});
            Object vmRuntime = getRuntime.invoke(null, new Object[0]);
            setHiddenApiExemptions.invoke(vmRuntime, new Object[]{new String[]{"L"}});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        helper.setReflectionAllowed(true);
    }
}

