/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.util;

import android.content.Context;
import com.farmerbb.taskbar.util.BlacklistEntry;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TopApps
implements Serializable {
    static final long serialVersionUID = 8541436853152666400L;
    private List<BlacklistEntry> topApps = new ArrayList<BlacklistEntry>();
    private static TopApps theInstance;

    private TopApps() {
    }

    public List<BlacklistEntry> getTopApps() {
        return this.topApps;
    }

    public void addTopApp(Context context, BlacklistEntry entry) {
        this.topApps.add(entry);
        this.save(context);
    }

    public void removeTopApp(Context context, String packageName) {
        int number = -1;
        for (int i = 0; i < this.topApps.size(); ++i) {
            if (!this.topApps.get(i).getPackageName().equals(packageName)) continue;
            number = i;
            break;
        }
        if (number != -1) {
            this.topApps.remove(number);
        }
        this.save(context);
    }

    public boolean isTopApp(String packageName) {
        for (int i = 0; i < this.topApps.size(); ++i) {
            if (!this.topApps.get(i).getPackageName().equals(packageName)) continue;
            return true;
        }
        return false;
    }

    private boolean save(Context context) {
        try {
            FileOutputStream fileOutputStream = context.openFileOutput("TopApps", 0);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
            fileOutputStream.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void clear(Context context) {
        this.topApps.clear();
        this.save(context);
    }

    public static TopApps getInstance(Context context) {
        if (theInstance == null) {
            try {
                FileInputStream fileInputStream = context.openFileInput("TopApps");
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                theInstance = (TopApps)objectInputStream.readObject();
                objectInputStream.close();
                fileInputStream.close();
            }
            catch (IOException | ClassNotFoundException e) {
                theInstance = new TopApps();
            }
        }
        return theInstance;
    }
}

