/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.view.WindowManager;
import com.farmerbb.taskbar.util.U;

public class TaskbarPosition {
    private static Integer cachedRotation;

    private TaskbarPosition() {
    }

    private static String transferPositionWithRotation(String position, int rotation) {
        switch (position) {
            case "bottom_left": {
                switch (rotation) {
                    case 0: {
                        return "bottom_left";
                    }
                    case 1: {
                        return "bottom_vertical_right";
                    }
                    case 2: {
                        return "top_right";
                    }
                    case 3: {
                        return "top_vertical_left";
                    }
                }
                break;
            }
            case "bottom_vertical_left": {
                switch (rotation) {
                    case 0: {
                        return "bottom_vertical_left";
                    }
                    case 1: {
                        return "bottom_right";
                    }
                    case 2: {
                        return "top_vertical_right";
                    }
                    case 3: {
                        return "top_left";
                    }
                }
                break;
            }
            case "bottom_right": {
                switch (rotation) {
                    case 0: {
                        return "bottom_right";
                    }
                    case 1: {
                        return "top_vertical_right";
                    }
                    case 2: {
                        return "top_left";
                    }
                    case 3: {
                        return "bottom_vertical_left";
                    }
                }
                break;
            }
            case "bottom_vertical_right": {
                switch (rotation) {
                    case 0: {
                        return "bottom_vertical_right";
                    }
                    case 1: {
                        return "top_right";
                    }
                    case 2: {
                        return "top_vertical_left";
                    }
                    case 3: {
                        return "bottom_left";
                    }
                }
                break;
            }
            case "top_left": {
                switch (rotation) {
                    case 0: {
                        return "top_left";
                    }
                    case 1: {
                        return "bottom_vertical_left";
                    }
                    case 2: {
                        return "bottom_right";
                    }
                    case 3: {
                        return "top_vertical_right";
                    }
                }
                break;
            }
            case "top_vertical_left": {
                switch (rotation) {
                    case 0: {
                        return "top_vertical_left";
                    }
                    case 1: {
                        return "bottom_left";
                    }
                    case 2: {
                        return "bottom_vertical_right";
                    }
                    case 3: {
                        return "top_right";
                    }
                }
                break;
            }
            case "top_right": {
                switch (rotation) {
                    case 0: {
                        return "top_right";
                    }
                    case 1: {
                        return "top_vertical_left";
                    }
                    case 2: {
                        return "bottom_left";
                    }
                    case 3: {
                        return "bottom_vertical_right";
                    }
                }
                break;
            }
            case "top_vertical_right": {
                switch (rotation) {
                    case 0: {
                        return "top_vertical_right";
                    }
                    case 1: {
                        return "top_left";
                    }
                    case 2: {
                        return "bottom_vertical_left";
                    }
                    case 3: {
                        return "bottom_right";
                    }
                }
            }
        }
        return "bottom_left";
    }

    public static boolean isVertical(String position) {
        switch (position) {
            case "top_vertical_left": 
            case "top_vertical_right": 
            case "bottom_vertical_left": 
            case "bottom_vertical_right": {
                return true;
            }
        }
        return false;
    }

    public static boolean isVertical(Context context) {
        return TaskbarPosition.isVertical(TaskbarPosition.getTaskbarPosition(context));
    }

    public static boolean isLeft(String position) {
        switch (position) {
            case "top_left": 
            case "top_vertical_left": 
            case "bottom_left": 
            case "bottom_vertical_left": {
                return true;
            }
        }
        return false;
    }

    public static boolean isLeft(Context context) {
        return TaskbarPosition.isLeft(TaskbarPosition.getTaskbarPosition(context));
    }

    public static boolean isRight(String position) {
        switch (position) {
            case "top_right": 
            case "top_vertical_right": 
            case "bottom_right": 
            case "bottom_vertical_right": {
                return true;
            }
        }
        return false;
    }

    public static boolean isRight(Context context) {
        return TaskbarPosition.isRight(TaskbarPosition.getTaskbarPosition(context));
    }

    public static boolean isBottom(String position) {
        switch (position) {
            case "bottom_left": 
            case "bottom_right": 
            case "bottom_vertical_left": 
            case "bottom_vertical_right": {
                return true;
            }
        }
        return false;
    }

    public static boolean isBottom(Context context) {
        return TaskbarPosition.isBottom(TaskbarPosition.getTaskbarPosition(context));
    }

    public static boolean isVerticalLeft(String position) {
        return TaskbarPosition.isVertical(position) && TaskbarPosition.isLeft(position);
    }

    public static boolean isVerticalLeft(Context context) {
        return TaskbarPosition.isVerticalLeft(TaskbarPosition.getTaskbarPosition(context));
    }

    public static boolean isVerticalRight(String position) {
        return TaskbarPosition.isVertical(position) && TaskbarPosition.isRight(position);
    }

    public static boolean isVerticalRight(Context context) {
        return TaskbarPosition.isVerticalRight(TaskbarPosition.getTaskbarPosition(context));
    }

    public static String getTaskbarPosition(Context context) {
        SharedPreferences pref = U.getSharedPreferences(context);
        String position = pref.getString("position", "bottom_left");
        if (pref.getBoolean("anchor", false)) {
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            int rotation = cachedRotation != null ? cachedRotation.intValue() : windowManager.getDefaultDisplay().getRotation();
            String finalPosition = TaskbarPosition.transferPositionWithRotation(position, rotation);
            return finalPosition == null ? position : finalPosition;
        }
        return position;
    }

    public static void setCachedRotation(int cachedRotation) {
        TaskbarPosition.cachedRotation = cachedRotation;
    }
}

