/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.util;

import android.content.Context;
import com.farmerbb.taskbar.util.SavedWindowSizesEntry;
import com.farmerbb.taskbar.util.U;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SavedWindowSizes
implements Serializable {
    static final long serialVersionUID = 7111185146180868281L;
    private List<SavedWindowSizesEntry> savedApps = new ArrayList<SavedWindowSizesEntry>();
    private static SavedWindowSizes theInstance;

    private SavedWindowSizes() {
    }

    public void setWindowSize(Context context, String packageName, String windowSize) {
        int number = -1;
        for (int i = 0; i < this.savedApps.size(); ++i) {
            if (!this.savedApps.get(i).getComponentName().equals(packageName)) continue;
            number = i;
            break;
        }
        if (number != -1) {
            this.savedApps.remove(number);
        }
        this.savedApps.add(new SavedWindowSizesEntry(packageName, windowSize));
        this.save(context);
    }

    public String getWindowSize(Context context, String packageName) {
        for (SavedWindowSizesEntry entry : this.savedApps) {
            if (!entry.getComponentName().equals(packageName)) continue;
            return entry.getWindowSize();
        }
        return U.getSharedPreferences(context).getString("window_size", "standard");
    }

    public void clear(Context context) {
        this.savedApps.clear();
        this.save(context);
    }

    private boolean save(Context context) {
        try {
            FileOutputStream fileOutputStream = context.openFileOutput("SavedWindowSizes", 0);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
            fileOutputStream.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static SavedWindowSizes getInstance(Context context) {
        if (theInstance == null) {
            try {
                FileInputStream fileInputStream = context.openFileInput("SavedWindowSizes");
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                theInstance = (SavedWindowSizes)objectInputStream.readObject();
                objectInputStream.close();
                fileInputStream.close();
            }
            catch (IOException | ClassNotFoundException e) {
                theInstance = new SavedWindowSizes();
            }
        }
        return theInstance;
    }

    public List<SavedWindowSizesEntry> getSavedWindowSizes() {
        return this.savedApps;
    }
}

