/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.util;

import android.content.Context;
import com.farmerbb.taskbar.util.AppEntry;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PinnedBlockedApps
implements Serializable {
    static final long serialVersionUID = 6649239269100390617L;
    private List<AppEntry> pinnedApps = new ArrayList<AppEntry>();
    private List<AppEntry> blockedApps = new ArrayList<AppEntry>();
    private static PinnedBlockedApps theInstance;

    private PinnedBlockedApps() {
    }

    public List<AppEntry> getPinnedApps() {
        return this.pinnedApps;
    }

    public List<AppEntry> getBlockedApps() {
        return this.blockedApps;
    }

    public void addPinnedApp(Context context, AppEntry entry) {
        this.pinnedApps.add(entry);
        this.save(context);
    }

    public void addBlockedApp(Context context, AppEntry entry) {
        this.blockedApps.add(entry);
        this.save(context);
    }

    public void removePinnedApp(Context context, String componentName) {
        int number = -1;
        for (int i = 0; i < this.pinnedApps.size(); ++i) {
            if (!this.pinnedApps.get(i).getComponentName().equals(componentName)) continue;
            number = i;
            break;
        }
        if (number != -1) {
            this.pinnedApps.remove(number);
        }
        this.save(context);
    }

    public void removeBlockedApp(Context context, String componentName) {
        int number = -1;
        for (int i = 0; i < this.blockedApps.size(); ++i) {
            if (!this.blockedApps.get(i).getComponentName().equals(componentName)) continue;
            number = i;
            break;
        }
        if (number != -1) {
            this.blockedApps.remove(number);
        }
        this.save(context);
    }

    public boolean isPinned(String componentName) {
        for (int i = 0; i < this.pinnedApps.size(); ++i) {
            if (!this.pinnedApps.get(i).getComponentName().equals(componentName)) continue;
            return true;
        }
        return false;
    }

    public boolean isBlocked(String componentName) {
        for (int i = 0; i < this.blockedApps.size(); ++i) {
            if (!this.blockedApps.get(i).getComponentName().equals(componentName)) continue;
            return true;
        }
        return false;
    }

    public void clear(Context context) {
        this.pinnedApps.clear();
        this.blockedApps.clear();
        this.save(context);
    }

    private boolean save(Context context) {
        try {
            FileOutputStream fileOutputStream = context.openFileOutput("PinnedBlockedApps", 0);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
            fileOutputStream.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static PinnedBlockedApps getInstance(Context context) {
        if (theInstance == null) {
            try {
                FileInputStream fileInputStream = context.openFileInput("PinnedBlockedApps");
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                theInstance = (PinnedBlockedApps)objectInputStream.readObject();
                objectInputStream.close();
                fileInputStream.close();
            }
            catch (IOException | ClassNotFoundException e) {
                theInstance = new PinnedBlockedApps();
            }
        }
        return theInstance;
    }
}

