/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.util;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import com.farmerbb.taskbar.util.IconPack;
import java.util.ArrayList;
import java.util.List;

public class IconPackManager {
    private static IconPackManager theInstance;
    private IconPack currentIconPack;

    private IconPackManager() {
    }

    public static IconPackManager getInstance() {
        if (theInstance == null) {
            theInstance = new IconPackManager();
        }
        return theInstance;
    }

    public List<IconPack> getAvailableIconPacks(Context mContext) {
        PackageManager pm = mContext.getPackageManager();
        List rinfo = pm.queryIntentActivities(new Intent("org.adw.launcher.THEMES"), 128);
        ArrayList<IconPack> iconPacks = new ArrayList<IconPack>();
        for (ResolveInfo ri : rinfo) {
            IconPack ip = new IconPack();
            ip.setPackageName(ri.activityInfo.packageName);
            try {
                ApplicationInfo ai = pm.getApplicationInfo(ip.getPackageName(), 128);
                ip.setName(mContext.getPackageManager().getApplicationLabel(ai).toString());
                iconPacks.add(ip);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        return iconPacks;
    }

    void nullify() {
        this.currentIconPack = null;
    }

    IconPack getIconPack(String packageName) {
        if (this.currentIconPack == null || !this.currentIconPack.getPackageName().equals(packageName)) {
            this.currentIconPack = new IconPack();
            this.currentIconPack.setPackageName(packageName);
        }
        return this.currentIconPack;
    }
}

