/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import com.farmerbb.taskbar.util.U;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class IconPack {
    private String packageName;
    private String name;
    private boolean mIsLoading = false;
    private boolean mLoaded = false;
    private Map<String, String> mPackagesDrawables = new HashMap<String, String>();
    private List<Bitmap> mBackImages = new ArrayList<Bitmap>();
    private Bitmap mMaskImage = null;
    private Bitmap mFrontImage = null;
    private float mFactor = 0.5f;
    private int totalIcons;
    private Resources iconPackres = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    private void load(Context mContext) {
        if (!this.mIsLoading) {
            this.mIsLoading = true;
            SharedPreferences pref = U.getSharedPreferences(mContext);
            boolean loadMasks = pref.getBoolean("icon_pack_use_mask", false);
            try {
                XmlResourceParser xpp = null;
                int appfilterid = this.getResources(mContext).getIdentifier("appfilter", "xml", this.packageName);
                if (appfilterid > 0) {
                    xpp = this.getResources(mContext).getXml(appfilterid);
                } else {
                    try {
                        InputStream appfilterstream = this.getResources(mContext).getAssets().open("appfilter.xml");
                        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
                        factory.setNamespaceAware(true);
                        xpp = factory.newPullParser();
                        xpp.setInput(appfilterstream, "utf-8");
                    }
                    catch (IOException appfilterstream) {
                        // empty catch block
                    }
                }
                if (xpp != null) {
                    int eventType = xpp.getEventType();
                    while (eventType != 1) {
                        if (eventType == 2) {
                            String drawableName;
                            if (loadMasks) {
                                String drawableName2;
                                if (xpp.getName().equals("iconback")) {
                                    for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                                        Bitmap iconback;
                                        if (!xpp.getAttributeName(i).startsWith("img") || (iconback = this.loadBitmap(mContext, drawableName = xpp.getAttributeValue(i))) == null) continue;
                                        this.mBackImages.add(iconback);
                                    }
                                } else if (xpp.getName().equals("iconmask")) {
                                    if (xpp.getAttributeCount() > 0 && xpp.getAttributeName(0).equals("img1")) {
                                        drawableName2 = xpp.getAttributeValue(0);
                                        this.mMaskImage = this.loadBitmap(mContext, drawableName2);
                                    }
                                } else if (xpp.getName().equals("iconupon")) {
                                    if (xpp.getAttributeCount() > 0 && xpp.getAttributeName(0).equals("img1")) {
                                        drawableName2 = xpp.getAttributeValue(0);
                                        this.mFrontImage = this.loadBitmap(mContext, drawableName2);
                                    }
                                } else if (xpp.getName().equals("scale") && xpp.getAttributeCount() > 0 && xpp.getAttributeName(0).equals("factor")) {
                                    this.mFactor = Float.valueOf(xpp.getAttributeValue(0)).floatValue();
                                }
                            }
                            if (xpp.getName().equals("item")) {
                                String componentName = null;
                                drawableName = null;
                                for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                                    if (xpp.getAttributeName(i).equals("component")) {
                                        componentName = xpp.getAttributeValue(i);
                                        continue;
                                    }
                                    if (!xpp.getAttributeName(i).equals("drawable")) continue;
                                    drawableName = xpp.getAttributeValue(i);
                                }
                                if (!this.mPackagesDrawables.containsKey(componentName)) {
                                    this.mPackagesDrawables.put(componentName, drawableName);
                                    ++this.totalIcons;
                                }
                            }
                        }
                        eventType = xpp.next();
                    }
                }
                this.mLoaded = true;
            }
            catch (IOException | XmlPullParserException throwable) {
                // empty catch block
            }
            this.mIsLoading = false;
        }
    }

    private Bitmap loadBitmap(Context context, String drawableName) {
        Drawable bitmap;
        int id2 = this.getResources(context).getIdentifier(drawableName, "drawable", this.packageName);
        if (id2 > 0 && (bitmap = this.getResources(context).getDrawable(id2)) instanceof BitmapDrawable) {
            return ((BitmapDrawable)bitmap).getBitmap();
        }
        return null;
    }

    private Drawable loadDrawable(Context context, String drawableName) {
        int id2 = this.getResources(context).getIdentifier(drawableName, "drawable", this.packageName);
        if (id2 > 0) {
            return this.getResources(context).getDrawable(id2);
        }
        return null;
    }

    Drawable getDrawableIconForPackage(Context mContext, String componentName) {
        int start;
        int end;
        String drawable2;
        if (!this.mLoaded) {
            this.load(mContext);
        }
        if ((drawable2 = this.mPackagesDrawables.get(componentName)) != null) {
            return this.loadDrawable(mContext, drawable2);
        }
        if (componentName != null && (end = componentName.indexOf("}", start = componentName.indexOf("{") + 1)) > start) {
            drawable2 = componentName.substring(start, end).toLowerCase(Locale.getDefault()).replace(".", "_").replace("/", "_");
            if (this.getResources(mContext).getIdentifier(drawable2, "drawable", this.packageName) > 0) {
                return this.loadDrawable(mContext, drawable2);
            }
        }
        return null;
    }

    Bitmap getIconForPackage(Context mContext, String componentName, Bitmap defaultBitmap) {
        int start;
        int end;
        String drawable2;
        if (!this.mLoaded) {
            this.load(mContext);
        }
        if ((drawable2 = this.mPackagesDrawables.get(componentName)) != null) {
            Bitmap BMP = this.loadBitmap(mContext, drawable2);
            if (BMP == null) {
                return this.generateBitmap(componentName, defaultBitmap);
            }
            return BMP;
        }
        if (componentName != null && (end = componentName.indexOf("}", start = componentName.indexOf("{") + 1)) > start) {
            drawable2 = componentName.substring(start, end).toLowerCase(Locale.getDefault()).replace(".", "_").replace("/", "_");
            if (this.getResources(mContext).getIdentifier(drawable2, "drawable", this.packageName) > 0) {
                return this.loadBitmap(mContext, drawable2);
            }
        }
        return this.generateBitmap(componentName, defaultBitmap);
    }

    private Bitmap generateBitmap(String componentName, Bitmap defaultBitmap) {
        if (this.mBackImages.size() == 0) {
            return defaultBitmap;
        }
        Random r = new Random(IconPack.generateSeed(componentName));
        int backImageInd = r.nextInt(this.mBackImages.size());
        Bitmap backImage = this.mBackImages.get(backImageInd);
        int w = backImage.getWidth();
        int h = backImage.getHeight();
        Bitmap result = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas mCanvas = new Canvas(result);
        mCanvas.drawBitmap(backImage, 0.0f, 0.0f, null);
        Bitmap scaledBitmap = Bitmap.createScaledBitmap((Bitmap)defaultBitmap, (int)((int)((float)w * this.mFactor)), (int)((int)((float)h * this.mFactor)), (boolean)true);
        if (this.mMaskImage != null) {
            Bitmap mutableMask = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas maskCanvas = new Canvas(mutableMask);
            maskCanvas.drawBitmap(this.mMaskImage, 0.0f, 0.0f, new Paint());
            Paint paint = new Paint(1);
            paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
            mCanvas.drawBitmap(scaledBitmap, (float)((w - scaledBitmap.getWidth()) / 2), (float)((h - scaledBitmap.getHeight()) / 2), null);
            mCanvas.drawBitmap(mutableMask, 0.0f, 0.0f, paint);
            paint.setXfermode(null);
        } else {
            Bitmap mutableMask = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas maskCanvas = new Canvas(mutableMask);
            maskCanvas.drawBitmap(backImage, 0.0f, 0.0f, new Paint());
            Paint paint = new Paint(1);
            paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
            mCanvas.drawBitmap(scaledBitmap, (float)((w - scaledBitmap.getWidth()) / 2), (float)((h - scaledBitmap.getHeight()) / 2), null);
            mCanvas.drawBitmap(mutableMask, 0.0f, 0.0f, paint);
            paint.setXfermode(null);
        }
        if (this.mFrontImage != null) {
            mCanvas.drawBitmap(this.mFrontImage, 0.0f, 0.0f, null);
        }
        return result;
    }

    private static long generateSeed(String packageName) {
        long seed = 0L;
        for (int i = 0; i < packageName.length(); ++i) {
            char ch = packageName.charAt(i);
            seed += (long)ch;
        }
        return seed;
    }

    private Resources getResources(Context context) {
        if (this.iconPackres == null) {
            try {
                this.iconPackres = context.getPackageManager().getResourcesForApplication(this.packageName);
            }
            catch (PackageManager.NameNotFoundException e) {
                this.iconPackres = context.getResources();
            }
        }
        return this.iconPackres;
    }
}

