/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.util;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.LauncherActivityInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.UserManager;
import android.util.LruCache;
import com.farmerbb.taskbar.util.IconPack;
import com.farmerbb.taskbar.util.IconPackManager;
import com.farmerbb.taskbar.util.U;

public class IconCache {
    private final LruCache<String, BitmapDrawable> drawables;
    private static IconCache theInstance;

    private IconCache(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        int memClass = am.getMemoryClass();
        int cacheSize = 0x100000 * memClass / 8;
        this.drawables = new LruCache<String, BitmapDrawable>(cacheSize){

            protected int sizeOf(String key, BitmapDrawable value) {
                return value.getBitmap().getByteCount();
            }
        };
    }

    public static IconCache getInstance(Context context) {
        if (theInstance == null) {
            theInstance = new IconCache(context);
        }
        return theInstance;
    }

    public BitmapDrawable getIcon(Context context, LauncherActivityInfo appInfo) {
        return this.getIcon(context, context.getPackageManager(), appInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitmapDrawable getIcon(Context context, PackageManager pm, LauncherActivityInfo appInfo) {
        BitmapDrawable drawable2;
        UserManager userManager = (UserManager)context.getSystemService("user");
        String name = appInfo.getComponentName().flattenToString() + ":" + userManager.getSerialNumberForUser(appInfo.getUser());
        LruCache<String, BitmapDrawable> lruCache = this.drawables;
        synchronized (lruCache) {
            drawable2 = (BitmapDrawable)this.drawables.get((Object)name);
            if (drawable2 == null) {
                Drawable loadedIcon = this.loadIcon(context, pm, appInfo);
                drawable2 = U.convertToBitmapDrawable(context, loadedIcon);
                this.drawables.put((Object)name, (Object)drawable2);
            }
        }
        return drawable2;
    }

    private Drawable loadIcon(Context context, PackageManager pm, LauncherActivityInfo appInfo) {
        SharedPreferences pref = U.getSharedPreferences(context);
        String iconPackPackage = pref.getString("icon_pack", context.getPackageName());
        boolean useMask = pref.getBoolean("icon_pack_use_mask", false);
        IconPackManager iconPackManager = IconPackManager.getInstance();
        try {
            pm.getPackageInfo(iconPackPackage, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            iconPackPackage = context.getPackageName();
            pref.edit().putString("icon_pack", iconPackPackage).apply();
            U.refreshPinnedIcons(context);
        }
        if (iconPackPackage.equals(context.getPackageName())) {
            return this.getIcon(pm, appInfo);
        }
        IconPack iconPack = iconPackManager.getIconPack(iconPackPackage);
        String componentName = new ComponentName(appInfo.getApplicationInfo().packageName, appInfo.getName()).toString();
        if (!useMask) {
            Drawable icon = iconPack.getDrawableIconForPackage(context, componentName);
            return icon == null ? this.getIcon(pm, appInfo) : icon;
        }
        Drawable drawable2 = this.getIcon(pm, appInfo);
        if (drawable2 instanceof BitmapDrawable) {
            return new BitmapDrawable(context.getResources(), iconPack.getIconForPackage(context, componentName, ((BitmapDrawable)drawable2).getBitmap()));
        }
        Drawable icon = iconPack.getDrawableIconForPackage(context, componentName);
        return icon == null ? drawable2 : icon;
    }

    public void clearCache() {
        this.drawables.evictAll();
        IconPackManager.getInstance().nullify();
        System.gc();
    }

    private Drawable getIcon(PackageManager pm, LauncherActivityInfo appInfo) {
        try {
            return appInfo.getBadgedIcon(0);
        }
        catch (NullPointerException e) {
            return pm.getDefaultActivityIcon();
        }
    }
}

