/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.util;

import android.content.Context;
import com.farmerbb.taskbar.util.AppEntry;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

public class DesktopIconInfo
implements Serializable {
    public int column;
    public int row;
    public AppEntry entry;
    static final long serialVersionUID = 1L;

    public DesktopIconInfo(int column, int row, AppEntry entry) {
        this.column = column;
        this.row = row;
        this.entry = entry;
    }

    public JSONObject toJson(Context context) {
        JSONObject json = new JSONObject();
        try {
            json.put("column", this.column);
            json.put("row", this.row);
            json.put("package_name", (Object)this.entry.getPackageName());
            json.put("app_name", (Object)this.entry.getLabel());
            json.put("component_name", (Object)this.entry.getComponentName());
            json.put("user_id", this.entry.getUserId(context));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json;
    }

    public static DesktopIconInfo fromJson(JSONObject json) {
        try {
            int column = json.getInt("column");
            int row = json.getInt("row");
            String packageName = json.getString("package_name");
            String label = json.getString("app_name");
            String componentName = json.getString("component_name");
            long userId = json.getLong("user_id");
            AppEntry entry = new AppEntry(packageName, componentName, label, null, false);
            entry.setUserId(userId);
            return new DesktopIconInfo(column, row, entry);
        }
        catch (JSONException e) {
            return null;
        }
    }
}

