/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.util;

import android.content.Context;
import com.farmerbb.taskbar.util.BlacklistEntry;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Blacklist
implements Serializable {
    static final long serialVersionUID = 9033765395690141037L;
    private List<BlacklistEntry> blockedApps = new ArrayList<BlacklistEntry>();
    private static Blacklist theInstance;

    private Blacklist() {
    }

    public List<BlacklistEntry> getBlockedApps() {
        return this.blockedApps;
    }

    public void addBlockedApp(Context context, BlacklistEntry entry) {
        this.blockedApps.add(entry);
        this.save(context);
    }

    public void removeBlockedApp(Context context, String packageName) {
        int number = -1;
        for (int i = 0; i < this.blockedApps.size(); ++i) {
            if (!this.blockedApps.get(i).getPackageName().equals(packageName)) continue;
            number = i;
            break;
        }
        if (number != -1) {
            this.blockedApps.remove(number);
        }
        this.save(context);
    }

    public boolean isBlocked(String packageName) {
        for (int i = 0; i < this.blockedApps.size(); ++i) {
            if (!this.blockedApps.get(i).getPackageName().equals(packageName)) continue;
            return true;
        }
        return false;
    }

    private boolean save(Context context) {
        try {
            FileOutputStream fileOutputStream = context.openFileOutput("Blacklist", 0);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
            fileOutputStream.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void clear(Context context) {
        this.blockedApps.clear();
        this.save(context);
    }

    public static Blacklist getInstance(Context context) {
        if (theInstance == null) {
            try {
                FileInputStream fileInputStream = context.openFileInput("Blacklist");
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                theInstance = (Blacklist)objectInputStream.readObject();
                objectInputStream.close();
                fileInputStream.close();
            }
            catch (IOException | ClassNotFoundException e) {
                theInstance = new Blacklist();
            }
        }
        return theInstance;
    }
}

