/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.util;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.LauncherActivityInfo;
import android.content.pm.LauncherApps;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Process;
import android.os.UserManager;
import com.farmerbb.taskbar.util.IconCache;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class AppEntry
implements Serializable {
    static final long serialVersionUID = -3982172488299272068L;
    private String packageName;
    private String componentName;
    private String label;
    private Long userId;
    private Long lastTimeUsed;
    private Long totalTimeInForeground;
    private transient Drawable icon;
    private byte[] iconByteArray;

    public AppEntry(String packageName, String componentName, String label, Drawable icon, boolean shouldCompress) {
        this.packageName = packageName;
        this.componentName = componentName;
        this.label = label;
        this.icon = icon;
        if (shouldCompress && icon instanceof BitmapDrawable) {
            Bitmap bitmap = ((BitmapDrawable)icon).getBitmap();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)stream);
            this.iconByteArray = stream.toByteArray();
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getLabel() {
        return this.label;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public long getUserId(Context context) {
        if (this.userId == null) {
            UserManager userManager = (UserManager)context.getSystemService("user");
            return userManager.getSerialNumberForUser(Process.myUserHandle());
        }
        return this.userId;
    }

    public Drawable getIcon(Context context) {
        if (this.icon == null) {
            if (this.iconByteArray != null) {
                this.icon = new BitmapDrawable(context.getResources(), BitmapFactory.decodeByteArray((byte[])this.iconByteArray, (int)0, (int)this.iconByteArray.length));
            } else {
                Intent intent = new Intent();
                intent.setComponent(ComponentName.unflattenFromString((String)this.componentName));
                LauncherApps launcherApps = (LauncherApps)context.getSystemService("launcherapps");
                UserManager userManager = (UserManager)context.getSystemService("user");
                LauncherActivityInfo appInfo = launcherApps.resolveActivity(intent, userManager.getUserForSerialNumber(this.userId.longValue()));
                this.icon = IconCache.getInstance(context).getIcon(context, appInfo);
            }
        }
        return this.icon;
    }

    public long getLastTimeUsed() {
        return this.lastTimeUsed == null ? 0L : this.lastTimeUsed;
    }

    public void setLastTimeUsed(long lastTimeUsed) {
        this.lastTimeUsed = lastTimeUsed;
    }

    public long getTotalTimeInForeground() {
        return this.totalTimeInForeground == null ? 0L : this.totalTimeInForeground;
    }

    public void setTotalTimeInForeground(long totalTimeInForeground) {
        this.totalTimeInForeground = totalTimeInForeground;
    }
}

