/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.ui;

import android.content.Context;
import android.content.SharedPreferences;
import com.farmerbb.taskbar.activity.SecondaryHomeActivity;
import com.farmerbb.taskbar.helper.LauncherHelper;
import com.farmerbb.taskbar.ui.UIHost;
import com.farmerbb.taskbar.util.U;

public abstract class UIController {
    protected Context context;

    public UIController(Context context) {
        this.context = context;
    }

    abstract void onCreateHost(UIHost var1);

    abstract void onRecreateHost(UIHost var1);

    abstract void onDestroyHost(UIHost var1);

    protected void init(Context context, UIHost host, Runnable runnable) {
        SharedPreferences pref = U.getSharedPreferences(context);
        LauncherHelper helper = LauncherHelper.getInstance();
        boolean shouldProceed = helper.isOnSecondaryHomeScreen(context) ? host instanceof SecondaryHomeActivity : true;
        if (shouldProceed && (pref.getBoolean("taskbar_active", false) || helper.isOnHomeScreen(context))) {
            if (U.canDrawOverlays(context)) {
                runnable.run();
            } else {
                pref.edit().putBoolean("taskbar_active", false).apply();
                host.terminate();
            }
        } else {
            host.terminate();
        }
    }
}

