/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.ui;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.app.usage.UsageEvents;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.bluetooth.BluetoothAdapter;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.LauncherActivityInfo;
import android.content.pm.LauncherApps;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.BatteryManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.PowerManager;
import android.os.Process;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.text.format.DateFormat;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.PointerIcon;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Space;
import android.widget.TextView;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.ColorUtils;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.activity.HomeActivity;
import com.farmerbb.taskbar.activity.HomeActivityDelegate;
import com.farmerbb.taskbar.activity.InvisibleActivityFreeform;
import com.farmerbb.taskbar.activity.MainActivity;
import com.farmerbb.taskbar.activity.SecondaryHomeActivity;
import com.farmerbb.taskbar.helper.FreeformHackHelper;
import com.farmerbb.taskbar.helper.LauncherHelper;
import com.farmerbb.taskbar.helper.MenuHelper;
import com.farmerbb.taskbar.ui.UIController;
import com.farmerbb.taskbar.ui.UIHost;
import com.farmerbb.taskbar.ui.ViewParams;
import com.farmerbb.taskbar.util.AppEntry;
import com.farmerbb.taskbar.util.DisplayInfo;
import com.farmerbb.taskbar.util.IconCache;
import com.farmerbb.taskbar.util.PinnedBlockedApps;
import com.farmerbb.taskbar.util.TaskbarPosition;
import com.farmerbb.taskbar.util.U;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class TaskbarController
extends UIController {
    private LinearLayout layout;
    private ImageView startButton;
    private LinearLayout taskbar;
    private FrameLayout scrollView;
    private Button button;
    private Space space;
    private FrameLayout dashboardButton;
    private LinearLayout navbarButtons;
    private LinearLayout sysTrayLayout;
    private FrameLayout sysTrayParentLayout;
    private TextView time;
    private ImageView notificationCountCircle;
    private TextView notificationCountText;
    private Handler handler;
    private Handler handler2;
    private Thread thread;
    private Thread thread2;
    private boolean isShowingRecents = true;
    private boolean shouldRefreshRecents = true;
    private boolean taskbarShownTemporarily = false;
    private boolean taskbarHiddenTemporarily = false;
    private boolean isRefreshingRecents = false;
    private boolean isFirstStart = true;
    private boolean startThread2 = false;
    private boolean stopThread2 = false;
    private int refreshInterval = -1;
    private long searchInterval = -1L;
    private String sortOrder = "false";
    private boolean runningAppsOnly = false;
    private int layoutId = R.layout.tb_taskbar_left;
    private int currentTaskbarPosition = 0;
    private boolean showHideAutomagically = false;
    private boolean positionIsVertical = false;
    private boolean dashboardEnabled = false;
    private boolean navbarButtonsEnabled = false;
    private boolean sysTrayEnabled = false;
    private List<String> currentTaskbarIds = new ArrayList<String>();
    private int numOfPinnedApps = -1;
    private int cellStrength = -1;
    private View.OnClickListener ocl = view -> U.sendBroadcast(this.context, "com.farmerbb.taskbar.TOGGLE_START_MENU");
    private BroadcastReceiver showReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            TaskbarController.this.showTaskbar(true);
        }
    };
    private BroadcastReceiver hideReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            TaskbarController.this.hideTaskbar(true);
        }
    };
    private BroadcastReceiver tempShowReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            TaskbarController.this.tempShowTaskbar();
        }
    };
    private BroadcastReceiver tempHideReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            TaskbarController.this.tempHideTaskbar(false);
        }
    };
    private BroadcastReceiver startMenuAppearReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (TaskbarController.this.startButton.getVisibility() == 8 && (!LauncherHelper.getInstance().isOnHomeScreen(context) || FreeformHackHelper.getInstance().isInFreeformWorkspace())) {
                TaskbarController.this.layout.setVisibility(8);
            }
        }
    };
    private BroadcastReceiver startMenuDisappearReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (TaskbarController.this.startButton.getVisibility() == 8) {
                TaskbarController.this.layout.setVisibility(0);
            }
        }
    };
    private BroadcastReceiver notificationCountReceiver = new BroadcastReceiver(){

        @SuppressLint(value={"SetTextI18n"})
        public void onReceive(Context context, Intent intent) {
            int count = intent.getIntExtra("count", 0);
            if (count > 0) {
                int color2 = ColorUtils.setAlphaComponent((int)U.getBackgroundTint(context), (int)255);
                TaskbarController.this.notificationCountText.setTextColor(color2);
                Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)R.drawable.tb_circle);
                drawable2.setTint(U.getAccentColor(context));
                TaskbarController.this.notificationCountCircle.setImageDrawable(drawable2);
                TaskbarController.this.notificationCountText.setText((CharSequence)Integer.toString(count));
            } else {
                TaskbarController.this.notificationCountCircle.setImageDrawable(null);
                TaskbarController.this.notificationCountText.setText(null);
            }
        }
    };
    @TargetApi(value=23)
    private PhoneStateListener listener = new PhoneStateListener(){

        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            try {
                TaskbarController.this.cellStrength = signalStrength.getLevel();
            }
            catch (SecurityException e) {
                TaskbarController.this.cellStrength = -1;
            }
        }
    };

    public TaskbarController(Context context) {
        super(context);
    }

    @Override
    @TargetApi(value=23)
    public void onCreateHost(UIHost host) {
        this.init(this.context, host, () -> this.drawTaskbar(host));
    }

    @SuppressLint(value={"RtlHardcoded"})
    private void drawTaskbar(UIHost host) {
        LinearLayout buttonLayoutToHide;
        IconCache.getInstance(this.context).clearCache();
        WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
        TaskbarPosition.setCachedRotation(windowManager.getDefaultDisplay().getRotation());
        ViewParams params = new ViewParams(-2, -2, -1, 131080);
        String taskbarPosition = TaskbarPosition.getTaskbarPosition(this.context);
        params.gravity = this.getTaskbarGravity(taskbarPosition);
        this.layoutId = this.getTaskbarLayoutId(taskbarPosition);
        this.positionIsVertical = TaskbarPosition.isVertical(taskbarPosition);
        SharedPreferences pref = U.getSharedPreferences(this.context);
        boolean altButtonConfig = pref.getBoolean("alt_button_config", false);
        this.layout = (LinearLayout)LayoutInflater.from((Context)U.wrapContext(this.context)).inflate(this.layoutId, null);
        this.taskbar = (LinearLayout)this.layout.findViewById(R.id.taskbar);
        this.scrollView = (FrameLayout)this.layout.findViewById(R.id.taskbar_scrollview);
        int backgroundTint = U.getBackgroundTint(this.context);
        int accentColor = U.getAccentColor(this.context);
        if (altButtonConfig) {
            this.space = (Space)this.layout.findViewById(R.id.space_alt);
            this.layout.findViewById(R.id.space).setVisibility(8);
        } else {
            this.space = (Space)this.layout.findViewById(R.id.space);
            this.layout.findViewById(R.id.space_alt).setVisibility(8);
        }
        this.space.setOnClickListener(v -> this.toggleTaskbar(true));
        this.startButton = (ImageView)this.layout.findViewById(R.id.start_button);
        this.drawStartButton(this.context, this.startButton, pref, accentColor);
        this.refreshInterval = (int)(Float.parseFloat(pref.getString("refresh_frequency", "1")) * 1000.0f);
        if (this.refreshInterval == 0) {
            this.refreshInterval = 100;
        }
        this.sortOrder = pref.getString("sort_order", "false");
        this.runningAppsOnly = "running_apps_only".equals(pref.getString("recents_amount", "past_day"));
        this.searchInterval = this.getSearchInterval(pref);
        U.sendBroadcast(this.context, "com.farmerbb.taskbar.HIDE_START_MENU");
        U.sendBroadcast(this.context, "com.farmerbb.taskbar.UPDATE_HOME_SCREEN_MARGINS");
        if (altButtonConfig) {
            this.button = (Button)this.layout.findViewById(R.id.hide_taskbar_button_alt);
            this.layout.findViewById(R.id.hide_taskbar_button).setVisibility(8);
        } else {
            this.button = (Button)this.layout.findViewById(R.id.hide_taskbar_button);
            this.layout.findViewById(R.id.hide_taskbar_button_alt).setVisibility(8);
        }
        try {
            this.button.setTypeface(Typeface.createFromFile((String)"/system/fonts/Roboto-Regular.ttf"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.updateButton(false);
        this.button.setOnClickListener(v -> this.toggleTaskbar(true));
        LinearLayout buttonLayout = (LinearLayout)this.layout.findViewById(altButtonConfig ? R.id.hide_taskbar_button_layout_alt : R.id.hide_taskbar_button_layout);
        if (buttonLayout != null) {
            buttonLayout.setOnClickListener(v -> this.toggleTaskbar(true));
        }
        if ((buttonLayoutToHide = (LinearLayout)this.layout.findViewById(altButtonConfig ? R.id.hide_taskbar_button_layout : R.id.hide_taskbar_button_layout_alt)) != null) {
            buttonLayoutToHide.setVisibility(8);
        }
        this.dashboardButton = (FrameLayout)this.layout.findViewById(R.id.dashboard_button);
        this.navbarButtons = (LinearLayout)this.layout.findViewById(R.id.navbar_buttons);
        this.dashboardEnabled = this.drawDashboardButton(this.context, this.layout, this.dashboardButton, accentColor);
        this.navbarButtonsEnabled = this.drawNavbarButtons(this.context, this.layout, pref, accentColor);
        if (!this.navbarButtonsEnabled) {
            this.navbarButtons.setVisibility(8);
        }
        this.sysTrayEnabled = U.isSystemTrayEnabled(this.context);
        if (this.sysTrayEnabled) {
            this.drawSysTray(this.context, this.layoutId, this.layout);
        }
        this.layout.setBackgroundColor(backgroundTint);
        this.layout.findViewById(R.id.divider).setBackgroundColor(accentColor);
        this.button.setTextColor(accentColor);
        if (this.isFirstStart && FreeformHackHelper.getInstance().isInFreeformWorkspace()) {
            this.showTaskbar(false);
        } else if (!pref.getBoolean("collapsed", false) && pref.getBoolean("taskbar_active", false)) {
            this.toggleTaskbar(false);
        }
        if (pref.getBoolean("auto_hide_navbar", false)) {
            U.showHideNavigationBar(this.context, false);
        }
        if (FreeformHackHelper.getInstance().isTouchAbsorberActive()) {
            U.sendBroadcast(this.context, "com.farmerbb.taskbar.FINISH_FREEFORM_ACTIVITY");
            new Handler().postDelayed(() -> U.startTouchAbsorberActivity(this.context), 500L);
        }
        U.registerReceiver(this.context, this.showReceiver, "com.farmerbb.taskbar.SHOW_TASKBAR");
        U.registerReceiver(this.context, this.hideReceiver, "com.farmerbb.taskbar.HIDE_TASKBAR");
        U.registerReceiver(this.context, this.tempShowReceiver, "com.farmerbb.taskbar.TEMP_SHOW_TASKBAR");
        U.registerReceiver(this.context, this.tempHideReceiver, "com.farmerbb.taskbar.TEMP_HIDE_TASKBAR");
        U.registerReceiver(this.context, this.startMenuAppearReceiver, "com.farmerbb.taskbar.START_MENU_APPEARING");
        U.registerReceiver(this.context, this.startMenuDisappearReceiver, "com.farmerbb.taskbar.START_MENU_DISAPPEARING");
        if (this.sysTrayEnabled) {
            TelephonyManager manager = (TelephonyManager)this.context.getSystemService("phone");
            manager.listen(this.listener, 256);
            U.registerReceiver(this.context, this.notificationCountReceiver, "com.farmerbb.taskbar.NOTIFICATION_COUNT_CHANGED");
            U.sendBroadcast(this.context, "com.farmerbb.taskbar.REQUEST_NOTIFICATION_COUNT");
        }
        this.startRefreshingRecents();
        host.addView((View)this.layout, params);
        this.isFirstStart = false;
    }

    @SuppressLint(value={"RtlHardcoded"})
    @VisibleForTesting
    public int getTaskbarGravity(String taskbarPosition) {
        int gravity = 83;
        switch (taskbarPosition) {
            case "bottom_left": 
            case "bottom_vertical_left": {
                gravity = 83;
                break;
            }
            case "bottom_right": 
            case "bottom_vertical_right": {
                gravity = 85;
                break;
            }
            case "top_left": 
            case "top_vertical_left": {
                gravity = 51;
                break;
            }
            case "top_right": 
            case "top_vertical_right": {
                gravity = 53;
            }
        }
        return gravity;
    }

    @VisibleForTesting
    public int getTaskbarLayoutId(String taskbarPosition) {
        int layoutId = R.layout.tb_taskbar_left;
        switch (taskbarPosition) {
            case "bottom_left": 
            case "top_left": {
                layoutId = R.layout.tb_taskbar_left;
                break;
            }
            case "bottom_vertical_left": 
            case "bottom_vertical_right": {
                layoutId = R.layout.tb_taskbar_vertical;
                break;
            }
            case "bottom_right": 
            case "top_right": {
                layoutId = R.layout.tb_taskbar_right;
                break;
            }
            case "top_vertical_left": 
            case "top_vertical_right": {
                layoutId = R.layout.tb_taskbar_top_vertical;
            }
        }
        return layoutId;
    }

    @VisibleForTesting
    public void drawStartButton(Context context, ImageView startButton, SharedPreferences pref, int accentColor) {
        Drawable allAppsIcon = ContextCompat.getDrawable((Context)context, (int)R.drawable.tb_all_apps_button_icon);
        int padding = 0;
        switch (pref.getString("start_button_image", U.getDefaultStartButtonImage(context))) {
            case "default": {
                startButton.setImageDrawable(allAppsIcon);
                padding = context.getResources().getDimensionPixelSize(R.dimen.tb_app_drawer_icon_padding);
                break;
            }
            case "app_logo": {
                Drawable drawable2;
                if (U.isBlissOs(context)) {
                    drawable2 = ContextCompat.getDrawable((Context)context, (int)R.drawable.tb_bliss);
                    drawable2.setTint(accentColor);
                } else {
                    LauncherApps launcherApps = (LauncherApps)context.getSystemService("launcherapps");
                    LauncherActivityInfo info = (LauncherActivityInfo)launcherApps.getActivityList(context.getPackageName(), Process.myUserHandle()).get(0);
                    drawable2 = IconCache.getInstance(context).getIcon(context, context.getPackageManager(), info);
                }
                startButton.setImageDrawable(drawable2);
                padding = context.getResources().getDimensionPixelSize(R.dimen.tb_app_drawer_icon_padding_alt);
                break;
            }
            case "custom": {
                U.applyCustomImage(context, "custom_image", startButton, allAppsIcon);
                padding = context.getResources().getDimensionPixelSize(R.dimen.tb_app_drawer_icon_padding);
            }
        }
        startButton.setPadding(padding, padding, padding, padding);
        startButton.setOnClickListener(this.ocl);
        startButton.setOnLongClickListener(view -> {
            this.openContextMenu();
            return true;
        });
        startButton.setOnGenericMotionListener((view, motionEvent) -> {
            if (motionEvent.getAction() == 11 && motionEvent.getButtonState() == 2) {
                this.openContextMenu();
            }
            return false;
        });
    }

    @VisibleForTesting
    public boolean drawDashboardButton(Context context, LinearLayout layout2, FrameLayout dashboardButton, int accentColor) {
        boolean dashboardEnabled = U.getBooleanPrefWithDefault(context, "dashboard");
        if (dashboardEnabled) {
            layout2.findViewById(R.id.square1).setBackgroundColor(accentColor);
            layout2.findViewById(R.id.square2).setBackgroundColor(accentColor);
            layout2.findViewById(R.id.square3).setBackgroundColor(accentColor);
            layout2.findViewById(R.id.square4).setBackgroundColor(accentColor);
            layout2.findViewById(R.id.square5).setBackgroundColor(accentColor);
            layout2.findViewById(R.id.square6).setBackgroundColor(accentColor);
            dashboardButton.setOnClickListener(v -> U.sendBroadcast(context, "com.farmerbb.taskbar.TOGGLE_DASHBOARD"));
            dashboardButton.setVisibility(0);
        } else {
            dashboardButton.setVisibility(8);
        }
        return dashboardEnabled;
    }

    @VisibleForTesting
    public boolean drawNavbarButtons(Context context, LinearLayout layout2, SharedPreferences pref, int accentColor) {
        boolean navbarButtonsEnabled = false;
        if (pref.getBoolean("button_back", false)) {
            navbarButtonsEnabled = true;
            ImageView backButton = (ImageView)layout2.findViewById(R.id.button_back);
            backButton.setColorFilter(accentColor);
            backButton.setVisibility(0);
            backButton.setOnClickListener(v -> {
                U.sendAccessibilityAction(context, 1);
                if (U.shouldCollapse(context, false)) {
                    this.hideTaskbar(true);
                }
            });
            backButton.setOnLongClickListener(v -> {
                InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
                imm.showInputMethodPicker();
                if (U.shouldCollapse(context, false)) {
                    this.hideTaskbar(true);
                }
                return true;
            });
            backButton.setOnGenericMotionListener((view13, motionEvent) -> {
                if (motionEvent.getAction() == 11 && motionEvent.getButtonState() == 2) {
                    InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
                    imm.showInputMethodPicker();
                    if (U.shouldCollapse(context, false)) {
                        this.hideTaskbar(true);
                    }
                }
                return true;
            });
        }
        if (pref.getBoolean("button_home", false)) {
            navbarButtonsEnabled = true;
            ImageView homeButton = (ImageView)layout2.findViewById(R.id.button_home);
            homeButton.setColorFilter(accentColor);
            homeButton.setVisibility(0);
            homeButton.setOnClickListener(v -> {
                U.sendAccessibilityAction(context, 2);
                if (U.shouldCollapse(context, false)) {
                    this.hideTaskbar(true);
                }
            });
            homeButton.setOnLongClickListener(v -> {
                Intent voiceSearchIntent = new Intent("android.speech.action.VOICE_SEARCH_HANDS_FREE");
                voiceSearchIntent.setFlags(0x10000000);
                try {
                    context.startActivity(voiceSearchIntent);
                }
                catch (ActivityNotFoundException activityNotFoundException) {
                    // empty catch block
                }
                if (U.shouldCollapse(context, false)) {
                    this.hideTaskbar(true);
                }
                return true;
            });
            homeButton.setOnGenericMotionListener((view13, motionEvent) -> {
                if (motionEvent.getAction() == 11 && motionEvent.getButtonState() == 2) {
                    Intent voiceSearchIntent = new Intent("android.speech.action.VOICE_SEARCH_HANDS_FREE");
                    voiceSearchIntent.setFlags(0x10000000);
                    try {
                        context.startActivity(voiceSearchIntent);
                    }
                    catch (ActivityNotFoundException activityNotFoundException) {
                        // empty catch block
                    }
                    if (U.shouldCollapse(context, false)) {
                        this.hideTaskbar(true);
                    }
                }
                return true;
            });
        }
        if (pref.getBoolean("button_recents", false)) {
            navbarButtonsEnabled = true;
            ImageView recentsButton = (ImageView)layout2.findViewById(R.id.button_recents);
            recentsButton.setColorFilter(accentColor);
            recentsButton.setVisibility(0);
            recentsButton.setOnClickListener(v -> {
                U.sendAccessibilityAction(context, 3);
                if (U.shouldCollapse(context, false)) {
                    this.hideTaskbar(true);
                }
            });
            if (Build.VERSION.SDK_INT >= 24) {
                recentsButton.setOnLongClickListener(v -> {
                    U.sendAccessibilityAction(context, 7);
                    if (U.shouldCollapse(context, false)) {
                        this.hideTaskbar(true);
                    }
                    return true;
                });
                recentsButton.setOnGenericMotionListener((view13, motionEvent) -> {
                    if (motionEvent.getAction() == 11 && motionEvent.getButtonState() == 2) {
                        U.sendAccessibilityAction(context, 7);
                        if (U.shouldCollapse(context, false)) {
                            this.hideTaskbar(true);
                        }
                    }
                    return true;
                });
            }
        }
        return navbarButtonsEnabled;
    }

    @VisibleForTesting
    public long getSearchInterval(SharedPreferences pref) {
        long searchInterval = -1L;
        switch (pref.getString("recents_amount", "past_day")) {
            case "past_day": {
                searchInterval = System.currentTimeMillis() - 86400000L;
                break;
            }
            case "app_start": {
                long appStartTime = pref.getLong("time_of_service_start", System.currentTimeMillis());
                long deviceStartTime = System.currentTimeMillis() - SystemClock.elapsedRealtime();
                searchInterval = Math.max(deviceStartTime, appStartTime);
                break;
            }
            case "show_all": {
                searchInterval = 0L;
            }
        }
        return searchInterval;
    }

    @VisibleForTesting
    public void drawSysTray(Context context, int layoutId, LinearLayout layout2) {
        this.sysTrayLayout = (LinearLayout)LayoutInflater.from((Context)context).inflate(R.layout.tb_system_tray, null);
        FrameLayout.LayoutParams sysTrayParams = new FrameLayout.LayoutParams(-2, context.getResources().getDimensionPixelSize(R.dimen.tb_icon_size));
        if (layoutId == R.layout.tb_taskbar_right) {
            this.time = (TextView)this.sysTrayLayout.findViewById(R.id.time_left);
            sysTrayParams.gravity = 0x800003;
        } else {
            this.time = (TextView)this.sysTrayLayout.findViewById(R.id.time_right);
            sysTrayParams.gravity = 0x800005;
        }
        this.time.setVisibility(0);
        this.sysTrayLayout.setLayoutParams((ViewGroup.LayoutParams)sysTrayParams);
        if (!U.isLibrary(context)) {
            this.sysTrayLayout.setOnClickListener(v -> {
                U.sendAccessibilityAction(context, 4, () -> {
                    if (LauncherHelper.getInstance().isOnSecondaryHomeScreen(context)) {
                        U.showToast(context, R.string.tb_opening_notification_tray);
                        U.sendBroadcast(context, "com.farmerbb.taskbar.ACTION_UNDIM_SCREEN");
                    }
                });
                if (U.shouldCollapse(context, false)) {
                    this.hideTaskbar(true);
                }
            });
            if (Build.VERSION.SDK_INT >= 24) {
                this.sysTrayLayout.setOnLongClickListener(v -> {
                    U.sendAccessibilityAction(context, 5, () -> {
                        if (LauncherHelper.getInstance().isOnSecondaryHomeScreen(context)) {
                            U.showToast(context, R.string.tb_opening_quick_settings);
                            U.sendBroadcast(context, "com.farmerbb.taskbar.ACTION_UNDIM_SCREEN");
                        }
                    });
                    if (U.shouldCollapse(context, false)) {
                        this.hideTaskbar(true);
                    }
                    return true;
                });
                this.sysTrayLayout.setOnGenericMotionListener((view, motionEvent) -> {
                    if (motionEvent.getAction() == 11 && motionEvent.getButtonState() == 2) {
                        U.sendAccessibilityAction(context, 5, () -> {
                            if (LauncherHelper.getInstance().isOnSecondaryHomeScreen(context)) {
                                U.showToast(context, R.string.tb_opening_quick_settings);
                                U.sendBroadcast(context, "com.farmerbb.taskbar.ACTION_UNDIM_SCREEN");
                            }
                        });
                        if (U.shouldCollapse(context, false)) {
                            this.hideTaskbar(true);
                        }
                    }
                    return true;
                });
            }
        }
        this.notificationCountCircle = (ImageView)this.sysTrayLayout.findViewById(R.id.notification_count_circle);
        this.notificationCountText = (TextView)this.sysTrayLayout.findViewById(R.id.notification_count_text);
        this.sysTrayParentLayout = (FrameLayout)layout2.findViewById(R.id.add_systray_here);
        this.sysTrayParentLayout.setVisibility(0);
        this.sysTrayParentLayout.addView((View)this.sysTrayLayout);
    }

    private void startRefreshingRecents() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.stopThread2 = true;
        SharedPreferences pref = U.getSharedPreferences(this.context);
        this.showHideAutomagically = pref.getBoolean("hide_when_keyboard_shown", false);
        this.currentTaskbarIds.clear();
        this.handler = new Handler();
        this.thread = new Thread(() -> {
            this.updateRecentApps(true);
            if (!this.isRefreshingRecents) {
                this.isRefreshingRecents = true;
                while (this.shouldRefreshRecents) {
                    this.updateSystemTray();
                    this.updateRecentApps(false);
                    if (this.showHideAutomagically && !this.positionIsVertical && !MenuHelper.getInstance().isStartMenuOpen()) {
                        this.handler.post(() -> {
                            if (this.layout != null) {
                                int[] location = new int[2];
                                this.layout.getLocationOnScreen(location);
                                if (location[1] != 0) {
                                    if (location[1] > this.currentTaskbarPosition) {
                                        this.currentTaskbarPosition = location[1];
                                    } else if (location[1] < this.currentTaskbarPosition) {
                                        if (this.currentTaskbarPosition - location[1] == this.getNavBarSize()) {
                                            this.currentTaskbarPosition = location[1];
                                        } else if (!this.startThread2) {
                                            this.startThread2 = true;
                                            this.tempHideTaskbar(true);
                                        }
                                    }
                                }
                            }
                        });
                    }
                    SystemClock.sleep((long)this.refreshInterval);
                }
                this.isRefreshingRecents = false;
            }
        });
        this.thread.start();
    }

    @TargetApi(value=22)
    private void updateRecentApps(boolean firstRefresh) {
        ArrayList usageStatsList;
        if (this.isScreenOff()) {
            return;
        }
        SharedPreferences pref = U.getSharedPreferences(this.context);
        PackageManager pm = this.context.getPackageManager();
        ArrayList<AppEntry> entries = new ArrayList<AppEntry>();
        ArrayList launcherAppCache = new ArrayList();
        int maxNumOfEntries = firstRefresh ? 0 : U.getMaxNumOfEntries(this.context);
        int realNumOfPinnedApps = 0;
        boolean fullLength = pref.getBoolean("full_length", true);
        PinnedBlockedApps pba = PinnedBlockedApps.getInstance(this.context);
        List<AppEntry> pinnedApps = pba.getPinnedApps();
        List<AppEntry> blockedApps = pba.getBlockedApps();
        ArrayList<String> applicationIdsToRemove = new ArrayList<String>();
        if (pinnedApps.size() > 0) {
            UserManager userManager = (UserManager)this.context.getSystemService("user");
            LauncherApps launcherApps = (LauncherApps)this.context.getSystemService("launcherapps");
            for (AppEntry entry : pinnedApps) {
                boolean packageEnabled = launcherApps.isPackageEnabled(entry.getPackageName(), userManager.getUserForSerialNumber(entry.getUserId(this.context)));
                if (packageEnabled) {
                    entries.add(entry);
                } else {
                    --realNumOfPinnedApps;
                }
                applicationIdsToRemove.add(entry.getPackageName());
            }
            realNumOfPinnedApps += pinnedApps.size();
        }
        if (blockedApps.size() > 0) {
            for (AppEntry entry : blockedApps) {
                applicationIdsToRemove.add(entry.getPackageName());
            }
        }
        ArrayList arrayList = usageStatsList = realNumOfPinnedApps < maxNumOfEntries ? this.getAppEntries() : new ArrayList();
        if (usageStatsList.size() > 0 || realNumOfPinnedApps > 0 || fullLength) {
            if (realNumOfPinnedApps < maxNumOfEntries) {
                ArrayList<AppEntry> usageStatsList2 = new ArrayList<AppEntry>();
                ArrayList<AppEntry> usageStatsList3 = new ArrayList<AppEntry>();
                ArrayList usageStatsList4 = new ArrayList();
                ArrayList<AppEntry> usageStatsList5 = new ArrayList<AppEntry>();
                Intent homeIntent = new Intent("android.intent.action.MAIN");
                homeIntent.addCategory("android.intent.category.HOME");
                ResolveInfo defaultLauncher = pm.resolveActivity(homeIntent, 65536);
                for (AppEntry appEntry : usageStatsList) {
                    if (!this.hasLauncherIntent(appEntry.getPackageName()) || appEntry.getPackageName().contains("com.farmerbb.taskbar") || appEntry.getPackageName().equals(defaultLauncher.activityInfo.packageName) || U.launcherIsDefault(this.context) && pref.getBoolean("desktop_mode", false) && appEntry.getPackageName().equals(pref.getString("hsl_id", "null"))) continue;
                    usageStatsList2.add(appEntry);
                }
                for (AppEntry appEntry : usageStatsList2) {
                    if (appEntry.getLastTimeUsed() <= this.searchInterval && !this.runningAppsOnly) continue;
                    usageStatsList3.add(appEntry);
                }
                if (!this.runningAppsOnly && this.sortOrder.contains("most_used")) {
                    Collections.sort(usageStatsList3, (us1, us2) -> Long.compare(us2.getTotalTimeInForeground(), us1.getTotalTimeInForeground()));
                } else {
                    Collections.sort(usageStatsList3, (us1, us2) -> Long.compare(us2.getLastTimeUsed(), us1.getLastTimeUsed()));
                }
                ArrayList<String> applicationIds = new ArrayList<String>();
                for (AppEntry stats3 : usageStatsList3) {
                    if (applicationIds.contains(stats3.getPackageName())) continue;
                    usageStatsList4.add(stats3);
                    applicationIds.add(stats3.getPackageName());
                }
                this.filterForegroundApp(this.context, pref, this.searchInterval, applicationIdsToRemove);
                Iterator iterator = usageStatsList4.iterator();
                while (iterator.hasNext()) {
                    AppEntry stats = (AppEntry)iterator.next();
                    if (applicationIdsToRemove.contains(stats.getPackageName())) continue;
                    usageStatsList5.add(stats);
                }
                List<AppEntry> usageStatsList6 = usageStatsList5.size() > maxNumOfEntries ? usageStatsList5.subList(0, maxNumOfEntries) : usageStatsList5;
                if (this.needToReverseOrder(this.context, this.sortOrder)) {
                    Collections.reverse(usageStatsList6);
                }
                int n = usageStatsList6.size() == maxNumOfEntries ? usageStatsList6.size() - realNumOfPinnedApps : usageStatsList6.size();
                UserManager userManager = (UserManager)this.context.getSystemService("user");
                LauncherApps launcherApps = (LauncherApps)this.context.getSystemService("launcherapps");
                List userHandles = userManager.getUserProfiles();
                block8: for (int i = 0; i < n; ++i) {
                    for (UserHandle handle : userHandles) {
                        String packageName = ((AppEntry)usageStatsList6.get(i)).getPackageName();
                        long lastTimeUsed = ((AppEntry)usageStatsList6.get(i)).getLastTimeUsed();
                        List list = launcherApps.getActivityList(packageName, handle);
                        if (list.isEmpty()) continue;
                        if (!packageName.equals("com.google.android.googlequicksearchbox")) {
                            launcherAppCache.add(list.get(0));
                        } else {
                            boolean added = false;
                            for (LauncherActivityInfo info : list) {
                                if (!info.getName().equals("com.google.android.googlequicksearchbox.SearchActivity")) continue;
                                launcherAppCache.add(info);
                                added = true;
                            }
                            if (!added) {
                                launcherAppCache.add(list.get(0));
                            }
                        }
                        AppEntry newEntry = new AppEntry(packageName, null, null, null, false);
                        newEntry.setUserId(userManager.getSerialNumberForUser(handle));
                        newEntry.setLastTimeUsed(lastTimeUsed);
                        entries.add(newEntry);
                        continue block8;
                    }
                }
            }
            while (entries.size() > maxNumOfEntries) {
                try {
                    entries.remove(entries.size() - 1);
                    launcherAppCache.remove(launcherAppCache.size() - 1);
                }
                catch (ArrayIndexOutOfBoundsException usageStatsList2) {}
            }
            if (TaskbarPosition.isVertical(this.context)) {
                Collections.reverse(entries);
                Collections.reverse(launcherAppCache);
            }
            boolean shouldRedrawTaskbar = firstRefresh;
            ArrayList<String> finalApplicationIds = new ArrayList<String>();
            for (AppEntry entry : entries) {
                finalApplicationIds.add(entry.getPackageName());
            }
            if (finalApplicationIds.size() != this.currentTaskbarIds.size() || this.numOfPinnedApps != realNumOfPinnedApps) {
                shouldRedrawTaskbar = true;
            } else {
                for (int i = 0; i < finalApplicationIds.size(); ++i) {
                    if (((String)finalApplicationIds.get(i)).equals(this.currentTaskbarIds.get(i))) continue;
                    shouldRedrawTaskbar = true;
                    break;
                }
            }
            if (shouldRedrawTaskbar) {
                this.currentTaskbarIds = finalApplicationIds;
                this.numOfPinnedApps = realNumOfPinnedApps;
                UserManager userManager = (UserManager)this.context.getSystemService("user");
                int launcherAppCachePos = -1;
                for (int i = 0; i < entries.size(); ++i) {
                    if (((AppEntry)entries.get(i)).getComponentName() != null) continue;
                    LauncherActivityInfo appInfo = (LauncherActivityInfo)launcherAppCache.get(++launcherAppCachePos);
                    String packageName = ((AppEntry)entries.get(i)).getPackageName();
                    long lastTimeUsed = ((AppEntry)entries.get(i)).getLastTimeUsed();
                    entries.remove(i);
                    AppEntry newEntry = new AppEntry(packageName, appInfo.getComponentName().flattenToString(), appInfo.getLabel().toString(), (Drawable)IconCache.getInstance(this.context).getIcon(this.context, pm, appInfo), false);
                    newEntry.setUserId(userManager.getSerialNumberForUser(appInfo.getUser()));
                    newEntry.setLastTimeUsed(lastTimeUsed);
                    entries.add(i, newEntry);
                }
                int numOfEntries = Math.min(entries.size(), maxNumOfEntries);
                this.handler.post(() -> {
                    if (numOfEntries > 0 || fullLength) {
                        ViewGroup.LayoutParams params = this.scrollView.getLayoutParams();
                        this.calculateScrollViewParams(this.context, pref, params, fullLength, numOfEntries);
                        this.scrollView.setLayoutParams(params);
                        this.taskbar.removeAllViews();
                        for (int i = 0; i < entries.size(); ++i) {
                            this.taskbar.addView(this.getView(entries, i));
                        }
                        if (this.runningAppsOnly) {
                            this.updateRunningAppIndicators(pinnedApps, usageStatsList, entries);
                        }
                        this.isShowingRecents = true;
                        if (this.shouldRefreshRecents && this.scrollView.getVisibility() != 0) {
                            if (firstRefresh) {
                                this.scrollView.setVisibility(4);
                            } else {
                                this.scrollView.setVisibility(0);
                            }
                        }
                        if (firstRefresh && this.scrollView.getVisibility() != 0) {
                            new Handler().post(() -> this.scrollTaskbar(this.scrollView, this.taskbar, TaskbarPosition.getTaskbarPosition(this.context), this.sortOrder, this.shouldRefreshRecents));
                        }
                    } else {
                        this.isShowingRecents = false;
                        this.scrollView.setVisibility(8);
                    }
                });
            } else if (this.runningAppsOnly) {
                this.handler.post(() -> this.updateRunningAppIndicators(pinnedApps, usageStatsList, entries));
            }
        } else if (firstRefresh || this.currentTaskbarIds.size() > 0) {
            this.currentTaskbarIds.clear();
            this.handler.post(() -> {
                this.isShowingRecents = false;
                this.scrollView.setVisibility(8);
            });
        }
    }

    @VisibleForTesting
    public void calculateScrollViewParams(Context context, SharedPreferences pref, ViewGroup.LayoutParams params, boolean fullLength, int numOfEntries) {
        block14: {
            float maxRecentsSize;
            DisplayInfo display = U.getDisplayInfo(context, true);
            int recentsSize = context.getResources().getDimensionPixelSize(R.dimen.tb_icon_size) * numOfEntries;
            float f = maxRecentsSize = fullLength ? Float.MAX_VALUE : (float)recentsSize;
            if (TaskbarPosition.isVertical(context)) {
                int maxScreenSize = Math.max(0, display.height - U.getStatusBarHeight(context) - U.getBaseTaskbarSize(context));
                params.height = (int)Math.min(maxRecentsSize, (float)maxScreenSize) + context.getResources().getDimensionPixelSize(R.dimen.tb_divider_size);
                if (fullLength) {
                    try {
                        Space whitespaceTop = (Space)this.layout.findViewById(R.id.whitespace_top);
                        Space whitespaceBottom = (Space)this.layout.findViewById(R.id.whitespace_bottom);
                        int height = maxScreenSize - recentsSize;
                        if (pref.getBoolean("centered_icons", false)) {
                            ViewGroup.LayoutParams topParams = whitespaceTop.getLayoutParams();
                            topParams.height = height / 2;
                            whitespaceTop.setLayoutParams(topParams);
                            ViewGroup.LayoutParams bottomParams = whitespaceBottom.getLayoutParams();
                            bottomParams.height = height / 2;
                            whitespaceBottom.setLayoutParams(bottomParams);
                            break block14;
                        }
                        if (TaskbarPosition.isBottom(context)) {
                            ViewGroup.LayoutParams topParams = whitespaceTop.getLayoutParams();
                            topParams.height = height;
                            whitespaceTop.setLayoutParams(topParams);
                            break block14;
                        }
                        ViewGroup.LayoutParams bottomParams = whitespaceBottom.getLayoutParams();
                        bottomParams.height = height;
                        whitespaceBottom.setLayoutParams(bottomParams);
                    }
                    catch (NullPointerException whitespaceTop) {}
                }
            } else {
                int maxScreenSize = Math.max(0, display.width - U.getBaseTaskbarSize(context));
                params.width = (int)Math.min(maxRecentsSize, (float)maxScreenSize) + context.getResources().getDimensionPixelSize(R.dimen.tb_divider_size);
                if (fullLength) {
                    try {
                        Space whitespaceLeft = (Space)this.layout.findViewById(R.id.whitespace_left);
                        Space whitespaceRight = (Space)this.layout.findViewById(R.id.whitespace_right);
                        int width = maxScreenSize - recentsSize;
                        if (pref.getBoolean("centered_icons", false)) {
                            ViewGroup.LayoutParams leftParams = whitespaceLeft.getLayoutParams();
                            leftParams.width = width / 2;
                            whitespaceLeft.setLayoutParams(leftParams);
                            ViewGroup.LayoutParams rightParams = whitespaceRight.getLayoutParams();
                            rightParams.width = width / 2;
                            whitespaceRight.setLayoutParams(rightParams);
                        } else if (TaskbarPosition.isRight(context)) {
                            ViewGroup.LayoutParams leftParams = whitespaceLeft.getLayoutParams();
                            leftParams.width = width;
                            whitespaceLeft.setLayoutParams(leftParams);
                        } else {
                            ViewGroup.LayoutParams rightParams = whitespaceRight.getLayoutParams();
                            rightParams.width = width;
                            whitespaceRight.setLayoutParams(rightParams);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @VisibleForTesting
    public void scrollTaskbar(FrameLayout scrollView, LinearLayout taskbar, String taskbarPosition, String sortOrder, boolean shouldRefreshRecents) {
        if (TaskbarPosition.isVertical(taskbarPosition)) {
            if (sortOrder.contains("false")) {
                scrollView.scrollTo(taskbar.getWidth(), taskbar.getHeight());
            } else if (sortOrder.contains("true")) {
                scrollView.scrollTo(0, 0);
            }
        } else if (sortOrder.contains("false")) {
            scrollView.scrollTo(0, 0);
        } else if (sortOrder.contains("true")) {
            scrollView.scrollTo(taskbar.getWidth(), taskbar.getHeight());
        }
        if (shouldRefreshRecents) {
            scrollView.setVisibility(0);
        }
    }

    @VisibleForTesting
    public void filterForegroundApp(Context context, SharedPreferences pref, long searchInterval, List<String> applicationIdsToRemove) {
        if (pref.getBoolean("hide_foreground", false)) {
            UsageStatsManager mUsageStatsManager = (UsageStatsManager)context.getSystemService("usagestats");
            UsageEvents events = mUsageStatsManager.queryEvents(searchInterval, System.currentTimeMillis());
            UsageEvents.Event eventCache = new UsageEvents.Event();
            String currentForegroundApp = null;
            while (events.hasNextEvent()) {
                events.getNextEvent(eventCache);
                if (eventCache.getEventType() != 1 || eventCache.getPackageName().contains("com.farmerbb.taskbar") && !eventCache.getClassName().equals(MainActivity.class.getCanonicalName()) && !eventCache.getClassName().equals(HomeActivity.class.getCanonicalName()) && !eventCache.getClassName().equals(HomeActivityDelegate.class.getCanonicalName()) && !eventCache.getClassName().equals(SecondaryHomeActivity.class.getCanonicalName()) && !eventCache.getClassName().equals(InvisibleActivityFreeform.class.getCanonicalName())) continue;
                currentForegroundApp = eventCache.getPackageName();
            }
            if (!applicationIdsToRemove.contains(currentForegroundApp)) {
                applicationIdsToRemove.add(currentForegroundApp);
            }
        }
    }

    @VisibleForTesting
    public boolean needToReverseOrder(Context context, String sortOrder) {
        switch (TaskbarPosition.getTaskbarPosition(context)) {
            case "bottom_right": 
            case "top_right": {
                return sortOrder.contains("false");
            }
        }
        return sortOrder.contains("true");
    }

    private void updateRunningAppIndicators(List<AppEntry> pinnedApps, List<AppEntry> usageStatsList, List<AppEntry> entries) {
        if (this.taskbar.getChildCount() != entries.size()) {
            return;
        }
        ArrayList<String> pinnedPackageList = new ArrayList<String>();
        ArrayList<String> runningPackageList = new ArrayList<String>();
        for (AppEntry entry : pinnedApps) {
            pinnedPackageList.add(entry.getPackageName());
        }
        for (AppEntry entry : usageStatsList) {
            runningPackageList.add(entry.getPackageName());
        }
        for (int i = 0; i < this.taskbar.getChildCount(); ++i) {
            View convertView = this.taskbar.getChildAt(i);
            String packageName = entries.get(i).getPackageName();
            ImageView runningAppIndicator = (ImageView)convertView.findViewById(R.id.running_app_indicator);
            if (pinnedPackageList.contains(packageName) && !runningPackageList.contains(packageName)) {
                runningAppIndicator.setVisibility(8);
                continue;
            }
            runningAppIndicator.setVisibility(0);
            runningAppIndicator.setColorFilter(U.getAccentColor(this.context));
        }
    }

    private void toggleTaskbar(boolean userInitiated) {
        if (userInitiated && Build.BRAND.equalsIgnoreCase("essential")) {
            SharedPreferences pref = U.getSharedPreferences(this.context);
            LauncherHelper helper = LauncherHelper.getInstance();
            if (!pref.getBoolean("grip_rejection_toast_shown", false) && !helper.isOnSecondaryHomeScreen(this.context)) {
                U.showToastLong(this.context, R.string.tb_essential_phone_grip_rejection);
                pref.edit().putBoolean("grip_rejection_toast_shown", true).apply();
            }
        }
        if (this.startButton.getVisibility() == 8) {
            this.showTaskbar(true);
        } else {
            this.hideTaskbar(true);
        }
    }

    private void showTaskbar(boolean clearVariables) {
        if (clearVariables) {
            this.taskbarShownTemporarily = false;
            this.taskbarHiddenTemporarily = false;
        }
        if (this.startButton.getVisibility() == 8) {
            this.startButton.setVisibility(0);
            this.space.setVisibility(0);
            if (this.dashboardEnabled) {
                this.dashboardButton.setVisibility(0);
            }
            if (this.navbarButtonsEnabled) {
                this.navbarButtons.setVisibility(0);
            }
            if (this.isShowingRecents && this.scrollView.getVisibility() == 8) {
                this.scrollView.setVisibility(4);
            }
            if (this.sysTrayEnabled) {
                this.sysTrayParentLayout.setVisibility(0);
            }
            this.shouldRefreshRecents = true;
            this.startRefreshingRecents();
            SharedPreferences pref = U.getSharedPreferences(this.context);
            pref.edit().putBoolean("collapsed", true).apply();
            this.updateButton(false);
            new Handler().post(() -> U.sendBroadcast(this.context, "com.farmerbb.taskbar.SHOW_START_MENU_SPACE"));
        }
    }

    private void hideTaskbar(boolean clearVariables) {
        if (clearVariables) {
            this.taskbarShownTemporarily = false;
            this.taskbarHiddenTemporarily = false;
        }
        if (this.startButton.getVisibility() == 0) {
            this.startButton.setVisibility(8);
            this.space.setVisibility(8);
            if (this.dashboardEnabled) {
                this.dashboardButton.setVisibility(8);
            }
            if (this.navbarButtonsEnabled) {
                this.navbarButtons.setVisibility(8);
            }
            if (this.isShowingRecents) {
                this.scrollView.setVisibility(8);
            }
            if (this.sysTrayEnabled) {
                this.sysTrayParentLayout.setVisibility(8);
            }
            this.shouldRefreshRecents = false;
            if (this.thread != null) {
                this.thread.interrupt();
            }
            SharedPreferences pref = U.getSharedPreferences(this.context);
            pref.edit().putBoolean("collapsed", false).apply();
            this.updateButton(true);
            if (clearVariables) {
                U.sendBroadcast(this.context, "com.farmerbb.taskbar.HIDE_START_MENU");
                U.sendBroadcast(this.context, "com.farmerbb.taskbar.HIDE_DASHBOARD");
            }
            new Handler().post(() -> U.sendBroadcast(this.context, "com.farmerbb.taskbar.HIDE_START_MENU_SPACE"));
        }
    }

    private void tempShowTaskbar() {
        SharedPreferences pref;
        if (!this.taskbarHiddenTemporarily && !(pref = U.getSharedPreferences(this.context)).getBoolean("collapsed", false)) {
            this.taskbarShownTemporarily = true;
        }
        this.showTaskbar(false);
        if (this.taskbarHiddenTemporarily) {
            this.taskbarHiddenTemporarily = false;
        }
    }

    private void tempHideTaskbar(boolean monitorPositionChanges) {
        SharedPreferences pref;
        if (!this.taskbarShownTemporarily && (pref = U.getSharedPreferences(this.context)).getBoolean("collapsed", false)) {
            this.taskbarHiddenTemporarily = true;
        }
        this.hideTaskbar(false);
        if (this.taskbarShownTemporarily) {
            this.taskbarShownTemporarily = false;
        }
        if (monitorPositionChanges && this.showHideAutomagically && !this.positionIsVertical) {
            if (this.thread2 != null) {
                this.thread2.interrupt();
            }
            this.handler2 = new Handler();
            this.thread2 = new Thread(() -> {
                this.stopThread2 = false;
                while (!this.stopThread2) {
                    SystemClock.sleep((long)this.refreshInterval);
                    this.handler2.post(() -> {
                        this.stopThread2 = this.checkPositionChange();
                    });
                }
                this.startThread2 = false;
            });
            this.thread2.start();
        }
    }

    private boolean checkPositionChange() {
        if (!this.isScreenOff() && this.layout != null) {
            int[] location = new int[2];
            this.layout.getLocationOnScreen(location);
            if (location[1] == 0) {
                return true;
            }
            if (location[1] > this.currentTaskbarPosition) {
                this.currentTaskbarPosition = location[1];
                if (this.taskbarHiddenTemporarily) {
                    this.tempShowTaskbar();
                    return true;
                }
            } else {
                if (location[1] == this.currentTaskbarPosition && this.taskbarHiddenTemporarily) {
                    this.tempShowTaskbar();
                    return true;
                }
                if (location[1] < this.currentTaskbarPosition && this.currentTaskbarPosition - location[1] == this.getNavBarSize()) {
                    this.currentTaskbarPosition = location[1];
                }
            }
        }
        return false;
    }

    private int getNavBarSize() {
        Point size = new Point();
        Point realSize = new Point();
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        display.getSize(size);
        display.getRealSize(realSize);
        return realSize.y - size.y;
    }

    @Override
    public void onDestroyHost(UIHost host) {
        SharedPreferences pref;
        this.shouldRefreshRecents = false;
        if (this.layout != null) {
            try {
                host.removeView((View)this.layout);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((pref = U.getSharedPreferences(this.context)).getBoolean("skip_auto_hide_navbar", false)) {
            pref.edit().remove("skip_auto_hide_navbar").apply();
        } else if (pref.getBoolean("auto_hide_navbar", false)) {
            U.showHideNavigationBar(this.context, true);
        }
        U.unregisterReceiver(this.context, this.showReceiver);
        U.unregisterReceiver(this.context, this.hideReceiver);
        U.unregisterReceiver(this.context, this.tempShowReceiver);
        U.unregisterReceiver(this.context, this.tempHideReceiver);
        U.unregisterReceiver(this.context, this.startMenuAppearReceiver);
        U.unregisterReceiver(this.context, this.startMenuDisappearReceiver);
        if (this.sysTrayEnabled) {
            TelephonyManager manager = (TelephonyManager)this.context.getSystemService("phone");
            manager.listen(this.listener, 0);
            U.unregisterReceiver(this.context, this.notificationCountReceiver);
        }
        this.isFirstStart = true;
    }

    private void openContextMenu() {
        SharedPreferences pref = U.getSharedPreferences(this.context);
        Bundle args = new Bundle();
        args.putBoolean("dont_show_quit", LauncherHelper.getInstance().isOnHomeScreen(this.context) && !pref.getBoolean("taskbar_active", false));
        args.putBoolean("is_start_button", true);
        U.startContextMenuActivity(this.context, args);
    }

    private void updateButton(boolean isCollapsed) {
        SharedPreferences pref = U.getSharedPreferences(this.context);
        boolean hide = pref.getBoolean("invisible_button", false);
        if (this.button != null) {
            this.button.setText((CharSequence)this.context.getString(isCollapsed ? R.string.tb_right_arrow : R.string.tb_left_arrow));
        }
        if (this.layout != null) {
            this.layout.setAlpha(isCollapsed && hide ? 0.0f : 1.0f);
        }
    }

    @Override
    @TargetApi(value=23)
    public void onRecreateHost(UIHost host) {
        if (this.layout != null) {
            try {
                host.removeView((View)this.layout);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.currentTaskbarPosition = 0;
            if (U.canDrawOverlays(this.context)) {
                this.drawTaskbar(host);
            } else {
                SharedPreferences pref = U.getSharedPreferences(this.context);
                pref.edit().putBoolean("taskbar_active", false).apply();
                host.terminate();
            }
        }
    }

    private View getView(List<AppEntry> list, int position) {
        View convertView = View.inflate((Context)this.context, (int)R.layout.tb_icon, null);
        AppEntry entry = list.get(position);
        SharedPreferences pref = U.getSharedPreferences(this.context);
        ImageView imageView = (ImageView)convertView.findViewById(R.id.icon);
        ImageView imageView2 = (ImageView)convertView.findViewById(R.id.shortcut_icon);
        imageView.setImageDrawable(entry.getIcon(this.context));
        imageView2.setBackgroundColor(U.getAccentColor(this.context));
        String taskbarPosition = TaskbarPosition.getTaskbarPosition(this.context);
        if (pref.getBoolean("shortcut_icon", true)) {
            boolean shouldShowShortcutIcon;
            if (taskbarPosition.contains("vertical")) {
                shouldShowShortcutIcon = position >= list.size() - this.numOfPinnedApps;
            } else {
                boolean bl = shouldShowShortcutIcon = position < this.numOfPinnedApps;
            }
            if (shouldShowShortcutIcon) {
                imageView2.setVisibility(0);
            }
        }
        if ("bottom_right".equals(taskbarPosition) || "top_right".equals(taskbarPosition)) {
            imageView.setRotationY(180.0f);
            imageView2.setRotationY(180.0f);
        }
        FrameLayout layout2 = (FrameLayout)convertView.findViewById(R.id.entry);
        layout2.setOnClickListener(view -> U.launchApp(this.context, entry, null, true, false, view));
        layout2.setOnLongClickListener(view -> {
            int[] location = new int[2];
            view.getLocationOnScreen(location);
            this.openContextMenu(entry, location);
            return true;
        });
        layout2.setOnGenericMotionListener((view, motionEvent) -> {
            int action = motionEvent.getAction();
            if (action == 11 && motionEvent.getButtonState() == 2) {
                int[] location = new int[2];
                view.getLocationOnScreen(location);
                this.openContextMenu(entry, location);
            }
            if (action == 8 && pref.getBoolean("visual_feedback", true)) {
                view.setBackgroundColor(0);
            }
            return false;
        });
        if (pref.getBoolean("visual_feedback", true)) {
            layout2.setOnHoverListener((v, event) -> {
                if (event.getAction() == 9) {
                    int accentColor = U.getAccentColor(this.context);
                    accentColor = ColorUtils.setAlphaComponent((int)accentColor, (int)(Color.alpha((int)accentColor) / 2));
                    v.setBackgroundColor(accentColor);
                }
                if (event.getAction() == 10) {
                    v.setBackgroundColor(0);
                }
                if (Build.VERSION.SDK_INT >= 24) {
                    v.setPointerIcon(PointerIcon.getSystemIcon((Context)this.context, (int)1000));
                }
                return false;
            });
            layout2.setOnTouchListener((v, event) -> {
                v.setAlpha(event.getAction() == 0 || event.getAction() == 2 ? 0.5f : 1.0f);
                return false;
            });
        }
        return convertView;
    }

    private void openContextMenu(AppEntry entry, int[] location) {
        Bundle args = new Bundle();
        args.putSerializable("app_entry", (Serializable)entry);
        args.putInt("x", location[0]);
        args.putInt("y", location[1]);
        U.startContextMenuActivity(this.context, args);
    }

    private List<AppEntry> getAppEntries() {
        SharedPreferences pref = U.getSharedPreferences(this.context);
        if (this.runningAppsOnly) {
            return this.getAppEntriesUsingActivityManager(Integer.parseInt(pref.getString("max_num_of_recents", "10")));
        }
        return this.getAppEntriesUsingUsageStats();
    }

    @TargetApi(value=23)
    private List<AppEntry> getAppEntriesUsingActivityManager(int maxNum) {
        ActivityManager mActivityManager = (ActivityManager)this.context.getSystemService("activity");
        List usageStatsList = mActivityManager.getRecentTasks(maxNum, 0);
        ArrayList<AppEntry> entries = new ArrayList<AppEntry>();
        for (int i = 0; i < usageStatsList.size(); ++i) {
            ActivityManager.RecentTaskInfo recentTaskInfo = (ActivityManager.RecentTaskInfo)usageStatsList.get(i);
            if (recentTaskInfo.id == -1) continue;
            String packageName = recentTaskInfo.baseActivity.getPackageName();
            AppEntry newEntry = new AppEntry(packageName, null, null, null, false);
            U.allowReflection();
            try {
                Field field = ActivityManager.RecentTaskInfo.class.getField("firstActiveTime");
                newEntry.setLastTimeUsed(field.getLong(recentTaskInfo));
            }
            catch (Exception e) {
                newEntry.setLastTimeUsed(i);
            }
            entries.add(newEntry);
        }
        return entries;
    }

    @TargetApi(value=22)
    private List<AppEntry> getAppEntriesUsingUsageStats() {
        UsageStatsManager mUsageStatsManager = (UsageStatsManager)this.context.getSystemService("usagestats");
        List usageStatsList = mUsageStatsManager.queryUsageStats(4, this.searchInterval, System.currentTimeMillis());
        ArrayList<AppEntry> entries = new ArrayList<AppEntry>();
        for (UsageStats usageStats : usageStatsList) {
            AppEntry newEntry = new AppEntry(usageStats.getPackageName(), null, null, null, false);
            newEntry.setTotalTimeInForeground(usageStats.getTotalTimeInForeground());
            newEntry.setLastTimeUsed(usageStats.getLastTimeUsed());
            entries.add(newEntry);
        }
        return entries;
    }

    private boolean hasLauncherIntent(String packageName) {
        Intent intentToResolve = new Intent("android.intent.action.MAIN");
        intentToResolve.addCategory("android.intent.category.LAUNCHER");
        intentToResolve.setPackage(packageName);
        List ris = this.context.getPackageManager().queryIntentActivities(intentToResolve, 0);
        return ris != null && ris.size() > 0;
    }

    private boolean isScreenOff() {
        if (U.isChromeOs(this.context)) {
            return false;
        }
        PowerManager pm = (PowerManager)this.context.getSystemService("power");
        return !pm.isInteractive();
    }

    private void updateSystemTray() {
        if (!this.sysTrayEnabled || this.isScreenOff()) {
            return;
        }
        this.handler.post(() -> {
            ImageView battery = (ImageView)this.sysTrayLayout.findViewById(R.id.battery);
            battery.setImageDrawable(this.getBatteryDrawable());
            ImageView wifi = (ImageView)this.sysTrayLayout.findViewById(R.id.wifi);
            wifi.setImageDrawable(this.getWifiDrawable());
            ImageView bluetooth = (ImageView)this.sysTrayLayout.findViewById(R.id.bluetooth);
            bluetooth.setImageDrawable(this.getBluetoothDrawable());
            ImageView cellular = (ImageView)this.sysTrayLayout.findViewById(R.id.cellular);
            cellular.setImageDrawable(this.getCellularDrawable());
            this.time.setText((CharSequence)this.context.getString(R.string.tb_systray_clock, new Object[]{DateFormat.getTimeFormat((Context)this.context).format(new Date()), DateFormat.getDateFormat((Context)this.context).format(new Date())}));
            this.time.setTextColor(U.getAccentColor(this.context));
        });
    }

    @TargetApi(value=23)
    private Drawable getBatteryDrawable() {
        boolean isCharging;
        BatteryManager bm = (BatteryManager)this.context.getSystemService("batterymanager");
        int batLevel = bm.getIntProperty(4);
        if (batLevel == Integer.MIN_VALUE) {
            return null;
        }
        IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryStatus = this.context.registerReceiver(null, ifilter);
        int status = batteryStatus.getIntExtra("status", -1);
        boolean bl = isCharging = status == 2 || status == 5;
        String batDrawable = batLevel < 10 && !isCharging ? "alert" : (batLevel < 25 ? "20" : (batLevel < 40 ? "30" : (batLevel < 55 ? "50" : (batLevel < 70 ? "60" : (batLevel < 85 ? "80" : (batLevel < 95 ? "90" : "full"))))));
        String charging = isCharging ? "charging_" : "";
        String batRes = "tb_battery_" + charging + batDrawable;
        int id2 = this.getResourceIdFor(batRes);
        return this.getDrawableForSysTray(id2);
    }

    @TargetApi(value=23)
    private Drawable getWifiDrawable() {
        ConnectivityManager manager = (ConnectivityManager)this.context.getSystemService("connectivity");
        NetworkInfo ethernet = manager.getNetworkInfo(9);
        if (ethernet != null && ethernet.isConnected()) {
            return this.getDrawableForSysTray(R.drawable.tb_settings_ethernet);
        }
        NetworkInfo wifi = manager.getNetworkInfo(1);
        if (wifi == null || !wifi.isConnected()) {
            return null;
        }
        WifiManager wifiManager = (WifiManager)this.context.getApplicationContext().getSystemService("wifi");
        int numberOfLevels = 5;
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        int level = WifiManager.calculateSignalLevel((int)wifiInfo.getRssi(), (int)numberOfLevels);
        String wifiRes = "tb_signal_wifi_" + level + "_bar";
        int id2 = this.getResourceIdFor(wifiRes);
        return this.getDrawableForSysTray(id2);
    }

    private Drawable getBluetoothDrawable() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null && adapter.isEnabled()) {
            return this.getDrawableForSysTray(R.drawable.tb_bluetooth);
        }
        return null;
    }

    @TargetApi(value=23)
    private Drawable getCellularDrawable() {
        if (Settings.Global.getInt((ContentResolver)this.context.getContentResolver(), (String)"airplane_mode_on", (int)0) != 0) {
            return this.getDrawableForSysTray(R.drawable.tb_airplanemode_active);
        }
        if (this.cellStrength == -1) {
            return null;
        }
        String cellRes = "tb_signal_cellular_" + this.cellStrength + "_bar";
        int id2 = this.getResourceIdFor(cellRes);
        return this.getDrawableForSysTray(id2);
    }

    private Drawable getDrawableForSysTray(int id2) {
        Drawable drawable2 = null;
        try {
            drawable2 = ContextCompat.getDrawable((Context)this.context, (int)id2);
        }
        catch (Resources.NotFoundException notFoundException) {
            // empty catch block
        }
        if (drawable2 == null) {
            return null;
        }
        drawable2.setTint(U.getAccentColor(this.context));
        return drawable2;
    }

    private int getResourceIdFor(String name) {
        String packageName = this.context.getResources().getResourcePackageName(R.drawable.tb_dummy);
        return this.context.getResources().getIdentifier(name, "drawable", packageName);
    }
}

