/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.ui;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.LauncherActivityInfo;
import android.content.pm.LauncherApps;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.util.Patterns;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.webkit.URLUtil;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.GridView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import androidx.appcompat.widget.SearchView;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.activity.InvisibleActivity;
import com.farmerbb.taskbar.activity.InvisibleActivityAlt;
import com.farmerbb.taskbar.adapter.StartMenuAdapter;
import com.farmerbb.taskbar.helper.FreeformHackHelper;
import com.farmerbb.taskbar.helper.LauncherHelper;
import com.farmerbb.taskbar.helper.MenuHelper;
import com.farmerbb.taskbar.ui.UIController;
import com.farmerbb.taskbar.ui.UIHost;
import com.farmerbb.taskbar.ui.ViewParams;
import com.farmerbb.taskbar.util.AppEntry;
import com.farmerbb.taskbar.util.Blacklist;
import com.farmerbb.taskbar.util.IconCache;
import com.farmerbb.taskbar.util.TaskbarPosition;
import com.farmerbb.taskbar.util.TopApps;
import com.farmerbb.taskbar.util.U;
import com.farmerbb.taskbar.widget.StartMenuLayout;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class StartMenuController
extends UIController {
    private StartMenuLayout layout;
    private GridView startMenu;
    private SearchView searchView;
    private TextView textView;
    private PackageManager pm;
    private StartMenuAdapter adapter;
    private Handler handler;
    private Thread thread;
    private boolean shouldShowSearchBox = false;
    private boolean hasSubmittedQuery = false;
    private boolean hasHardwareKeyboard = false;
    private boolean searchViewClicked = false;
    private int layoutId = R.layout.tb_start_menu_left;
    private List<String> currentStartMenuIds = new ArrayList<String>();
    private View.OnClickListener ocl = view -> this.toggleStartMenu();
    private BroadcastReceiver toggleReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            StartMenuController.this.toggleStartMenu();
        }
    };
    private BroadcastReceiver showSpaceReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            StartMenuController.this.layout.findViewById(R.id.start_menu_space).setVisibility(0);
        }
    };
    private BroadcastReceiver hideSpaceReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            StartMenuController.this.layout.findViewById(R.id.start_menu_space).setVisibility(8);
        }
    };
    private BroadcastReceiver hideReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            StartMenuController.this.hideStartMenu(true);
        }
    };
    private BroadcastReceiver hideReceiverNoReset = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            StartMenuController.this.hideStartMenu(false);
        }
    };
    private BroadcastReceiver resetReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            StartMenuController.this.startMenu.setSelection(0);
        }
    };
    private Comparator<LauncherActivityInfo> comparator = (ai1, ai2) -> {
        String label2;
        String label1;
        try {
            label1 = ai1.getLabel().toString();
            label2 = ai2.getLabel().toString();
        }
        catch (OutOfMemoryError e) {
            System.gc();
            label1 = ai1.getApplicationInfo().packageName;
            label2 = ai2.getApplicationInfo().packageName;
        }
        return Collator.getInstance().compare(label1, label2);
    };

    public StartMenuController(Context context) {
        super(context);
    }

    @Override
    @TargetApi(value=23)
    public void onCreateHost(UIHost host) {
        this.hasHardwareKeyboard = this.context.getResources().getConfiguration().keyboard != 1;
        this.init(this.context, host, () -> this.drawStartMenu(host));
    }

    @SuppressLint(value={"RtlHardcoded"})
    private void drawStartMenu(UIHost host) {
        IconCache.getInstance(this.context).clearCache();
        SharedPreferences pref = U.getSharedPreferences(this.context);
        switch (pref.getString("show_search_bar", "always")) {
            case "always": {
                this.shouldShowSearchBox = true;
                break;
            }
            case "keyboard": {
                this.shouldShowSearchBox = this.hasHardwareKeyboard;
                break;
            }
            case "never": {
                this.shouldShowSearchBox = false;
            }
        }
        WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
        TaskbarPosition.setCachedRotation(windowManager.getDefaultDisplay().getRotation());
        ViewParams params = new ViewParams(-2, -2, -1, this.shouldShowSearchBox ? 0 : 131080);
        switch (TaskbarPosition.getTaskbarPosition(this.context)) {
            case "bottom_left": {
                this.layoutId = R.layout.tb_start_menu_left;
                params.gravity = 83;
                break;
            }
            case "bottom_vertical_left": {
                this.layoutId = R.layout.tb_start_menu_vertical_left;
                params.gravity = 83;
                break;
            }
            case "bottom_right": {
                this.layoutId = R.layout.tb_start_menu_right;
                params.gravity = 85;
                break;
            }
            case "bottom_vertical_right": {
                this.layoutId = R.layout.tb_start_menu_vertical_right;
                params.gravity = 85;
                break;
            }
            case "top_left": {
                this.layoutId = R.layout.tb_start_menu_top_left;
                params.gravity = 51;
                break;
            }
            case "top_vertical_left": {
                this.layoutId = R.layout.tb_start_menu_vertical_left;
                params.gravity = 51;
                break;
            }
            case "top_right": {
                this.layoutId = R.layout.tb_start_menu_top_right;
                params.gravity = 53;
                break;
            }
            case "top_vertical_right": {
                this.layoutId = R.layout.tb_start_menu_vertical_right;
                params.gravity = 53;
            }
        }
        this.layout = (StartMenuLayout)LayoutInflater.from((Context)U.wrapContext(this.context)).inflate(this.layoutId, null);
        this.layout.setAlpha(0.0f);
        this.startMenu = (GridView)this.layout.findViewById(R.id.start_menu);
        if (this.shouldShowSearchBox && !this.hasHardwareKeyboard || Build.VERSION.SDK_INT < 22) {
            this.layout.viewHandlesBackButton();
        }
        boolean scrollbar = pref.getBoolean("scrollbar", false);
        this.startMenu.setFastScrollEnabled(scrollbar);
        this.startMenu.setFastScrollAlwaysVisible(scrollbar);
        this.startMenu.setScrollBarStyle(scrollbar ? 0x3000000 : 0);
        if (pref.getBoolean("transparent_start_menu", false)) {
            this.startMenu.setBackgroundColor(0);
        }
        if (pref.getBoolean("visual_feedback", true)) {
            this.startMenu.setRecyclerListener(view -> view.setBackgroundColor(0));
        }
        int columns = this.context.getResources().getInteger(R.integer.tb_start_menu_columns);
        boolean isGrid = pref.getString("start_menu_layout", "grid").equals("grid");
        if (isGrid) {
            ViewGroup.LayoutParams startMenuParams = this.startMenu.getLayoutParams();
            startMenuParams.width = (int)((float)startMenuParams.width * ((float)columns / 3.0f));
            this.startMenu.setLayoutParams(startMenuParams);
        }
        this.searchView = (SearchView)this.layout.findViewById(R.id.search);
        this.searchViewClicked = false;
        int backgroundTint = U.getBackgroundTint(this.context);
        FrameLayout startMenuFrame = (FrameLayout)this.layout.findViewById(R.id.start_menu_frame);
        FrameLayout searchViewLayout = (FrameLayout)this.layout.findViewById(R.id.search_view_layout);
        startMenuFrame.setBackgroundColor(backgroundTint);
        searchViewLayout.setBackgroundColor(backgroundTint);
        if (this.shouldShowSearchBox) {
            if (!this.hasHardwareKeyboard) {
                this.searchView.setIconifiedByDefault(true);
            }
            this.searchView.setOnTouchListener((v, event) -> {
                this.searchViewClicked = true;
                return false;
            });
            this.searchView.setOnQueryTextListener(new SearchView.OnQueryTextListener(){

                public boolean onQueryTextSubmit(String query) {
                    ListAdapter adapter;
                    if (!StartMenuController.this.hasSubmittedQuery && (adapter = StartMenuController.this.startMenu.getAdapter()) != null) {
                        StartMenuController.this.hasSubmittedQuery = true;
                        if (adapter.getCount() > 0) {
                            View view = adapter.getView(0, null, (ViewGroup)StartMenuController.this.startMenu);
                            LinearLayout layout2 = (LinearLayout)view.findViewById(R.id.entry);
                            layout2.performClick();
                        } else {
                            Intent intent;
                            if (U.shouldCollapse(StartMenuController.this.context, true)) {
                                U.sendBroadcast(StartMenuController.this.context, "com.farmerbb.taskbar.HIDE_TASKBAR");
                            } else {
                                U.sendBroadcast(StartMenuController.this.context, "com.farmerbb.taskbar.HIDE_START_MENU");
                            }
                            if (Patterns.WEB_URL.matcher(query).matches()) {
                                intent = new Intent("android.intent.action.VIEW");
                                intent.setData(Uri.parse((String)URLUtil.guessUrl((String)query)));
                            } else {
                                intent = new Intent("android.intent.action.WEB_SEARCH");
                                intent.putExtra("query", query);
                            }
                            intent.setFlags(0x10000000);
                            if (intent.resolveActivity(StartMenuController.this.context.getPackageManager()) != null) {
                                StartMenuController.this.context.startActivity(intent);
                            } else {
                                Uri uri = new Uri.Builder().scheme("https").authority("www.google.com").path("search").appendQueryParameter("q", query).build();
                                intent = new Intent("android.intent.action.VIEW");
                                intent.setData(uri);
                                intent.setFlags(0x10000000);
                                try {
                                    StartMenuController.this.context.startActivity(intent);
                                }
                                catch (ActivityNotFoundException activityNotFoundException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    return true;
                }

                public boolean onQueryTextChange(String newText) {
                    StartMenuController.this.searchView.setIconified(false);
                    View closeButton = StartMenuController.this.searchView.findViewById(R.id.search_close_btn);
                    if (closeButton != null) {
                        closeButton.setVisibility(8);
                    }
                    StartMenuController.this.refreshApps(newText, false);
                    if (Build.VERSION.SDK_INT < 22) {
                        new Handler().postDelayed(() -> {
                            EditText editText = (EditText)StartMenuController.this.searchView.findViewById(R.id.search_src_text);
                            if (editText != null) {
                                editText.requestFocus();
                                editText.setSelection(editText.getText().length());
                            }
                        }, 50L);
                    }
                    return true;
                }
            });
            this.searchView.setImeOptions(0x10000006);
            LinearLayout powerButton = (LinearLayout)this.layout.findViewById(R.id.power_button);
            powerButton.setOnClickListener(view -> {
                int[] location = new int[2];
                view.getLocationOnScreen(location);
                this.openContextMenu(location);
            });
            powerButton.setOnGenericMotionListener((view, motionEvent) -> {
                if (motionEvent.getAction() == 11 && motionEvent.getButtonState() == 2) {
                    int[] location = new int[2];
                    view.getLocationOnScreen(location);
                    this.openContextMenu(location);
                }
                return false;
            });
            searchViewLayout.setOnClickListener(view -> this.searchView.setIconified(false));
            this.startMenu.setOnItemClickListener((viewParent, view, position, id2) -> {
                this.hideStartMenu(true);
                AppEntry entry = (AppEntry)viewParent.getAdapter().getItem(position);
                U.launchApp(this.context, entry, null, false, false, view);
            });
            View childLayout = this.layout.findViewById(R.id.search_view_child_layout);
            if (pref.getBoolean("transparent_start_menu", false)) {
                childLayout.setBackgroundColor(0);
            }
            if (isGrid) {
                ViewGroup.LayoutParams childLayoutParams = childLayout.getLayoutParams();
                childLayoutParams.width = (int)((float)childLayoutParams.width * ((float)columns / 3.0f));
                childLayout.setLayoutParams(childLayoutParams);
            }
        } else {
            searchViewLayout.setVisibility(8);
        }
        this.textView = (TextView)this.layout.findViewById(R.id.no_apps_found);
        U.registerReceiver(this.context, this.toggleReceiver, "com.farmerbb.taskbar.TOGGLE_START_MENU");
        U.registerReceiver(this.context, this.hideReceiver, "com.farmerbb.taskbar.HIDE_START_MENU");
        U.registerReceiver(this.context, this.hideReceiverNoReset, "com.farmerbb.taskbar.HIDE_START_MENU_NO_RESET");
        U.registerReceiver(this.context, this.showSpaceReceiver, "com.farmerbb.taskbar.SHOW_START_MENU_SPACE");
        U.registerReceiver(this.context, this.hideSpaceReceiver, "com.farmerbb.taskbar.HIDE_START_MENU_SPACE");
        U.registerReceiver(this.context, this.resetReceiver, "com.farmerbb.taskbar.RESET_START_MENU");
        this.handler = new Handler();
        this.refreshApps(true);
        host.addView((View)this.layout, params);
    }

    private void refreshApps(boolean firstDraw) {
        this.refreshApps(null, firstDraw);
    }

    private void refreshApps(String query, boolean firstDraw) {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.handler = new Handler();
        this.thread = new Thread(() -> {
            ArrayList<Object> queryList;
            if (this.pm == null) {
                this.pm = this.context.getPackageManager();
            }
            UserManager userManager = (UserManager)this.context.getSystemService("user");
            LauncherApps launcherApps = (LauncherApps)this.context.getSystemService("launcherapps");
            List userHandles = userManager.getUserProfiles();
            ArrayList unfilteredList = new ArrayList();
            for (UserHandle handle : userHandles) {
                unfilteredList.addAll(launcherApps.getActivityList(null, handle));
            }
            ArrayList<Object> topAppsList = new ArrayList<Object>();
            ArrayList<Object> allAppsList = new ArrayList<Object>();
            ArrayList<Object> list = new ArrayList<Object>();
            TopApps topApps = TopApps.getInstance(this.context);
            for (Object appInfo : unfilteredList) {
                String userSuffix = ":" + userManager.getSerialNumberForUser(appInfo.getUser());
                if (!topApps.isTopApp(appInfo.getComponentName().flattenToString() + userSuffix) && !topApps.isTopApp(appInfo.getComponentName().flattenToString()) && !topApps.isTopApp(appInfo.getName())) continue;
                topAppsList.add(appInfo);
            }
            Blacklist blacklist = Blacklist.getInstance(this.context);
            for (Object appInfo : unfilteredList) {
                String string2 = ":" + userManager.getSerialNumberForUser(appInfo.getUser());
                if (blacklist.isBlocked(appInfo.getComponentName().flattenToString() + string2) || blacklist.isBlocked(appInfo.getComponentName().flattenToString()) || blacklist.isBlocked(appInfo.getName()) || topApps.isTopApp(appInfo.getComponentName().flattenToString() + string2) || topApps.isTopApp(appInfo.getComponentName().flattenToString()) || topApps.isTopApp(appInfo.getName())) continue;
                allAppsList.add(appInfo);
            }
            Collections.sort(topAppsList, this.comparator);
            Collections.sort(allAppsList, this.comparator);
            list.addAll(topAppsList);
            list.addAll(allAppsList);
            topAppsList.clear();
            allAppsList.clear();
            if (query == null) {
                queryList = list;
            } else {
                queryList = new ArrayList();
                for (LauncherActivityInfo launcherActivityInfo : list) {
                    if (!launcherActivityInfo.getLabel().toString().toLowerCase().contains(query.toLowerCase())) continue;
                    queryList.add(launcherActivityInfo);
                }
            }
            boolean shouldRedrawStartMenu = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (query == null && !firstDraw) {
                for (LauncherActivityInfo launcherActivityInfo : queryList) {
                    arrayList.add(launcherActivityInfo.getApplicationInfo().packageName);
                }
                if (arrayList.size() != this.currentStartMenuIds.size()) {
                    shouldRedrawStartMenu = true;
                } else {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        if (((String)arrayList.get(i)).equals(this.currentStartMenuIds.get(i))) continue;
                        shouldRedrawStartMenu = true;
                        break;
                    }
                }
            } else {
                shouldRedrawStartMenu = true;
            }
            if (shouldRedrawStartMenu) {
                if (query == null) {
                    this.currentStartMenuIds = arrayList;
                }
                Drawable defaultIcon = this.pm.getDefaultActivityIcon();
                ArrayList<AppEntry> arrayList2 = new ArrayList<AppEntry>();
                for (LauncherActivityInfo launcherActivityInfo : queryList) {
                    Drawable icon;
                    String label;
                    try {
                        label = launcherActivityInfo.getLabel().toString();
                        icon = IconCache.getInstance(this.context).getIcon(this.context, this.pm, launcherActivityInfo);
                    }
                    catch (OutOfMemoryError e) {
                        System.gc();
                        label = launcherActivityInfo.getApplicationInfo().packageName;
                        icon = defaultIcon;
                    }
                    AppEntry newEntry = new AppEntry(launcherActivityInfo.getApplicationInfo().packageName, new ComponentName(launcherActivityInfo.getApplicationInfo().packageName, launcherActivityInfo.getName()).flattenToString(), label, icon, false);
                    newEntry.setUserId(userManager.getSerialNumberForUser(launcherActivityInfo.getUser()));
                    arrayList2.add(newEntry);
                }
                this.handler.post(() -> {
                    String queryText = this.searchView.getQuery().toString();
                    if (query == null && queryText.length() == 0 || query != null && query.equals(queryText)) {
                        if (firstDraw) {
                            SharedPreferences pref = U.getSharedPreferences(this.context);
                            if (pref.getString("start_menu_layout", "grid").equals("grid")) {
                                this.startMenu.setNumColumns(this.context.getResources().getInteger(R.integer.tb_start_menu_columns));
                                this.adapter = new StartMenuAdapter(this.context, R.layout.tb_row_alt, entries);
                            } else {
                                this.adapter = new StartMenuAdapter(this.context, R.layout.tb_row, entries);
                            }
                            this.startMenu.setAdapter((ListAdapter)this.adapter);
                        }
                        int position = this.startMenu.getFirstVisiblePosition();
                        if (!firstDraw && this.adapter != null) {
                            this.adapter.updateList(entries);
                        }
                        this.startMenu.setSelection(position);
                        if (this.adapter != null && this.adapter.getCount() > 0) {
                            this.textView.setText(null);
                        } else if (query != null) {
                            this.textView.setText((CharSequence)this.context.getString(Patterns.WEB_URL.matcher(query).matches() ? R.string.tb_press_enter_alt : R.string.tb_press_enter));
                        } else {
                            this.textView.setText((CharSequence)this.context.getString(R.string.tb_nothing_to_see_here));
                        }
                    }
                });
            }
        });
        this.thread.start();
    }

    private void toggleStartMenu() {
        if (this.layout.getVisibility() == 8) {
            this.showStartMenu();
        } else {
            this.hideStartMenu(true);
        }
    }

    @TargetApi(value=24)
    private void showStartMenu() {
        if (this.layout.getVisibility() == 8) {
            this.layout.setOnClickListener(this.ocl);
            this.layout.setVisibility(0);
            if (Build.VERSION.SDK_INT <= 25 && !this.hasHardwareKeyboard) {
                this.layout.setAlpha(1.0f);
            }
            MenuHelper.getInstance().setStartMenuOpen(true);
            U.sendBroadcast(this.context, "com.farmerbb.taskbar.START_MENU_APPEARING");
            boolean onHomeScreen = LauncherHelper.getInstance().isOnHomeScreen(this.context);
            boolean inFreeformMode = FreeformHackHelper.getInstance().isInFreeformWorkspace();
            if (!(U.isChromeOs(this.context) || onHomeScreen && !inFreeformMode)) {
                Class clazz = inFreeformMode && !U.hasBrokenSetLaunchBoundsApi() ? InvisibleActivityAlt.class : InvisibleActivity.class;
                Intent intent = new Intent(this.context, clazz);
                intent.addFlags(0x10000000);
                intent.addFlags(65536);
                if (inFreeformMode) {
                    if (clazz.equals(InvisibleActivity.class)) {
                        U.startActivityLowerRight(this.context, intent);
                    } else if (clazz.equals(InvisibleActivityAlt.class)) {
                        U.startActivityMaximized(this.context, intent);
                    }
                } else {
                    this.context.startActivity(intent);
                }
            }
            EditText editText = (EditText)this.searchView.findViewById(R.id.search_src_text);
            if (this.searchView.getVisibility() == 0) {
                if (this.hasHardwareKeyboard) {
                    this.searchView.setIconifiedByDefault(true);
                    if (editText != null) {
                        editText.setShowSoftInputOnFocus(false);
                    }
                } else {
                    this.searchView.requestFocus();
                }
            }
            this.refreshApps(false);
            new Handler().postDelayed(() -> {
                if (Build.VERSION.SDK_INT > 25 || this.hasHardwareKeyboard) {
                    this.layout.setAlpha(1.0f);
                }
                if (this.hasHardwareKeyboard) {
                    this.searchView.setIconifiedByDefault(false);
                    if (editText != null) {
                        editText.setShowSoftInputOnFocus(true);
                    }
                    this.searchView.requestFocus();
                }
                this.searchView.setOnQueryTextFocusChangeListener((view, b) -> {
                    if (!this.hasHardwareKeyboard) {
                        ViewGroup.LayoutParams params1 = this.startMenu.getLayoutParams();
                        params1.height = this.context.getResources().getDimensionPixelSize(b && !this.isSecondScreenDisablingKeyboard() ? R.dimen.tb_start_menu_height_half : R.dimen.tb_start_menu_height);
                        this.startMenu.setLayoutParams(params1);
                    }
                    if (!b) {
                        if (this.hasHardwareKeyboard && Build.VERSION.SDK_INT >= 22) {
                            U.sendBroadcast(this.context, "com.farmerbb.taskbar.HIDE_START_MENU");
                        } else {
                            InputMethodManager imm = (InputMethodManager)this.context.getSystemService("input_method");
                            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
                        }
                    }
                });
                InputMethodManager imm = (InputMethodManager)this.context.getSystemService("input_method");
                imm.hideSoftInputFromWindow(this.layout.getWindowToken(), 0);
            }, 100L);
        }
    }

    private void hideStartMenu(boolean shouldReset) {
        if (this.layout.getVisibility() == 0) {
            this.layout.setOnClickListener(null);
            this.layout.setAlpha(0.0f);
            MenuHelper.getInstance().setStartMenuOpen(false);
            U.sendBroadcast(this.context, "com.farmerbb.taskbar.START_MENU_DISAPPEARING");
            this.layout.postDelayed(() -> {
                this.layout.setVisibility(8);
                if (this.searchViewClicked || this.hasHardwareKeyboard) {
                    if (!this.hasHardwareKeyboard) {
                        this.searchView.setQuery(null, false);
                    }
                    this.searchView.setIconified(true);
                }
                this.searchView.setOnQueryTextFocusChangeListener(null);
                this.hasSubmittedQuery = false;
                if (shouldReset) {
                    this.startMenu.smoothScrollBy(0, 0);
                    this.startMenu.setSelection(0);
                }
                InputMethodManager imm = (InputMethodManager)this.context.getSystemService("input_method");
                imm.hideSoftInputFromWindow(this.layout.getWindowToken(), 0);
            }, 100L);
        }
    }

    @Override
    public void onDestroyHost(UIHost host) {
        if (this.layout != null) {
            try {
                host.removeView((View)this.layout);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        U.unregisterReceiver(this.context, this.toggleReceiver);
        U.unregisterReceiver(this.context, this.hideReceiver);
        U.unregisterReceiver(this.context, this.hideReceiverNoReset);
        U.unregisterReceiver(this.context, this.showSpaceReceiver);
        U.unregisterReceiver(this.context, this.hideSpaceReceiver);
        U.unregisterReceiver(this.context, this.resetReceiver);
        U.sendBroadcast(this.context, "com.farmerbb.taskbar.START_MENU_DISAPPEARING");
    }

    @Override
    @TargetApi(value=23)
    public void onRecreateHost(UIHost host) {
        if (this.layout != null) {
            try {
                host.removeView((View)this.layout);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (U.canDrawOverlays(this.context)) {
                this.drawStartMenu(host);
            } else {
                SharedPreferences pref = U.getSharedPreferences(this.context);
                pref.edit().putBoolean("taskbar_active", false).apply();
                host.terminate();
            }
        }
    }

    private void openContextMenu(int[] location) {
        U.sendBroadcast(this.context, "com.farmerbb.taskbar.HIDE_START_MENU_NO_RESET");
        Bundle args = new Bundle();
        args.putBoolean("launched_from_start_menu", true);
        args.putBoolean("is_overflow_menu", true);
        args.putInt("x", location[0]);
        args.putInt("y", location[1]);
        new Handler().postDelayed(() -> U.startContextMenuActivity(this.context, args), this.shouldDelay() ? 100L : 0L);
    }

    private boolean shouldDelay() {
        return U.hasFreeformSupport(this.context) && U.isFreeformModeEnabled(this.context) && !FreeformHackHelper.getInstance().isFreeformHackActive();
    }

    private boolean isSecondScreenDisablingKeyboard() {
        return Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"default_input_method").startsWith("com.farmerbb.secondscreen");
    }
}

