/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.appwidget.AppWidgetHost;
import android.appwidget.AppWidgetHostView;
import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProviderInfo;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Process;
import android.util.SparseArray;
import android.view.PointerIcon;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.graphics.ColorUtils;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.activity.DashboardActivity;
import com.farmerbb.taskbar.helper.DashboardHelper;
import com.farmerbb.taskbar.helper.FreeformHackHelper;
import com.farmerbb.taskbar.helper.LauncherHelper;
import com.farmerbb.taskbar.ui.UIController;
import com.farmerbb.taskbar.ui.UIHost;
import com.farmerbb.taskbar.ui.ViewParams;
import com.farmerbb.taskbar.util.TaskbarPosition;
import com.farmerbb.taskbar.util.U;
import com.farmerbb.taskbar.widget.DashboardCell;
import java.util.List;

public class DashboardController
extends UIController {
    private AppWidgetManager mAppWidgetManager;
    private AppWidgetHost mAppWidgetHost;
    private LinearLayout layout;
    private SparseArray<DashboardCell> cells = new SparseArray();
    private SparseArray<AppWidgetHostView> widgets = new SparseArray();
    private final int APPWIDGET_HOST_ID = 123;
    private int columns;
    private int rows;
    private int maxSize;
    private int previouslySelectedCell = -1;
    private View.OnClickListener ocl = view -> this.toggleDashboard();
    private View.OnClickListener cellOcl = view -> this.cellClick(view, true);
    private View.OnHoverListener cellOhl = (v, event) -> {
        this.cellClick(v, false);
        if (Build.VERSION.SDK_INT >= 24) {
            v.setPointerIcon(PointerIcon.getSystemIcon((Context)this.context, (int)1000));
        }
        return false;
    };
    private View.OnLongClickListener olcl = v -> {
        this.cellLongClick(v);
        return true;
    };
    private View.OnGenericMotionListener ogml = (view, motionEvent) -> {
        if (motionEvent.getAction() == 11 && motionEvent.getButtonState() == 2) {
            this.cellLongClick(view);
        }
        return false;
    };
    private DashboardCell.OnInterceptedLongPressListener listener = this::cellLongClick;
    private BroadcastReceiver toggleReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            DashboardController.this.toggleDashboard();
        }
    };
    private BroadcastReceiver addWidgetReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            DashboardController.this.fadeIn();
            if (intent.hasExtra("appWidgetId") && intent.hasExtra("cellId")) {
                int appWidgetId = intent.getExtras().getInt("appWidgetId", -1);
                int cellId = intent.getExtras().getInt("cellId", -1);
                DashboardController.this.addWidget(appWidgetId, cellId, true);
            }
        }
    };
    private BroadcastReceiver removeWidgetReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            DashboardController.this.fadeIn();
            if (intent.hasExtra("cellId")) {
                int cellId = intent.getExtras().getInt("cellId", -1);
                DashboardController.this.removeWidget(cellId, false);
            }
        }
    };
    private BroadcastReceiver hideReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            DashboardController.this.hideDashboard();
        }
    };

    public DashboardController(Context context) {
        super(context);
    }

    @Override
    @TargetApi(value=23)
    public void onCreateHost(UIHost host) {
        if (U.getBooleanPrefWithDefault(this.context, "dashboard")) {
            this.init(this.context, host, () -> this.drawDashboard(host));
        } else {
            host.terminate();
        }
    }

    @SuppressLint(value={"RtlHardcoded"})
    private void drawDashboard(UIHost host) {
        int i;
        int accentColor;
        boolean isLandscape;
        ViewParams params = new ViewParams(-1, -1, -1, 131080);
        this.layout = new LinearLayout(this.context);
        this.layout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.layout.setVisibility(8);
        this.layout.setAlpha(0.0f);
        SharedPreferences pref = U.getSharedPreferences(this.context);
        int width = U.getIntPrefWithDefault(this.context, "dashboard_width");
        int height = U.getIntPrefWithDefault(this.context, "dashboard_height");
        int orientation = U.getDisplayOrientation(this.context);
        boolean isPortrait = orientation == 1;
        boolean bl = isLandscape = orientation == 2;
        if (isPortrait) {
            this.columns = height;
            this.rows = width;
        }
        if (isLandscape) {
            this.columns = width;
            this.rows = height;
        }
        this.maxSize = this.columns * this.rows;
        int backgroundTint = U.getBackgroundTint(this.context);
        int accentColorAlt = accentColor = U.getAccentColor(this.context);
        accentColorAlt = ColorUtils.setAlphaComponent((int)accentColorAlt, (int)(Color.alpha((int)accentColorAlt) / 3));
        int cellCount = 0;
        for (i = 0; i < this.columns; ++i) {
            LinearLayout layout2 = new LinearLayout(this.context);
            layout2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
            layout2.setOrientation(1);
            for (int j = 0; j < this.rows; ++j) {
                DashboardCell cellLayout = (DashboardCell)View.inflate((Context)this.context, (int)R.layout.tb_dashboard, null);
                cellLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
                cellLayout.setBackgroundColor(backgroundTint);
                cellLayout.setOnClickListener(this.cellOcl);
                cellLayout.setOnHoverListener(this.cellOhl);
                cellLayout.setFocusable(false);
                TextView empty = (TextView)cellLayout.findViewById(R.id.empty);
                empty.setBackgroundColor(accentColorAlt);
                empty.setTextColor(accentColor);
                Bundle bundle = new Bundle();
                bundle.putInt("cellId", cellCount);
                cellLayout.setTag(bundle);
                this.cells.put(cellCount, (Object)cellLayout);
                ++cellCount;
                layout2.addView((View)cellLayout);
            }
            this.layout.addView((View)layout2);
        }
        this.mAppWidgetManager = AppWidgetManager.getInstance((Context)this.context);
        this.mAppWidgetHost = new AppWidgetHost(this.context, 123);
        this.mAppWidgetHost.startListening();
        for (i = 0; i < this.maxSize; ++i) {
            int appWidgetId = pref.getInt("dashboard_widget_" + i, -1);
            if (appWidgetId != -1) {
                this.addWidget(appWidgetId, i, false);
                continue;
            }
            if (!pref.getBoolean("dashboard_widget_" + i + "_placeholder", false)) continue;
            this.addPlaceholder(i);
        }
        this.mAppWidgetHost.stopListening();
        U.registerReceiver(this.context, this.toggleReceiver, "com.farmerbb.taskbar.TOGGLE_DASHBOARD");
        U.registerReceiver(this.context, this.addWidgetReceiver, "com.farmerbb.taskbar.ADD_WIDGET_COMPLETED");
        U.registerReceiver(this.context, this.removeWidgetReceiver, "com.farmerbb.taskbar.REMOVE_WIDGET_COMPLETED");
        U.registerReceiver(this.context, this.hideReceiver, "com.farmerbb.taskbar.HIDE_DASHBOARD");
        host.addView((View)this.layout, params);
        new Handler().postDelayed(() -> {
            int paddingSize = this.context.getResources().getDimensionPixelSize(R.dimen.tb_icon_size);
            switch (TaskbarPosition.getTaskbarPosition(this.context)) {
                case "top_vertical_left": 
                case "bottom_vertical_left": {
                    this.layout.setPadding(paddingSize, 0, 0, 0);
                    break;
                }
                case "top_left": 
                case "top_right": {
                    this.layout.setPadding(0, paddingSize, 0, 0);
                    break;
                }
                case "top_vertical_right": 
                case "bottom_vertical_right": {
                    this.layout.setPadding(0, 0, paddingSize, 0);
                    break;
                }
                case "bottom_left": 
                case "bottom_right": {
                    this.layout.setPadding(0, 0, 0, paddingSize);
                }
            }
        }, 100L);
    }

    private void toggleDashboard() {
        if (this.layout.getVisibility() == 8) {
            this.showDashboard();
        } else {
            this.hideDashboard();
        }
    }

    @TargetApi(value=24)
    private void showDashboard() {
        if (this.layout.getVisibility() == 8) {
            this.layout.setOnClickListener(this.ocl);
            this.fadeIn();
            U.sendBroadcast(this.context, "com.farmerbb.taskbar.DASHBOARD_APPEARING");
            U.sendBroadcast(this.context, "com.farmerbb.taskbar.HIDE_START_MENU");
            boolean inFreeformMode = FreeformHackHelper.getInstance().isInFreeformWorkspace();
            Intent intent = U.getThemedIntent(this.context, DashboardActivity.class);
            intent.addFlags(0x10000000);
            intent.addFlags(65536);
            if (inFreeformMode) {
                if (U.hasBrokenSetLaunchBoundsApi()) {
                    intent.putExtra("context_menu_fix", true);
                }
                U.startActivityMaximized(this.context, intent);
            } else {
                this.context.startActivity(intent);
            }
            for (int i = 0; i < this.maxSize; ++i) {
                DashboardCell cellLayout = (DashboardCell)((Object)this.cells.get(i));
                AppWidgetHostView hostView = (AppWidgetHostView)this.widgets.get(i);
                if (hostView == null) continue;
                try {
                    this.context.getPackageManager().getApplicationInfo(hostView.getAppWidgetInfo().provider.getPackageName(), 0);
                    hostView.post(() -> {
                        ViewGroup.LayoutParams params = hostView.getLayoutParams();
                        params.width = cellLayout.getWidth();
                        params.height = cellLayout.getHeight();
                        hostView.setLayoutParams(params);
                        hostView.updateAppWidgetSize(null, cellLayout.getWidth(), cellLayout.getHeight(), cellLayout.getWidth(), cellLayout.getHeight());
                    });
                    continue;
                }
                catch (PackageManager.NameNotFoundException e) {
                    this.removeWidget(i, false);
                    continue;
                }
                catch (NullPointerException e) {
                    this.removeWidget(i, true);
                }
            }
            SharedPreferences pref = U.getSharedPreferences(this.context);
            if (!pref.getBoolean("dashboard_tutorial_shown", false)) {
                U.showToastLong(this.context, R.string.tb_dashboard_tutorial);
                pref.edit().putBoolean("dashboard_tutorial_shown", true).apply();
            }
        }
    }

    private void hideDashboard() {
        if (this.layout.getVisibility() == 0) {
            this.layout.setOnClickListener(null);
            this.fadeOut(true);
            for (int i = 0; i < this.maxSize; ++i) {
                FrameLayout frameLayout = (FrameLayout)this.cells.get(i);
                frameLayout.findViewById(R.id.empty).setVisibility(8);
            }
            this.previouslySelectedCell = -1;
        }
    }

    private void fadeIn() {
        this.mAppWidgetHost.startListening();
        DashboardHelper.getInstance().setDashboardOpen(true);
        this.layout.setVisibility(0);
        this.layout.animate().alpha(1.0f).setDuration((long)this.context.getResources().getInteger(0x10E0000)).setListener(null);
    }

    private void fadeOut(final boolean sendIntent) {
        this.mAppWidgetHost.stopListening();
        DashboardHelper.getInstance().setDashboardOpen(false);
        this.layout.animate().alpha(0.0f).setDuration((long)this.context.getResources().getInteger(0x10E0000)).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                DashboardController.this.layout.setVisibility(8);
                if (sendIntent) {
                    U.sendBroadcast(DashboardController.this.context, "com.farmerbb.taskbar.DASHBOARD_DISAPPEARING");
                }
            }
        });
    }

    @Override
    @TargetApi(value=23)
    public void onRecreateHost(UIHost host) {
        if (this.layout != null) {
            try {
                host.removeView((View)this.layout);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            SharedPreferences pref = U.getSharedPreferences(this.context);
            if (U.canDrawOverlays(this.context)) {
                this.drawDashboard(host);
            } else {
                pref.edit().putBoolean("taskbar_active", false).apply();
                host.terminate();
            }
        }
    }

    @Override
    public void onDestroyHost(UIHost host) {
        if (this.layout != null) {
            try {
                host.removeView((View)this.layout);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        U.unregisterReceiver(this.context, this.toggleReceiver);
        U.unregisterReceiver(this.context, this.addWidgetReceiver);
        U.unregisterReceiver(this.context, this.removeWidgetReceiver);
        U.unregisterReceiver(this.context, this.hideReceiver);
        SharedPreferences pref = U.getSharedPreferences(this.context);
        if (!LauncherHelper.getInstance().isOnSecondaryHomeScreen(this.context) || !pref.getBoolean("dont_stop_dashboard", false)) {
            U.sendBroadcast(this.context, "com.farmerbb.taskbar.DASHBOARD_DISAPPEARING");
        }
        pref.edit().remove("dont_stop_dashboard").apply();
    }

    private void cellClick(View view, boolean isActualClick) {
        Bundle bundle = (Bundle)view.getTag();
        int cellId = bundle.getInt("cellId");
        int appWidgetId = bundle.getInt("appWidgetId", -1);
        int currentlySelectedCell = appWidgetId == -1 ? cellId : -1;
        SharedPreferences pref = U.getSharedPreferences(this.context);
        boolean shouldShowPlaceholder = pref.getBoolean("dashboard_widget_" + cellId + "_placeholder", false);
        if (isActualClick && (appWidgetId == -1 && currentlySelectedCell == this.previouslySelectedCell || shouldShowPlaceholder)) {
            String providerName;
            this.fadeOut(false);
            FrameLayout frameLayout = (FrameLayout)this.cells.get(currentlySelectedCell);
            frameLayout.findViewById(R.id.empty).setVisibility(8);
            Intent intent = new Intent("com.farmerbb.taskbar.ADD_WIDGET_REQUESTED");
            intent.putExtra("appWidgetId", 123);
            intent.putExtra("cellId", cellId);
            U.sendBroadcast(this.context, intent);
            if (shouldShowPlaceholder && !(providerName = pref.getString("dashboard_widget_" + cellId + "_provider", "null")).equals("null")) {
                ComponentName componentName = ComponentName.unflattenFromString((String)providerName);
                List providerInfoList = this.mAppWidgetManager.getInstalledProvidersForProfile(Process.myUserHandle());
                for (AppWidgetProviderInfo info : providerInfoList) {
                    if (!info.provider.equals((Object)componentName)) continue;
                    U.showToast(this.context, this.context.getString(R.string.tb_widget_restore_toast, new Object[]{info.loadLabel(this.context.getPackageManager())}), 0);
                    break;
                }
            }
            this.previouslySelectedCell = -1;
        } else {
            for (int i = 0; i < this.maxSize; ++i) {
                FrameLayout frameLayout = (FrameLayout)this.cells.get(i);
                frameLayout.findViewById(R.id.empty).setVisibility(i == currentlySelectedCell && !shouldShowPlaceholder ? 0 : 8);
            }
            this.previouslySelectedCell = currentlySelectedCell;
        }
    }

    private void cellLongClick(View view) {
        this.fadeOut(false);
        Bundle bundle = (Bundle)view.getTag();
        int cellId = bundle.getInt("cellId");
        Intent intent = new Intent("com.farmerbb.taskbar.REMOVE_WIDGET_REQUESTED");
        intent.putExtra("cellId", cellId);
        U.sendBroadcast(this.context, intent);
    }

    private void addWidget(int appWidgetId, int cellId, boolean shouldSave) {
        AppWidgetProviderInfo appWidgetInfo = this.mAppWidgetManager.getAppWidgetInfo(appWidgetId);
        DashboardCell cellLayout = (DashboardCell)((Object)this.cells.get(cellId));
        AppWidgetHostView hostView = this.mAppWidgetHost.createView(this.context, appWidgetId, appWidgetInfo);
        hostView.setAppWidget(appWidgetId, appWidgetInfo);
        Bundle bundle = new Bundle();
        bundle.putInt("cellId", cellId);
        hostView.setTag((Object)bundle);
        cellLayout.findViewById(R.id.empty).setVisibility(8);
        cellLayout.findViewById(R.id.placeholder).setVisibility(8);
        cellLayout.setOnLongClickListener(this.olcl);
        cellLayout.setOnGenericMotionListener(this.ogml);
        cellLayout.setOnInterceptedLongPressListener(this.listener);
        LinearLayout linearLayout = (LinearLayout)cellLayout.findViewById(R.id.dashboard);
        linearLayout.addView((View)hostView);
        Bundle bundle2 = (Bundle)cellLayout.getTag();
        bundle2.putInt("appWidgetId", appWidgetId);
        cellLayout.setTag(bundle2);
        this.widgets.put(cellId, (Object)hostView);
        if (shouldSave) {
            SharedPreferences pref = U.getSharedPreferences(this.context);
            SharedPreferences.Editor editor = pref.edit();
            editor.putInt("dashboard_widget_" + cellId, appWidgetId);
            editor.putString("dashboard_widget_" + cellId + "_provider", appWidgetInfo.provider.flattenToString());
            editor.remove("dashboard_widget_" + cellId + "_placeholder");
            editor.apply();
        }
        new Handler().post(() -> {
            ViewGroup.LayoutParams params = hostView.getLayoutParams();
            params.width = cellLayout.getWidth();
            params.height = cellLayout.getHeight();
            hostView.setLayoutParams(params);
            hostView.updateAppWidgetSize(null, cellLayout.getWidth(), cellLayout.getHeight(), cellLayout.getWidth(), cellLayout.getHeight());
        });
    }

    private void removeWidget(int cellId, boolean tempRemove) {
        this.widgets.remove(cellId);
        DashboardCell cellLayout = (DashboardCell)((Object)this.cells.get(cellId));
        Bundle bundle = (Bundle)cellLayout.getTag();
        this.mAppWidgetHost.deleteAppWidgetId(bundle.getInt("appWidgetId"));
        bundle.remove("appWidgetId");
        LinearLayout linearLayout = (LinearLayout)cellLayout.findViewById(R.id.dashboard);
        linearLayout.removeAllViews();
        cellLayout.setTag(bundle);
        cellLayout.setOnClickListener(this.cellOcl);
        cellLayout.setOnHoverListener(this.cellOhl);
        cellLayout.setOnLongClickListener(null);
        cellLayout.setOnGenericMotionListener(null);
        cellLayout.setOnInterceptedLongPressListener(null);
        SharedPreferences pref = U.getSharedPreferences(this.context);
        SharedPreferences.Editor editor = pref.edit();
        editor.remove("dashboard_widget_" + cellId);
        if (tempRemove) {
            editor.putBoolean("dashboard_widget_" + cellId + "_placeholder", true);
            this.addPlaceholder(cellId);
        } else {
            editor.remove("dashboard_widget_" + cellId + "_provider");
        }
        editor.apply();
    }

    private void addPlaceholder(int cellId) {
        FrameLayout placeholder = (FrameLayout)((DashboardCell)((Object)this.cells.get(cellId))).findViewById(R.id.placeholder);
        SharedPreferences pref = U.getSharedPreferences(this.context);
        String providerName = pref.getString("dashboard_widget_" + cellId + "_provider", "null");
        if (!providerName.equals("null")) {
            ImageView imageView = (ImageView)placeholder.findViewById(R.id.placeholder_image);
            ComponentName componentName = ComponentName.unflattenFromString((String)providerName);
            List providerInfoList = this.mAppWidgetManager.getInstalledProvidersForProfile(Process.myUserHandle());
            for (AppWidgetProviderInfo info : providerInfoList) {
                if (!info.provider.equals((Object)componentName)) continue;
                Drawable drawable2 = info.loadPreviewImage(this.context, -1);
                if (drawable2 == null) {
                    drawable2 = info.loadIcon(this.context, -1);
                }
                ColorMatrix matrix = new ColorMatrix();
                matrix.setSaturation(0.0f);
                imageView.setImageDrawable(drawable2);
                imageView.setColorFilter((ColorFilter)new ColorMatrixColorFilter(matrix));
                break;
            }
        }
        placeholder.setVisibility(0);
    }
}

