/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.service;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.drawable.Icon;
import android.os.Handler;
import android.service.quicksettings.Tile;
import android.service.quicksettings.TileService;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.service.NotificationService;
import com.farmerbb.taskbar.util.U;

@TargetApi(value=24)
public class QuickSettingsTileService
extends TileService {
    public void onStartListening() {
        super.onStartListening();
        this.updateState();
    }

    public void onClick() {
        super.onClick();
        Intent intent = new Intent(U.isServiceRunning((Context)this, NotificationService.class) ? "com.farmerbb.taskbar.QUIT" : "com.farmerbb.taskbar.START");
        intent.setPackage(this.getPackageName());
        this.sendBroadcast(intent);
        new Handler().postDelayed(this::updateState, 100L);
    }

    private void updateState() {
        Tile tile = this.getQsTile();
        if (tile != null) {
            SharedPreferences pref = U.getSharedPreferences((Context)this);
            tile.setIcon(Icon.createWithResource((Context)this, (int)(pref.getString("start_button_image", U.getDefaultStartButtonImage((Context)this)).equals("app_logo") ? R.drawable.tb_system : R.drawable.tb_allapps)));
            if (U.canDrawOverlays((Context)this)) {
                tile.setState(U.isServiceRunning((Context)this, NotificationService.class) ? 2 : 1);
            } else {
                tile.setState(0);
            }
            tile.updateTile();
        }
    }
}

