/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.service;

import android.annotation.TargetApi;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.IBinder;
import android.service.quicksettings.TileService;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.activity.MainActivity;
import com.farmerbb.taskbar.service.DashboardService;
import com.farmerbb.taskbar.service.QuickSettingsTileService;
import com.farmerbb.taskbar.service.StartMenuService;
import com.farmerbb.taskbar.service.TaskbarService;
import com.farmerbb.taskbar.util.DependencyUtils;
import com.farmerbb.taskbar.util.IconCache;
import com.farmerbb.taskbar.util.U;

public class NotificationService
extends Service {
    private boolean isHidden = true;
    BroadcastReceiver userForegroundReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            NotificationService.this.startService(new Intent(context, TaskbarService.class));
            NotificationService.this.startService(new Intent(context, StartMenuService.class));
            NotificationService.this.startService(new Intent(context, DashboardService.class));
        }
    };
    BroadcastReceiver userBackgroundReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            NotificationService.this.stopService(new Intent(context, TaskbarService.class));
            NotificationService.this.stopService(new Intent(context, StartMenuService.class));
            NotificationService.this.stopService(new Intent(context, DashboardService.class));
            IconCache.getInstance(context).clearCache();
        }
    };

    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent != null && intent.getBooleanExtra("start_services", false)) {
            this.startService(new Intent((Context)this, TaskbarService.class));
            this.startService(new Intent((Context)this, StartMenuService.class));
            this.startService(new Intent((Context)this, DashboardService.class));
        }
        return 1;
    }

    @TargetApi(value=23)
    public void onCreate() {
        super.onCreate();
        SharedPreferences pref = U.getSharedPreferences((Context)this);
        if (pref.getBoolean("taskbar_active", false)) {
            if (U.canDrawOverlays((Context)this)) {
                String showHideLabel;
                this.isHidden = U.getSharedPreferences((Context)this).getBoolean("is_hidden", false);
                Intent intent = new Intent((Context)this, MainActivity.class);
                intent.setFlags(0x10008000);
                Intent receiverIntent = new Intent("com.farmerbb.taskbar.SHOW_HIDE_TASKBAR");
                receiverIntent.setPackage(this.getPackageName());
                Intent receiverIntent2 = new Intent("com.farmerbb.taskbar.QUIT");
                receiverIntent2.setPackage(this.getPackageName());
                PendingIntent contentIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)intent, (int)0x10000000);
                PendingIntent receiverPendingIntent = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)receiverIntent, (int)0x8000000);
                PendingIntent receiverPendingIntent2 = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)receiverIntent2, (int)0x8000000);
                String id2 = "taskbar_notification_channel";
                if (Build.VERSION.SDK_INT >= 26) {
                    String name = this.getString(R.string.tb_app_name);
                    int importance = 1;
                    NotificationManager mNotificationManager = (NotificationManager)this.getSystemService("notification");
                    mNotificationManager.createNotificationChannel(new NotificationChannel(id2, (CharSequence)name, importance));
                }
                NotificationCompat.Builder mBuilder = new NotificationCompat.Builder((Context)this, id2).setSmallIcon(pref.getString("start_button_image", U.getDefaultStartButtonImage((Context)this)).equals("app_logo") ? R.drawable.tb_system : R.drawable.tb_allapps).setContentIntent(contentIntent).setContentTitle((CharSequence)this.getString(R.string.tb_taskbar_is_active)).setContentText((CharSequence)this.getString(R.string.tb_click_to_open_settings)).setColor(ContextCompat.getColor((Context)this, (int)R.color.tb_colorPrimary)).setPriority(-2).setShowWhen(false).setOngoing(true);
                if (U.canEnableFreeform() && !U.isChromeOs((Context)this) && !pref.getBoolean("desktop_mode", false)) {
                    String freeformLabel = this.getString(pref.getBoolean("freeform_hack", false) ? R.string.tb_freeform_off : R.string.tb_freeform_on);
                    Intent freeformIntent = new Intent("com.farmerbb.taskbar.TOGGLE_FREEFORM_MODE");
                    freeformIntent.setPackage(this.getPackageName());
                    PendingIntent freeformPendingIntent = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)freeformIntent, (int)0x8000000);
                    mBuilder.addAction(0, (CharSequence)freeformLabel, freeformPendingIntent);
                    showHideLabel = this.getString(this.isHidden ? R.string.tb_action_show_alt : R.string.tb_action_hide_alt);
                } else {
                    showHideLabel = this.getString(this.isHidden ? R.string.tb_action_show : R.string.tb_action_hide);
                }
                mBuilder.addAction(0, (CharSequence)showHideLabel, receiverPendingIntent).addAction(0, (CharSequence)this.getString(R.string.tb_action_quit), receiverPendingIntent2);
                this.startForeground(8675309, mBuilder.build());
                U.sendBroadcast((Context)this, "com.farmerbb.taskbar.UPDATE_SWITCH");
                if (Build.VERSION.SDK_INT >= 24) {
                    TileService.requestListeningState((Context)this, (ComponentName)new ComponentName(this.getPackageName(), QuickSettingsTileService.class.getName()));
                }
                DependencyUtils.requestTaskerQuery((Context)this);
                if (!this.isHidden) {
                    this.registerReceiver(this.userForegroundReceiver, new IntentFilter("android.intent.action.USER_FOREGROUND"));
                    this.registerReceiver(this.userBackgroundReceiver, new IntentFilter("android.intent.action.USER_BACKGROUND"));
                }
            } else {
                pref.edit().putBoolean("taskbar_active", false).apply();
                this.stopSelf();
            }
        } else {
            this.stopSelf();
        }
    }

    public void onDestroy() {
        SharedPreferences pref = U.getSharedPreferences((Context)this);
        if (pref.getBoolean("is_restarting", false)) {
            pref.edit().remove("is_restarting").apply();
        } else {
            U.sendBroadcast((Context)this, "com.farmerbb.taskbar.UPDATE_SWITCH");
            if (Build.VERSION.SDK_INT >= 24) {
                TileService.requestListeningState((Context)this, (ComponentName)new ComponentName(this.getPackageName(), QuickSettingsTileService.class.getName()));
            }
            DependencyUtils.requestTaskerQuery((Context)this);
            if (!U.launcherIsDefault((Context)this) || U.isChromeOs((Context)this)) {
                U.stopFreeformHack((Context)this);
            }
        }
        super.onDestroy();
        if (!this.isHidden) {
            this.unregisterReceiver(this.userForegroundReceiver);
            this.unregisterReceiver(this.userBackgroundReceiver);
        }
    }
}

