/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.service;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.service.notification.NotificationListenerService;
import android.service.notification.StatusBarNotification;
import com.farmerbb.taskbar.util.U;

public class NotificationCountService
extends NotificationListenerService {
    private BroadcastReceiver requestCountReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            NotificationCountService.this.broadcastNotificationCount();
        }
    };

    public void onListenerConnected() {
        U.registerReceiver((Context)this, this.requestCountReceiver, "com.farmerbb.taskbar.REQUEST_NOTIFICATION_COUNT");
        this.broadcastNotificationCount();
    }

    public void onListenerDisconnected() {
        U.unregisterReceiver((Context)this, this.requestCountReceiver);
        this.broadcastNotificationCount(0);
    }

    public void onNotificationPosted(StatusBarNotification sbn) {
        this.broadcastNotificationCount();
    }

    public void onNotificationRemoved(StatusBarNotification sbn) {
        this.broadcastNotificationCount();
    }

    private void broadcastNotificationCount() {
        StatusBarNotification[] notifications;
        int count = 0;
        try {
            notifications = this.getActiveNotifications();
        }
        catch (SecurityException e) {
            notifications = new StatusBarNotification[]{};
        }
        for (StatusBarNotification notification : notifications) {
            if ((notification.getNotification().flags & 0x200) != 0 || !notification.isClearable()) continue;
            ++count;
        }
        this.broadcastNotificationCount(count);
    }

    private void broadcastNotificationCount(int count) {
        Intent intent = new Intent("com.farmerbb.taskbar.NOTIFICATION_COUNT_CHANGED");
        intent.putExtra("count", Math.min(count, 99));
        U.sendBroadcast((Context)this, intent);
    }
}

