/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.activity.DummyActivity;
import com.farmerbb.taskbar.service.NotificationService;
import com.farmerbb.taskbar.util.U;

public class ToggleFreeformModeReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        SharedPreferences pref = U.getSharedPreferences(context);
        if (!pref.getBoolean("taskbar_active", false) || pref.getBoolean("desktop_mode", false)) {
            return;
        }
        Intent notificationIntent = new Intent(context, NotificationService.class);
        if (pref.getBoolean("freeform_hack", false)) {
            pref.edit().putBoolean("freeform_hack", false).apply();
            context.stopService(notificationIntent);
            U.startForegroundService(context, notificationIntent);
            U.stopFreeformHack(context);
            U.sendBroadcast(context, "com.farmerbb.taskbar.UPDATE_FREEFORM_CHECKBOX");
        } else if (U.hasFreeformSupport(context)) {
            pref.edit().putBoolean("freeform_hack", true).apply();
            context.stopService(notificationIntent);
            Intent intent2 = new Intent(context, DummyActivity.class);
            intent2.putExtra("start_freeform_hack", true);
            intent2.setFlags(0x10000000);
            context.startActivity(intent2);
            U.startForegroundService(context, notificationIntent);
            U.sendBroadcast(context, "com.farmerbb.taskbar.UPDATE_FREEFORM_CHECKBOX");
        } else {
            U.showToastLong(context, R.string.tb_no_freeform_support);
        }
    }
}

