/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Handler;
import com.farmerbb.taskbar.activity.DummyActivity;
import com.farmerbb.taskbar.service.NotificationService;
import com.farmerbb.taskbar.util.U;

public class StartReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        boolean taskbarActiveButHidden;
        SharedPreferences pref = U.getSharedPreferences(context);
        boolean taskbarNotActive = !U.isServiceRunning(context, NotificationService.class);
        boolean bl = taskbarActiveButHidden = !taskbarNotActive && pref.getBoolean("is_hidden", false);
        if (!U.canDrawOverlays(context)) {
            new Handler().postDelayed(() -> {
                Intent intent2 = new Intent(context, DummyActivity.class);
                intent2.putExtra("show_permission_dialog", true);
                intent2.setFlags(0x10000000);
                context.startActivity(intent2);
            }, 250L);
        } else if (taskbarNotActive || taskbarActiveButHidden) {
            U.initPrefs(context);
            SharedPreferences.Editor editor = pref.edit();
            editor.putBoolean("is_hidden", false);
            if (taskbarNotActive) {
                if (pref.getBoolean("first_run", true)) {
                    editor.putBoolean("first_run", false);
                    editor.putBoolean("collapsed", true);
                    new Handler().postDelayed(() -> {
                        Intent intent2 = new Intent(context, DummyActivity.class);
                        intent2.putExtra("show_recent_apps_dialog", true);
                        intent2.setFlags(0x10000000);
                        context.startActivity(intent2);
                    }, 250L);
                }
                editor.putBoolean("taskbar_active", true);
                editor.putLong("time_of_service_start", System.currentTimeMillis());
            }
            editor.apply();
            if (taskbarActiveButHidden) {
                context.stopService(new Intent(context, NotificationService.class));
            }
            if (U.hasFreeformSupport(context) && U.isFreeformModeEnabled(context)) {
                Intent intent2 = new Intent(context, DummyActivity.class);
                intent2.putExtra("start_freeform_hack", true);
                intent2.setFlags(0x10000000);
                context.startActivity(intent2);
            }
            Intent notificationIntent = new Intent(context, NotificationService.class);
            notificationIntent.putExtra("start_services", true);
            U.startForegroundService(context, notificationIntent);
        } else if (intent.hasExtra("secondscreen")) {
            pref.edit().putBoolean("skip_quit_receiver", true).apply();
        }
    }
}

