/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import com.farmerbb.taskbar.helper.LauncherHelper;
import com.farmerbb.taskbar.service.DashboardService;
import com.farmerbb.taskbar.service.NotificationService;
import com.farmerbb.taskbar.service.StartMenuService;
import com.farmerbb.taskbar.service.TaskbarService;
import com.farmerbb.taskbar.util.IconCache;
import com.farmerbb.taskbar.util.U;

public class QuitReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        SharedPreferences pref = U.getSharedPreferences(context);
        if (!pref.getBoolean("skip_quit_receiver", false)) {
            Intent taskbarIntent = new Intent(context, TaskbarService.class);
            Intent startMenuIntent = new Intent(context, StartMenuService.class);
            Intent dashboardIntent = new Intent(context, DashboardService.class);
            Intent notificationIntent = new Intent(context, NotificationService.class);
            pref.edit().putBoolean("taskbar_active", false).apply();
            if (!LauncherHelper.getInstance().isOnHomeScreen(context)) {
                context.stopService(taskbarIntent);
                context.stopService(startMenuIntent);
                context.stopService(dashboardIntent);
                IconCache.getInstance(context).clearCache();
                U.sendBroadcast(context, "com.farmerbb.taskbar.START_MENU_DISAPPEARING");
            }
            context.stopService(notificationIntent);
        } else {
            pref.edit().remove("skip_quit_receiver").apply();
        }
    }
}

