/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import com.farmerbb.taskbar.activity.DummyActivity;
import com.farmerbb.taskbar.service.NotificationService;
import com.farmerbb.taskbar.util.ShortcutUtils;
import com.farmerbb.taskbar.util.U;

public class BootReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        if ("android.intent.action.BOOT_COMPLETED".equals(intent.getAction())) {
            SharedPreferences pref = U.getSharedPreferences(context);
            if (U.isBlissOs(context) && !pref.getBoolean("bliss_os_prefs", false)) {
                U.initPrefs(context);
            }
            SharedPreferences.Editor editor = pref.edit();
            if (!U.hasFreeformSupport(context)) {
                editor.putBoolean("freeform_hack", false);
            }
            if (pref.getBoolean("start_on_boot", false)) {
                editor.putBoolean("taskbar_active", true);
                editor.putLong("time_of_service_start", System.currentTimeMillis());
                editor.apply();
                boolean startServices = false;
                if (!pref.getBoolean("is_hidden", false)) {
                    if (U.hasFreeformSupport(context) && U.isFreeformModeEnabled(context)) {
                        Intent intent2 = new Intent(context, DummyActivity.class);
                        intent2.putExtra("start_freeform_hack", true);
                        intent2.setFlags(0x10000000);
                        context.startActivity(intent2);
                    }
                    startServices = true;
                }
                Intent notificationIntent = new Intent(context, NotificationService.class);
                notificationIntent.putExtra("start_services", startServices);
                U.startForegroundService(context, notificationIntent);
            } else {
                editor.putBoolean("taskbar_active", U.isServiceRunning(context, NotificationService.class));
                editor.apply();
            }
            ShortcutUtils.initFavoriteAppTiles(context);
        }
    }
}

