/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.lib;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import com.farmerbb.taskbar.activity.MainActivity;
import com.farmerbb.taskbar.activity.SecondaryHomeActivity;
import com.farmerbb.taskbar.util.U;

@Keep
public class Taskbar {
    private Taskbar() {
    }

    @Keep
    public static void openSettings(@NonNull Context context) {
        Taskbar.openSettings(context, null, -1);
    }

    @Keep
    public static void openSettings(@NonNull Context context, @Nullable String title) {
        Taskbar.openSettings(context, title, -1);
    }

    @Keep
    public static void openSettings(@NonNull Context context, @StyleRes int theme) {
        Taskbar.openSettings(context, null, theme);
    }

    @Keep
    public static void openSettings(@NonNull Context context, @Nullable String title, @StyleRes int theme) {
        Intent intent = new Intent(context, MainActivity.class);
        intent.putExtra("title", title);
        intent.putExtra("theme", theme);
        intent.putExtra("back_arrow", true);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        context.startActivity(intent);
    }

    @Keep
    public static void setEnabled(@NonNull Context context, boolean enabled) {
        U.setComponentEnabled(context, SecondaryHomeActivity.class, enabled);
    }
}

