/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.helper;

import android.content.Context;
import com.farmerbb.taskbar.util.U;

public class LauncherHelper {
    private boolean onPrimaryHomeScreen = false;
    private boolean onSecondaryHomeScreen = false;
    private int secondaryDisplayId = -1;
    private static LauncherHelper theInstance;

    private LauncherHelper() {
    }

    public static LauncherHelper getInstance() {
        if (theInstance == null) {
            theInstance = new LauncherHelper();
        }
        return theInstance;
    }

    public boolean isOnHomeScreen(Context context) {
        return this.isOnHomeScreen(context, true);
    }

    public boolean isOnSecondaryHomeScreen(Context context) {
        return this.isOnHomeScreen(context, false);
    }

    private boolean isOnHomeScreen(Context context, boolean checkPrimary) {
        boolean checkSecondary = true;
        if (U.getExternalDisplayID(context) == 0) {
            checkSecondary = false;
        }
        if (checkPrimary && checkSecondary) {
            return this.onPrimaryHomeScreen || this.onSecondaryHomeScreen;
        }
        if (!checkPrimary && checkSecondary) {
            return this.onSecondaryHomeScreen;
        }
        if (checkPrimary) {
            return this.onPrimaryHomeScreen;
        }
        return false;
    }

    public void setOnPrimaryHomeScreen(boolean value) {
        this.onPrimaryHomeScreen = value;
    }

    public void setOnSecondaryHomeScreen(boolean value, int displayId) {
        this.onSecondaryHomeScreen = value;
        this.secondaryDisplayId = value ? displayId : -1;
    }

    public int getSecondaryDisplayId() {
        return this.secondaryDisplayId;
    }
}

