/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.fragment;

import android.annotation.SuppressLint;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.preference.CheckBoxPreference;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceFragment;
import android.preference.PreferenceScreen;
import android.view.MenuItem;
import android.view.View;
import android.widget.ListView;
import androidx.annotation.XmlRes;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.activity.ClearDataActivity;
import com.farmerbb.taskbar.activity.MainActivity;
import com.farmerbb.taskbar.fragment.AboutFragment;
import com.farmerbb.taskbar.helper.FreeformHackHelper;
import com.farmerbb.taskbar.helper.LauncherHelper;
import com.farmerbb.taskbar.util.U;
import java.util.HashMap;
import java.util.Map;

public abstract class SettingsFragment
extends PreferenceFragment
implements Preference.OnPreferenceClickListener {
    boolean finishedLoadingPrefs;
    boolean showReminderToast = false;
    boolean restartNotificationService = false;
    String isModified = "_is_modified";
    protected Map<String, Class<?>> prefsToSanitize = new HashMap();
    private Preference.OnPreferenceChangeListener sBindPreferenceSummaryToValueListener = new Preference.OnPreferenceChangeListener(){

        public boolean onPreferenceChange(Preference preference, Object value) {
            String stringValue = value.toString();
            if (preference instanceof ListPreference) {
                ListPreference listPreference = (ListPreference)preference;
                int index = listPreference.findIndexOfValue(stringValue);
                preference.setSummary(index >= 0 ? listPreference.getEntries()[index] : null);
            } else if (!(preference instanceof CheckBoxPreference)) {
                preference.setSummary((CharSequence)stringValue);
            }
            if (SettingsFragment.this.finishedLoadingPrefs) {
                boolean shouldRestart = true;
                switch (preference.getKey()) {
                    case "theme": {
                        if (U.isLibrary((Context)SettingsFragment.this.getActivity())) break;
                        Intent intent = new Intent((Context)SettingsFragment.this.getActivity(), MainActivity.class);
                        intent.setFlags(0x10008000);
                        intent.putExtra("theme_change", true);
                        SettingsFragment.this.startActivity(intent);
                        SettingsFragment.this.getActivity().overridePendingTransition(0, 0);
                        break;
                    }
                    case "chrome_os_context_menu_fix": {
                        FreeformHackHelper helper = FreeformHackHelper.getInstance();
                        helper.setFreeformHackActive(false);
                        helper.setInFreeformWorkspace(false);
                        U.sendBroadcast((Context)SettingsFragment.this.getActivity(), "com.farmerbb.taskbar.FINISH_FREEFORM_ACTIVITY");
                        SharedPreferences pref = U.getSharedPreferences((Context)SettingsFragment.this.getActivity());
                        if (!pref.getBoolean("taskbar_active", false) || pref.getBoolean("is_hidden", false)) break;
                        new Handler().post(() -> U.startFreeformHack((Context)SettingsFragment.this.getActivity()));
                        break;
                    }
                    case "start_button_image": {
                        if (!stringValue.equals("custom")) break;
                        U.showImageChooser(SettingsFragment.this.getActivity());
                        break;
                    }
                    case "display_density": {
                        boolean isOnHomeScreen = LauncherHelper.getInstance().isOnSecondaryHomeScreen((Context)SettingsFragment.this.getActivity());
                        int displayID = U.getExternalDisplayID((Context)SettingsFragment.this.getActivity());
                        try {
                            U.setDensity(displayID, stringValue);
                            SharedPreferences pref2 = U.getSharedPreferences((Context)SettingsFragment.this.getActivity());
                            if (pref2.getBoolean("auto_hide_navbar_desktop_mode", false) && isOnHomeScreen) {
                                U.showHideNavigationBar(U.getDisplayContext((Context)SettingsFragment.this.getActivity()), displayID, false, 250);
                            }
                        }
                        catch (Exception e) {
                            U.showToast((Context)SettingsFragment.this.getActivity(), R.string.tb_unable_to_apply_density_change);
                        }
                        shouldRestart = false;
                        break;
                    }
                    case "hide_icon_labels": {
                        U.sendBroadcast((Context)SettingsFragment.this.getActivity(), "com.farmerbb.taskbar.REFRESH_DESKTOP_ICONS");
                        break;
                    }
                    case "dashboard": 
                    case "sys_tray": {
                        SharedPreferences pref2 = U.getSharedPreferences((Context)SettingsFragment.this.getActivity());
                        pref2.edit().putBoolean(preference.getKey() + SettingsFragment.this.isModified, true).apply();
                    }
                }
                if (shouldRestart) {
                    U.restartTaskbar((Context)SettingsFragment.this.getActivity());
                }
            }
            return true;
        }
    };

    protected void addPrefsToSanitize() {
    }

    protected abstract void loadPrefs();

    public void onCreate(Bundle savedInstanceState) {
        this.finishedLoadingPrefs = false;
        super.onCreate(savedInstanceState);
        if (U.isLibrary((Context)this.getActivity())) {
            this.getPreferenceManager().setSharedPreferencesName("com.farmerbb.taskbar_preferences");
        }
        this.setRetainInstance(true);
        this.setHasOptionsMenu(true);
        this.addPrefsToSanitize();
        SharedPreferences pref = U.getSharedPreferences((Context)this.getActivity());
        for (String key : this.prefsToSanitize.keySet()) {
            if (pref.contains(key + "_default")) continue;
            Class<?> rClass = this.prefsToSanitize.get(key);
            if (rClass == R.bool.class) {
                pref.edit().putBoolean(key + "_default", U.getBooleanPrefWithDefault((Context)this.getActivity(), key)).apply();
                continue;
            }
            if (rClass != R.integer.class) continue;
            pref.edit().putInt(key + "_default", U.getIntPrefWithDefault((Context)this.getActivity(), key)).apply();
        }
        this.loadPrefs();
        for (String key : this.prefsToSanitize.keySet()) {
            if (pref.getBoolean(key + "_is_modified", false)) continue;
            pref.edit().remove(key).apply();
        }
        this.finishedLoadingPrefs = true;
    }

    public void onStart() {
        super.onStart();
        ((MainActivity)this.getActivity()).updateHelpButton(this);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        ListView list;
        super.onActivityCreated(savedInstanceState);
        View rootView = this.getView();
        if (rootView != null && (list = (ListView)rootView.findViewById(16908298)) != null) {
            list.setDivider(null);
        }
    }

    void bindPreferenceSummaryToValue(Preference preference) {
        preference.setOnPreferenceChangeListener(this.sBindPreferenceSummaryToValueListener);
        if (!(preference instanceof CheckBoxPreference)) {
            this.sBindPreferenceSummaryToValueListener.onPreferenceChange(preference, (Object)U.getSharedPreferences(preference.getContext()).getString(preference.getKey(), ""));
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.getActivity().onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onResume() {
        super.onResume();
        if (this.restartNotificationService) {
            this.restartNotificationService = false;
            U.restartNotificationService((Context)this.getActivity());
        }
    }

    @SuppressLint(value={"SetTextI18n"})
    public boolean onPreferenceClick(Preference p) {
        if (p.getKey().equals("clear_pinned_apps")) {
            Intent clearIntent = U.getThemedIntent((Context)this.getActivity(), ClearDataActivity.class);
            this.startActivity(clearIntent);
        }
        return true;
    }

    protected void navigateTo(SettingsFragment fragment) {
        this.getFragmentManager().beginTransaction().replace(R.id.fragmentContainer, (Fragment)fragment, ((Object)((Object)fragment)).getClass().getSimpleName()).setTransition(4097).commit();
    }

    public void addPreferencesFromResource(@XmlRes int preferencesResId) {
        if (!(this instanceof AboutFragment)) {
            U.allowReflection();
            try {
                Context context = U.wrapContext(U.getDisplayContext((Context)this.getActivity()));
                Class.forName("android.preference.PreferenceManager").getMethod("inflateFromResource", Context.class, Integer.TYPE, PreferenceScreen.class).invoke((Object)this.getPreferenceManager(), context, preferencesResId, this.getPreferenceScreen());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.addPreferencesFromResource(preferencesResId);
    }
}

