/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.fragment;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceManager;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.fragment.SettingsFragment;
import com.farmerbb.taskbar.util.U;

public class RecentAppsFragment
extends SettingsFragment
implements SharedPreferences.OnSharedPreferenceChangeListener {
    @Override
    protected void addPrefsToSanitize() {
        this.prefsToSanitize.put("sys_tray", R.bool.class);
    }

    @Override
    protected void loadPrefs() {
        this.addPreferencesFromResource(R.xml.tb_pref_recent_apps);
        this.findPreference("enable_recents").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.findPreference("max_num_of_recents").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.findPreference("refresh_frequency").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        if (this.showRunningAppsOnly()) {
            ListPreference recentsAmountPref = (ListPreference)this.findPreference("recents_amount");
            recentsAmountPref.setEntries((CharSequence[])this.getResources().getStringArray(R.array.tb_pref_recents_amount_alt));
            recentsAmountPref.setEntryValues((CharSequence[])this.getResources().getStringArray(R.array.tb_pref_recents_amount_values_alt));
            SharedPreferences pref = U.getSharedPreferences((Context)this.getActivity());
            if ("running_apps_only".equals(pref.getString("recents_amount", "past_day"))) {
                ListPreference sortOrderPref = (ListPreference)this.findPreference("sort_order");
                sortOrderPref.setEntries((CharSequence[])this.getResources().getStringArray(R.array.tb_pref_sort_order_alt));
                sortOrderPref.setEntryValues((CharSequence[])this.getResources().getStringArray(R.array.tb_pref_sort_order_values_alt));
            }
        }
        this.bindPreferenceSummaryToValue(this.findPreference("recents_amount"));
        this.bindPreferenceSummaryToValue(this.findPreference("sort_order"));
        this.bindPreferenceSummaryToValue(this.findPreference("disable_scrolling_list"));
        this.bindPreferenceSummaryToValue(this.findPreference("full_length"));
        this.bindPreferenceSummaryToValue(this.findPreference("centered_icons"));
        if (Build.VERSION.SDK_INT >= 23) {
            if (U.isAndroidTV((Context)this.getActivity())) {
                this.getPreferenceScreen().removePreference(this.findPreference("notification_count"));
            } else {
                this.findPreference("notification_count").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            }
            this.bindPreferenceSummaryToValue(this.findPreference("sys_tray"));
        } else {
            this.getPreferenceScreen().removePreference(this.findPreference("notification_count"));
            this.getPreferenceScreen().removePreference(this.findPreference("sys_tray"));
        }
        this.updateMaxNumOfRecents(false);
        this.updateRefreshFrequency(false);
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        AppCompatActivity activity = (AppCompatActivity)this.getActivity();
        activity.setTitle(R.string.tb_pref_header_recent_apps);
        ActionBar actionBar = activity.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
    }

    @Override
    @SuppressLint(value={"SetTextI18n"})
    @TargetApi(value=22)
    public boolean onPreferenceClick(Preference p) {
        SharedPreferences pref = U.getSharedPreferences((Context)this.getActivity());
        switch (p.getKey()) {
            case "enable_recents": {
                try {
                    this.startActivity(new Intent("android.settings.USAGE_ACCESS_SETTINGS"));
                }
                catch (ActivityNotFoundException e) {
                    this.showAndroidTVPermissionDialog(R.string.tb_enable_recent_apps_instructions_tv, () -> U.showErrorDialog((Context)this.getActivity(), "GET_USAGE_STATS"));
                }
                break;
            }
            case "max_num_of_recents": {
                int max = 26;
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
                LinearLayout dialogLayout = (LinearLayout)View.inflate((Context)this.getActivity(), (int)R.layout.tb_seekbar_pref, null);
                String value = pref.getString("max_num_of_recents", "10");
                final TextView textView = (TextView)dialogLayout.findViewById(R.id.seekbar_value);
                textView.setText((CharSequence)"0");
                SeekBar seekBar = (SeekBar)dialogLayout.findViewById(R.id.seekbar);
                seekBar.setMax(26);
                seekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

                    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                        if (progress == 26) {
                            textView.setText(R.string.tb_infinity);
                        } else {
                            textView.setText((CharSequence)Integer.toString(progress));
                        }
                    }

                    public void onStartTrackingTouch(SeekBar seekBar) {
                    }

                    public void onStopTrackingTouch(SeekBar seekBar) {
                    }
                });
                seekBar.setProgress(Integer.parseInt(value));
                TextView blurb = (TextView)dialogLayout.findViewById(R.id.blurb);
                blurb.setText(R.string.tb_num_of_recents_blurb);
                builder.setView((View)dialogLayout).setTitle(R.string.tb_pref_max_num_of_recents).setPositiveButton(R.string.tb_action_ok, (dialog, id2) -> {
                    int progress = seekBar.getProgress();
                    if (progress == 26) {
                        progress = Integer.MAX_VALUE;
                    }
                    pref.edit().putString("max_num_of_recents", Integer.toString(progress)).apply();
                    this.updateMaxNumOfRecents(true);
                }).setNegativeButton(R.string.tb_action_cancel, null);
                AlertDialog dialog3 = builder.create();
                dialog3.show();
                break;
            }
            case "refresh_frequency": {
                int max2 = 20;
                AlertDialog.Builder builder2 = new AlertDialog.Builder((Context)this.getActivity());
                LinearLayout dialogLayout2 = (LinearLayout)View.inflate((Context)this.getActivity(), (int)R.layout.tb_seekbar_pref, null);
                String value2 = pref.getString("refresh_frequency", "1");
                final TextView textView2 = (TextView)dialogLayout2.findViewById(R.id.seekbar_value);
                textView2.setText(R.string.tb_infinity);
                SeekBar seekBar2 = (SeekBar)dialogLayout2.findViewById(R.id.seekbar);
                seekBar2.setMax(20);
                seekBar2.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

                    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                        if (progress == 0) {
                            textView2.setText(R.string.tb_infinity);
                        } else {
                            textView2.setText((CharSequence)Double.toString((double)progress * 0.5));
                        }
                    }

                    public void onStartTrackingTouch(SeekBar seekBar) {
                    }

                    public void onStopTrackingTouch(SeekBar seekBar) {
                    }
                });
                seekBar2.setProgress((int)(Double.parseDouble(value2) * 2.0));
                TextView blurb2 = (TextView)dialogLayout2.findViewById(R.id.blurb);
                blurb2.setText(R.string.tb_refresh_frequency_blurb);
                builder2.setView((View)dialogLayout2).setTitle(R.string.tb_pref_title_recents_refresh_interval).setPositiveButton(R.string.tb_action_ok, (dialog2, id2) -> {
                    double progress = (double)seekBar2.getProgress() * 0.5;
                    pref.edit().putString("refresh_frequency", Double.toString(progress)).apply();
                    this.updateRefreshFrequency(true);
                }).setNegativeButton(R.string.tb_action_cancel, null);
                AlertDialog dialog22 = builder2.create();
                dialog22.show();
                break;
            }
            case "notification_count": {
                try {
                    this.startActivity(new Intent("android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS"));
                    break;
                }
                catch (ActivityNotFoundException e) {
                    U.showToast((Context)this.getActivity(), R.string.tb_lock_device_not_supported);
                }
            }
        }
        return super.onPreferenceClick(p);
    }

    private void updateMaxNumOfRecents(boolean restartTaskbar) {
        SharedPreferences pref = U.getSharedPreferences((Context)this.getActivity());
        int value = Integer.parseInt(pref.getString("max_num_of_recents", "10"));
        switch (value) {
            case 1: {
                this.findPreference("max_num_of_recents").setSummary(R.string.tb_max_num_of_recents_singular);
                break;
            }
            case 0x7FFFFFFF: {
                this.findPreference("max_num_of_recents").setSummary(R.string.tb_max_num_of_recents_unlimited);
                break;
            }
            default: {
                this.findPreference("max_num_of_recents").setSummary((CharSequence)this.getString(R.string.tb_max_num_of_recents, new Object[]{value}));
            }
        }
        if (restartTaskbar) {
            U.restartTaskbar((Context)this.getActivity());
        }
    }

    private void updateRefreshFrequency(boolean restartTaskbar) {
        SharedPreferences pref = U.getSharedPreferences((Context)this.getActivity());
        String value = pref.getString("refresh_frequency", "1");
        double doubleValue = Double.parseDouble(value);
        int intValue = (int)doubleValue;
        if (doubleValue == 0.0) {
            this.findPreference("refresh_frequency").setSummary(R.string.tb_refresh_frequency_continuous);
        } else if (doubleValue == 1.0) {
            this.findPreference("refresh_frequency").setSummary(R.string.tb_refresh_frequency_singular);
        } else if (doubleValue == (double)intValue) {
            this.findPreference("refresh_frequency").setSummary((CharSequence)this.getString(R.string.tb_refresh_frequency, new Object[]{Integer.toString(intValue)}));
        } else {
            this.findPreference("refresh_frequency").setSummary((CharSequence)this.getString(R.string.tb_refresh_frequency, new Object[]{value}));
        }
        if (restartTaskbar) {
            U.restartTaskbar((Context)this.getActivity());
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        if (this.showRunningAppsOnly()) {
            PreferenceManager.getDefaultSharedPreferences((Context)this.getActivity()).registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        }
    }

    public void onStop() {
        super.onStop();
        if (this.showRunningAppsOnly()) {
            PreferenceManager.getDefaultSharedPreferences((Context)this.getActivity()).unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        }
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        if (key.equals("recents_amount")) {
            boolean useAlt = sharedPreferences.getString(key, "past_day").equals("running_apps_only");
            ListPreference sortOrderPref = (ListPreference)this.findPreference("sort_order");
            sortOrderPref.setEntries((CharSequence[])this.getResources().getStringArray(useAlt ? R.array.tb_pref_sort_order_alt : R.array.tb_pref_sort_order));
            sortOrderPref.setEntryValues((CharSequence[])this.getResources().getStringArray(useAlt ? R.array.tb_pref_sort_order_values_alt : R.array.tb_pref_sort_order_values));
            String sortOrderValue = sharedPreferences.getString("sort_order", "false");
            if (useAlt && sortOrderValue.startsWith("most_used_")) {
                sharedPreferences.edit().putString("sort_order", sortOrderValue.replace("most_used_", "")).apply();
            }
        }
    }

    private boolean showRunningAppsOnly() {
        return Build.VERSION.SDK_INT >= 23 && U.isSystemApp((Context)this.getActivity());
    }

    private void showAndroidTVPermissionDialog(int message, Runnable onError) {
        if (!U.hasAndroidTVSettings((Context)this.getActivity())) {
            onError.run();
            return;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.tb_permission_dialog_title).setMessage(message).setPositiveButton(R.string.tb_action_open_settings, (dialog, which) -> {
            try {
                this.startActivity(new Intent("android.settings.MANAGE_APPLICATIONS_SETTINGS"));
            }
            catch (ActivityNotFoundException e) {
                onError.run();
            }
        }).setNegativeButton(R.string.tb_action_cancel, null);
        AlertDialog dialog2 = builder.create();
        dialog2.show();
    }
}

