/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.fragment;

import android.annotation.TargetApi;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.preference.Preference;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.activity.BackupRestoreActivity;
import com.farmerbb.taskbar.fragment.SettingsFragment;
import com.farmerbb.taskbar.util.U;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class ManageAppDataFragment
extends SettingsFragment {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-kkmmss", Locale.US);

    @Override
    protected void loadPrefs() {
        this.addPreferencesFromResource(R.xml.tb_pref_manage_app_data);
        this.findPreference("backup_settings").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.findPreference("restore_settings").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.findPreference("clear_pinned_apps").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        AppCompatActivity activity = (AppCompatActivity)this.getActivity();
        activity.setTitle(R.string.tb_manage_app_data);
        ActionBar actionBar = activity.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
    }

    @Override
    @TargetApi(value=26)
    public boolean onPreferenceClick(Preference p) {
        switch (p.getKey()) {
            case "backup_settings": {
                Intent intent = new Intent("android.intent.action.CREATE_DOCUMENT");
                intent.addCategory("android.intent.category.OPENABLE");
                intent.setType("*/*");
                intent.putExtra("android.intent.extra.TITLE", "Taskbar-" + this.dateFormat.format(new Date()) + ".bak");
                try {
                    this.startActivityForResult(intent, 123);
                }
                catch (ActivityNotFoundException e) {
                    U.showToastLong((Context)this.getActivity(), R.string.tb_backup_restore_not_available);
                }
                break;
            }
            case "restore_settings": {
                Intent intent2 = new Intent("android.intent.action.OPEN_DOCUMENT");
                intent2.addCategory("android.intent.category.OPENABLE");
                intent2.setType("*/*");
                try {
                    this.startActivityForResult(intent2, 456);
                    break;
                }
                catch (ActivityNotFoundException e) {
                    U.showToastLong((Context)this.getActivity(), R.string.tb_backup_restore_not_available);
                }
            }
        }
        return super.onPreferenceClick(p);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent resultData) {
        int performBackupRestore = 789;
        if (requestCode == performBackupRestore) {
            U.showToastLong((Context)this.getActivity(), resultCode);
            return;
        }
        if (resultCode != -1 || resultData == null) {
            return;
        }
        Intent intent = new Intent((Context)this.getActivity(), BackupRestoreActivity.class);
        intent.putExtra("request_code", requestCode);
        intent.putExtra("uri", (Parcelable)resultData.getData());
        this.startActivityForResult(intent, performBackupRestore);
    }
}

