/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.fragment;

import android.annotation.TargetApi;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.preference.Preference;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.activity.SelectAppActivity;
import com.farmerbb.taskbar.fragment.SettingsFragment;
import com.farmerbb.taskbar.util.Blacklist;
import com.farmerbb.taskbar.util.TopApps;
import com.farmerbb.taskbar.util.U;

public class GeneralFragment
extends SettingsFragment {
    @Override
    protected void loadPrefs() {
        this.addPreferencesFromResource(R.xml.tb_pref_general);
        this.findPreference("blacklist").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        if (U.isLibrary((Context)this.getActivity()) || U.isAndroidTV((Context)this.getActivity())) {
            this.getPreferenceScreen().removePreference(this.findPreference("notification_settings"));
            if (!U.isAndroidTV((Context)this.getActivity())) {
                this.getPreferenceScreen().removePreference(this.findPreference("start_on_boot"));
            }
        } else {
            this.findPreference("notification_settings").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        }
        if (U.canEnableFreeform() && !U.isChromeOs((Context)this.getActivity()) && !U.isOverridingFreeformHack((Context)this.getActivity(), false)) {
            this.findPreference("hide_taskbar").setSummary(R.string.tb_hide_taskbar_disclaimer);
        }
        this.bindPreferenceSummaryToValue(this.findPreference("start_menu_layout"));
        this.bindPreferenceSummaryToValue(this.findPreference("scrollbar"));
        this.bindPreferenceSummaryToValue(this.findPreference("position"));
        this.bindPreferenceSummaryToValue(this.findPreference("anchor"));
        this.bindPreferenceSummaryToValue(this.findPreference("alt_button_config"));
        this.bindPreferenceSummaryToValue(this.findPreference("show_search_bar"));
        this.bindPreferenceSummaryToValue(this.findPreference("hide_when_keyboard_shown"));
        if (U.isChromeOs((Context)this.getActivity())) {
            this.bindPreferenceSummaryToValue(this.findPreference("chrome_os_context_menu_fix"));
        } else {
            this.getPreferenceScreen().removePreference(this.findPreference("chrome_os_context_menu_fix"));
        }
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        AppCompatActivity activity = (AppCompatActivity)this.getActivity();
        activity.setTitle(R.string.tb_pref_header_general);
        ActionBar actionBar = activity.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        int size = Blacklist.getInstance((Context)this.getActivity()).getBlockedApps().size();
        String summary = size == 1 ? this.getString(R.string.tb_app_hidden) : this.getString(R.string.tb_apps_hidden, new Object[]{size});
        size = TopApps.getInstance((Context)this.getActivity()).getTopApps().size();
        summary = summary + "\n" + (size == 1 ? this.getString(R.string.tb_top_app) : this.getString(R.string.tb_top_apps, new Object[]{size}));
        Preference blacklistPref = this.findPreference("blacklist");
        if (blacklistPref != null) {
            blacklistPref.setSummary((CharSequence)summary);
        }
    }

    @Override
    @TargetApi(value=26)
    public boolean onPreferenceClick(Preference p) {
        switch (p.getKey()) {
            case "blacklist": {
                Intent intent = U.getThemedIntent((Context)this.getActivity(), SelectAppActivity.class);
                this.startActivity(intent);
                break;
            }
            case "notification_settings": {
                Intent intent2 = new Intent();
                intent2.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
                if (Build.VERSION.SDK_INT > 25) {
                    intent2.putExtra("android.provider.extra.APP_PACKAGE", this.getActivity().getPackageName());
                } else {
                    intent2.putExtra("app_package", this.getActivity().getPackageName());
                    intent2.putExtra("app_uid", this.getActivity().getApplicationInfo().uid);
                }
                try {
                    this.startActivity(intent2);
                    this.restartNotificationService = true;
                    break;
                }
                catch (ActivityNotFoundException activityNotFoundException) {
                    // empty catch block
                }
            }
        }
        return super.onPreferenceClick(p);
    }
}

