/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.fragment;

import android.annotation.TargetApi;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.provider.Settings;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.fragment.SettingsFragment;
import com.farmerbb.taskbar.helper.FreeformHackHelper;
import com.farmerbb.taskbar.util.U;

public class FreeformModeFragment
extends SettingsFragment {
    private BroadcastReceiver checkBoxReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            CheckBoxPreference preference = (CheckBoxPreference)FreeformModeFragment.this.findPreference("freeform_hack");
            if (preference != null) {
                SharedPreferences pref = U.getSharedPreferences((Context)FreeformModeFragment.this.getActivity());
                preference.setChecked(pref.getBoolean("freeform_hack", false));
            }
        }
    };

    @Override
    protected void loadPrefs() {
        boolean lockFreeformToggle;
        this.addPreferencesFromResource(R.xml.tb_pref_freeform_hack);
        this.findPreference("freeform_hack").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.findPreference("window_size").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        boolean enableFreeformModeShortcut = U.enableFreeformModeShortcut((Context)this.getActivity());
        if (enableFreeformModeShortcut) {
            this.findPreference("add_shortcut").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        } else {
            this.getPreferenceScreen().removePreference(this.findPreference("add_shortcut"));
        }
        this.bindPreferenceSummaryToValue(this.findPreference("window_size"));
        SharedPreferences pref = U.getSharedPreferences((Context)this.getActivity());
        boolean isLibrary = U.isLibrary((Context)this.getActivity());
        boolean freeformHackEnabled = pref.getBoolean("freeform_hack", false);
        boolean bl = lockFreeformToggle = pref.getBoolean("desktop_mode", false) || freeformHackEnabled && U.isChromeOs((Context)this.getActivity()) || isLibrary;
        if (!lockFreeformToggle) {
            this.findPreference("save_window_sizes").setDependency("freeform_hack");
            this.findPreference("force_new_window").setDependency("freeform_hack");
            this.findPreference("launch_games_fullscreen").setDependency("freeform_hack");
            this.findPreference("window_size").setDependency("freeform_hack");
            if (enableFreeformModeShortcut) {
                this.findPreference("add_shortcut").setDependency("freeform_hack");
            }
        } else {
            ((CheckBoxPreference)this.findPreference("freeform_hack")).setChecked(true);
            pref.edit().putBoolean("freeform_hack", freeformHackEnabled).apply();
        }
        if (!isLibrary) {
            this.findPreference("freeform_hack").setEnabled(!lockFreeformToggle);
        } else {
            this.getPreferenceScreen().removePreference(this.findPreference("freeform_hack"));
        }
        if (U.isSamsungDevice() && !pref.getBoolean("samsung_dialog_shown", false)) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
            builder.setTitle(R.string.tb_samsung_freeform_title).setMessage(R.string.tb_samsung_freeform_message).setPositiveButton(R.string.tb_action_ok, (dialog, which) -> pref.edit().putBoolean("samsung_dialog_shown", true).apply());
            AlertDialog dialog2 = builder.create();
            dialog2.show();
            dialog2.setCancelable(false);
        }
        U.registerReceiver((Context)this.getActivity(), this.checkBoxReceiver, "com.farmerbb.taskbar.UPDATE_FREEFORM_CHECKBOX");
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        AppCompatActivity activity = (AppCompatActivity)this.getActivity();
        activity.setTitle(R.string.tb_pref_header_freeform);
        ActionBar actionBar = activity.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.showReminderToast) {
            this.showReminderToast = false;
            this.freeformSetupComplete();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        U.unregisterReceiver((Context)this.getActivity(), this.checkBoxReceiver);
    }

    @Override
    @TargetApi(value=24)
    public boolean onPreferenceClick(Preference p) {
        SharedPreferences pref = U.getSharedPreferences((Context)this.getActivity());
        switch (p.getKey()) {
            case "freeform_hack": {
                if (((CheckBoxPreference)p).isChecked()) {
                    if (!U.hasFreeformSupport((Context)this.getActivity())) {
                        try {
                            Settings.Global.putInt((ContentResolver)this.getActivity().getContentResolver(), (String)"enable_freeform_support", (int)1);
                            U.showToastLong((Context)this.getActivity(), R.string.tb_reboot_required);
                        }
                        catch (Exception e) {
                            ((CheckBoxPreference)p).setChecked(false);
                            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
                            if (Build.VERSION.SDK_INT > 25 && Build.VERSION.SDK_INT <= 28) {
                                builder.setTitle(R.string.tb_freeform_dialog_title).setMessage(R.string.tb_freeform_dialog_message_alt).setPositiveButton(R.string.tb_action_continue, (dialogInterface, i) -> this.freeformSetupComplete());
                            } else {
                                String settingName = this.getString(R.string.tb_force_activities_resizable);
                                builder.setTitle(R.string.tb_freeform_dialog_title).setMessage((CharSequence)this.getString(R.string.tb_freeform_dialog_message, new Object[]{settingName})).setPositiveButton(R.string.tb_action_developer_options, (dialogInterface, i) -> {
                                    this.showReminderToast = true;
                                    Intent intent = new Intent("android.settings.APPLICATION_DEVELOPMENT_SETTINGS");
                                    try {
                                        this.startActivity(intent);
                                        U.showToast((Context)this.getActivity(), this.getString(R.string.tb_enable_force_activities_resizable, new Object[]{settingName}), 1);
                                    }
                                    catch (ActivityNotFoundException e1) {
                                        intent = new Intent("android.settings.DEVICE_INFO_SETTINGS");
                                        try {
                                            this.startActivity(intent);
                                            U.showToastLong((Context)this.getActivity(), R.string.tb_enable_developer_options);
                                        }
                                        catch (ActivityNotFoundException activityNotFoundException) {
                                            // empty catch block
                                        }
                                    }
                                });
                            }
                            AlertDialog dialog = builder.create();
                            dialog.show();
                            dialog.setCancelable(false);
                        }
                    }
                    if (pref.getBoolean("taskbar_active", false) && !FreeformHackHelper.getInstance().isFreeformHackActive()) {
                        U.startFreeformHack((Context)this.getActivity(), true);
                    }
                } else {
                    U.stopFreeformHack((Context)this.getActivity());
                    U.sendBroadcast((Context)this.getActivity(), "com.farmerbb.taskbar.FORCE_TASKBAR_RESTART");
                }
                U.restartNotificationService((Context)this.getActivity());
                U.sendBroadcast((Context)this.getActivity(), "com.farmerbb.taskbar.FREEFORM_PREF_CHANGED");
                break;
            }
            case "add_shortcut": {
                U.pinAppShortcut((Context)this.getActivity());
                break;
            }
            case "window_size": {
                if (!U.hasBrokenSetLaunchBoundsApi()) break;
                U.showToastLong((Context)this.getActivity(), R.string.tb_window_sizes_not_available);
            }
        }
        return super.onPreferenceClick(p);
    }

    private void freeformSetupComplete() {
        ((CheckBoxPreference)this.findPreference("freeform_hack")).setChecked(U.hasFreeformSupport((Context)this.getActivity()));
        if (U.hasFreeformSupport((Context)this.getActivity())) {
            U.showToastLong((Context)this.getActivity(), R.string.tb_reboot_required);
        }
    }
}

