/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.fragment;

import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.hardware.display.DisplayManager;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.ListPreference;
import android.preference.Preference;
import android.provider.Settings;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.activity.EnableAdditionalSettingsActivity;
import com.farmerbb.taskbar.activity.HSLActivity;
import com.farmerbb.taskbar.activity.HSLConfigActivity;
import com.farmerbb.taskbar.activity.SecondaryHomeActivity;
import com.farmerbb.taskbar.fragment.SettingsFragment;
import com.farmerbb.taskbar.helper.LauncherHelper;
import com.farmerbb.taskbar.util.DisplayInfo;
import com.farmerbb.taskbar.util.U;

public class DesktopModeFragment
extends SettingsFragment {
    public static boolean isConfiguringHomeApp;
    private boolean isConfiguringDeveloperOptions;
    private boolean updateAdditionalSettings;
    private DisplayManager.DisplayListener listener = new DisplayManager.DisplayListener(){

        public void onDisplayAdded(int displayId) {
            DesktopModeFragment.this.updateAdditionalSettings();
        }

        public void onDisplayChanged(int displayId) {
            DesktopModeFragment.this.updateAdditionalSettings();
        }

        public void onDisplayRemoved(int displayId) {
            DesktopModeFragment.this.updateAdditionalSettings();
        }
    };

    @Override
    protected void loadPrefs() {
        this.addPreferencesFromResource(R.xml.tb_pref_desktop_mode);
        this.findPreference("desktop_mode").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.findPreference("set_launcher_default").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.findPreference("primary_launcher").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.findPreference("dim_screen").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.findPreference("enable_additional_settings").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        SharedPreferences pref = U.getSharedPreferences((Context)this.getActivity());
        if (pref.getBoolean("launcher", false)) {
            this.findPreference("desktop_mode").setEnabled(false);
            U.showToastLong((Context)this.getActivity(), R.string.tb_disable_home_setting);
        } else {
            this.bindPreferenceSummaryToValue(this.findPreference("desktop_mode"));
        }
        this.bindPreferenceSummaryToValue(this.findPreference("display_density"));
        DisplayManager manager = (DisplayManager)this.getActivity().getSystemService("display");
        manager.registerDisplayListener(this.listener, null);
        this.updateAdditionalSettings();
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        AppCompatActivity activity = (AppCompatActivity)this.getActivity();
        activity.setTitle(R.string.tb_pref_header_desktop_mode);
        ActionBar actionBar = activity.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
    }

    @Override
    public void onResume() {
        Preference primaryLauncherPref;
        super.onResume();
        if (this.updateAdditionalSettings) {
            this.updateAdditionalSettings = false;
            this.updateAdditionalSettings();
        }
        if (isConfiguringHomeApp) {
            isConfiguringHomeApp = false;
            if (this.showReminderToast) {
                this.showReminderToast = false;
                this.desktopModeSetupComplete();
            } else {
                this.startStopDesktopMode(true);
            }
        }
        if (this.isConfiguringDeveloperOptions && !isConfiguringHomeApp) {
            this.isConfiguringDeveloperOptions = false;
            boolean desktopModeEnabled = U.isDesktopModePrefEnabled((Context)this.getActivity());
            ((CheckBoxPreference)this.findPreference("desktop_mode")).setChecked(desktopModeEnabled);
            this.handleDesktopModePrefChange(desktopModeEnabled);
            if (desktopModeEnabled) {
                this.showReminderToast = true;
                this.configureHomeApp();
            }
        }
        if ((primaryLauncherPref = this.findPreference("primary_launcher")) != null) {
            SharedPreferences pref = U.getSharedPreferences((Context)this.getActivity());
            String primaryLauncherName = pref.getString("hsl_name", "null");
            String primaryLauncherPackage = pref.getString("hsl_id", "null");
            boolean primaryLauncherValid = true;
            try {
                this.getActivity().getPackageManager().getPackageInfo(primaryLauncherPackage, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                primaryLauncherValid = false;
            }
            primaryLauncherPref.setSummary((CharSequence)(primaryLauncherValid ? primaryLauncherName : this.getString(R.string.tb_icon_pack_none)));
        }
    }

    public void onDestroy() {
        DisplayManager manager = (DisplayManager)this.getActivity().getSystemService("display");
        manager.unregisterDisplayListener(this.listener);
        super.onDestroy();
    }

    @Override
    public boolean onPreferenceClick(Preference p) {
        switch (p.getKey()) {
            case "desktop_mode": {
                boolean isChecked = ((CheckBoxPreference)p).isChecked();
                if (isChecked && !U.isDesktopModePrefEnabled((Context)this.getActivity())) {
                    try {
                        Settings.Global.putInt((ContentResolver)this.getActivity().getContentResolver(), (String)"enable_freeform_support", (int)1);
                        Settings.Global.putInt((ContentResolver)this.getActivity().getContentResolver(), (String)"force_desktop_mode_on_external_displays", (int)1);
                        U.showToastLong((Context)this.getActivity(), R.string.tb_reboot_required);
                    }
                    catch (Exception e) {
                        ((CheckBoxPreference)p).setChecked(false);
                        isChecked = false;
                        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
                        builder.setTitle(R.string.tb_desktop_mode_dialog_title).setMessage(R.string.tb_desktop_mode_dialog_message).setPositiveButton(R.string.tb_action_developer_options, (dialogInterface, i) -> {
                            Intent intent = new Intent("android.settings.APPLICATION_DEVELOPMENT_SETTINGS");
                            try {
                                this.startActivity(intent);
                                this.isConfiguringDeveloperOptions = true;
                            }
                            catch (ActivityNotFoundException e1) {
                                intent = new Intent("android.settings.DEVICE_INFO_SETTINGS");
                                try {
                                    this.startActivity(intent);
                                    U.showToastLong((Context)this.getActivity(), R.string.tb_enable_developer_options);
                                }
                                catch (ActivityNotFoundException activityNotFoundException) {
                                    // empty catch block
                                }
                            }
                        });
                        AlertDialog dialog = builder.create();
                        dialog.show();
                        dialog.setCancelable(false);
                    }
                }
                this.handleDesktopModePrefChange(isChecked);
                break;
            }
            case "set_launcher_default": {
                this.configureHomeApp();
                break;
            }
            case "primary_launcher": {
                Intent intent = new Intent((Context)this.getActivity(), HSLConfigActivity.class);
                intent.putExtra("return_to_settings", true);
                this.startActivity(intent);
                break;
            }
            case "auto_hide_navbar_desktop_mode": {
                LauncherHelper helper = LauncherHelper.getInstance();
                if (!helper.isOnSecondaryHomeScreen((Context)this.getActivity())) break;
                U.showHideNavigationBar((Context)this.getActivity(), helper.getSecondaryDisplayId(), !((CheckBoxPreference)p).isChecked(), 0);
                break;
            }
            case "dim_screen": {
                if (((CheckBoxPreference)p).isChecked()) break;
                U.sendBroadcast((Context)this.getActivity(), "com.farmerbb.taskbar.FINISH_DIM_SCREEN_ACTIVITY");
                break;
            }
            case "enable_additional_settings": {
                this.updateAdditionalSettings = true;
                this.startActivity(U.getThemedIntent((Context)this.getActivity(), EnableAdditionalSettingsActivity.class));
            }
        }
        return super.onPreferenceClick(p);
    }

    private void startStopDesktopMode(boolean start) {
        if (!(start && U.isDesktopModeActive((Context)this.getActivity()) && U.launcherIsDefault((Context)this.getActivity()))) {
            U.sendBroadcast((Context)this.getActivity(), "com.farmerbb.taskbar.KILL_HOME_ACTIVITY");
        } else if (!LauncherHelper.getInstance().isOnSecondaryHomeScreen((Context)this.getActivity())) {
            U.showToastLong((Context)this.getActivity(), R.string.tb_desktop_mode_setup_complete);
        }
    }

    private void updateAdditionalSettings() {
        SharedPreferences pref = U.getSharedPreferences((Context)this.getActivity());
        this.updateAdditionalSettings(pref.getBoolean("desktop_mode", false));
    }

    private void updateAdditionalSettings(boolean desktopModeEnabled) {
        this.finishedLoadingPrefs = false;
        boolean enabled = desktopModeEnabled && U.hasWriteSecureSettingsPermission((Context)this.getActivity()) && U.isDesktopModeActive((Context)this.getActivity());
        this.findPreference("display_density").setEnabled(enabled);
        this.findPreference("auto_hide_navbar_desktop_mode").setEnabled(enabled);
        this.findPreference("auto_hide_navbar_desktop_mode").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        SharedPreferences pref = U.getSharedPreferences((Context)this.getActivity());
        DisplayInfo info = U.getExternalDisplayInfo((Context)this.getActivity());
        String densityPrefValue = info.currentDensity == info.defaultDensity ? "reset" : Integer.toString(info.currentDensity);
        pref.edit().putString("display_density", densityPrefValue).apply();
        CharSequence[] noDefaultList = this.getResources().getStringArray(R.array.tb_pref_display_density_list_alt);
        CharSequence[] noDefaultValues = this.getResources().getStringArray(R.array.tb_pref_display_density_list_values_alt);
        boolean useNoDefault = false;
        for (int i = 0; i < noDefaultValues.length; ++i) {
            if (info.defaultDensity != Integer.parseInt(noDefaultValues[i])) continue;
            noDefaultList[i] = this.getString(R.string.tb_density_default, new Object[]{info.defaultDensity});
            noDefaultValues[i] = "reset";
            useNoDefault = true;
            break;
        }
        ListPreference densityPref = (ListPreference)this.findPreference("display_density");
        if (useNoDefault) {
            densityPref.setEntries(noDefaultList);
            densityPref.setEntryValues(noDefaultValues);
        } else {
            densityPref.setEntries(R.array.tb_pref_display_density_list);
            densityPref.setEntryValues(R.array.tb_pref_display_density_list_values);
        }
        densityPref.setValue(densityPrefValue);
        this.bindPreferenceSummaryToValue((Preference)densityPref);
        if (densityPref.getSummary() == null || densityPref.getSummary().equals("")) {
            densityPref.setSummary((CharSequence)this.getString(R.string.tb_density_custom, new Object[]{info.currentDensity}));
        }
        this.finishedLoadingPrefs = true;
    }

    private void handleDesktopModePrefChange(boolean isChecked) {
        U.setComponentEnabled((Context)this.getActivity(), SecondaryHomeActivity.class, isChecked);
        U.setComponentEnabled((Context)this.getActivity(), HSLActivity.class, isChecked);
        this.startStopDesktopMode(isChecked);
        this.updateAdditionalSettings(isChecked);
    }

    private void configureHomeApp() {
        try {
            this.startActivity(new Intent("android.settings.HOME_SETTINGS"));
            isConfiguringHomeApp = true;
        }
        catch (ActivityNotFoundException e) {
            U.showToastLong((Context)this.getActivity(), R.string.tb_unable_to_set_default_home);
            this.showReminderToast = false;
        }
    }

    private void desktopModeSetupComplete() {
        boolean desktopModeEnabled = U.isDesktopModePrefEnabled((Context)this.getActivity());
        ((CheckBoxPreference)this.findPreference("desktop_mode")).setChecked(desktopModeEnabled);
        if (desktopModeEnabled) {
            U.showToastLong((Context)this.getActivity(), R.string.tb_reboot_required_alt);
        }
        this.updateAdditionalSettings();
    }
}

