/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.fragment;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.os.Bundle;
import android.preference.ListPreference;
import android.preference.Preference;
import android.view.View;
import android.widget.ScrollView;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.activity.IconPackActivity;
import com.farmerbb.taskbar.fragment.SettingsFragment;
import com.farmerbb.taskbar.util.U;

public class AppearanceFragment
extends SettingsFragment {
    private int alpha;
    private int red;
    private int green;
    private int blue;

    @Override
    protected void loadPrefs() {
        SharedPreferences pref = U.getSharedPreferences((Context)this.getActivity());
        if (pref.getString("start_button_image", "null").equals("null")) {
            pref.edit().putString("start_button_image", U.getDefaultStartButtonImage((Context)this.getActivity())).apply();
        }
        this.addPreferencesFromResource(R.xml.tb_pref_appearance);
        this.findPreference("icon_pack_list").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.findPreference("reset_colors").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.findPreference("background_tint_pref").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.findPreference("accent_color_pref").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        if (U.isBlissOs((Context)this.getActivity())) {
            ((ListPreference)this.findPreference("start_button_image")).setEntries(R.array.tb_pref_start_button_image_list_alt);
        }
        this.bindPreferenceSummaryToValue(this.findPreference("theme"));
        this.bindPreferenceSummaryToValue(this.findPreference("invisible_button"));
        this.bindPreferenceSummaryToValue(this.findPreference("start_button_image"));
        this.bindPreferenceSummaryToValue(this.findPreference("icon_pack_use_mask"));
        this.bindPreferenceSummaryToValue(this.findPreference("visual_feedback"));
        this.bindPreferenceSummaryToValue(this.findPreference("shortcut_icon"));
        this.bindPreferenceSummaryToValue(this.findPreference("transparent_start_menu"));
        this.bindPreferenceSummaryToValue(this.findPreference("hide_icon_labels"));
        this.findPreference("background_tint_pref").setSummary((CharSequence)("#" + String.format("%08x", U.getBackgroundTint((Context)this.getActivity())).toUpperCase()));
        this.findPreference("accent_color_pref").setSummary((CharSequence)("#" + String.format("%08x", U.getAccentColor((Context)this.getActivity())).toUpperCase()));
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        AppCompatActivity activity = (AppCompatActivity)this.getActivity();
        activity.setTitle(R.string.tb_pref_header_appearance);
        ActionBar actionBar = activity.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        Preference iconPackListPref = this.findPreference("icon_pack_list");
        if (iconPackListPref != null) {
            SharedPreferences pref = U.getSharedPreferences((Context)this.getActivity());
            String iconPackPackage = pref.getString("icon_pack", this.getActivity().getPackageName());
            PackageManager pm = this.getActivity().getPackageManager();
            boolean iconPackValid = true;
            try {
                pm.getPackageInfo(iconPackPackage, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                iconPackValid = false;
            }
            if (!iconPackValid || iconPackPackage.equals(this.getActivity().getPackageName())) {
                iconPackListPref.setSummary((CharSequence)this.getString(R.string.tb_icon_pack_none));
            } else {
                try {
                    iconPackListPref.setSummary(pm.getApplicationLabel(pm.getApplicationInfo(iconPackPackage, 0)));
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean onPreferenceClick(Preference p) {
        SharedPreferences pref = U.getSharedPreferences((Context)this.getActivity());
        switch (p.getKey()) {
            case "icon_pack_list": {
                Intent intent = U.getThemedIntent((Context)this.getActivity(), IconPackActivity.class);
                this.startActivityForResult(intent, 123);
                break;
            }
            case "reset_colors": {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
                builder.setTitle(R.string.tb_reset_colors).setMessage(R.string.tb_are_you_sure).setNegativeButton(R.string.tb_action_cancel, null).setPositiveButton(R.string.tb_action_ok, (dialog, which) -> {
                    this.finishedLoadingPrefs = false;
                    pref.edit().remove("background_tint").remove("accent_color").apply();
                    this.findPreference("background_tint_pref").setSummary((CharSequence)("#" + String.format("%08x", U.getBackgroundTint((Context)this.getActivity())).toUpperCase()));
                    this.findPreference("accent_color_pref").setSummary((CharSequence)("#" + String.format("%08x", U.getAccentColor((Context)this.getActivity())).toUpperCase()));
                    this.finishedLoadingPrefs = true;
                    U.restartTaskbar((Context)this.getActivity());
                });
                AlertDialog dialog2 = builder.create();
                dialog2.show();
                break;
            }
            case "background_tint_pref": {
                this.showColorPicker(ColorPickerType.BACKGROUND_TINT);
                break;
            }
            case "accent_color_pref": {
                this.showColorPicker(ColorPickerType.ACCENT_COLOR);
            }
        }
        return super.onPreferenceClick(p);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode != -1) {
            return;
        }
        if (requestCode == 123) {
            U.refreshPinnedIcons((Context)this.getActivity());
            U.restartTaskbar((Context)this.getActivity());
        }
        if (requestCode == 1001) {
            if (data.getData() == null) {
                return;
            }
            if (U.importImage((Context)this.getActivity(), data.getData(), "custom_image")) {
                U.restartTaskbar((Context)this.getActivity());
            }
        }
    }

    @SuppressLint(value={"SetTextI18n"})
    private void showColorPicker(ColorPickerType type) {
        int color2 = -1;
        int dialogTitle = -1;
        switch (type) {
            case BACKGROUND_TINT: {
                color2 = U.getBackgroundTint((Context)this.getActivity());
                dialogTitle = R.string.tb_pref_title_background_tint;
                break;
            }
            case ACCENT_COLOR: {
                color2 = U.getAccentColor((Context)this.getActivity());
                dialogTitle = R.string.tb_pref_title_accent_color;
            }
        }
        this.alpha = Color.alpha((int)color2);
        this.red = Color.red((int)color2);
        this.green = Color.green((int)color2);
        this.blue = Color.blue((int)color2);
        ScrollView dialogLayout = (ScrollView)View.inflate((Context)this.getActivity(), (int)R.layout.tb_color_picker_pref, null);
        final View colorPreview = dialogLayout.findViewById(R.id.color_preview);
        colorPreview.setBackgroundColor(Color.argb((int)this.alpha, (int)this.red, (int)this.green, (int)this.blue));
        final TextView hexPreview = (TextView)dialogLayout.findViewById(R.id.hex_preview);
        hexPreview.setText((CharSequence)("#" + String.format("%08x", Color.argb((int)this.alpha, (int)this.red, (int)this.green, (int)this.blue)).toUpperCase()));
        final TextView alphaValue = (TextView)dialogLayout.findViewById(R.id.alpha_value);
        alphaValue.setText((CharSequence)"0");
        SeekBar alphaSeekBar = (SeekBar)dialogLayout.findViewById(R.id.alpha_seekbar);
        alphaSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                AppearanceFragment.this.alpha = progress;
                alphaValue.setText((CharSequence)Integer.toString(AppearanceFragment.this.alpha));
                colorPreview.setBackgroundColor(Color.argb((int)AppearanceFragment.this.alpha, (int)AppearanceFragment.this.red, (int)AppearanceFragment.this.green, (int)AppearanceFragment.this.blue));
                hexPreview.setText((CharSequence)("#" + String.format("%08x", Color.argb((int)AppearanceFragment.this.alpha, (int)AppearanceFragment.this.red, (int)AppearanceFragment.this.green, (int)AppearanceFragment.this.blue)).toUpperCase()));
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        alphaSeekBar.setProgress(Color.alpha((int)color2));
        final TextView redValue = (TextView)dialogLayout.findViewById(R.id.red_value);
        redValue.setText((CharSequence)"0");
        SeekBar redSeekBar = (SeekBar)dialogLayout.findViewById(R.id.red_seekbar);
        redSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                AppearanceFragment.this.red = progress;
                redValue.setText((CharSequence)Integer.toString(AppearanceFragment.this.red));
                colorPreview.setBackgroundColor(Color.argb((int)AppearanceFragment.this.alpha, (int)AppearanceFragment.this.red, (int)AppearanceFragment.this.green, (int)AppearanceFragment.this.blue));
                hexPreview.setText((CharSequence)("#" + String.format("%08x", Color.argb((int)AppearanceFragment.this.alpha, (int)AppearanceFragment.this.red, (int)AppearanceFragment.this.green, (int)AppearanceFragment.this.blue)).toUpperCase()));
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        redSeekBar.setProgress(Color.red((int)color2));
        final TextView greenValue = (TextView)dialogLayout.findViewById(R.id.green_value);
        greenValue.setText((CharSequence)"0");
        SeekBar greenSeekBar = (SeekBar)dialogLayout.findViewById(R.id.green_seekbar);
        greenSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                AppearanceFragment.this.green = progress;
                greenValue.setText((CharSequence)Integer.toString(AppearanceFragment.this.green));
                colorPreview.setBackgroundColor(Color.argb((int)AppearanceFragment.this.alpha, (int)AppearanceFragment.this.red, (int)AppearanceFragment.this.green, (int)AppearanceFragment.this.blue));
                hexPreview.setText((CharSequence)("#" + String.format("%08x", Color.argb((int)AppearanceFragment.this.alpha, (int)AppearanceFragment.this.red, (int)AppearanceFragment.this.green, (int)AppearanceFragment.this.blue)).toUpperCase()));
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        greenSeekBar.setProgress(Color.green((int)color2));
        final TextView blueValue = (TextView)dialogLayout.findViewById(R.id.blue_value);
        blueValue.setText((CharSequence)"0");
        SeekBar blueSeekBar = (SeekBar)dialogLayout.findViewById(R.id.blue_seekbar);
        blueSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                AppearanceFragment.this.blue = progress;
                blueValue.setText((CharSequence)Integer.toString(AppearanceFragment.this.blue));
                colorPreview.setBackgroundColor(Color.argb((int)AppearanceFragment.this.alpha, (int)AppearanceFragment.this.red, (int)AppearanceFragment.this.green, (int)AppearanceFragment.this.blue));
                hexPreview.setText((CharSequence)("#" + String.format("%08x", Color.argb((int)AppearanceFragment.this.alpha, (int)AppearanceFragment.this.red, (int)AppearanceFragment.this.green, (int)AppearanceFragment.this.blue)).toUpperCase()));
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        blueSeekBar.setProgress(Color.blue((int)color2));
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        builder.setView((View)dialogLayout).setTitle(dialogTitle).setPositiveButton(R.string.tb_action_ok, (dialog, which) -> {
            String preferenceId = null;
            switch (type) {
                case BACKGROUND_TINT: {
                    preferenceId = "background_tint";
                    break;
                }
                case ACCENT_COLOR: {
                    preferenceId = "accent_color";
                }
            }
            SharedPreferences pref = U.getSharedPreferences((Context)this.getActivity());
            pref.edit().putInt(preferenceId, Color.argb((int)this.alpha, (int)this.red, (int)this.green, (int)this.blue)).apply();
            this.findPreference(preferenceId + "_pref").setSummary((CharSequence)("#" + String.format("%08x", Color.argb((int)this.alpha, (int)this.red, (int)this.green, (int)this.blue)).toUpperCase()));
            U.restartTaskbar((Context)this.getActivity());
        }).setNegativeButton(R.string.tb_action_cancel, null);
        AlertDialog dialog2 = builder.create();
        dialog2.show();
    }

    private static enum ColorPickerType {
        BACKGROUND_TINT,
        ACCENT_COLOR;

    }
}

