/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.fragment;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.LinearLayout;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.activity.HomeActivity;
import com.farmerbb.taskbar.activity.KeyboardShortcutActivity;
import com.farmerbb.taskbar.activity.KeyboardShortcutActivityLockDevice;
import com.farmerbb.taskbar.activity.NavigationBarButtonsActivity;
import com.farmerbb.taskbar.fragment.ManageAppDataFragment;
import com.farmerbb.taskbar.fragment.SettingsFragment;
import com.farmerbb.taskbar.util.DependencyUtils;
import com.farmerbb.taskbar.util.U;

public class AdvancedFragment
extends SettingsFragment {
    boolean secondScreenPrefEnabled = false;
    private BroadcastReceiver homeToggleReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            SharedPreferences pref = U.getSharedPreferences((Context)AdvancedFragment.this.getActivity());
            CheckBoxPreference checkBox = (CheckBoxPreference)AdvancedFragment.this.findPreference("launcher");
            checkBox.setChecked(pref.getBoolean("launcher", false));
        }
    };

    @Override
    protected void addPrefsToSanitize() {
        this.prefsToSanitize.put("dashboard", R.bool.class);
    }

    @Override
    protected void loadPrefs() {
        boolean lockHomeToggle;
        this.addPreferencesFromResource(R.xml.tb_pref_advanced);
        this.findPreference("dashboard_grid_size").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.findPreference("keyboard_shortcut").setSummary(DependencyUtils.getKeyboardShortcutSummary((Context)this.getActivity()));
        boolean isLibrary = U.isLibrary((Context)this.getActivity());
        boolean isAndroidx86 = this.getActivity().getPackageName().equals("com.farmerbb.taskbar.androidx86");
        SharedPreferences pref = U.getSharedPreferences((Context)this.getActivity());
        boolean bl = lockHomeToggle = pref.getBoolean("launcher", false) && U.isLauncherPermanentlyEnabled((Context)this.getActivity()) || pref.getBoolean("desktop_mode", false);
        if (isLibrary) {
            this.getPreferenceScreen().removePreference(this.findPreference("tasker_enabled"));
            this.getPreferenceScreen().removePreference(this.findPreference("launcher"));
            this.getPreferenceScreen().removePreference(this.findPreference("keyboard_shortcut"));
            this.getPreferenceScreen().removePreference(this.findPreference("navigation_bar_buttons"));
            this.getPreferenceScreen().removePreference(this.findPreference("manage_app_data"));
            this.findPreference("clear_pinned_apps").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        } else {
            this.findPreference("launcher").setEnabled(!lockHomeToggle);
            this.findPreference("launcher").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            this.findPreference("navigation_bar_buttons").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            this.findPreference("manage_app_data").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            if (!U.isChromeOs((Context)this.getActivity())) {
                this.findPreference("keyboard_shortcut").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            } else {
                this.getPreferenceScreen().removePreference(this.findPreference("keyboard_shortcut"));
            }
            this.getPreferenceScreen().removePreference(this.findPreference("clear_pinned_apps"));
        }
        if (!isAndroidx86 && !isLibrary && U.isPlayStoreInstalled((Context)this.getActivity()) && U.isPlayStoreRelease((Context)this.getActivity())) {
            this.findPreference("secondscreen").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            this.secondScreenPrefEnabled = true;
            if (U.isDesktopModeSupported((Context)this.getActivity())) {
                this.findPreference("secondscreen").setSummary(R.string.tb_pref_secondscreen_description_alt);
            }
        } else {
            this.getPreferenceScreen().removePreference(this.findPreference("secondscreen"));
        }
        this.bindPreferenceSummaryToValue(this.findPreference("dashboard"));
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        AppCompatActivity activity = (AppCompatActivity)this.getActivity();
        activity.setTitle(R.string.tb_pref_header_advanced);
        ActionBar actionBar = activity.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.secondScreenPrefEnabled) {
            this.findPreference("secondscreen").setTitle(U.getSecondScreenPackageName((Context)this.getActivity()) == null ? R.string.tb_pref_secondscreen_title_install : R.string.tb_pref_secondscreen_title_open);
        }
        this.updateDashboardGridSize(false);
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        U.registerReceiver((Context)this.getActivity(), this.homeToggleReceiver, "com.farmerbb.taskbar.LAUNCHER_PREF_CHANGED");
    }

    public void onDetach() {
        U.unregisterReceiver((Context)this.getActivity(), this.homeToggleReceiver);
        super.onDetach();
    }

    @Override
    @SuppressLint(value={"SetTextI18n"})
    public boolean onPreferenceClick(Preference p) {
        SharedPreferences pref = U.getSharedPreferences((Context)this.getActivity());
        switch (p.getKey()) {
            case "launcher": {
                if (U.canDrawOverlays((Context)this.getActivity())) {
                    U.setComponentEnabled((Context)this.getActivity(), HomeActivity.class, ((CheckBoxPreference)p).isChecked());
                } else {
                    U.showPermissionDialog((Context)this.getActivity());
                    ((CheckBoxPreference)p).setChecked(false);
                }
                if (((CheckBoxPreference)p).isChecked()) break;
                U.sendBroadcast((Context)this.getActivity(), "com.farmerbb.taskbar.KILL_HOME_ACTIVITY");
                break;
            }
            case "keyboard_shortcut": {
                U.setComponentEnabled((Context)this.getActivity(), KeyboardShortcutActivity.class, ((CheckBoxPreference)p).isChecked());
                if (Build.VERSION.SDK_INT < 28) break;
                U.setComponentEnabled((Context)this.getActivity(), KeyboardShortcutActivityLockDevice.class, ((CheckBoxPreference)p).isChecked());
                break;
            }
            case "dashboard_grid_size": {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
                LinearLayout dialogLayout = (LinearLayout)View.inflate((Context)this.getActivity(), (int)R.layout.tb_dashboard_size_dialog, null);
                int orientation = U.getDisplayOrientation((Context)this.getActivity());
                boolean isPortrait = orientation == 1;
                boolean isLandscape = orientation == 2;
                int editTextId = -1;
                int editText2Id = -1;
                if (isPortrait) {
                    editTextId = R.id.fragmentEditText2;
                    editText2Id = R.id.fragmentEditText1;
                }
                if (isLandscape) {
                    editTextId = R.id.fragmentEditText1;
                    editText2Id = R.id.fragmentEditText2;
                }
                EditText editText = (EditText)dialogLayout.findViewById(editTextId);
                EditText editText2 = (EditText)dialogLayout.findViewById(editText2Id);
                builder.setView((View)dialogLayout).setTitle(R.string.tb_dashboard_grid_size).setPositiveButton(R.string.tb_action_ok, (dialog, id2) -> {
                    boolean successfullyUpdated = false;
                    String widthString = editText.getText().toString();
                    String heightString = editText2.getText().toString();
                    if (widthString.length() > 0 && heightString.length() > 0) {
                        int width = Integer.parseInt(widthString);
                        int height = Integer.parseInt(heightString);
                        if (width > 0 && height > 0) {
                            SharedPreferences.Editor editor = pref.edit();
                            editor.putInt("dashboard_width", width);
                            editor.putInt("dashboard_height", height);
                            editor.putBoolean("dashboard_width" + this.isModified, true);
                            editor.putBoolean("dashboard_height" + this.isModified, true);
                            editor.apply();
                            this.updateDashboardGridSize(true);
                            successfullyUpdated = true;
                        }
                    }
                    if (!successfullyUpdated) {
                        U.showToast((Context)this.getActivity(), R.string.tb_invalid_grid_size);
                    }
                }).setNegativeButton(R.string.tb_action_cancel, null).setNeutralButton(R.string.tb_use_default, (dialog, id2) -> {
                    SharedPreferences.Editor editor = pref.edit();
                    editor.remove("dashboard_width");
                    editor.remove("dashboard_height");
                    editor.remove("dashboard_width" + this.isModified);
                    editor.remove("dashboard_height" + this.isModified);
                    editor.apply();
                    this.updateDashboardGridSize(true);
                });
                editText.setText((CharSequence)Integer.toString(U.getIntPrefWithDefault((Context)this.getActivity(), "dashboard_width")));
                editText2.setText((CharSequence)Integer.toString(U.getIntPrefWithDefault((Context)this.getActivity(), "dashboard_height")));
                AlertDialog dialog2 = builder.create();
                dialog2.show();
                new Handler().post(() -> {
                    InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
                    imm.showSoftInput((View)editText2, 1);
                });
                break;
            }
            case "navigation_bar_buttons": {
                Intent intent = U.getThemedIntent((Context)this.getActivity(), NavigationBarButtonsActivity.class);
                this.startActivity(intent);
                break;
            }
            case "secondscreen": {
                Intent intent2;
                PackageManager packageManager = this.getActivity().getPackageManager();
                String packageName = U.getSecondScreenPackageName((Context)this.getActivity());
                if (packageName == null) {
                    intent2 = new Intent("android.intent.action.VIEW");
                    intent2.setData(Uri.parse((String)"https://play.google.com/store/apps/details?id=com.farmerbb.secondscreen.free"));
                } else {
                    intent2 = packageManager.getLaunchIntentForPackage(packageName);
                }
                if (intent2 == null) break;
                intent2.setFlags(0x10000000);
                try {
                    this.startActivity(intent2);
                }
                catch (ActivityNotFoundException activityNotFoundException) {}
                break;
            }
            case "manage_app_data": {
                this.navigateTo(new ManageAppDataFragment());
            }
        }
        return super.onPreferenceClick(p);
    }

    private void updateDashboardGridSize(boolean restartTaskbar) {
        int width = U.getIntPrefWithDefault((Context)this.getActivity(), "dashboard_width");
        int height = U.getIntPrefWithDefault((Context)this.getActivity(), "dashboard_height");
        int orientation = U.getDisplayOrientation((Context)this.getActivity());
        boolean isPortrait = orientation == 1;
        boolean isLandscape = orientation == 2;
        int first = -1;
        int second = -1;
        if (isPortrait) {
            first = height;
            second = width;
        }
        if (isLandscape) {
            first = width;
            second = height;
        }
        this.findPreference("dashboard_grid_size").setSummary((CharSequence)this.getString(R.string.tb_dashboard_grid_description, new Object[]{first, second}));
        if (restartTaskbar) {
            U.restartTaskbar((Context)this.getActivity());
        }
    }
}

