/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.fragment;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.preference.Preference;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.activity.MainActivity;
import com.farmerbb.taskbar.fragment.AdvancedFragment;
import com.farmerbb.taskbar.fragment.AppearanceFragment;
import com.farmerbb.taskbar.fragment.DesktopModeFragment;
import com.farmerbb.taskbar.fragment.FreeformModeFragment;
import com.farmerbb.taskbar.fragment.GeneralFragment;
import com.farmerbb.taskbar.fragment.RecentAppsFragment;
import com.farmerbb.taskbar.fragment.SettingsFragment;
import com.farmerbb.taskbar.util.U;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Currency;
import java.util.Locale;
import java.util.TimeZone;

public class AboutFragment
extends SettingsFragment {
    private int noThanksCount = 0;

    @Override
    protected void loadPrefs() {
        this.addPreferencesFromResource(R.xml.tb_pref_base);
        this.addPreferencesFromResource(R.xml.tb_pref_about);
        boolean isLibrary = U.isLibrary((Context)this.getActivity());
        if (!isLibrary) {
            SharedPreferences pref = U.getSharedPreferences((Context)this.getActivity());
            if (this.getActivity().getPackageName().equals("com.farmerbb.taskbar") && U.isPlayStoreInstalled((Context)this.getActivity()) && U.isPlayStoreRelease((Context)this.getActivity()) && !U.isSystemApp((Context)this.getActivity()) && !pref.getBoolean("hide_donate", false)) {
                this.findPreference("donate").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            } else {
                this.getPreferenceScreen().removePreference(this.findPreference("donate_category"));
            }
        }
        if (U.canEnableFreeform()) {
            this.findPreference("pref_screen_freeform").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        } else {
            this.getPreferenceScreen().removePreference(this.findPreference("pref_screen_freeform"));
        }
        if (U.isDesktopModeSupported((Context)this.getActivity()) && !isLibrary) {
            this.findPreference("pref_screen_desktop_mode").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            this.findPreference("pref_screen_desktop_mode").setIcon(this.getDesktopModeDrawable());
        } else {
            this.getPreferenceScreen().removePreference(this.findPreference("pref_screen_desktop_mode"));
        }
        this.findPreference("pref_screen_general").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.findPreference("pref_screen_appearance").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.findPreference("pref_screen_recent_apps").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        this.findPreference("pref_screen_advanced").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
        if (!isLibrary) {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("America/Denver"));
            calendar.setTimeInMillis(1590989481094L);
            int year = calendar.get(1);
            if (U.isConsumerBuild((Context)this.getActivity())) {
                String emoji = new String(Character.toChars(128513));
                this.findPreference("about").setSummary((CharSequence)this.getString(R.string.tb_pref_about_description, new Object[]{year, emoji}));
                this.findPreference("about").setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            } else {
                this.findPreference("about").setSummary((CharSequence)this.getString(R.string.tb_pref_about_description_alt, new Object[]{year}));
            }
        }
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        AppCompatActivity activity = (AppCompatActivity)this.getActivity();
        activity.setTitle((CharSequence)((MainActivity)this.getActivity()).getAboutFragmentTitle());
        ActionBar actionBar = activity.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(((MainActivity)this.getActivity()).getAboutFragmentBackArrow());
        }
    }

    @Override
    public boolean onPreferenceClick(Preference p) {
        SharedPreferences pref = U.getSharedPreferences((Context)this.getActivity());
        switch (p.getKey()) {
            case "about": {
                U.checkForUpdates((Context)this.getActivity());
                break;
            }
            case "donate": {
                NumberFormat format = NumberFormat.getCurrencyInstance();
                format.setCurrency(Currency.getInstance(Locale.US));
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
                builder.setTitle(R.string.tb_pref_title_donate).setMessage((CharSequence)this.getString(R.string.tb_dialog_donate_message, new Object[]{format.format(1.99)})).setPositiveButton(R.string.tb_action_ok, (dialog, which) -> {
                    Intent intent2 = new Intent("android.intent.action.VIEW");
                    intent2.setData(Uri.parse((String)"https://play.google.com/store/apps/details?id=com.farmerbb.taskbar.paid"));
                    intent2.setFlags(0x10000000);
                    try {
                        this.startActivity(intent2);
                    }
                    catch (ActivityNotFoundException activityNotFoundException) {
                        // empty catch block
                    }
                }).setNegativeButton(this.noThanksCount == 2 ? R.string.tb_action_dont_show_again : R.string.tb_action_no_thanks, (dialog, which) -> {
                    ++this.noThanksCount;
                    if (this.noThanksCount == 3) {
                        pref.edit().putBoolean("hide_donate", true).apply();
                        this.getPreferenceScreen().removePreference(this.findPreference("donate_category"));
                    }
                });
                AlertDialog dialog2 = builder.create();
                dialog2.show();
                break;
            }
            case "pref_screen_general": {
                this.navigateTo(new GeneralFragment());
                break;
            }
            case "pref_screen_appearance": {
                this.navigateTo(new AppearanceFragment());
                break;
            }
            case "pref_screen_recent_apps": {
                this.navigateTo(new RecentAppsFragment());
                break;
            }
            case "pref_screen_freeform": {
                this.navigateTo(new FreeformModeFragment());
                break;
            }
            case "pref_screen_desktop_mode": {
                this.navigateTo(new DesktopModeFragment());
                break;
            }
            case "pref_screen_advanced": {
                this.navigateTo(new AdvancedFragment());
            }
        }
        return super.onPreferenceClick(p);
    }

    private Drawable getDesktopModeDrawable() {
        Drawable loadedIcon = ContextCompat.getDrawable((Context)this.getActivity(), (int)R.drawable.tb_desktop_mode);
        if (loadedIcon == null) {
            return null;
        }
        return U.resizeDrawable((Context)this.getActivity(), loadedIcon, R.dimen.tb_settings_icon_size);
    }
}

