/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.backup;

import com.farmerbb.taskbar.backup.BackupAgent;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONBackupAgent
implements BackupAgent {
    private JSONObject json;

    public JSONBackupAgent(JSONObject json) {
        this.json = json;
    }

    @Override
    public void putString(String key, String value) {
        try {
            this.json.put(key, (Object)value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public void putStringArray(String key, String[] value) {
        try {
            JSONArray array2 = new JSONArray();
            for (String v : value) {
                array2.put((Object)v);
            }
            this.json.put(key, (Object)array2);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public void putLongArray(String key, long[] value) {
        try {
            JSONArray array2 = new JSONArray();
            for (long v : value) {
                array2.put(v);
            }
            this.json.put(key, (Object)array2);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public String getString(String key) {
        try {
            return this.json.getString(key);
        }
        catch (JSONException e) {
            return null;
        }
    }

    @Override
    public String[] getStringArray(String key) {
        try {
            JSONArray array2 = this.json.getJSONArray(key);
            String[] returnValue = new String[array2.length()];
            for (int i = 0; i < array2.length(); ++i) {
                returnValue[i] = array2.getString(i);
            }
            return returnValue;
        }
        catch (JSONException e) {
            return null;
        }
    }

    @Override
    public long[] getLongArray(String key) {
        try {
            JSONArray array2 = this.json.getJSONArray(key);
            long[] returnValue = new long[array2.length()];
            for (int i = 0; i < array2.length(); ++i) {
                returnValue[i] = array2.getLong(i);
            }
            return returnValue;
        }
        catch (JSONException e) {
            return null;
        }
    }
}

