/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.adapter;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.util.SparseIntArray;
import android.view.LayoutInflater;
import android.view.PointerIcon;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.SectionIndexer;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.ColorUtils;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.helper.FreeformHackHelper;
import com.farmerbb.taskbar.util.AppEntry;
import com.farmerbb.taskbar.util.TopApps;
import com.farmerbb.taskbar.util.U;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StartMenuAdapter
extends ArrayAdapter<AppEntry>
implements SectionIndexer {
    private boolean isGrid;
    private final List<Character> sections = new ArrayList<Character>();
    private final SparseIntArray gpfsCache = new SparseIntArray();
    private final SparseIntArray gsfpCache = new SparseIntArray();
    private final Map<AppEntry, Boolean> topAppsCache = new HashMap<AppEntry, Boolean>();
    private final List<Character> lowercase = Arrays.asList(Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'));
    private final List<Character> uppercase = Arrays.asList(Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'));

    public StartMenuAdapter(Context context, int layout2, List<AppEntry> list) {
        super(context, layout2, list);
        this.isGrid = layout2 == R.layout.tb_row_alt;
        this.updateList(list, true);
    }

    @NonNull
    public View getView(int position, View convertView, @NonNull ViewGroup parent) {
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.getContext()).inflate(this.isGrid ? R.layout.tb_row_alt : R.layout.tb_row, parent, false);
            convertView.setBackgroundColor(0);
        }
        AppEntry entry = (AppEntry)this.getItem(position);
        assert (entry != null);
        SharedPreferences pref = U.getSharedPreferences(this.getContext());
        TextView textView = (TextView)convertView.findViewById(R.id.name);
        textView.setText((CharSequence)(pref.getBoolean("hide_icon_labels", false) ? "" : entry.getLabel()));
        textView.setTypeface(null, this.isTopApp(entry) ? 1 : 0);
        textView.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)(U.isDarkTheme(this.getContext()) ? R.color.tb_text_color_dark : R.color.tb_text_color)));
        ImageView imageView = (ImageView)convertView.findViewById(R.id.icon);
        imageView.setImageDrawable(entry.getIcon(this.getContext()));
        LinearLayout layout2 = (LinearLayout)convertView.findViewById(R.id.entry);
        layout2.setOnClickListener(view -> {
            U.sendBroadcast(this.getContext(), "com.farmerbb.taskbar.HIDE_START_MENU");
            U.launchApp(this.getContext(), entry, null, false, false, view);
        });
        layout2.setOnLongClickListener(view -> {
            int[] location = new int[2];
            view.getLocationOnScreen(location);
            this.openContextMenu(entry, location);
            return true;
        });
        boolean visualFeedbackEnabled = pref.getBoolean("visual_feedback", true);
        layout2.setOnGenericMotionListener((view, motionEvent) -> {
            int action = motionEvent.getAction();
            if (action == 11 && motionEvent.getButtonState() == 2) {
                int[] location = new int[2];
                view.getLocationOnScreen(location);
                this.openContextMenu(entry, location);
            }
            if (action == 8 && visualFeedbackEnabled) {
                view.setBackgroundColor(0);
            }
            return false;
        });
        if (visualFeedbackEnabled) {
            layout2.setOnHoverListener((v, event) -> {
                if (event.getAction() == 9) {
                    int backgroundTint = pref.getBoolean("transparent_start_menu", false) ? U.getAccentColor(this.getContext()) : U.getBackgroundTint(this.getContext());
                    backgroundTint = ColorUtils.setAlphaComponent((int)backgroundTint, (int)(Color.alpha((int)backgroundTint) / 2));
                    v.setBackgroundColor(backgroundTint);
                }
                if (event.getAction() == 10) {
                    v.setBackgroundColor(0);
                }
                if (Build.VERSION.SDK_INT >= 24) {
                    v.setPointerIcon(PointerIcon.getSystemIcon((Context)this.getContext(), (int)1000));
                }
                return false;
            });
        }
        if (pref.getBoolean("visual_feedback", true)) {
            layout2.setOnTouchListener((v, event) -> {
                v.setAlpha(event.getAction() == 0 || event.getAction() == 2 ? 0.5f : 1.0f);
                return false;
            });
        }
        return convertView;
    }

    private boolean isTopApp(AppEntry entry) {
        if (this.topAppsCache.containsKey(entry)) {
            return this.topAppsCache.get(entry);
        }
        Intent intent = new Intent();
        intent.setComponent(ComponentName.unflattenFromString((String)entry.getComponentName()));
        ActivityInfo activityInfo = intent.resolveActivityInfo(this.getContext().getPackageManager(), 0);
        if (activityInfo != null) {
            TopApps topApps = TopApps.getInstance(this.getContext());
            boolean isTopApp = topApps.isTopApp(activityInfo.packageName + "/" + activityInfo.name + ":" + entry.getUserId(this.getContext())) || topApps.isTopApp(activityInfo.packageName + "/" + activityInfo.name) || topApps.isTopApp(activityInfo.name);
            this.topAppsCache.put(entry, isTopApp);
            return isTopApp;
        }
        this.topAppsCache.put(entry, false);
        return false;
    }

    private void openContextMenu(AppEntry entry, int[] location) {
        U.sendBroadcast(this.getContext(), "com.farmerbb.taskbar.HIDE_START_MENU_NO_RESET");
        Bundle args = new Bundle();
        args.putSerializable("app_entry", (Serializable)entry);
        args.putBoolean("launched_from_start_menu", true);
        args.putInt("x", location[0]);
        args.putInt("y", location[1]);
        new Handler().postDelayed(() -> U.startContextMenuActivity(this.getContext(), args), this.shouldDelay() ? 100L : 0L);
    }

    private boolean shouldDelay() {
        return U.hasFreeformSupport(this.getContext()) && U.isFreeformModeEnabled(this.getContext()) && !FreeformHackHelper.getInstance().isFreeformHackActive();
    }

    public void updateList(List<AppEntry> list) {
        this.updateList(list, false);
    }

    private void updateList(List<AppEntry> list, boolean firstUpdate) {
        SharedPreferences pref;
        if (!firstUpdate) {
            this.clear();
            this.sections.clear();
            this.gsfpCache.clear();
            this.gpfsCache.clear();
            this.topAppsCache.clear();
            this.addAll(list);
        }
        if ((pref = U.getSharedPreferences(this.getContext())).getBoolean("scrollbar", false)) {
            for (AppEntry entry : list) {
                char firstLetter = this.getSectionForAppEntry(entry);
                if (this.sections.contains(Character.valueOf(firstLetter))) continue;
                this.sections.add(Character.valueOf(firstLetter));
            }
        }
    }

    private char getSectionForAppEntry(AppEntry entry) {
        if (this.isTopApp(entry)) {
            return '\u2605';
        }
        if (entry.getLabel().equals("")) {
            return ' ';
        }
        char origChar = entry.getLabel().charAt(0);
        if (this.uppercase.contains(Character.valueOf(origChar))) {
            return origChar;
        }
        if (this.lowercase.contains(Character.valueOf(origChar))) {
            return this.uppercase.get(this.lowercase.indexOf(Character.valueOf(origChar))).charValue();
        }
        return '#';
    }

    public int getPositionForSection(int section) {
        int cachedPos = this.gpfsCache.get(section, -1);
        if (cachedPos != -1) {
            return cachedPos;
        }
        for (int i = 0; i < this.getCount(); ++i) {
            if (this.sections.get(section).charValue() != this.getSectionForAppEntry((AppEntry)this.getItem(i))) continue;
            this.gpfsCache.put(section, i);
            return i;
        }
        this.gpfsCache.put(section, 0);
        return 0;
    }

    public int getSectionForPosition(int position) {
        int cachedSection = this.gsfpCache.get(position, -1);
        if (cachedSection != -1) {
            return cachedSection;
        }
        for (int i = 0; i < this.sections.size(); ++i) {
            if (this.sections.get(i).charValue() != this.getSectionForAppEntry((AppEntry)this.getItem(position))) continue;
            this.gsfpCache.put(position, i);
            return i;
        }
        this.gsfpCache.put(position, 0);
        return 0;
    }

    public Object[] getSections() {
        return this.sections.toArray();
    }
}

