/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.util.Blacklist;
import com.farmerbb.taskbar.util.BlacklistEntry;
import com.farmerbb.taskbar.util.TopApps;
import com.farmerbb.taskbar.util.U;
import java.util.List;

public class AppListAdapter
extends ArrayAdapter<BlacklistEntry> {
    private final Blacklist blacklist = Blacklist.getInstance(this.getContext());
    private final TopApps topApps = TopApps.getInstance(this.getContext());
    private int type;

    public AppListAdapter(Context context, int layout2, List<BlacklistEntry> list, int type) {
        super(context, layout2, list);
        this.type = type;
    }

    @NonNull
    public View getView(int position, View convertView, @NonNull ViewGroup parent) {
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.tb_row_blacklist, parent, false);
        }
        switch (this.type) {
            case 0: {
                this.setupHidden(position, convertView);
                break;
            }
            case 1: {
                this.setupTopApps(position, convertView);
            }
        }
        return convertView;
    }

    private void setupHidden(int position, View convertView) {
        BlacklistEntry entry = (BlacklistEntry)this.getItem(position);
        assert (entry != null);
        String componentName = entry.getPackageName();
        String componentNameAlt = componentName.contains(":") ? componentName.split(":")[0] : componentName;
        String componentNameAlt2 = componentNameAlt.contains("/") ? componentNameAlt.split("/")[1] : componentNameAlt;
        TextView textView = (TextView)convertView.findViewById(R.id.name);
        textView.setText((CharSequence)entry.getLabel());
        CheckBox checkBox = (CheckBox)convertView.findViewById(R.id.checkbox);
        checkBox.setChecked(this.blacklist.isBlocked(componentName) || this.blacklist.isBlocked(componentNameAlt) || this.blacklist.isBlocked(componentNameAlt2));
        LinearLayout layout2 = (LinearLayout)convertView.findViewById(R.id.entry);
        layout2.setOnClickListener(view -> {
            if (this.topApps.isTopApp(componentName) || this.topApps.isTopApp(componentNameAlt) || this.topApps.isTopApp(componentNameAlt2)) {
                U.showToast(this.getContext(), this.getContext().getString(R.string.tb_already_top_app, new Object[]{entry.getLabel()}), 1);
            } else if (this.blacklist.isBlocked(componentName)) {
                this.blacklist.removeBlockedApp(this.getContext(), componentName);
                checkBox.setChecked(false);
            } else if (this.blacklist.isBlocked(componentNameAlt)) {
                this.blacklist.removeBlockedApp(this.getContext(), componentNameAlt);
                checkBox.setChecked(false);
            } else if (this.blacklist.isBlocked(componentNameAlt2)) {
                this.blacklist.removeBlockedApp(this.getContext(), componentNameAlt2);
                checkBox.setChecked(false);
            } else {
                this.blacklist.addBlockedApp(this.getContext(), entry);
                checkBox.setChecked(true);
            }
        });
    }

    private void setupTopApps(int position, View convertView) {
        BlacklistEntry entry = (BlacklistEntry)this.getItem(position);
        assert (entry != null);
        String componentName = entry.getPackageName();
        String componentNameAlt = componentName.contains(":") ? componentName.split(":")[0] : componentName;
        String componentNameAlt2 = componentNameAlt.contains("/") ? componentNameAlt.split("/")[1] : componentNameAlt;
        TextView textView = (TextView)convertView.findViewById(R.id.name);
        textView.setText((CharSequence)entry.getLabel());
        CheckBox checkBox = (CheckBox)convertView.findViewById(R.id.checkbox);
        checkBox.setChecked(this.topApps.isTopApp(componentName) || this.topApps.isTopApp(componentNameAlt) || this.topApps.isTopApp(componentNameAlt2));
        LinearLayout layout2 = (LinearLayout)convertView.findViewById(R.id.entry);
        layout2.setOnClickListener(view -> {
            if (this.blacklist.isBlocked(componentName) || this.blacklist.isBlocked(componentNameAlt) || this.blacklist.isBlocked(componentNameAlt2)) {
                U.showToast(this.getContext(), this.getContext().getString(R.string.tb_already_blacklisted, new Object[]{entry.getLabel()}), 1);
            } else if (this.topApps.isTopApp(componentName)) {
                this.topApps.removeTopApp(this.getContext(), componentName);
                checkBox.setChecked(false);
            } else if (this.topApps.isTopApp(componentNameAlt)) {
                this.topApps.removeTopApp(this.getContext(), componentNameAlt);
                checkBox.setChecked(false);
            } else if (this.topApps.isTopApp(componentNameAlt2)) {
                this.topApps.removeTopApp(this.getContext(), componentNameAlt2);
                checkBox.setChecked(false);
            } else {
                this.topApps.addTopApp(this.getContext(), entry);
                checkBox.setChecked(true);
            }
        });
    }
}

