/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.provider.Settings;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.helper.FreeformHackHelper;
import com.farmerbb.taskbar.util.DisplayInfo;
import com.farmerbb.taskbar.util.U;

public class TouchAbsorberActivity
extends Activity {
    private static long lastStartTime = 0L;
    private static String transitionAnimScale = "";
    private BroadcastReceiver finishReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            TouchAbsorberActivity.this.finish();
        }
    };

    @SuppressLint(value={"HardwareIds"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.tb_incognito);
        DisplayInfo display = U.getDisplayInfo((Context)this);
        LinearLayout layout2 = (LinearLayout)this.findViewById(R.id.incognitoLayout);
        layout2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(display.width, display.height));
        U.registerReceiver((Context)this, this.finishReceiver, "com.farmerbb.taskbar.FINISH_FREEFORM_ACTIVITY");
        FreeformHackHelper.getInstance().setTouchAbsorberActive(true);
        U.sendBroadcast((Context)this, "com.farmerbb.taskbar.TOUCH_ABSORBER_STATE_CHANGED");
        lastStartTime = System.currentTimeMillis();
    }

    protected void onStart() {
        super.onStart();
        if (U.hasWriteSecureSettingsPermission((Context)this)) {
            transitionAnimScale = Settings.Global.getString((ContentResolver)this.getContentResolver(), (String)"transition_animation_scale");
            try {
                Settings.Global.putString((ContentResolver)this.getContentResolver(), (String)"transition_animation_scale", (String)"0.0");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void onStop() {
        super.onStop();
        if (U.hasWriteSecureSettingsPermission((Context)this)) {
            try {
                Settings.Global.putString((ContentResolver)this.getContentResolver(), (String)"transition_animation_scale", (String)transitionAnimScale);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.finish();
    }

    protected void onDestroy() {
        U.unregisterReceiver((Context)this, this.finishReceiver);
        FreeformHackHelper.getInstance().setTouchAbsorberActive(false);
        U.sendBroadcast((Context)this, "com.farmerbb.taskbar.TOUCH_ABSORBER_STATE_CHANGED");
        super.onDestroy();
    }

    public void onBackPressed() {
        if (!U.isAccessibilityServiceEnabled((Context)this) && !U.hasWriteSecureSettingsPermission((Context)this) || lastStartTime > System.currentTimeMillis() - 250L) {
            return;
        }
        super.onBackPressed();
        new Handler().postDelayed(() -> U.sendAccessibilityAction((Context)this, 1, () -> new Handler().postDelayed(() -> U.startTouchAbsorberActivity((Context)this), 100L)), 100L);
    }
}

