/*
 * Decompiled with CFR 0.152.
 */
package com.farmerbb.taskbar.activity;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.LauncherActivityInfo;
import android.content.pm.LauncherApps;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.UserHandle;
import android.os.UserManager;
import android.view.WindowManager;
import android.widget.ProgressBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.farmerbb.taskbar.R;
import com.farmerbb.taskbar.adapter.AppListAdapter;
import com.farmerbb.taskbar.fragment.SelectAppFragment;
import com.farmerbb.taskbar.util.Blacklist;
import com.farmerbb.taskbar.util.BlacklistEntry;
import com.farmerbb.taskbar.util.TopApps;
import com.farmerbb.taskbar.util.U;
import com.google.android.material.tabs.TabLayout;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SelectAppActivity
extends AppCompatActivity {
    private AppListGenerator appListGenerator;
    private ProgressBar progressBar;
    private AppListAdapter hiddenAdapter;
    private AppListAdapter topAppsAdapter;
    private boolean isCollapsed;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        boolean noShadow = this.getIntent().hasExtra("no_shadow");
        if (savedInstanceState == null) {
            SharedPreferences pref;
            this.setContentView(R.layout.tb_configure_start_menu);
            this.setFinishOnTouchOutside(false);
            this.setTitle(R.string.tb_start_menu_apps);
            if (noShadow) {
                WindowManager.LayoutParams params = this.getWindow().getAttributes();
                params.dimAmount = 0.0f;
                this.getWindow().setAttributes(params);
                if (U.isChromeOs((Context)this) && Build.VERSION.SDK_INT >= 22) {
                    this.getWindow().setElevation(0.0f);
                }
            }
            boolean bl = this.isCollapsed = !(pref = U.getSharedPreferences((Context)this)).getBoolean("collapsed", false);
            if (!this.isCollapsed) {
                U.sendBroadcast((Context)this, "com.farmerbb.taskbar.HIDE_TASKBAR");
            }
            this.progressBar = (ProgressBar)this.findViewById(R.id.progress_bar);
            this.appListGenerator = new AppListGenerator();
            this.appListGenerator.execute(new Void[0]);
        } else {
            this.finish();
            if (!noShadow) {
                new Handler().post(() -> {
                    Intent intent = U.getThemedIntent((Context)this, SelectAppActivity.class);
                    this.startActivity(intent);
                });
            }
        }
    }

    public void finish() {
        if (this.appListGenerator != null && this.appListGenerator.getStatus() == AsyncTask.Status.RUNNING) {
            this.appListGenerator.cancel(true);
        }
        if (!this.isCollapsed) {
            U.sendBroadcast((Context)this, "com.farmerbb.taskbar.SHOW_TASKBAR");
        }
        super.finish();
    }

    public AppListAdapter getAppListAdapter(int type) {
        switch (type) {
            case 0: {
                return this.hiddenAdapter;
            }
            case 1: {
                return this.topAppsAdapter;
            }
        }
        return null;
    }

    private final class AppListGenerator
    extends AsyncTask<Void, Void, AppListAdapter[]> {
        private AppListGenerator() {
        }

        protected AppListAdapter[] doInBackground(Void ... params) {
            UserManager userManager = (UserManager)SelectAppActivity.this.getSystemService("user");
            LauncherApps launcherApps = (LauncherApps)SelectAppActivity.this.getSystemService("launcherapps");
            List userHandles = userManager.getUserProfiles();
            ArrayList list = new ArrayList();
            for (UserHandle handle : userHandles) {
                list.addAll(launcherApps.getActivityList(null, handle));
            }
            Blacklist blacklist = Blacklist.getInstance((Context)SelectAppActivity.this);
            TopApps topApps = TopApps.getInstance((Context)SelectAppActivity.this);
            ArrayList<String> blacklistedApps = new ArrayList<String>();
            ArrayList<String> topAppsList = new ArrayList<String>();
            ArrayList<String> installedApps = new ArrayList<String>();
            for (BlacklistEntry entry : blacklist.getBlockedApps()) {
                blacklistedApps.add(entry.getPackageName());
            }
            for (BlacklistEntry entry : topApps.getTopApps()) {
                topAppsList.add(entry.getPackageName());
            }
            for (LauncherActivityInfo appInfo : list) {
                installedApps.add(appInfo.getApplicationInfo().packageName + "/" + appInfo.getName() + ":" + userManager.getSerialNumberForUser(appInfo.getUser()));
                installedApps.add(appInfo.getApplicationInfo().packageName + "/" + appInfo.getName());
                installedApps.add(appInfo.getName());
            }
            for (String packageName : blacklistedApps) {
                if (installedApps.contains(packageName)) continue;
                blacklist.removeBlockedApp((Context)SelectAppActivity.this, packageName);
            }
            for (String packageName : topAppsList) {
                if (installedApps.contains(packageName)) continue;
                topApps.removeTopApp((Context)SelectAppActivity.this, packageName);
            }
            Collections.sort(list, (ai1, ai2) -> {
                String label2;
                String label1;
                try {
                    label1 = ai1.getLabel().toString();
                    label2 = ai2.getLabel().toString();
                }
                catch (OutOfMemoryError e) {
                    System.gc();
                    label1 = ai1.getApplicationInfo().packageName;
                    label2 = ai2.getApplicationInfo().packageName;
                }
                return Collator.getInstance().compare(label1, label2);
            });
            ArrayList<BlacklistEntry> entries = new ArrayList<BlacklistEntry>();
            for (LauncherActivityInfo appInfo : list) {
                String label;
                try {
                    label = appInfo.getLabel().toString();
                }
                catch (OutOfMemoryError e) {
                    System.gc();
                    label = appInfo.getApplicationInfo().packageName;
                }
                entries.add(new BlacklistEntry(appInfo.getApplicationInfo().packageName + "/" + appInfo.getName() + ":" + userManager.getSerialNumberForUser(appInfo.getUser()), label));
            }
            return new AppListAdapter[]{new AppListAdapter((Context)SelectAppActivity.this, R.layout.tb_row_blacklist, entries, 0), new AppListAdapter((Context)SelectAppActivity.this, R.layout.tb_row_blacklist, entries, 1)};
        }

        protected void onPostExecute(AppListAdapter[] adapters) {
            SelectAppActivity.this.hiddenAdapter = adapters[0];
            SelectAppActivity.this.topAppsAdapter = adapters[1];
            SelectAppPagerAdapter pagerAdapter = new SelectAppPagerAdapter(SelectAppActivity.this.getSupportFragmentManager());
            ViewPager viewPager = (ViewPager)SelectAppActivity.this.findViewById(R.id.pager);
            viewPager.setAdapter((PagerAdapter)pagerAdapter);
            TabLayout tabLayout = (TabLayout)SelectAppActivity.this.findViewById(R.id.sliding_tabs);
            tabLayout.setupWithViewPager(viewPager);
            SelectAppActivity.this.findViewById(R.id.configure_start_menu_layout).setVisibility(0);
            SelectAppActivity.this.progressBar.setVisibility(8);
            SelectAppActivity.this.setFinishOnTouchOutside(true);
        }
    }

    private class SelectAppPagerAdapter
    extends FragmentPagerAdapter {
        SelectAppPagerAdapter(FragmentManager fm) {
            super(fm);
        }

        public Fragment getItem(int position) {
            return SelectAppFragment.newInstance(position);
        }

        public int getCount() {
            return 2;
        }

        public CharSequence getPageTitle(int position) {
            switch (position) {
                case 0: {
                    return SelectAppActivity.this.getString(R.string.tb_blacklist_dialog_title);
                }
                case 1: {
                    return SelectAppActivity.this.getString(R.string.tb_top_apps_dialog_title);
                }
            }
            return null;
        }
    }
}

